# SeparatDateTimeRange 分离日期范围选择器
分离的日期范围选择器，允许用户只选择开始或结束日期。

## 用法

### 基础用法

::: demo

```vue
<template>
	<SeparatDateTimeRange :startTime.sync="startTime" :endTime.sync="endTime"/>
</template>


<script>
export default {
  name:"DEMO",
  data(){
    return {
      startTime:'',
      endTime:''
    }
  },
}
</script>
```

::: 

### 自定义分隔符

::: demo

```vue
<template>
	<SeparatDateTimeRange :startTime.sync="startTime" :endTime.sync="endTime" rangeSeparator="到"/>
</template>


<script>
export default {
  name:"DEMO",
  data(){
    return {
      startTime:'',
      endTime:''
    }
  },
}
</script>
```

::: 

### 其他日期类型

::: demo

```vue
<template>
  <dl>
    <dt>year</dt>
    <dd><SeparatDateTimeRange :startTime.sync="startTime" :endTime.sync="endTime" type="year"/></dd>
    
    <dt>month</dt>
    <dd><SeparatDateTimeRange :startTime.sync="startTime" :endTime.sync="endTime" type="month"/></dd>
    
    <dt>date</dt>
    <dd><SeparatDateTimeRange :startTime.sync="startTime" :endTime.sync="endTime" type="date"/></dd>
    
    <dt>datetime</dt>
    <dd><SeparatDateTimeRange :startTime.sync="startTime" :endTime.sync="endTime" type="datetime"/></dd>
  </dl>
</template>


<script>
export default {
  name:"DEMO",
  data(){
    return {
      startTime:'',
      endTime:''
    }
  },
}
</script>
```

::: 

### 禁用

::: demo

```vue
<template>
	<SeparatDateTimeRange :startTime.sync="startTime" :endTime.sync="endTime" disabled/>
</template>


<script>
export default {
  name:"DEMO",
  data(){
    return {
      startTime:'',
      endTime:''
    }
  },
}
</script>
```

::: 

### placeholder

::: demo

```vue
<template>
	<SeparatDateTimeRange :startTime.sync="startTime" :endTime.sync="endTime" placeholder="请选择日期范围"/>

	<SeparatDateTimeRange :startTime.sync="startTime" :endTime.sync="endTime" :placeholder="['请选择开始日期','请选择结束日期']"/>
</template>


<script>
export default {
  name:"DEMO",
  data(){
    return {
      startTime:'',
      endTime:''
    }
  },
}
</script>
```

::: 

### fromNow 从当前日期开始

::: demo

```vue
<template>
	<SeparatDateTimeRange :startTime.sync="startTime" :endTime.sync="endTime" fromNow/>
</template>


<script>
export default {
  name:"DEMO",
  data(){
    return {
      startTime:'',
      endTime:''
    }
  },
}
</script>
```

::: 

### toNow 到当前日期截止

::: demo

```vue
<template>
	<SeparatDateTimeRange :startTime.sync="startTime" :endTime.sync="endTime" toNow/>
</template>


<script>
export default {
  name:"DEMO",
  data(){
    return {
      startTime:'',
      endTime:''
    }
  },
}
</script>
```

::: 



## Props

| 参数                  | 说明                                                       | 类型          | 可选值                   | 默认值              |
| --------------------- | ---------------------------------------------------------- | ------------- | ------------------------ | ------------------- |
| startTime             | 开始时间，支持.sync                                        | string        | -                        | -                   |
| endTime               | 结束时间，支持.sync                                        | string        | -                        | -                   |
| type                  | 控件显示类型                                               | string        | year/month/date/datetime | datetime            |
| rangeSeparator        | 分隔符                                                     | string        | -                        | "-"                 |
| disabled              | 禁用                                                       | boolean       | -                        | false               |
| placeholder           | 占位符，使用数组可分别设置开始和结束占位符                 | string\|Array | -                        | "请选择日期时间"    |
| valueFormat           | 日期值格式                                                 | string        | -                        | yyyy-MM-dd HH:mm:ss |
| startTimeDisabledDate | 开始日期禁用函数(date, endTime, fromNow, toNow)=>boolean   | Function      | -                        | -                   |
| endTimeDisabledDate   | 结束日期禁用函数(date, startTime, fromNow, toNow)=>boolean | Function      | -                        | -                   |
| fromNow               | 开始时间是否从当前时间开始，优先级比toNow更高              | false         | -                        | -                   |
| toNow                 | 截止日期是否到当前时间                                     | false         | -                        | -                   |

