# ResizableDialog 缩放大小弹窗
缩放大小弹窗可展开和收起弹窗内容，保留弹窗标题。
## 用法

### 基础用法

::: demo

```vue
<template>
	<div style="padding:20px;">
    <ResizableDialog title="缩放弹窗" v-if="!closed" @close="closed=true">
    这是一个缩放弹窗
  	</ResizableDialog>
    <el-button @click="closed=!closed" style="float:right;">点击切换显示隐藏</el-button>
  </div>
</template>

<script>
export default {
  name:'DEMO',
  data(){
    return {
      closed:false
    }
  },
}
</script>
```

::: 

### 不可关闭

::: demo

```vue
<template>
	<ResizableDialog title="缩放弹窗" :closable="false">
    这是一个缩放弹窗
  </ResizableDialog>
</template>
```

::: 

### 不可缩放

::: demo

```vue
<template>
	<ResizableDialog title="缩放弹窗" :minimizable="false">
    这是一个缩放弹窗
  </ResizableDialog>
</template>
```

::: 

## Props

| 参数         | 说明                                         | 类型                  | 可选值                            | 默认值 |
| ------------ | -------------------------------------------- | --------------------- | --------------------------------- | ------ |
| position     | 原点位置，将基于此位置进行放大缩小           | string                | left-top \| left-bottom \| bottom | bottom |
| width        | 宽度                                         | number                | -                                 | 300    |
| height       | 高度                                         | number                | -                                 | 300    |
| title        | 弹窗标题                                     | string                | -                                 | -      |
| closable     | 是否可关闭                                   | boolean               | -                                 | true   |
| minimizable  | 是否可最小化                                 | boolean               | -                                 | true   |
| bodyStyle    | 自定义内容区style                            | string\|Object\|Array | -                                 | -      |
| appendToBody | 是否插入到body                               | boolean               | -                                 | false  |
| parentNode   | 自定义插入父节点（appendToBody为true时有效） | HTMLElement           | -                                 | -      |

## Slots

| 名称   | 说明       |
| ------ | ---------- |
| footer | 底部操作区 |

