# MutableList 列表

可增删排序列表，支持标签模式，以及自定义渲染，支持拖拽排序。

> 精力原因，文档较为简略，具体使用可以参考src/views/strategy/StrategySetting 下MutableList的使用例子。

- 自定义列表

  ![aX7jpb](https://raw.githubusercontent.com/jiangwenyang/graphbed/master/uPic/aX7jpb.png)

- 标签列表

  ![MOLJPG](https://raw.githubusercontent.com/jiangwenyang/graphbed/master/uPic/MOLJPG.png)


## 基础用法
:::demo
```vue
<template>
  <MutableList v-model="list" />
</template>
<script>
export default {
  data() {
    return {
      list: [{name:'tom1'},{name:'tom2'}],
    }
  },
}
</script>
```
:::

## 可拖拽排序
:::demo
```vue
<template>
  <MutableList v-model="list" allowSort/>
</template>
<script>
export default {
  data() {
    return {
      list: [{name:'tom1'},{name:'tom2'}],
    }
  },
}
</script>
```
:::

## 自定义渲染
:::demo
```vue
<template>
<mutable-list
              v-model="list"
              :generate-item="(list)=> ({name:`tom${list.length+1}`})"
            >
  <template #item="{item}">
		I'm {{item.name}}
  </template>
</mutable-list>
</template>
<script>
export default {
  data() {
    return {
      list: [{name:'tom1'},{name:'tom2'}],
    }
  },
}
</script>
```
:::

## 标签模式

:::demo type为tag时将使用标签模式渲染为标签
```vue
<template>
  <mutable-list
                type="tag"
                v-model="list"
                :generate-item="(list)=> ({name:`tom${list.length+1}`})"
              >
    <template #item="{item}">
      I'm {{item.name}}
    </template>
  </mutable-list>
</template>

<script>
export default {
  data() {
    return {
      list: [{name:'tom1'},{name:'tom2'}],
    }
  },
}
</script>
```
:::


## Props

| 参数             | 说明                                                         | 类型                                       | 默认值                        |
| :--------------- | :----------------------------------------------------------- | :----------------------------------------- | :---------------------------- |
| allowSort        | 是否允许排序                                                 | boolean                                    | false                         |
| value            | 数据列表,支持v-model                                         | Array                                      | []                            |
| type             | 列表模式，支持标签模式（tag），列表模式（list）              | string                                     | "list"                        |
| minNumber        | 最小列表项数目，列表项数目等于此数目时不允许再删除           | number                                     | 0                             |
| maxNumber        | 最大列表项数目，列表项数目等于此数目时不允许再新增           | number                                     | Infinity                      |
| itemLabel        | 项目名称，接收属性路径或者一个生成函数                       | string\|(item,index,list)=>{}              | "name"                        |
| itemKey          | 列表项目key，接收属性路径或者一个生成函数,默认使用索引       | string\|(item,index,list)=>{}              | (item, index, value) => index |
| generateItem     | 生成列表项目,允许任意类型,暂不支持promise。（如果给定的是函数，则函数的返回值将作为生成项目。） | any                                        | -                             |
| beforeRemove     | 移除前执行函数。如果返回falsy,则不执行移除；如果返回promise，列表项将等待promise状态resolve之后执行移除。 | (removeItem, index, list)=>{}              | -                             |
| customRemove     | 自定义移除处理函数                                           | (removeItem, index,list, beforeValue)=>{}  | -                             |
| afterRemove      | 移除后执行函数                                               | (removeItem, index, list, removeValue)=>{} | -                             |
| beforeAdd        | 新增前执行函数。如果返回falsy,则不执行新增；如果返回promise，列表项将等待promise状态resolve之后执行新增。 | (list)=>{}                                 | -                             |
| customAdd        | 自定义添加处理函数                                           | (newItem, list, beforeValue)=>{}           | -                             |
| afterAdd         | 新增后执行函数                                               | (newItem, list, addValue)=>{}              | -                             |
| current          | 当前项，支持.sync                                            | any                                        | -                             |
| customShowRemove | 自定义是否显示移除按钮（minNumber优先级更高）                | index=>{}                                  | -                             |
| customShowAdd    | 自定义是否显示添加按钮（maxNumber优先级更高）                | index=>{}                                  | -                             |

## Events

| 事件名称       | 说明             | 回调参数                                                 |
| :------------- | :--------------- | :------------------------------------------------------- |
| Input          | 数据列表改变     | 数据列表                                                 |
| sort           | 数据列表顺序改变 | 接收两个参数，依次为：排序后的数据列表，排序前的数据列表 |
| current-change | 当前项改变       | 接收两个参数，依次为：当前项，当前项索引                 |
| remove         | 移除项目         | 接收两个参数，依次为：移除项，移除项索引                 |
| add            | 新增项目         | 新增项目                                                 |

### Scoped Slot

| name | 说明                                                         |
| :--- | :----------------------------------------------------------- |
| item | 自定义列表项（tag模式下无效），参数为{item,index,handleRemove,showRemove,handleAdd,showAdd,handleCurrentChange,label} |

