# Checkboxs 多选框组件

多选框组件。基于 Element [Checkbox 多选框](https://element.eleme.cn/#/zh-CN/component/checkbox) 组件进行封装，在不更改功能特性的基础上简化了使用方式。

## 用法

### 基本用法
:::demo 最简单的用法
```vue 
<template>
  <checkboxs checked>checkbox</checkboxs>
</template>
```
:::

### 分组

:::demo 
```vue
<template>
  <div class="checkboxs-group-list">
    <!-- 最简单的用法 -->
    <checkboxs-group :options="options" v-model="data" />
    <!-- 可统一定义单选按钮样式 -->
    <checkboxs-group :options="options" v-model="data" border size="mini" button />
  </div>
  
</template>

<script>
export default {
  name: 'demo',
  data() {
    return {
      options: [{ label: 'label1', value: 1 }, { label: 'label2', value: 2 }],
      data: [1,2],
    }
  },
}
</script>
<style>
.checkboxs-group-list{
  display:flex;
  justify-content: space-around;
}
</style>
```
:::

## Checkboxs

### Props

| 参数       | 说明                        | 类型            | 可选值 | 默认值 |
| :--------- | :-------------------------- | :-------------- | :----- | :----- |
| label      | 选项文字信息                | string          | -      | ‘’     |
| value      | 根据 value 进行判断是否选中 | any             | -      | -      |
| button     | 是否显示按钮类型多选框      | boolean         | -      | false  |
| checked    | 指定当前是否选中            | boolean         | -      | false  |
| disabled   | 是否禁用                    | boolean         | -      | false  |
| trueValue  | 选中时的值                  | string / number | -      | false  |
| falseValue | 没有选中时的值              | string / number | -      | false  |

> true-label false-label 两个属性不支持（被替换为对应的true-value和false-value），除此之外其他参数将直接透传到 Element 的多选框组件上, 

## CheckboxGroup

### Props

| 参数          | 说明                                                         | 类型                  | 可选值 | 默认值                          |
| ------------- | ------------------------------------------------------------ | --------------------- | ------ | ------------------------------- |
| options       | 选项数据,每一项的所有属性将作为参数传到 Checkboxs            | Array                 | -      | []                              |
| button        | 是否显示按钮类型单选框（如果 options[n]中已定义 button 属性将会优先使用。） | boolean               | -      | false                           |
| border        | 是否显示边框（如果 options[n]中已定义 border 属性将会优先使用。） | boolean               | -      | false                           |
| props         | 选项配置                                                     | Object                | -      | {label: 'label',value: 'value'} |
| checkboxClass | 自定义CheckBox样式                                           | string\|Object\|Array | -      | -                               |
| optionKey     | 选项key,默认将会取value作为key，可以传入函数(option, index, options)=>string或者字段路径“a.b.c” | string\|Function      | -      | -                               |

> 其他参数将直接透传到 Element 的多选分组组件上
