# BaseChart 基础图表组件

基于Echart封装的基础图表组件，支持自动缩放以及自定义样式等。

> 处于包大小考虑，当前组件默认只注入了部分常用图表以及组件，如果你的业务需要用到特殊的图表和组件，可以通过plugins传入
>
> 参考：[在打包环境中使用 ECharts](https://echarts.apache.org/zh/tutorial.html#%E5%9C%A8%E6%89%93%E5%8C%85%E7%8E%AF%E5%A2%83%E4%B8%AD%E4%BD%BF%E7%94%A8%20ECharts)

自动引入的图表及组件列表参考：

- TitleComponent
- TooltipComponent
- LegendComponent
- GridComponent
- BarChart
- LineChart
- PieChart
- CanvasRenderer

## 用法

### 基础用法

::: demo 基本的柱状图和复杂点的折线图（官网示例）

```vue
<template>
	<div>
    <BaseChart :option="option" />
		<BaseChart :option="option2" />
  </div>
</template>

<script>
export default {
  name: 'DEMO',
  data() {
    return {
      option: {
        title: {
          text: 'ECharts 入门示例',
        },
        tooltip: {},
        legend: {
          data: ['销量'],
        },
        xAxis: {
          data: ['衬衫', '羊毛衫', '雪纺衫', '裤子', '高跟鞋', '袜子'],
        },
        yAxis: {},
        series: [
          {
            name: '销量',
            type: 'bar',
            data: [5, 20, 36, 10, 10, 20],
          },
        ],
      },
      option2: {
        title: {
          text: '堆叠区域图',
        },
        tooltip: {
          trigger: 'axis',
          axisPointer: {
            type: 'cross',
            label: {
              backgroundColor: '#6a7985',
            },
          },
        },
        legend: {
          data: ['邮件营销', '联盟广告', '视频广告', '直接访问', '搜索引擎'],
        },
        toolbox: {
          feature: {
            saveAsImage: {},
          },
        },
        grid: {
          left: '3%',
          right: '4%',
          bottom: '3%',
          containLabel: true,
        },
        xAxis: [
          {
            type: 'category',
            boundaryGap: false,
            data: ['周一', '周二', '周三', '周四', '周五', '周六', '周日'],
          },
        ],
        yAxis: [
          {
            type: 'value',
          },
        ],
        series: [
          {
            name: '邮件营销',
            type: 'line',
            stack: '总量',
            areaStyle: {},
            emphasis: {
              focus: 'series',
            },
            data: [120, 132, 101, 134, 90, 230, 210],
          },
          {
            name: '联盟广告',
            type: 'line',
            stack: '总量',
            areaStyle: {},
            emphasis: {
              focus: 'series',
            },
            data: [220, 182, 191, 234, 290, 330, 310],
          },
          {
            name: '视频广告',
            type: 'line',
            stack: '总量',
            areaStyle: {},
            emphasis: {
              focus: 'series',
            },
            data: [150, 232, 201, 154, 190, 330, 410],
          },
          {
            name: '直接访问',
            type: 'line',
            stack: '总量',
            areaStyle: {},
            emphasis: {
              focus: 'series',
            },
            data: [320, 332, 301, 334, 390, 330, 320],
          },
          {
            name: '搜索引擎',
            type: 'line',
            stack: '总量',
            label: {
              show: true,
              position: 'top',
            },
            areaStyle: {},
            emphasis: {
              focus: 'series',
            },
            data: [820, 932, 901, 934, 1290, 1330, 1320],
          },
        ],
      },
    };
  },
};
</script>

```

:::

## Props

| 参数       | 说明                                                         | 类型           | 可选值 | 默认值                                                       |
| :--------- | :----------------------------------------------------------- | :------------- | :----- | :----------------------------------------------------------- |
| option     | 图表实例的配置项以及数据                                     | Object         | -      | -                                                            |
| theme      | 应用的主题。可以是一个主题的配置对象，也可以是使用已经通过 [echarts.registerTheme](https://echarts.apache.org/zh/api.html#echarts.registerTheme) 注册的主题名称。 | Object\|string | -      | -                                                            |
| opts       | 图表实例初始化附加参数，具体参考 https://echarts.apache.org/zh/api.html#echarts.init 使用 | Object         | -      | {width:'auto',height:'auto',}                                |
| autoResize | 是否自动缩放, 开启后将监听窗口的resize事件缩放图表           | boolean        | -      | true                                                         |
| chartStyle | 图表容器style                                                | Object         | -      | -                                                            |
| plugins    | Echart组件，作为插件的形式引入                               | Object         | -      | [TitleComponent,TooltipComponent,LegendComponent,GridComponent,BarChart,LineChart,PieChart,CanvasRenderer] |

## Methods

| 方法名         | 说明                                                         | 参数                                                         |
| :------------- | :----------------------------------------------------------- | :----------------------------------------------------------- |
| clear          | 暴露Echart实例的setOption方法。清空当前实例，会移除实例中所有的组件和图表。 | -                                                            |
| setOption      | 暴露Echart实例的setOption方法。设置图表实例的配置项以及数据，万能接口，所有参数和数据的修改都可以通过 `setOption` 完成，ECharts 会合并新的参数和数据，然后刷新图表。如果开启[动画](https://echarts.apache.org/zh/option.html#option.animation)的话，ECharts 找到两组数据之间的差异然后通过合适的动画去表现数据的变化。 | Function(<br />option: Object, notMerge?:boolean, lazyUpdate?:boolean) |
| resize         | 暴露Echart实例的resize方法。改变图表尺寸，用于特殊情况手动resize。参考 [echartsInstance.](https://echarts.apache.org/zh/api.html#echartsInstance) [resize](https://echarts.apache.org/zh/api.html#echartsInstance.resize) | Function(opts?:Object)                                       |
| dispatchAction | 暴露Echart实例的dispatchAction方法，触发图表行为。参考[echartsInstance.](https://echarts.apache.org/zh/api.html#echartsInstance) [dispatchAction](https://echarts.apache.org/zh/api.html#echartsInstance.dispatchAction) | Function(payload: Object)                                    |

> 当你想调用的方法没有暴露出来时，你可以直接通过refs['myChart'].echartsInstance 来获取到echart实例来调用。
