# UI组件 `web-lib-components` 

UI组件主要基于Element进行了一些数据驱动风格的封装，并且针对业务需求做了一些定制化，更符合业务开发需要。
同时也扩展了一部分新的组件，例如：CollapsePanel收缩面板、Hamburger面包屑、MutableList可自定义渲染可变列表组件、InfoGroup信息项展示组件等。

## 使用
你可以完整引入web-lib-components，也可以按需引入。下面我们分别介绍这两种引入方式。

### 完整引入

> 完整引入适用于将会完整使用整个UI库的使用情况。

在main.js中写入一下内容：
``` js
import WebLibComponents from 'web-lib/packages/web-lib-components'
import 'web-lib/packages/web-lib-components/lib/index.css'
Vue.use(WebLibComponents)
```

这样就完成了web-lib-components的引用，你可以全局任意使用包含的组件。

### 按需引入

> 按需引入适用于只使用部分组件，不希望整个组件库被打包的情况。

``` js
import Empty from 'web-lib/packages/web-lib-components/lib/Empty'
import 'web-lib/packages/web-lib-components/lib/Empty.css' 
Vue.components('Empty',Empty)
```

值得注意的是，并不是每个组件都需要引入css资源，以下组件需要引入对应的css文件。*（具体可以查看lib目录进行确认）*

- BaseChart
- Breadcrumb
- Checkboxs
- CollapsePanel
- ColorLabel
- DragAndResizable
- Empty
- Hamburger
- ImageViewer
- Import
- InfoGroup
- InfoTitle
- List
- MutableList
- PDFViewer
- PageContainer
- Radios
- ResizableDialog
- SeparatDateTimeRange
- SvgIcon
- Tables
- Tree
- TreeSelect
- Upload
- Viewer
- index

