# 工具函数 `web-lib-utils`
工具函数主要提供了以下类型的工具函数方便使用：
- assist 常用的helper
- cache 缓存类，实现内存缓存以及storage缓存映射
- crypto 加密相关
- file 文件操作相关
- fullScreen 全屏操作相关
- lang 语言层面相关，如判断是否是Promise
- storage 简化storage操作
- tree 树结构转换和查询相关
- util 一些其他工具函数
- validate 校验相关，如常见手机用户名等验证

工具函数没有提供完整引入方式

## 使用
你可以完整引入web-lib-utils，也可以按需引入。下面我们分别介绍这两种引入方式。

### 完整引入
> 完整引入适用于将会完整使用整个UI库的使用情况。

```js
import WebLibUtils from 'web-lib/packages/web-lib-utils';

WebLibUtils.validate.isMobilePhoneNumber('12312341234')
```

### 按需引入

> 按需引入适用于只使用部分组件，不希望整个组件库被打包的情况。
```js
import validate from 'web-lib/packages/web-lib-utils/lib/validate';

validate.isMobilePhoneNumber('12312341234')
```
