const path = require("path");
const { merge } = require("webpack-merge");

const webpackCommonConfig = require("../../../build/webpack.common.js");

module.exports = merge(webpackCommonConfig, {
  mode: "production",
  devtool: "cheap-module-source-map",
  context: path.resolve(__dirname, "../src"),
  // 入口
  entry: {
    ...require("../src/containers.json"),
    index: "./index.js",
  },

  output: {
    path: path.join(__dirname, "../lib"),
    filename: "[name].js",
  },
});
