

# Viewer 预览组件

Viewer支持不同文件类型的同时预览。

## 用法

### 基础用法

::: demo

```vue
<template>
  <Viewer :data="data" />
</template>
<script>
export default {
  name: 'DEMO',
  data() {
    return {
      data: [
        {
          src: 'https://pdfobject.com/pdf/sample-3pp.pdf',
          name: '我是一个有名字的pdf.pdf',
        },
        {
          src: 'https://via.placeholder.com/150?text=image1',
          _fileType:"IMAGE"
        },
        {
          src: 'https://via.placeholder.com/150?text=image2',
          name: '我是一个有名字的图片.jpg',
          _fileType:"IMAGE"
        },
        {
          src: 'https://via.placeholder.com/150?text=image3',
          _fileType:"IMAGE"
        },
        {
          src: 'https://media.w3.org/2010/05/sintel/trailer.mp4',
          name: '我是一个有名字的视频.mp4',
        },
        {
          src: 'http://downsc.chinaz.net/Files/DownLoad/sound1/201906/11582.mp3',
        },
      ],
    };
  },
};
</script>

```

::: 

## Props

| 参数         | 说明                 | 类型    | 可选值 | 默认值 |
| ------------ | -------------------- | ------- | ------ | ------ |
| data         | 数据源列表           | Array   | -      | -      |
| appendToBody | 预览弹窗是否插入body | boolean | -      | false  |

#### data项

| 属性     | 说明                                                         |
| -------- | ------------------------------------------------------------ |
| src/url  | 必需，文件源地址                                             |
| name     | 可选，文件名 (如未指定，则src/url作为文件名)                 |
| _fileType | 文件类型"IMAGE" \| "VIDEO" \| "AUDIO" \| "PDF" \| "OTHER"   (默认不需要指定，将会从文件名进行获取，可自行指定) |

