'use strict';var vue=require('vue');function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

function _slicedToArray(arr, i) {
  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
}

function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}

function _iterableToArrayLimit(arr, i) {
  var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]);

  if (_i == null) return;
  var _arr = [];
  var _n = true;
  var _d = false;

  var _s, _e;

  try {
    for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) {
      _arr.push(_s.value);

      if (i && _arr.length === i) break;
    }
  } catch (err) {
    _d = true;
    _e = err;
  } finally {
    try {
      if (!_n && _i["return"] != null) _i["return"]();
    } finally {
      if (_d) throw _e;
    }
  }

  return _arr;
}

function _unsupportedIterableToArray(o, minLen) {
  if (!o) return;
  if (typeof o === "string") return _arrayLikeToArray(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor) n = o.constructor.name;
  if (n === "Map" || n === "Set") return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
}

function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length) len = arr.length;

  for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

  return arr2;
}

function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}var script$2 = /*#__PURE__*/vue.defineComponent({
  name: 'BasicTheme',
  // vue component name
  props: {
    uuid: {
      type: String,
      required: true
    },
    src: {
      type: String,
      required: true
    },
    autoplay: {
      type: Boolean,
      required: true
    },
    loop: {
      type: Boolean,
      required: true
    },
    controls: {
      type: Boolean,
      required: true
    },
    hoverable: {
      type: Boolean,
      required: true
    },
    mask: {
      type: Boolean,
      required: true
    },
    colors: {
      type: [String, Array],
      required: true
    },
    time: {
      type: Object,
      required: true
    },
    playing: {
      type: Boolean,
      default: false
    },
    duration: {
      type: [String, Number],
      required: true
    }
  },
  data: function data() {
    return {
      hovered: false,
      volume: false,
      amount: 1
    };
  },
  computed: {
    colorFrom: function colorFrom() {
      var _this$colors;

      if (typeof this.colors === 'string') {
        return this.colors ? this.colors : '#fbbf24';
      }

      return (_this$colors = this.colors) !== null && _this$colors !== void 0 && _this$colors[0] ? this.colors[0] : '#fbbf24';
    },
    colorTo: function colorTo() {
      var _this$colors2;

      if (typeof this.colors === 'string') {
        return this.colors ? this.colors : '#fbbf24';
      }

      return (_this$colors2 = this.colors) !== null && _this$colors2 !== void 0 && _this$colors2[1] ? this.colors[1] : '#ec4899';
    }
  },
  mounted: function mounted() {
    this.$emit('setPlayer', this.$refs[this.uuid]);
  },
  methods: {
    setVolume: function setVolume() {
      this.$refs[this.uuid].volume = this.amount;
    },
    stopVolume: function stopVolume() {
      if (this.amount > 0) return this.amount = 0;
      return this.amount = 1;
    }
  }
});var _hoisted_1$2 = {
  class: "relative"
};
var _hoisted_2$1 = {
  class: "flex items-center justify-start w-full"
};
var _hoisted_3$1 = {
  class: "font-sans text-white text-xs w-24"
};
var _hoisted_4$1 = {
  class: "mr-3 ml-2"
};
var _hoisted_5$1 = {
  class: "relative"
};
var _hoisted_6 = {
  class: "px-3 py-2 rounded-lg flex items-center transform translate-x-2",
  style: {
    "background-color": "rgba(0, 0, 0, .8)"
  }
};

var _hoisted_7 = /*#__PURE__*/vue.createVNode("img", {
  src: "https://en-zo.dev/vue-videoplayer/play.svg",
  alt: "Icon play video",
  class: "transform translate-x-0.5 w-12"
}, null, -1);

function render$2(_ctx, _cache, $props, $setup, $data, $options) {
  return vue.openBlock(), vue.createBlock("div", {
    class: "shadow-xl rounded-xl overflow-hidden relative",
    onMouseenter: _cache[15] || (_cache[15] = function ($event) {
      return _ctx.hovered = true;
    }),
    onMouseleave: _cache[16] || (_cache[16] = function ($event) {
      return _ctx.hovered = false;
    }),
    onKeydown: _cache[17] || (_cache[17] = vue.withKeys(function ($event) {
      return _ctx.$emit('play');
    }, ["left"]))
  }, [vue.createVNode("div", _hoisted_1$2, [vue.createVNode("video", {
    ref: _ctx.uuid,
    class: "w-full",
    loop: _ctx.loop,
    autoplay: _ctx.autoplay,
    muted: _ctx.autoplay,
    onTimeupdate: _cache[1] || (_cache[1] = function ($event) {
      return _ctx.$emit('timeupdate', $event.target);
    }),
    onPause: _cache[2] || (_cache[2] = function ($event) {
      return _ctx.$emit('isPlaying', false);
    }),
    onPlay: _cache[3] || (_cache[3] = function ($event) {
      return _ctx.$emit('isPlaying', true);
    }),
    onClick: _cache[4] || (_cache[4] = function ($event) {
      return _ctx.$emit('play');
    })
  }, [vue.createVNode("source", {
    src: _ctx.src,
    type: "video/mp4"
  }, null, 8, ["src"])], 40, ["loop", "autoplay", "muted"]), _ctx.controls ? (vue.openBlock(), vue.createBlock("div", {
    key: 0,
    class: [_defineProperty({
      'opacity-0 translate-y-full': !_ctx.hoverable && _ctx.hovered
    }, "opacity-0 translate-y-full", _ctx.hoverable && !_ctx.hovered), "transition duration-300 transform absolute w-full bottom-0 left-0 flex items-center justify-between overlay px-5  pt-3 pb-5"]
  }, [vue.createVNode("div", _hoisted_2$1, [vue.createVNode("p", _hoisted_3$1, vue.toDisplayString(_ctx.time.display) + "/" + vue.toDisplayString(_ctx.duration), 1), vue.createVNode("div", _hoisted_4$1, [vue.withDirectives(vue.createVNode("img", {
    src: "https://en-zo.dev/vue-videoplayer/pause.svg",
    alt: "Icon pause video",
    class: "w-5 cursor-pointer",
    onClick: _cache[5] || (_cache[5] = function ($event) {
      return _ctx.$emit('play');
    })
  }, null, 512), [[vue.vShow, _ctx.playing]]), vue.withDirectives(vue.createVNode("img", {
    src: "https://en-zo.dev/vue-videoplayer/play.svg",
    alt: "Icon play video",
    class: "w-5 cursor-pointer",
    onClick: _cache[6] || (_cache[6] = function ($event) {
      return _ctx.$emit('play');
    })
  }, null, 512), [[vue.vShow, !_ctx.playing]])]), vue.createVNode("div", {
    class: "w-full h-1 bg-white bg-opacity-60 rounded-sm cursor-pointer",
    onClick: _cache[7] || (_cache[7] = function (e) {
      return _ctx.$emit('position', e);
    })
  }, [vue.createVNode("div", {
    class: "relative h-full pointer-events-none",
    style: "width: ".concat(_ctx.time.progress, "%; transition: width .2s ease-in-out;")
  }, [vue.createVNode("div", {
    class: "w-full rounded-sm h-full gradient-variable bg-gradient-to-r pointer-events-none absolute top-0 left-0",
    style: "--tw-gradient-from: ".concat(_ctx.colorFrom, ";--tw-gradient-to: ").concat(_ctx.colorTo, ";transition: width .2s ease-in-out")
  }, null, 4), vue.createVNode("div", {
    class: "w-full rounded-sm filter blur-sm h-full gradient-variable bg-gradient-to-r pointer-events-none absolute top-0 left-0",
    style: "--tw-gradient-from: ".concat(_ctx.colorFrom, ";--tw-gradient-to: ").concat(_ctx.colorTo, ";transition: width .2s ease-in-out")
  }, null, 4)], 4)])]), vue.createVNode("div", {
    class: "ml-5 flex items-center justify-end",
    onMouseleave: _cache[13] || (_cache[13] = function ($event) {
      return _ctx.volume = false;
    })
  }, [vue.createVNode("div", _hoisted_5$1, [vue.createVNode("div", {
    class: "w-128 origin-left translate-x-2 -rotate-90 w-128 transition duration-200 absolute transform top-0 py-2 ".concat(_ctx.volume ? '-translate-y-4' : 'opacity-0 -translate-y-1 pointer-events-none')
  }, [vue.createVNode("div", _hoisted_6, [vue.withDirectives(vue.createVNode("input", {
    "onUpdate:modelValue": _cache[8] || (_cache[8] = function ($event) {
      return _ctx.amount = $event;
    }),
    type: "range",
    step: "0.05",
    min: "0",
    max: "1",
    class: "rounded-lg overflow-hidden appearance-none bg-white bg-opacity-30 h-1 w-128 vertical-range",
    onInput: _cache[9] || (_cache[9] = function () {
      return _ctx.setVolume && _ctx.setVolume.apply(_ctx, arguments);
    })
  }, null, 544), [[vue.vModelText, _ctx.amount]])])], 2), vue.createVNode("img", {
    src: "https://en-zo.dev/vue-videoplayer/volume-".concat(Math.ceil(_ctx.amount * 2), ".svg"),
    alt: "High volume video",
    class: "w-5 cursor-pointer relative",
    style: {
      "z-index": "2"
    },
    onClick: _cache[10] || (_cache[10] = function () {
      return _ctx.stopVolume && _ctx.stopVolume.apply(_ctx, arguments);
    }),
    onMouseenter: _cache[11] || (_cache[11] = function ($event) {
      return _ctx.volume = true;
    })
  }, null, 40, ["src"])]), vue.createVNode("img", {
    src: "https://en-zo.dev/vue-videoplayer/maximize.svg",
    alt: "Fullscreen",
    class: "w-3 ml-4 cursor-pointer",
    onClick: _cache[12] || (_cache[12] = function ($event) {
      return _ctx.$emit('fullScreen');
    })
  })], 32)], 2)) : vue.createCommentVNode("", true), !_ctx.autoplay && _ctx.mask && _ctx.time.current === 0 ? (vue.openBlock(), vue.createBlock("div", {
    key: 1,
    class: "transition transform duration-300 absolute top-0 left-0 w-full h-full bg-black bg-opacity-50 backdrop-filter z-10 flex items-center justify-center ".concat(_ctx.playing ? 'opacity-0 pointer-events-none' : '')
  }, [vue.createVNode("div", {
    class: "w-20 h-20 rounded-full bg-white bg-opacity-20 transition duration-200 hover:bg-opacity-40 flex items-center justify-center cursor-pointer",
    onClick: _cache[14] || (_cache[14] = function ($event) {
      return _ctx.$emit('play');
    })
  }, [_hoisted_7])], 2)) : vue.createCommentVNode("", true)])], 32);
}script$2.render = render$2;var script$1 = /*#__PURE__*/vue.defineComponent({
  name: 'BasicTheme',
  // vue component name
  props: {
    uuid: {
      type: String,
      required: true
    },
    src: {
      type: String,
      required: true
    },
    autoplay: {
      type: Boolean,
      required: true
    },
    loop: {
      type: Boolean,
      required: true
    },
    controls: {
      type: Boolean,
      required: true
    },
    hoverable: {
      type: Boolean,
      required: true
    },
    mask: {
      type: Boolean,
      required: true
    },
    colors: {
      type: [String, Array],
      required: true
    },
    time: {
      type: Object,
      required: true
    },
    playing: {
      type: Boolean,
      default: false
    },
    duration: {
      type: [String, Number],
      required: true
    }
  },
  data: function data() {
    return {
      hovered: false,
      volume: false,
      amount: 1
    };
  },
  computed: {
    color: function color() {
      var _this$colors;

      if (typeof this.colors === 'string') {
        return this.colors ? this.colors : '#8B5CF6';
      }

      return (_this$colors = this.colors) !== null && _this$colors !== void 0 && _this$colors[0] ? this.colors[0] : '#8B5CF6';
    }
  },
  mounted: function mounted() {
    this.$emit('setPlayer', this.$refs[this.uuid]);
  },
  methods: {
    setVolume: function setVolume() {
      this.$refs[this.uuid].volume = this.amount;
    },
    stopVolume: function stopVolume() {
      if (this.amount > 0) return this.amount = 0;
      return this.amount = 1;
    }
  }
});var _hoisted_1$1 = {
  class: "relative"
};
var _hoisted_2 = {
  class: "mr-5"
};
var _hoisted_3 = {
  class: "relative mr-6"
};
var _hoisted_4 = {
  class: "px-3 py-3 rounded-xl flex items-center transform translate-x-9 bg-black bg-opacity-30"
};

var _hoisted_5 = /*#__PURE__*/vue.createVNode("img", {
  src: "https://en-zo.dev/vue-videoplayer/play.svg",
  alt: "Icon play video",
  class: "transform translate-x-0.5 w-12"
}, null, -1);

function render$1(_ctx, _cache, $props, $setup, $data, $options) {
  return vue.openBlock(), vue.createBlock("div", {
    class: "shadow-xl rounded-3xl overflow-hidden relative",
    onMouseenter: _cache[14] || (_cache[14] = function ($event) {
      return _ctx.hovered = true;
    }),
    onMouseleave: _cache[15] || (_cache[15] = function ($event) {
      return _ctx.hovered = false;
    }),
    onKeydown: _cache[16] || (_cache[16] = vue.withKeys(function ($event) {
      return _ctx.$emit('play');
    }, ["left"]))
  }, [vue.createVNode("div", _hoisted_1$1, [vue.createVNode("video", {
    ref: _ctx.uuid,
    class: "w-full",
    loop: _ctx.loop,
    autoplay: _ctx.autoplay,
    muted: _ctx.autoplay,
    onTimeupdate: _cache[1] || (_cache[1] = function ($event) {
      return _ctx.$emit('timeupdate', $event.target);
    }),
    onPause: _cache[2] || (_cache[2] = function ($event) {
      return _ctx.$emit('isPlaying', false);
    }),
    onPlay: _cache[3] || (_cache[3] = function ($event) {
      return _ctx.$emit('isPlaying', true);
    }),
    onClick: _cache[4] || (_cache[4] = function ($event) {
      return _ctx.$emit('play');
    })
  }, [vue.createVNode("source", {
    src: _ctx.src,
    type: "video/mp4"
  }, null, 8, ["src"])], 40, ["loop", "autoplay", "muted"]), _ctx.controls ? (vue.openBlock(), vue.createBlock("div", {
    key: 0,
    class: [_defineProperty({
      'opacity-0 translate-y-full': !_ctx.hoverable && _ctx.hovered
    }, "opacity-0 translate-y-full", _ctx.hoverable && !_ctx.hovered), "absolute px-5 pb-5 bottom-0 left-0 w-full transition duration-300 transform"]
  }, [vue.createVNode("div", {
    class: "w-full bg-black bg-opacity-30 px-5 py-4 rounded-xl flex items-center justify-between",
    onMouseleave: _cache[12] || (_cache[12] = function ($event) {
      return _ctx.volume = false;
    })
  }, [vue.createVNode("div", {
    class: "font-sans py-1 px-2 text-white rounded-md text-xs mr-5 whitespace-nowrap font-medium w-32 text-center",
    style: "font-size: 11px; background-color: ".concat(_ctx.color)
  }, vue.toDisplayString(_ctx.time.display) + " / " + vue.toDisplayString(_ctx.duration), 5), vue.createVNode("div", _hoisted_2, [vue.withDirectives(vue.createVNode("img", {
    src: "https://en-zo.dev/vue-videoplayer/basic/pause.svg",
    alt: "Icon pause video",
    class: "w-4 cursor-pointer filter-white transition duration-300",
    onClick: _cache[5] || (_cache[5] = function ($event) {
      return _ctx.$emit('play');
    })
  }, null, 512), [[vue.vShow, _ctx.playing]]), vue.withDirectives(vue.createVNode("img", {
    src: "https://en-zo.dev/vue-videoplayer/basic/play.svg",
    alt: "Icon play video",
    class: "w-4 cursor-pointer filter-white transition duration-300",
    onClick: _cache[6] || (_cache[6] = function ($event) {
      return _ctx.$emit('play');
    })
  }, null, 512), [[vue.vShow, !_ctx.playing]])]), vue.createVNode("div", {
    class: "w-full h-1 bg-white bg-opacity-40 rounded-sm cursor-pointer mr-6",
    onClick: _cache[7] || (_cache[7] = function (e) {
      return _ctx.$emit('position', e);
    })
  }, [vue.createVNode("div", {
    class: "w-full rounded-sm h-full bg-white pointer-events-none",
    style: "width: ".concat(_ctx.time.progress, "%; transition: width .2s ease-in-out;")
  }, null, 4)]), vue.createVNode("div", _hoisted_3, [vue.createVNode("div", {
    class: "w-128 origin-left translate-x-2 -rotate-90 w-128 transition duration-200 absolute transform top-0 py-2 ".concat(_ctx.volume ? '-translate-y-4' : 'opacity-0 -translate-y-1 pointer-events-none')
  }, [vue.createVNode("div", _hoisted_4, [vue.withDirectives(vue.createVNode("input", {
    "onUpdate:modelValue": _cache[8] || (_cache[8] = function ($event) {
      return _ctx.amount = $event;
    }),
    type: "range",
    step: "0.05",
    min: "0",
    max: "1",
    class: "rounded-lg overflow-hidden appearance-none bg-white bg-opacity-30 h-1.5 w-128 vertical-range"
  }, null, 512), [[vue.vModelText, _ctx.amount]])])], 2), vue.createVNode("img", {
    src: "https://en-zo.dev/vue-videoplayer/basic/volume_".concat(Math.ceil(_ctx.amount * 2), ".svg"),
    alt: "High volume video",
    class: "w-5 cursor-pointer filter-white transition duration-300 relative",
    style: {
      "z-index": "2"
    },
    onClick: _cache[9] || (_cache[9] = function () {
      return _ctx.stopVolume && _ctx.stopVolume.apply(_ctx, arguments);
    }),
    onMouseenter: _cache[10] || (_cache[10] = function ($event) {
      return _ctx.volume = true;
    })
  }, null, 40, ["src"])]), vue.createVNode("img", {
    src: "https://en-zo.dev/vue-videoplayer/basic/fullscreen.svg",
    alt: "Fullscreen",
    class: "w-4 cursor-pointer filter-white transition duration-300",
    onClick: _cache[11] || (_cache[11] = function ($event) {
      return _ctx.$emit('fullScreen');
    })
  })], 32)], 2)) : vue.createCommentVNode("", true), !_ctx.autoplay && _ctx.mask && _ctx.time.current === 0 ? (vue.openBlock(), vue.createBlock("div", {
    key: 1,
    class: "transition transform duration-300 absolute top-0 left-0 w-full h-full bg-black bg-opacity-50 backdrop-filter z-10 flex items-center justify-center ".concat(_ctx.playing ? 'opacity-0 pointer-events-none' : '')
  }, [vue.createVNode("div", {
    class: "w-20 h-20 rounded-full bg-white bg-opacity-20 transition duration-200 hover:bg-opacity-40 flex items-center justify-center cursor-pointer",
    onClick: _cache[13] || (_cache[13] = function ($event) {
      return _ctx.$emit('play');
    })
  }, [_hoisted_5])], 2)) : vue.createCommentVNode("", true)])], 32);
}script$1.render = render$1;var script = /*#__PURE__*/vue.defineComponent({
  name: 'Vue3PlayerVideo',
  // vue component name
  components: {
    basic: script$1,
    gradient: script$2
  },
  props: {
    src: {
      type: String,
      required: true
    },
    autoplay: {
      type: Boolean,
      default: false
    },
    loop: {
      type: Boolean,
      default: false
    },
    controls: {
      type: Boolean,
      default: true
    },
    mask: {
      type: Boolean,
      default: true
    },
    colors: {
      type: [String, Array],
      default: function _default() {
        return ['#8B5CF6', '#ec4899'];
      }
    },
    hoverable: {
      type: Boolean,
      default: false
    },
    theme: {
      type: String,
      default: 'basic'
    }
  },
  data: function data() {
    return {
      uuid: Math.random().toString(36).substr(2, 18),
      player: null,
      duration: 0,
      playing: false,
      time: {
        progress: 0,
        display: 0,
        current: 0
      }
    };
  },
  created: function created() {
    var _this = this;

    window.addEventListener('keyup', function (_ref) {
      var keyCode = _ref.keyCode;

      if (keyCode === 32) {
        _this.play();
      }
    });
  },
  watch: {
    'time.current': function timeCurrent(value) {
      this.time.display = this.format(Number(value));
      this.time.progress = value * 100 / this.player.duration;
    }
  },
  methods: {
    isPlaying: function isPlaying(bool) {
      this.playing = bool;
    },
    play: function play() {
      if (this.playing) {
        return this.player.pause();
      }

      return this.player.play();
    },
    setPlayer: function setPlayer(e) {
      var _this2 = this;

      this.player = e;
      this.player.addEventListener('loadeddata', function () {
        if (_this2.player.readyState >= 3) {
          _this2.duration = _this2.format(Number(_this2.player.duration));
          _this2.time.display = _this2.format(0);
        }
      });
    },
    stop: function stop() {
      this.player.pause();
      this.player.currentTime = 0;
    },
    fullScreen: function fullScreen() {
      this.player.webkitEnterFullscreen();
    },
    position: function position(e) {
      this.player.pause();
      var rect = e.target.getBoundingClientRect();
      var pos = e.clientX - rect.left;
      var percentage = pos * 100 / e.target.offsetWidth;
      this.player.currentTime = percentage * this.player.duration / 100;
      this.player.play();
    },
    format: function format(seconds) {
      var h = Math.floor(seconds / 3600);
      var m = Math.floor(seconds % 3600 / 60);
      var s = Math.round(seconds % 60);
      return [h, m > 9 ? m : h ? '0' + m : m || '00', s > 9 ? s : '0' + s].filter(Boolean).join(':');
    }
  }
});var _hoisted_1 = {
  class: "vue3-player-video"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return vue.openBlock(), vue.createBlock("div", _hoisted_1, [(vue.openBlock(), vue.createBlock(vue.resolveDynamicComponent(_ctx.theme), {
    uuid: _ctx.uuid,
    src: _ctx.src,
    autoplay: _ctx.autoplay,
    loop: _ctx.loop,
    controls: _ctx.controls,
    mask: _ctx.mask,
    colors: _ctx.colors,
    time: _ctx.time,
    playing: _ctx.playing,
    duration: _ctx.duration,
    hoverable: _ctx.hoverable,
    onPlay: _ctx.play,
    onStop: _ctx.stop,
    onTimeupdate: _cache[1] || (_cache[1] = function (_ref) {
      var currentTime = _ref.currentTime;
      return _ctx.time.current = currentTime;
    }),
    onPosition: _ctx.position,
    onFullScreen: _ctx.fullScreen,
    onSetPlayer: _ctx.setPlayer,
    onIsPlaying: _ctx.isPlaying
  }, null, 8, ["uuid", "src", "autoplay", "loop", "controls", "mask", "colors", "time", "playing", "duration", "hoverable", "onPlay", "onStop", "onPosition", "onFullScreen", "onSetPlayer", "onIsPlaying"]))]);
}function styleInject(css, ref) {
  if ( ref === void 0 ) ref = {};
  var insertAt = ref.insertAt;

  if (!css || typeof document === 'undefined') { return; }

  var head = document.head || document.getElementsByTagName('head')[0];
  var style = document.createElement('style');
  style.type = 'text/css';

  if (insertAt === 'top') {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }

  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}var css_248z = "/*! tailwindcss v2.1.2 | MIT License | https://tailwindcss.com*/\n\n/*! modern-normalize v1.1.0 | MIT License | https://github.com/sindresorhus/modern-normalize */input{font-family:inherit;font-size:100%;line-height:1.15;margin:0}[type=button],[type=reset],[type=submit]{-webkit-appearance:button}::-moz-focus-inner{border-style:none;padding:0}:-moz-focusring{outline:1px dotted ButtonText}:-moz-ui-invalid{box-shadow:none}progress{vertical-align:baseline}::-webkit-inner-spin-button,::-webkit-outer-spin-button{height:auto}[type=search]{-webkit-appearance:textfield;outline-offset:-2px}::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}p{margin:0}*,:after,:before{box-sizing:border-box;border:0 solid #e5e7eb}img{border-style:solid}input:-ms-input-placeholder{opacity:1;color:#9ca3af}input::placeholder{opacity:1;color:#9ca3af}[role=button]{cursor:pointer}input{padding:0;line-height:inherit;color:inherit}img,svg,video{display:block;vertical-align:middle}img,video{max-width:100%;height:auto}.vue3-player-video .appearance-none{-webkit-appearance:none;appearance:none}.vue3-player-video .bg-black{--tw-bg-opacity:1;background-color:rgba(0,0,0,var(--tw-bg-opacity))}.vue3-player-video .bg-white{--tw-bg-opacity:1;background-color:rgba(255,255,255,var(--tw-bg-opacity))}.vue3-player-video .bg-gradient-to-r{background-image:linear-gradient(90deg,var(--tw-gradient-stops))}.vue3-player-video .bg-opacity-20{--tw-bg-opacity:0.2}.vue3-player-video .bg-opacity-30{--tw-bg-opacity:0.3}.vue3-player-video .bg-opacity-40{--tw-bg-opacity:0.4}.vue3-player-video .bg-opacity-50{--tw-bg-opacity:0.5}.vue3-player-video .bg-opacity-60{--tw-bg-opacity:0.6}.vue3-player-video .hover\\:bg-opacity-40:hover{--tw-bg-opacity:0.4}.vue3-player-video .rounded-sm{border-radius:.125rem}.vue3-player-video .rounded-md{border-radius:.375rem}.vue3-player-video .rounded-lg{border-radius:.5rem}.vue3-player-video .rounded-xl{border-radius:.75rem}.vue3-player-video .rounded-3xl{border-radius:1.5rem}.vue3-player-video .rounded-full{border-radius:9999px}.vue3-player-video .cursor-pointer{cursor:pointer}.vue3-player-video .flex{display:flex}.vue3-player-video .items-center{align-items:center}.vue3-player-video .justify-start{justify-content:flex-start}.vue3-player-video .justify-end{justify-content:flex-end}.vue3-player-video .justify-center{justify-content:center}.vue3-player-video .justify-between{justify-content:space-between}.vue3-player-video .font-sans{font-family:ui-sans-serif,system-ui,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica Neue,Arial,Noto Sans,sans-serif,Apple Color Emoji,Segoe UI Emoji,Segoe UI Symbol,Noto Color Emoji}.vue3-player-video .font-medium{font-weight:500}.vue3-player-video .h-1{height:.25rem}.vue3-player-video .h-20{height:5rem}.vue3-player-video .h-full{height:100%}.vue3-player-video .text-xs{font-size:.75rem;line-height:1rem}.vue3-player-video .ml-2{margin-left:.5rem}.vue3-player-video .mr-3{margin-right:.75rem}.vue3-player-video .ml-4{margin-left:1rem}.vue3-player-video .mr-5{margin-right:1.25rem}.vue3-player-video .ml-5{margin-left:1.25rem}.vue3-player-video .mr-6{margin-right:1.5rem}.vue3-player-video .opacity-0{opacity:0}.vue3-player-video .overflow-hidden{overflow:hidden}.vue3-player-video .py-1{padding-top:.25rem;padding-bottom:.25rem}.vue3-player-video .py-2{padding-top:.5rem;padding-bottom:.5rem}.vue3-player-video .px-2{padding-left:.5rem;padding-right:.5rem}.vue3-player-video .py-3{padding-top:.75rem;padding-bottom:.75rem}.vue3-player-video .px-3{padding-left:.75rem;padding-right:.75rem}.vue3-player-video .py-4{padding-top:1rem;padding-bottom:1rem}.vue3-player-video .px-5{padding-left:1.25rem;padding-right:1.25rem}.vue3-player-video .pt-3{padding-top:.75rem}.vue3-player-video .pb-5{padding-bottom:1.25rem}.vue3-player-video .pointer-events-none{pointer-events:none}.vue3-player-video .absolute{position:absolute}.vue3-player-video .relative{position:relative}.vue3-player-video .top-0{top:0}.vue3-player-video .bottom-0{bottom:0}.vue3-player-video .left-0{left:0}*{--tw-shadow:0 0 transparent}.vue3-player-video .shadow-xl{--tw-shadow:0 20px 25px -5px rgba(0,0,0,0.1),0 10px 10px -5px rgba(0,0,0,0.04);box-shadow:var(--tw-ring-offset-shadow,0 0 transparent),var(--tw-ring-shadow,0 0 transparent),var(--tw-shadow)}*{--tw-ring-inset:var(--tw-empty,/*!*/ /*!*/);--tw-ring-offset-width:0px;--tw-ring-offset-color:#fff;--tw-ring-color:rgba(59,130,246,0.5);--tw-ring-offset-shadow:0 0 transparent;--tw-ring-shadow:0 0 transparent}.vue3-player-video .text-center{text-align:center}.vue3-player-video .text-white{--tw-text-opacity:1;color:rgba(255,255,255,var(--tw-text-opacity))}.vue3-player-video .whitespace-nowrap{white-space:nowrap}.vue3-player-video .w-3{width:.75rem}.vue3-player-video .w-4{width:1rem}.vue3-player-video .w-5{width:1.25rem}.vue3-player-video .w-12{width:3rem}.vue3-player-video .w-20{width:5rem}.vue3-player-video .w-24{width:6rem}.vue3-player-video .w-32{width:8rem}.vue3-player-video .w-full{width:100%}.vue3-player-video .z-10{z-index:10}.vue3-player-video .transform{--tw-translate-x:0;--tw-translate-y:0;--tw-rotate:0;--tw-skew-x:0;--tw-skew-y:0;--tw-scale-x:1;--tw-scale-y:1;transform:translateX(var(--tw-translate-x)) translateY(var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.vue3-player-video .origin-left{transform-origin:left}.vue3-player-video .-rotate-90{--tw-rotate:-90deg}.vue3-player-video .translate-x-0{--tw-translate-x:0px}.vue3-player-video .translate-x-2{--tw-translate-x:0.5rem}.vue3-player-video .translate-x-9{--tw-translate-x:2.25rem}.vue3-player-video .-translate-y-1{--tw-translate-y:-0.25rem}.vue3-player-video .-translate-y-4{--tw-translate-y:-1rem}.vue3-player-video .translate-y-full{--tw-translate-y:100%}.vue3-player-video .transition{transition-property:background-color,border-color,color,fill,stroke,opacity,box-shadow,transform,filter,-webkit-backdrop-filter;transition-property:background-color,border-color,color,fill,stroke,opacity,box-shadow,transform,filter,backdrop-filter;transition-property:background-color,border-color,color,fill,stroke,opacity,box-shadow,transform,filter,backdrop-filter,-webkit-backdrop-filter;transition-timing-function:cubic-bezier(.4,0,.2,1);transition-duration:.15s}.vue3-player-video .ease-in-out{transition-timing-function:cubic-bezier(.4,0,.2,1)}.vue3-player-video .duration-200{transition-duration:.2s}.vue3-player-video .duration-300{transition-duration:.3s}@keyframes spin{to{transform:rotate(1turn)}}@keyframes ping{75%,to{transform:scale(2);opacity:0}}@keyframes pulse{50%{opacity:.5}}@keyframes bounce{0%,to{transform:translateY(-25%);animation-timing-function:cubic-bezier(.8,0,1,1)}50%{transform:none;animation-timing-function:cubic-bezier(0,0,.2,1)}}.vue3-player-video .filter{--tw-blur:var(--tw-empty,/*!*/ /*!*/);--tw-brightness:var(--tw-empty,/*!*/ /*!*/);--tw-contrast:var(--tw-empty,/*!*/ /*!*/);--tw-grayscale:var(--tw-empty,/*!*/ /*!*/);--tw-hue-rotate:var(--tw-empty,/*!*/ /*!*/);--tw-invert:var(--tw-empty,/*!*/ /*!*/);--tw-saturate:var(--tw-empty,/*!*/ /*!*/);--tw-sepia:var(--tw-empty,/*!*/ /*!*/);--tw-drop-shadow:var(--tw-empty,/*!*/ /*!*/);filter:var(--tw-blur) var(--tw-brightness) var(--tw-contrast) var(--tw-grayscale) var(--tw-hue-rotate) var(--tw-invert) var(--tw-saturate) var(--tw-sepia) var(--tw-drop-shadow)}.vue3-player-video .blur-sm{--tw-blur:blur(4px)}.vue3-player-video .blur{--tw-blur:blur(8px)}.vue3-player-video .backdrop-filter{--tw-backdrop-blur:var(--tw-empty,/*!*/ /*!*/);--tw-backdrop-brightness:var(--tw-empty,/*!*/ /*!*/);--tw-backdrop-contrast:var(--tw-empty,/*!*/ /*!*/);--tw-backdrop-grayscale:var(--tw-empty,/*!*/ /*!*/);--tw-backdrop-hue-rotate:var(--tw-empty,/*!*/ /*!*/);--tw-backdrop-invert:var(--tw-empty,/*!*/ /*!*/);--tw-backdrop-opacity:var(--tw-empty,/*!*/ /*!*/);--tw-backdrop-saturate:var(--tw-empty,/*!*/ /*!*/);--tw-backdrop-sepia:var(--tw-empty,/*!*/ /*!*/);-webkit-backdrop-filter:var(--tw-backdrop-blur) var(--tw-backdrop-brightness) var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale) var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert) var(--tw-backdrop-opacity) var(--tw-backdrop-saturate) var(--tw-backdrop-sepia);backdrop-filter:var(--tw-backdrop-blur) var(--tw-backdrop-brightness) var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale) var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert) var(--tw-backdrop-opacity) var(--tw-backdrop-saturate) var(--tw-backdrop-sepia)}.overlay{background:linear-gradient(0deg,rgba(0,0,0,.41961),transparent)}.vertical-range::-webkit-slider-thumb{width:6px;-webkit-appearance:none;appearance:none;height:6px;background-color:#fff;cursor:ns-resize;box-shadow:-405px 0 0 400px hsla(0,0%,100%,.6);border-radius:50%}.backdrop-filter{-webkit-backdrop-filter:blur(15px)!important;backdrop-filter:blur(15px)!important}.filter-white:hover{filter:brightness(2)}.gradient-variable{--tw-gradient-from:#fbbf24;--tw-gradient-to:#ec4899;--tw-gradient-stops:var(--tw-gradient-from),var(--tw-gradient-to,rgba(251,191,36,0))}";
styleInject(css_248z);script.render = render;// Import vue component
// IIFE injects install function into component, allowing component
// to be registered via Vue.use() as well as Vue.component(),

var component = /*#__PURE__*/(function () {
  // Get component instance
  var installable = script; // Attach install function executed by Vue.use()

  installable.install = function (app) {
    app.component('Vue3PlayerVideo', installable);
  };

  return installable;
})(); // It's possible to expose named exports when writing components that can
// also be used as directives, etc. - eg. import { RollupDemoDirective } from 'rollup-demo';
// export const RollupDemoDirective = directive;
var namedExports=/*#__PURE__*/Object.freeze({__proto__:null,'default': component});// only expose one global var, with named exports exposed as properties of
// that global var (eg. plugin.namedExport)

Object.entries(namedExports).forEach(function (_ref) {
  var _ref2 = _slicedToArray(_ref, 2),
      exportName = _ref2[0],
      exported = _ref2[1];

  if (exportName !== 'default') component[exportName] = exported;
});module.exports=component;