# vue-router [![release candidate](https://img.shields.io/npm/v/vue-router.svg)](https://www.npmjs.com/package/vue-router) [![CircleCI](https://badgen.net/circleci/github/vuejs/router/main)](https://circleci.com/gh/vuejs/router)

> This is the repository for Vue Router 4 (for Vue 3)

<h2 align="center">Supporting Vue Router</h2>

Vue Router is part of the Vue Ecosystem and is an MIT-licensed open source project with its ongoing development made possible entirely by the support of Sponsors. If you would like to become a sponsor, please consider:

- [Become a Sponsor on GitHub](https://github.com/sponsors/posva)
- [One-time donation via PayPal](https://paypal.me/posva)

<!--sponsors start-->

<h3 align="center">Platinum Sponsors</h3>
  <p align="center">
    <a href="https://www.finclip.com/#/home?from=vue" target="_blank" rel="noopener noreferrer">
      <picture>
        <source srcset="https://posva-sponsors.pages.dev/logos/fincliplogo_white_svg.svg" media="(prefers-color-scheme: dark)" height="96px" alt="Finogeeks" />
        <img src="https://posva-sponsors.pages.dev/logos/fincliplogo_black_svg.svg" height="96px" alt="Finogeeks" />
      </picture>
    </a>
  </p>

<h4 align="center">Gold Sponsors</h4>
  <p align="center">
    <a href="https://vuejobs.com/?utm_source=vuerouter&utm_campaign=sponsor" target="_blank" rel="noopener noreferrer">
      <picture>
        <source srcset="https://posva-sponsors.pages.dev/logos/vuejobs.svg" media="(prefers-color-scheme: dark)" height="72px" alt="VueJobs" />
        <img src="https://posva-sponsors.pages.dev/logos/vuejobs.svg" height="72px" alt="VueJobs" />
      </picture>
    </a>
  </p>

<h4 align="center">Silver Sponsors</h4>
  <p align="center">
    <a href="https://www.vuemastery.com/" target="_blank" rel="noopener noreferrer">
      <picture>
        <source srcset="https://posva-sponsors.pages.dev/logos/vuemastery-dark.png" media="(prefers-color-scheme: dark)" height="42px" alt="VueMastery" />
        <img src="https://posva-sponsors.pages.dev/logos/vuemastery-light.svg" height="42px" alt="VueMastery" />
      </picture>
    </a>
    <a href="https://birdeatsbug.com/?utm_source=vuerouter&utm_medium=sponsor&utm_campaign=silver" target="_blank" rel="noopener noreferrer">
      <picture>
        <source srcset="https://posva-sponsors.pages.dev/logos/birdeatsbug-light.svg" media="(prefers-color-scheme: dark)" height="42px" alt="Bird Eats Bug" />
        <img src="https://posva-sponsors.pages.dev/logos/birdeatsbug-dark.svg" height="42px" alt="Bird Eats Bug" />
      </picture>
    </a>
  </p>

<h4 align="center">Bronze Sponsors</h4>
  <p align="center">
    <a href="https://storyblok.com" target="_blank" rel="noopener noreferrer">
      <picture>
        <source srcset="https://posva-sponsors.pages.dev/logos/storyblok.png" media="(prefers-color-scheme: dark)" height="26px" alt="Storyblok" />
        <img src="https://posva-sponsors.pages.dev/logos/storyblok.png" height="26px" alt="Storyblok" />
      </picture>
    </a>
    <a href="https://nuxtjs.org" target="_blank" rel="noopener noreferrer">
      <picture>
        <source srcset="https://posva-sponsors.pages.dev/logos/nuxt-dark.svg" media="(prefers-color-scheme: dark)" height="26px" alt="NuxtJS" />
        <img src="https://posva-sponsors.pages.dev/logos/nuxt-light.svg" height="26px" alt="NuxtJS" />
      </picture>
    </a>
  </p>
<!--sponsors end-->

---

Get started with the [documentation](https://router.vuejs.org).

## Quickstart

- Via CDN: `<script src="https://unpkg.com/vue-router@4"></script>`
- In-browser playground on [CodeSandbox](https://codesandbox.io/s/vue-router-4-reproduction-hb9lh)
- Add it to an existing Vue Project:
  ```bash
  npm install vue-router@4
  ```

## Changes from Vue Router 3

Please consult the [Migration Guide](https://router.vuejs.org/guide/migration/).

## Contributing

See [Contributing Guide](https://github.com/vuejs/router/blob/main/.github/contributing.md).

## Special Thanks

<a href="https://www.browserstack.com">
  <img src="https://github.com/vuejs/vue-router/raw/dev/assets/browserstack-logo-600x315.png" height="80" title="BrowserStack Logo" alt="BrowserStack Logo" />
</a>

Special thanks to [BrowserStack](https://www.browserstack.com) for letting the maintainers use their service to debug browser specific issues.
