import type { Ref, WatchSource } from 'vue';
import type { LoadMoreExtendsOption } from '../useLoadMore';
import type { PaginationExtendsOption } from '../usePagination';
import type { UnWrapRefObject } from './utils/types';
export interface BaseResult<R, P extends unknown[]> extends QueryState<R, P> {
    queries: Queries<R, P>;
    reset: () => void;
}
export declare type UnWrapState<R, P extends unknown[]> = UnWrapRefObject<InnerQueryState<R, P>>;
export declare type Queries<R, P extends unknown[]> = {
    [key: string]: UnWrapState<R, P>;
};
declare type MutateData<R> = (newData: R) => void;
declare type MutateFunction<R> = (arg: (oldData: R) => R) => void;
export declare type Query<R, P extends unknown[]> = (...args: P) => Promise<R>;
export interface Mutate<R> extends MutateData<R>, MutateFunction<R> {
}
export declare type State<R, P> = {
    loading: Ref<boolean>;
    data: Ref<R | undefined>;
    error: Ref<Error | undefined>;
    params: Ref<P>;
};
export interface QueryState<R, P extends unknown[]> extends State<R, P> {
    run: (...arg: P) => Promise<R | null>;
    cancel: () => void;
    refresh: () => Promise<R | null>;
    mutate: Mutate<R>;
}
export interface InnerQueryState<R, P extends unknown[]> extends QueryState<R, P> {
    unmount: () => void;
}
interface DebounceOptions {
    leading?: boolean;
    trailing?: boolean;
    maxWait?: number;
}
declare type ThrottleOptions = Omit<DebounceOptions, 'maxWait'>;
export interface GlobalOptions extends PaginationExtendsOption, LoadMoreExtendsOption {
    loadingDelay?: number;
    pollingInterval?: number;
    pollingWhenHidden?: boolean;
    pollingWhenOffline?: boolean;
    debounceInterval?: number;
    debounceOptions?: DebounceOptions;
    throttleOptions?: ThrottleOptions;
    throttleInterval?: number;
    refreshOnWindowFocus?: boolean;
    refocusTimespan?: number;
    cacheTime?: number;
    staleTime?: number;
    manual?: boolean;
    errorRetryCount?: number;
    errorRetryInterval?: number;
}
export declare type BaseOptions<R, P extends unknown[]> = GlobalOptions & {
    defaultParams?: P;
    ready?: Ref<boolean>;
    initialData?: R;
    refreshDeps?: WatchSource<any>[];
    cacheKey?: string;
    queryKey?: (...args: P) => string;
    onSuccess?: (data: R, params: P) => void;
    onError?: (error: Error, params: P) => void;
    onBefore?: (params: P) => void;
    onAfter?: (params: P) => void;
};
declare const FRPlaceholderType: unique symbol;
export declare type FRPlaceholderType = typeof FRPlaceholderType;
export declare type FormatOptions<R, P extends unknown[], FR> = {
    formatResult: (data: R) => FR;
    onSuccess?: (data: FR extends FRPlaceholderType ? any : FR, params: P) => void;
} & Omit<BaseOptions<FR, P>, 'onSuccess'>;
export declare type MixinOptions<R, P extends unknown[], FR> = BaseOptions<R, P> | FormatOptions<R, P, FR>;
export declare type Config<R, P extends unknown[]> = Omit<BaseOptions<R, P>, 'defaultParams' | 'manual' | 'ready' | 'refreshDeps' | 'queryKey'> & Required<Pick<BaseOptions<R, P>, 'loadingDelay' | 'pollingWhenHidden' | 'pollingWhenOffline' | 'refreshOnWindowFocus' | 'errorRetryCount' | 'errorRetryInterval'>> & {
    stopPollingWhenHiddenOrOffline: Ref<boolean>;
    initialAutoRunFlag: Ref<boolean>;
    formatResult?: (data: any) => R;
    updateCache: (state: State<R, P>) => void;
};
export {};
