import { Plugin } from 'vite';
import { Options } from 'svgo';

interface ViteSvgIconsPlugin {
    /**
     * icons folder, all svg files in it will be converted to svg sprite.
     */
    iconDirs: string[];
    /**
     * svgo configuration, used to compress svg
     * @default：true
     */
    svgoOptions?: boolean | Options;
    /**
     * icon format
     * @default: icon-[dir]-[name]
     */
    symbolId?: string;
}
interface FileStats {
    relativeName: string;
    mtimeMs?: number;
    code: string;
    symbolId?: string;
}
declare const _default: (opt: ViteSvgIconsPlugin) => Plugin;

declare function createModuleCode(cache: Map<string, FileStats>, svgoOptions: Options, options: ViteSvgIconsPlugin): Promise<{
    code: string;
    idSet: string;
}>;
/**
 * Preload all icons in advance
 * @param cache
 * @param options
 */
declare function compilerIcons(cache: Map<string, FileStats>, svgOptions: Options, options: ViteSvgIconsPlugin): Promise<{
    insertHtml: string;
    idSet: Set<string>;
}>;
declare function compilerIcon(file: string, symbolId: string, svgOptions: Options): Promise<string | null>;
declare function createSymbolId(name: string, options: ViteSvgIconsPlugin): string;
declare function discreteDir(name: string): {
    fileName: string | undefined;
    dirName: string;
};

export default _default;
export { ViteSvgIconsPlugin, compilerIcon, compilerIcons, createModuleCode, createSymbolId, discreteDir };
