import ajax from './ajax';
import type { PropType } from 'vue';
import type { ListType, UploadFile, ElFile } from './upload.type';
declare type Nullable<T> = null | T;
declare type IFileHanlder = (file: Nullable<ElFile[]>, fileList?: UploadFile[]) => unknown;
declare type AjaxEventListener = (e: ProgressEvent, file: ElFile) => unknown;
declare const _default: import("vue").DefineComponent<{
    type: {
        type: StringConstructor;
        default: string;
    };
    action: {
        type: StringConstructor;
        required: true;
    };
    name: {
        type: StringConstructor;
        default: string;
    };
    data: {
        type: PropType<Record<string, any>>;
        default: () => any;
    };
    headers: {
        type: PropType<Partial<Headers>>;
        default: () => any;
    };
    withCredentials: {
        type: BooleanConstructor;
        default: boolean;
    };
    multiple: {
        type: PropType<boolean>;
        default: any;
    };
    accept: {
        type: StringConstructor;
        default: string;
    };
    onStart: {
        type: PropType<(file: File) => void>;
        default: (file: File) => void;
    };
    onProgress: {
        type: PropType<AjaxEventListener>;
        default: AjaxEventListener;
    };
    onSuccess: {
        type: PropType<AjaxEventListener>;
        default: AjaxEventListener;
    };
    onError: {
        type: PropType<AjaxEventListener>;
        default: AjaxEventListener;
    };
    beforeUpload: {
        type: PropType<(file: File) => Promise<File | Blob> | boolean | unknown>;
        default: (file: File) => void;
    };
    drag: {
        type: BooleanConstructor;
        default: boolean;
    };
    onPreview: {
        type: PropType<IFileHanlder>;
        default: IFileHanlder;
    };
    onRemove: {
        type: PropType<(file: Nullable<FileList>, rawFile: ElFile) => void>;
        default: (file: Nullable<FileList>, rawFile: ElFile) => void;
    };
    fileList: {
        type: PropType<UploadFile[]>;
        default: () => UploadFile[];
    };
    autoUpload: {
        type: BooleanConstructor;
        default: boolean;
    };
    listType: {
        type: PropType<ListType>;
        default: string;
    };
    httpRequest: {
        type: PropType<typeof ajax> | PropType<(...args: unknown[]) => Promise<unknown>>;
        default: () => typeof ajax;
    };
    disabled: BooleanConstructor;
    limit: {
        type: PropType<number>;
        default: any;
    };
    onExceed: {
        type: PropType<(files: FileList, fileList: UploadFile[]) => void>;
        default: () => void;
    };
}, {
    reqs: any;
    mouseover: import("vue").Ref<boolean>;
    inputRef: import("vue").Ref<HTMLInputElement>;
    abort: (file: any) => void;
    post: (rawFile: ElFile) => void;
    handleChange: (e: DragEvent) => void;
    handleClick: () => void;
    handleKeydown: () => void;
    upload: (rawFile: ElFile) => void;
    uploadFiles: (files: FileList) => void;
}, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, Record<string, any>, string, import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<{
    disabled: boolean;
    listType: ListType;
    name: string;
    type: string;
    action: string;
    withCredentials: boolean;
    accept: string;
    onStart: (file: File) => void;
    onProgress: AjaxEventListener;
    onSuccess: AjaxEventListener;
    onError: AjaxEventListener;
    beforeUpload: (file: File) => Promise<File | Blob> | boolean | unknown;
    drag: boolean;
    onPreview: IFileHanlder;
    onRemove: (file: Nullable<FileList>, rawFile: ElFile) => void;
    fileList: UploadFile[];
    autoUpload: boolean;
    httpRequest: typeof ajax | ((...args: unknown[]) => Promise<unknown>);
    onExceed: (files: FileList, fileList: UploadFile[]) => void;
} & {
    data?: any;
    headers?: any;
    multiple?: boolean;
    limit?: number;
}>, {
    disabled: boolean;
    listType: ListType;
    name: string;
    type: string;
    data: any;
    headers: any;
    withCredentials: boolean;
    multiple: boolean;
    accept: string;
    onStart: (file: File) => void;
    onProgress: AjaxEventListener;
    onSuccess: AjaxEventListener;
    onError: AjaxEventListener;
    beforeUpload: (file: File) => Promise<File | Blob> | boolean | unknown;
    drag: boolean;
    onPreview: IFileHanlder;
    onRemove: (file: Nullable<FileList>, rawFile: ElFile) => void;
    fileList: UploadFile[];
    autoUpload: boolean;
    httpRequest: typeof ajax | ((...args: unknown[]) => Promise<unknown>);
    limit: number;
    onExceed: (files: FileList, fileList: UploadFile[]) => void;
}>;
export default _default;
