import { TableColumnCtx } from './table-column/defaults';
import { Store } from './store/index';
import { TreeNode } from './table/defaults';
export declare const cellStarts: {
    default: {
        order: string;
    };
    selection: {
        width: number;
        minWidth: number;
        realWidth: number;
        order: string;
        className: string;
    };
    expand: {
        width: number;
        minWidth: number;
        realWidth: number;
        order: string;
    };
    index: {
        width: number;
        minWidth: number;
        realWidth: number;
        order: string;
    };
};
export declare const cellForced: {
    selection: {
        renderHeader: <T>({ store }: {
            store: {
                mutations: {
                    setData(states: {
                        _currentRowKey: import("vue").Ref<string>;
                        currentRow: import("vue").Ref<T>;
                        expandRowKeys: import("vue").Ref<string[]>;
                        treeData: import("vue").Ref<unknown>;
                        indent: import("vue").Ref<number>;
                        lazy: import("vue").Ref<boolean>;
                        lazyTreeNodeMap: import("vue").Ref<{}>;
                        lazyColumnIdentifier: import("vue").Ref<string>;
                        childrenColumnName: import("vue").Ref<string>;
                        expandRows: import("vue").Ref<T[]>;
                        defaultExpandAll: import("vue").Ref<boolean>;
                        rowKey: import("vue").Ref<string>;
                        data: import("vue").Ref<T[]>;
                        _data: import("vue").Ref<T[]>;
                        isComplex: import("vue").Ref<boolean>;
                        _columns: import("vue").Ref<TableColumnCtx<T>[]>;
                        originColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        columns: import("vue").Ref<TableColumnCtx<T>[]>;
                        fixedColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        rightFixedColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        leafColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        fixedLeafColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        rightFixedLeafColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        leafColumnsLength: import("vue").Ref<number>;
                        fixedLeafColumnsLength: import("vue").Ref<number>;
                        rightFixedLeafColumnsLength: import("vue").Ref<number>;
                        isAllSelected: import("vue").Ref<boolean>;
                        selection: import("vue").Ref<T[]>;
                        reserveSelection: import("vue").Ref<boolean>;
                        selectOnIndeterminate: import("vue").Ref<boolean>;
                        selectable: import("vue").Ref<(row: T, index: number) => boolean>;
                        filters: import("vue").Ref<import("./store/index").StoreFilter>;
                        filteredData: any;
                        sortingColumn: any;
                        sortProp: any;
                        sortOrder: any;
                        hoverRow: any;
                    }, data: T[]): void;
                    insertColumn(states: {
                        _currentRowKey: import("vue").Ref<string>;
                        currentRow: import("vue").Ref<T>;
                        expandRowKeys: import("vue").Ref<string[]>;
                        treeData: import("vue").Ref<unknown>;
                        indent: import("vue").Ref<number>;
                        lazy: import("vue").Ref<boolean>;
                        lazyTreeNodeMap: import("vue").Ref<{}>;
                        lazyColumnIdentifier: import("vue").Ref<string>;
                        childrenColumnName: import("vue").Ref<string>;
                        expandRows: import("vue").Ref<T[]>;
                        defaultExpandAll: import("vue").Ref<boolean>;
                        rowKey: import("vue").Ref<string>;
                        data: import("vue").Ref<T[]>;
                        _data: import("vue").Ref<T[]>;
                        isComplex: import("vue").Ref<boolean>;
                        _columns: import("vue").Ref<TableColumnCtx<T>[]>;
                        originColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        columns: import("vue").Ref<TableColumnCtx<T>[]>;
                        fixedColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        rightFixedColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        leafColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        fixedLeafColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        rightFixedLeafColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        leafColumnsLength: import("vue").Ref<number>;
                        fixedLeafColumnsLength: import("vue").Ref<number>;
                        rightFixedLeafColumnsLength: import("vue").Ref<number>;
                        isAllSelected: import("vue").Ref<boolean>;
                        selection: import("vue").Ref<T[]>;
                        reserveSelection: import("vue").Ref<boolean>;
                        selectOnIndeterminate: import("vue").Ref<boolean>;
                        selectable: import("vue").Ref<(row: T, index: number) => boolean>;
                        filters: import("vue").Ref<import("./store/index").StoreFilter>;
                        filteredData: any;
                        sortingColumn: any;
                        sortProp: any;
                        sortOrder: any;
                        hoverRow: any;
                    }, column: TableColumnCtx<T>, parent: TableColumnCtx<T>): void;
                    removeColumn(states: {
                        _currentRowKey: import("vue").Ref<string>;
                        currentRow: import("vue").Ref<T>;
                        expandRowKeys: import("vue").Ref<string[]>;
                        treeData: import("vue").Ref<unknown>;
                        indent: import("vue").Ref<number>;
                        lazy: import("vue").Ref<boolean>;
                        lazyTreeNodeMap: import("vue").Ref<{}>;
                        lazyColumnIdentifier: import("vue").Ref<string>;
                        childrenColumnName: import("vue").Ref<string>;
                        expandRows: import("vue").Ref<T[]>;
                        defaultExpandAll: import("vue").Ref<boolean>;
                        rowKey: import("vue").Ref<string>;
                        data: import("vue").Ref<T[]>;
                        _data: import("vue").Ref<T[]>;
                        isComplex: import("vue").Ref<boolean>;
                        _columns: import("vue").Ref<TableColumnCtx<T>[]>;
                        originColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        columns: import("vue").Ref<TableColumnCtx<T>[]>;
                        fixedColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        rightFixedColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        leafColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        fixedLeafColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        rightFixedLeafColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        leafColumnsLength: import("vue").Ref<number>;
                        fixedLeafColumnsLength: import("vue").Ref<number>;
                        rightFixedLeafColumnsLength: import("vue").Ref<number>;
                        isAllSelected: import("vue").Ref<boolean>;
                        selection: import("vue").Ref<T[]>;
                        reserveSelection: import("vue").Ref<boolean>;
                        selectOnIndeterminate: import("vue").Ref<boolean>;
                        selectable: import("vue").Ref<(row: T, index: number) => boolean>;
                        filters: import("vue").Ref<import("./store/index").StoreFilter>;
                        filteredData: any;
                        sortingColumn: any;
                        sortProp: any;
                        sortOrder: any;
                        hoverRow: any;
                    }, column: TableColumnCtx<T>, parent: TableColumnCtx<T>): void;
                    sort(states: {
                        _currentRowKey: import("vue").Ref<string>;
                        currentRow: import("vue").Ref<T>;
                        expandRowKeys: import("vue").Ref<string[]>;
                        treeData: import("vue").Ref<unknown>;
                        indent: import("vue").Ref<number>;
                        lazy: import("vue").Ref<boolean>;
                        lazyTreeNodeMap: import("vue").Ref<{}>;
                        lazyColumnIdentifier: import("vue").Ref<string>;
                        childrenColumnName: import("vue").Ref<string>;
                        expandRows: import("vue").Ref<T[]>;
                        defaultExpandAll: import("vue").Ref<boolean>;
                        rowKey: import("vue").Ref<string>;
                        data: import("vue").Ref<T[]>;
                        _data: import("vue").Ref<T[]>;
                        isComplex: import("vue").Ref<boolean>;
                        _columns: import("vue").Ref<TableColumnCtx<T>[]>;
                        originColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        columns: import("vue").Ref<TableColumnCtx<T>[]>;
                        fixedColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        rightFixedColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        leafColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        fixedLeafColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        rightFixedLeafColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        leafColumnsLength: import("vue").Ref<number>;
                        fixedLeafColumnsLength: import("vue").Ref<number>;
                        rightFixedLeafColumnsLength: import("vue").Ref<number>;
                        isAllSelected: import("vue").Ref<boolean>;
                        selection: import("vue").Ref<T[]>;
                        reserveSelection: import("vue").Ref<boolean>;
                        selectOnIndeterminate: import("vue").Ref<boolean>;
                        selectable: import("vue").Ref<(row: T, index: number) => boolean>;
                        filters: import("vue").Ref<import("./store/index").StoreFilter>;
                        filteredData: any;
                        sortingColumn: any;
                        sortProp: any;
                        sortOrder: any;
                        hoverRow: any;
                    }, options: import("./table/defaults").Sort): void;
                    changeSortCondition(states: {
                        _currentRowKey: import("vue").Ref<string>;
                        currentRow: import("vue").Ref<T>;
                        expandRowKeys: import("vue").Ref<string[]>;
                        treeData: import("vue").Ref<unknown>;
                        indent: import("vue").Ref<number>;
                        lazy: import("vue").Ref<boolean>;
                        lazyTreeNodeMap: import("vue").Ref<{}>;
                        lazyColumnIdentifier: import("vue").Ref<string>;
                        childrenColumnName: import("vue").Ref<string>;
                        expandRows: import("vue").Ref<T[]>;
                        defaultExpandAll: import("vue").Ref<boolean>;
                        rowKey: import("vue").Ref<string>;
                        data: import("vue").Ref<T[]>;
                        _data: import("vue").Ref<T[]>;
                        isComplex: import("vue").Ref<boolean>;
                        _columns: import("vue").Ref<TableColumnCtx<T>[]>;
                        originColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        columns: import("vue").Ref<TableColumnCtx<T>[]>;
                        fixedColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        rightFixedColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        leafColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        fixedLeafColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        rightFixedLeafColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        leafColumnsLength: import("vue").Ref<number>;
                        fixedLeafColumnsLength: import("vue").Ref<number>;
                        rightFixedLeafColumnsLength: import("vue").Ref<number>;
                        isAllSelected: import("vue").Ref<boolean>;
                        selection: import("vue").Ref<T[]>;
                        reserveSelection: import("vue").Ref<boolean>;
                        selectOnIndeterminate: import("vue").Ref<boolean>;
                        selectable: import("vue").Ref<(row: T, index: number) => boolean>;
                        filters: import("vue").Ref<import("./store/index").StoreFilter>;
                        filteredData: any;
                        sortingColumn: any;
                        sortProp: any;
                        sortOrder: any;
                        hoverRow: any;
                    }, options: import("./table/defaults").Sort): void;
                    filterChange(_states: {
                        _currentRowKey: import("vue").Ref<string>;
                        currentRow: import("vue").Ref<T>;
                        expandRowKeys: import("vue").Ref<string[]>;
                        treeData: import("vue").Ref<unknown>;
                        indent: import("vue").Ref<number>;
                        lazy: import("vue").Ref<boolean>;
                        lazyTreeNodeMap: import("vue").Ref<{}>;
                        lazyColumnIdentifier: import("vue").Ref<string>;
                        childrenColumnName: import("vue").Ref<string>;
                        expandRows: import("vue").Ref<T[]>;
                        defaultExpandAll: import("vue").Ref<boolean>;
                        rowKey: import("vue").Ref<string>;
                        data: import("vue").Ref<T[]>;
                        _data: import("vue").Ref<T[]>;
                        isComplex: import("vue").Ref<boolean>;
                        _columns: import("vue").Ref<TableColumnCtx<T>[]>;
                        originColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        columns: import("vue").Ref<TableColumnCtx<T>[]>;
                        fixedColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        rightFixedColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        leafColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        fixedLeafColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        rightFixedLeafColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        leafColumnsLength: import("vue").Ref<number>;
                        fixedLeafColumnsLength: import("vue").Ref<number>;
                        rightFixedLeafColumnsLength: import("vue").Ref<number>;
                        isAllSelected: import("vue").Ref<boolean>;
                        selection: import("vue").Ref<T[]>;
                        reserveSelection: import("vue").Ref<boolean>;
                        selectOnIndeterminate: import("vue").Ref<boolean>;
                        selectable: import("vue").Ref<(row: T, index: number) => boolean>;
                        filters: import("vue").Ref<import("./store/index").StoreFilter>;
                        filteredData: any;
                        sortingColumn: any;
                        sortProp: any;
                        sortOrder: any;
                        hoverRow: any;
                    }, options: import("./table/defaults").Filter<T>): void;
                    toggleAllSelection(): void;
                    rowSelectedChanged(_states: any, row: T): void;
                    setHoverRow(states: {
                        _currentRowKey: import("vue").Ref<string>;
                        currentRow: import("vue").Ref<T>;
                        expandRowKeys: import("vue").Ref<string[]>;
                        treeData: import("vue").Ref<unknown>;
                        indent: import("vue").Ref<number>;
                        lazy: import("vue").Ref<boolean>;
                        lazyTreeNodeMap: import("vue").Ref<{}>;
                        lazyColumnIdentifier: import("vue").Ref<string>;
                        childrenColumnName: import("vue").Ref<string>;
                        expandRows: import("vue").Ref<T[]>;
                        defaultExpandAll: import("vue").Ref<boolean>;
                        rowKey: import("vue").Ref<string>;
                        data: import("vue").Ref<T[]>;
                        _data: import("vue").Ref<T[]>;
                        isComplex: import("vue").Ref<boolean>;
                        _columns: import("vue").Ref<TableColumnCtx<T>[]>;
                        originColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        columns: import("vue").Ref<TableColumnCtx<T>[]>;
                        fixedColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        rightFixedColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        leafColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        fixedLeafColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        rightFixedLeafColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                        leafColumnsLength: import("vue").Ref<number>;
                        fixedLeafColumnsLength: import("vue").Ref<number>;
                        rightFixedLeafColumnsLength: import("vue").Ref<number>;
                        isAllSelected: import("vue").Ref<boolean>;
                        selection: import("vue").Ref<T[]>;
                        reserveSelection: import("vue").Ref<boolean>;
                        selectOnIndeterminate: import("vue").Ref<boolean>;
                        selectable: import("vue").Ref<(row: T, index: number) => boolean>;
                        filters: import("vue").Ref<import("./store/index").StoreFilter>;
                        filteredData: any;
                        sortingColumn: any;
                        sortProp: any;
                        sortOrder: any;
                        hoverRow: any;
                    }, row: T): void;
                    setCurrentRow(_states: any, row: T): void;
                };
                commit: (name: "setData" | "insertColumn" | "removeColumn" | "sort" | "changeSortCondition" | "filterChange" | "toggleAllSelection" | "rowSelectedChanged" | "setHoverRow" | "setCurrentRow", ...args: any[]) => void;
                updateTableScrollY: () => void;
                assertRowKey: () => void;
                updateColumns: () => void;
                scheduleLayout: (needUpdateColumns?: boolean, immediate?: boolean) => void;
                isSelected: (row: any) => boolean;
                clearSelection: () => void;
                cleanSelection: () => void;
                toggleRowSelection: (row: T, selected?: any, emitChange?: boolean) => void;
                _toggleAllSelection: () => void;
                toggleAllSelection: any;
                updateSelectionByRowKey: () => void;
                updateAllSelected: () => void;
                updateFilters: (columns: any, values: any) => {};
                updateCurrentRow: (_currentRow: T) => void;
                updateSort: (column: any, prop: any, order: any) => void;
                execFilter: () => void;
                execSort: () => void;
                execQuery: (ignore?: any) => void;
                clearFilter: (columnKeys: any) => void;
                clearSort: () => void;
                toggleRowExpansion: (row: T, expanded?: boolean) => void;
                setExpandRowKeysAdapter: (val: string[]) => void;
                setCurrentRowKey: (key: string) => void;
                toggleRowExpansionAdapter: (row: T, expanded: boolean) => void;
                isRowExpanded: (row: T) => boolean;
                updateExpandRows: () => void;
                updateCurrentRowData: () => void;
                loadOrToggle: (row: any) => void;
                states: {
                    _currentRowKey: import("vue").Ref<string>;
                    currentRow: import("vue").Ref<T>;
                    expandRowKeys: import("vue").Ref<string[]>;
                    treeData: import("vue").Ref<unknown>;
                    indent: import("vue").Ref<number>;
                    lazy: import("vue").Ref<boolean>;
                    lazyTreeNodeMap: import("vue").Ref<{}>;
                    lazyColumnIdentifier: import("vue").Ref<string>;
                    childrenColumnName: import("vue").Ref<string>;
                    expandRows: import("vue").Ref<T[]>;
                    defaultExpandAll: import("vue").Ref<boolean>;
                    rowKey: import("vue").Ref<string>;
                    data: import("vue").Ref<T[]>;
                    _data: import("vue").Ref<T[]>;
                    isComplex: import("vue").Ref<boolean>;
                    _columns: import("vue").Ref<TableColumnCtx<T>[]>;
                    originColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                    columns: import("vue").Ref<TableColumnCtx<T>[]>;
                    fixedColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                    rightFixedColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                    leafColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                    fixedLeafColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                    rightFixedLeafColumns: import("vue").Ref<TableColumnCtx<T>[]>;
                    leafColumnsLength: import("vue").Ref<number>;
                    fixedLeafColumnsLength: import("vue").Ref<number>;
                    rightFixedLeafColumnsLength: import("vue").Ref<number>;
                    isAllSelected: import("vue").Ref<boolean>;
                    selection: import("vue").Ref<T[]>;
                    reserveSelection: import("vue").Ref<boolean>;
                    selectOnIndeterminate: import("vue").Ref<boolean>;
                    selectable: import("vue").Ref<(row: T, index: number) => boolean>;
                    filters: import("vue").Ref<import("./store/index").StoreFilter>;
                    filteredData: any;
                    sortingColumn: any;
                    sortProp: any;
                    sortOrder: any;
                    hoverRow: any;
                };
            };
        }) => import("vue").VNode<import("vue").RendererNode, import("vue").RendererElement, {
            [key: string]: any;
        }>;
        renderCell: <T_1>({ row, column, store, $index, }: {
            row: T_1;
            column: TableColumnCtx<T_1>;
            store: {
                mutations: {
                    setData(states: {
                        _currentRowKey: import("vue").Ref<string>;
                        currentRow: import("vue").Ref<T_1>;
                        expandRowKeys: import("vue").Ref<string[]>;
                        treeData: import("vue").Ref<unknown>;
                        indent: import("vue").Ref<number>;
                        lazy: import("vue").Ref<boolean>;
                        lazyTreeNodeMap: import("vue").Ref<{}>;
                        lazyColumnIdentifier: import("vue").Ref<string>;
                        childrenColumnName: import("vue").Ref<string>;
                        expandRows: import("vue").Ref<T_1[]>;
                        defaultExpandAll: import("vue").Ref<boolean>;
                        rowKey: import("vue").Ref<string>;
                        data: import("vue").Ref<T_1[]>;
                        _data: import("vue").Ref<T_1[]>;
                        isComplex: import("vue").Ref<boolean>;
                        _columns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        originColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        columns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        fixedColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        rightFixedColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        leafColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        fixedLeafColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        rightFixedLeafColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        leafColumnsLength: import("vue").Ref<number>;
                        fixedLeafColumnsLength: import("vue").Ref<number>;
                        rightFixedLeafColumnsLength: import("vue").Ref<number>;
                        isAllSelected: import("vue").Ref<boolean>;
                        selection: import("vue").Ref<T_1[]>;
                        reserveSelection: import("vue").Ref<boolean>;
                        selectOnIndeterminate: import("vue").Ref<boolean>;
                        selectable: import("vue").Ref<(row: T_1, index: number) => boolean>;
                        filters: import("vue").Ref<import("./store/index").StoreFilter>;
                        filteredData: any;
                        sortingColumn: any;
                        sortProp: any;
                        sortOrder: any;
                        hoverRow: any;
                    }, data: T_1[]): void;
                    insertColumn(states: {
                        _currentRowKey: import("vue").Ref<string>;
                        currentRow: import("vue").Ref<T_1>;
                        expandRowKeys: import("vue").Ref<string[]>;
                        treeData: import("vue").Ref<unknown>;
                        indent: import("vue").Ref<number>;
                        lazy: import("vue").Ref<boolean>;
                        lazyTreeNodeMap: import("vue").Ref<{}>;
                        lazyColumnIdentifier: import("vue").Ref<string>;
                        childrenColumnName: import("vue").Ref<string>;
                        expandRows: import("vue").Ref<T_1[]>;
                        defaultExpandAll: import("vue").Ref<boolean>;
                        rowKey: import("vue").Ref<string>;
                        data: import("vue").Ref<T_1[]>;
                        _data: import("vue").Ref<T_1[]>;
                        isComplex: import("vue").Ref<boolean>;
                        _columns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        originColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        columns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        fixedColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        rightFixedColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        leafColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        fixedLeafColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        rightFixedLeafColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        leafColumnsLength: import("vue").Ref<number>;
                        fixedLeafColumnsLength: import("vue").Ref<number>;
                        rightFixedLeafColumnsLength: import("vue").Ref<number>;
                        isAllSelected: import("vue").Ref<boolean>;
                        selection: import("vue").Ref<T_1[]>;
                        reserveSelection: import("vue").Ref<boolean>;
                        selectOnIndeterminate: import("vue").Ref<boolean>;
                        selectable: import("vue").Ref<(row: T_1, index: number) => boolean>;
                        filters: import("vue").Ref<import("./store/index").StoreFilter>;
                        filteredData: any;
                        sortingColumn: any;
                        sortProp: any;
                        sortOrder: any;
                        hoverRow: any;
                    }, column: TableColumnCtx<T_1>, parent: TableColumnCtx<T_1>): void;
                    removeColumn(states: {
                        _currentRowKey: import("vue").Ref<string>;
                        currentRow: import("vue").Ref<T_1>;
                        expandRowKeys: import("vue").Ref<string[]>;
                        treeData: import("vue").Ref<unknown>;
                        indent: import("vue").Ref<number>;
                        lazy: import("vue").Ref<boolean>;
                        lazyTreeNodeMap: import("vue").Ref<{}>;
                        lazyColumnIdentifier: import("vue").Ref<string>;
                        childrenColumnName: import("vue").Ref<string>;
                        expandRows: import("vue").Ref<T_1[]>;
                        defaultExpandAll: import("vue").Ref<boolean>;
                        rowKey: import("vue").Ref<string>;
                        data: import("vue").Ref<T_1[]>;
                        _data: import("vue").Ref<T_1[]>;
                        isComplex: import("vue").Ref<boolean>;
                        _columns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        originColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        columns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        fixedColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        rightFixedColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        leafColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        fixedLeafColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        rightFixedLeafColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        leafColumnsLength: import("vue").Ref<number>;
                        fixedLeafColumnsLength: import("vue").Ref<number>;
                        rightFixedLeafColumnsLength: import("vue").Ref<number>;
                        isAllSelected: import("vue").Ref<boolean>;
                        selection: import("vue").Ref<T_1[]>;
                        reserveSelection: import("vue").Ref<boolean>;
                        selectOnIndeterminate: import("vue").Ref<boolean>;
                        selectable: import("vue").Ref<(row: T_1, index: number) => boolean>;
                        filters: import("vue").Ref<import("./store/index").StoreFilter>;
                        filteredData: any;
                        sortingColumn: any;
                        sortProp: any;
                        sortOrder: any;
                        hoverRow: any;
                    }, column: TableColumnCtx<T_1>, parent: TableColumnCtx<T_1>): void;
                    sort(states: {
                        _currentRowKey: import("vue").Ref<string>;
                        currentRow: import("vue").Ref<T_1>;
                        expandRowKeys: import("vue").Ref<string[]>;
                        treeData: import("vue").Ref<unknown>;
                        indent: import("vue").Ref<number>;
                        lazy: import("vue").Ref<boolean>;
                        lazyTreeNodeMap: import("vue").Ref<{}>;
                        lazyColumnIdentifier: import("vue").Ref<string>;
                        childrenColumnName: import("vue").Ref<string>;
                        expandRows: import("vue").Ref<T_1[]>;
                        defaultExpandAll: import("vue").Ref<boolean>;
                        rowKey: import("vue").Ref<string>;
                        data: import("vue").Ref<T_1[]>;
                        _data: import("vue").Ref<T_1[]>;
                        isComplex: import("vue").Ref<boolean>;
                        _columns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        originColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        columns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        fixedColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        rightFixedColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        leafColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        fixedLeafColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        rightFixedLeafColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        leafColumnsLength: import("vue").Ref<number>;
                        fixedLeafColumnsLength: import("vue").Ref<number>;
                        rightFixedLeafColumnsLength: import("vue").Ref<number>;
                        isAllSelected: import("vue").Ref<boolean>;
                        selection: import("vue").Ref<T_1[]>;
                        reserveSelection: import("vue").Ref<boolean>;
                        selectOnIndeterminate: import("vue").Ref<boolean>;
                        selectable: import("vue").Ref<(row: T_1, index: number) => boolean>;
                        filters: import("vue").Ref<import("./store/index").StoreFilter>;
                        filteredData: any;
                        sortingColumn: any;
                        sortProp: any;
                        sortOrder: any;
                        hoverRow: any;
                    }, options: import("./table/defaults").Sort): void;
                    changeSortCondition(states: {
                        _currentRowKey: import("vue").Ref<string>;
                        currentRow: import("vue").Ref<T_1>;
                        expandRowKeys: import("vue").Ref<string[]>;
                        treeData: import("vue").Ref<unknown>;
                        indent: import("vue").Ref<number>;
                        lazy: import("vue").Ref<boolean>;
                        lazyTreeNodeMap: import("vue").Ref<{}>;
                        lazyColumnIdentifier: import("vue").Ref<string>;
                        childrenColumnName: import("vue").Ref<string>;
                        expandRows: import("vue").Ref<T_1[]>;
                        defaultExpandAll: import("vue").Ref<boolean>;
                        rowKey: import("vue").Ref<string>;
                        data: import("vue").Ref<T_1[]>;
                        _data: import("vue").Ref<T_1[]>;
                        isComplex: import("vue").Ref<boolean>;
                        _columns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        originColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        columns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        fixedColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        rightFixedColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        leafColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        fixedLeafColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        rightFixedLeafColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        leafColumnsLength: import("vue").Ref<number>;
                        fixedLeafColumnsLength: import("vue").Ref<number>;
                        rightFixedLeafColumnsLength: import("vue").Ref<number>;
                        isAllSelected: import("vue").Ref<boolean>;
                        selection: import("vue").Ref<T_1[]>;
                        reserveSelection: import("vue").Ref<boolean>;
                        selectOnIndeterminate: import("vue").Ref<boolean>;
                        selectable: import("vue").Ref<(row: T_1, index: number) => boolean>;
                        filters: import("vue").Ref<import("./store/index").StoreFilter>;
                        filteredData: any;
                        sortingColumn: any;
                        sortProp: any;
                        sortOrder: any;
                        hoverRow: any;
                    }, options: import("./table/defaults").Sort): void;
                    filterChange(_states: {
                        _currentRowKey: import("vue").Ref<string>;
                        currentRow: import("vue").Ref<T_1>;
                        expandRowKeys: import("vue").Ref<string[]>;
                        treeData: import("vue").Ref<unknown>;
                        indent: import("vue").Ref<number>;
                        lazy: import("vue").Ref<boolean>;
                        lazyTreeNodeMap: import("vue").Ref<{}>;
                        lazyColumnIdentifier: import("vue").Ref<string>;
                        childrenColumnName: import("vue").Ref<string>;
                        expandRows: import("vue").Ref<T_1[]>;
                        defaultExpandAll: import("vue").Ref<boolean>;
                        rowKey: import("vue").Ref<string>;
                        data: import("vue").Ref<T_1[]>;
                        _data: import("vue").Ref<T_1[]>;
                        isComplex: import("vue").Ref<boolean>;
                        _columns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        originColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        columns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        fixedColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        rightFixedColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        leafColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        fixedLeafColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        rightFixedLeafColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        leafColumnsLength: import("vue").Ref<number>;
                        fixedLeafColumnsLength: import("vue").Ref<number>;
                        rightFixedLeafColumnsLength: import("vue").Ref<number>;
                        isAllSelected: import("vue").Ref<boolean>;
                        selection: import("vue").Ref<T_1[]>;
                        reserveSelection: import("vue").Ref<boolean>;
                        selectOnIndeterminate: import("vue").Ref<boolean>;
                        selectable: import("vue").Ref<(row: T_1, index: number) => boolean>;
                        filters: import("vue").Ref<import("./store/index").StoreFilter>;
                        filteredData: any;
                        sortingColumn: any;
                        sortProp: any;
                        sortOrder: any;
                        hoverRow: any;
                    }, options: import("./table/defaults").Filter<T_1>): void;
                    toggleAllSelection(): void;
                    rowSelectedChanged(_states: any, row: T_1): void;
                    setHoverRow(states: {
                        _currentRowKey: import("vue").Ref<string>;
                        currentRow: import("vue").Ref<T_1>;
                        expandRowKeys: import("vue").Ref<string[]>;
                        treeData: import("vue").Ref<unknown>;
                        indent: import("vue").Ref<number>;
                        lazy: import("vue").Ref<boolean>;
                        lazyTreeNodeMap: import("vue").Ref<{}>;
                        lazyColumnIdentifier: import("vue").Ref<string>;
                        childrenColumnName: import("vue").Ref<string>;
                        expandRows: import("vue").Ref<T_1[]>;
                        defaultExpandAll: import("vue").Ref<boolean>;
                        rowKey: import("vue").Ref<string>;
                        data: import("vue").Ref<T_1[]>;
                        _data: import("vue").Ref<T_1[]>;
                        isComplex: import("vue").Ref<boolean>;
                        _columns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        originColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        columns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        fixedColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        rightFixedColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        leafColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        fixedLeafColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        rightFixedLeafColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                        leafColumnsLength: import("vue").Ref<number>;
                        fixedLeafColumnsLength: import("vue").Ref<number>;
                        rightFixedLeafColumnsLength: import("vue").Ref<number>;
                        isAllSelected: import("vue").Ref<boolean>;
                        selection: import("vue").Ref<T_1[]>;
                        reserveSelection: import("vue").Ref<boolean>;
                        selectOnIndeterminate: import("vue").Ref<boolean>;
                        selectable: import("vue").Ref<(row: T_1, index: number) => boolean>;
                        filters: import("vue").Ref<import("./store/index").StoreFilter>;
                        filteredData: any;
                        sortingColumn: any;
                        sortProp: any;
                        sortOrder: any;
                        hoverRow: any;
                    }, row: T_1): void;
                    setCurrentRow(_states: any, row: T_1): void;
                };
                commit: (name: "setData" | "insertColumn" | "removeColumn" | "sort" | "changeSortCondition" | "filterChange" | "toggleAllSelection" | "rowSelectedChanged" | "setHoverRow" | "setCurrentRow", ...args: any[]) => void;
                updateTableScrollY: () => void;
                assertRowKey: () => void;
                updateColumns: () => void;
                scheduleLayout: (needUpdateColumns?: boolean, immediate?: boolean) => void;
                isSelected: (row: any) => boolean;
                clearSelection: () => void;
                cleanSelection: () => void;
                toggleRowSelection: (row: T_1, selected?: any, emitChange?: boolean) => void;
                _toggleAllSelection: () => void;
                toggleAllSelection: any;
                updateSelectionByRowKey: () => void;
                updateAllSelected: () => void;
                updateFilters: (columns: any, values: any) => {};
                updateCurrentRow: (_currentRow: T_1) => void;
                updateSort: (column: any, prop: any, order: any) => void;
                execFilter: () => void;
                execSort: () => void;
                execQuery: (ignore?: any) => void;
                clearFilter: (columnKeys: any) => void;
                clearSort: () => void;
                toggleRowExpansion: (row: T_1, expanded?: boolean) => void;
                setExpandRowKeysAdapter: (val: string[]) => void;
                setCurrentRowKey: (key: string) => void;
                toggleRowExpansionAdapter: (row: T_1, expanded: boolean) => void;
                isRowExpanded: (row: T_1) => boolean;
                updateExpandRows: () => void;
                updateCurrentRowData: () => void;
                loadOrToggle: (row: any) => void;
                states: {
                    _currentRowKey: import("vue").Ref<string>;
                    currentRow: import("vue").Ref<T_1>;
                    expandRowKeys: import("vue").Ref<string[]>;
                    treeData: import("vue").Ref<unknown>;
                    indent: import("vue").Ref<number>;
                    lazy: import("vue").Ref<boolean>;
                    lazyTreeNodeMap: import("vue").Ref<{}>;
                    lazyColumnIdentifier: import("vue").Ref<string>;
                    childrenColumnName: import("vue").Ref<string>;
                    expandRows: import("vue").Ref<T_1[]>;
                    defaultExpandAll: import("vue").Ref<boolean>;
                    rowKey: import("vue").Ref<string>;
                    data: import("vue").Ref<T_1[]>;
                    _data: import("vue").Ref<T_1[]>;
                    isComplex: import("vue").Ref<boolean>;
                    _columns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                    originColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                    columns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                    fixedColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                    rightFixedColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                    leafColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                    fixedLeafColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                    rightFixedLeafColumns: import("vue").Ref<TableColumnCtx<T_1>[]>;
                    leafColumnsLength: import("vue").Ref<number>;
                    fixedLeafColumnsLength: import("vue").Ref<number>;
                    rightFixedLeafColumnsLength: import("vue").Ref<number>;
                    isAllSelected: import("vue").Ref<boolean>;
                    selection: import("vue").Ref<T_1[]>;
                    reserveSelection: import("vue").Ref<boolean>;
                    selectOnIndeterminate: import("vue").Ref<boolean>;
                    selectable: import("vue").Ref<(row: T_1, index: number) => boolean>;
                    filters: import("vue").Ref<import("./store/index").StoreFilter>;
                    filteredData: any;
                    sortingColumn: any;
                    sortProp: any;
                    sortOrder: any;
                    hoverRow: any;
                };
            };
            $index: string;
        }) => import("vue").VNode<import("vue").RendererNode, import("vue").RendererElement, {
            [key: string]: any;
        }>;
        sortable: boolean;
        resizable: boolean;
    };
    index: {
        renderHeader: <T_2>({ column }: {
            column: TableColumnCtx<T_2>;
        }) => string;
        renderCell: <T_3>({ column, $index, }: {
            column: TableColumnCtx<T_3>;
            $index: number;
        }) => import("vue").VNode<import("vue").RendererNode, import("vue").RendererElement, {
            [key: string]: any;
        }>;
        sortable: boolean;
    };
    expand: {
        renderHeader: <T_4>({ column }: {
            column: TableColumnCtx<T_4>;
        }) => string;
        renderCell: <T_5>({ row, store }: {
            row: T_5;
            store: {
                mutations: {
                    setData(states: {
                        _currentRowKey: import("vue").Ref<string>;
                        currentRow: import("vue").Ref<T_5>;
                        expandRowKeys: import("vue").Ref<string[]>;
                        treeData: import("vue").Ref<unknown>;
                        indent: import("vue").Ref<number>;
                        lazy: import("vue").Ref<boolean>;
                        lazyTreeNodeMap: import("vue").Ref<{}>;
                        lazyColumnIdentifier: import("vue").Ref<string>;
                        childrenColumnName: import("vue").Ref<string>;
                        expandRows: import("vue").Ref<T_5[]>;
                        defaultExpandAll: import("vue").Ref<boolean>;
                        rowKey: import("vue").Ref<string>;
                        data: import("vue").Ref<T_5[]>;
                        _data: import("vue").Ref<T_5[]>;
                        isComplex: import("vue").Ref<boolean>;
                        _columns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        originColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        columns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        fixedColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        rightFixedColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        leafColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        fixedLeafColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        rightFixedLeafColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        leafColumnsLength: import("vue").Ref<number>;
                        fixedLeafColumnsLength: import("vue").Ref<number>;
                        rightFixedLeafColumnsLength: import("vue").Ref<number>;
                        isAllSelected: import("vue").Ref<boolean>;
                        selection: import("vue").Ref<T_5[]>;
                        reserveSelection: import("vue").Ref<boolean>;
                        selectOnIndeterminate: import("vue").Ref<boolean>;
                        selectable: import("vue").Ref<(row: T_5, index: number) => boolean>;
                        filters: import("vue").Ref<import("./store/index").StoreFilter>;
                        filteredData: any;
                        sortingColumn: any;
                        sortProp: any;
                        sortOrder: any;
                        hoverRow: any;
                    }, data: T_5[]): void;
                    insertColumn(states: {
                        _currentRowKey: import("vue").Ref<string>;
                        currentRow: import("vue").Ref<T_5>;
                        expandRowKeys: import("vue").Ref<string[]>;
                        treeData: import("vue").Ref<unknown>;
                        indent: import("vue").Ref<number>;
                        lazy: import("vue").Ref<boolean>;
                        lazyTreeNodeMap: import("vue").Ref<{}>;
                        lazyColumnIdentifier: import("vue").Ref<string>;
                        childrenColumnName: import("vue").Ref<string>;
                        expandRows: import("vue").Ref<T_5[]>;
                        defaultExpandAll: import("vue").Ref<boolean>;
                        rowKey: import("vue").Ref<string>;
                        data: import("vue").Ref<T_5[]>;
                        _data: import("vue").Ref<T_5[]>;
                        isComplex: import("vue").Ref<boolean>;
                        _columns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        originColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        columns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        fixedColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        rightFixedColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        leafColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        fixedLeafColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        rightFixedLeafColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        leafColumnsLength: import("vue").Ref<number>;
                        fixedLeafColumnsLength: import("vue").Ref<number>;
                        rightFixedLeafColumnsLength: import("vue").Ref<number>;
                        isAllSelected: import("vue").Ref<boolean>;
                        selection: import("vue").Ref<T_5[]>;
                        reserveSelection: import("vue").Ref<boolean>;
                        selectOnIndeterminate: import("vue").Ref<boolean>;
                        selectable: import("vue").Ref<(row: T_5, index: number) => boolean>;
                        filters: import("vue").Ref<import("./store/index").StoreFilter>;
                        filteredData: any;
                        sortingColumn: any;
                        sortProp: any;
                        sortOrder: any;
                        hoverRow: any;
                    }, column: TableColumnCtx<T_5>, parent: TableColumnCtx<T_5>): void;
                    removeColumn(states: {
                        _currentRowKey: import("vue").Ref<string>;
                        currentRow: import("vue").Ref<T_5>;
                        expandRowKeys: import("vue").Ref<string[]>;
                        treeData: import("vue").Ref<unknown>;
                        indent: import("vue").Ref<number>;
                        lazy: import("vue").Ref<boolean>;
                        lazyTreeNodeMap: import("vue").Ref<{}>;
                        lazyColumnIdentifier: import("vue").Ref<string>;
                        childrenColumnName: import("vue").Ref<string>;
                        expandRows: import("vue").Ref<T_5[]>;
                        defaultExpandAll: import("vue").Ref<boolean>;
                        rowKey: import("vue").Ref<string>;
                        data: import("vue").Ref<T_5[]>;
                        _data: import("vue").Ref<T_5[]>;
                        isComplex: import("vue").Ref<boolean>;
                        _columns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        originColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        columns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        fixedColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        rightFixedColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        leafColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        fixedLeafColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        rightFixedLeafColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        leafColumnsLength: import("vue").Ref<number>;
                        fixedLeafColumnsLength: import("vue").Ref<number>;
                        rightFixedLeafColumnsLength: import("vue").Ref<number>;
                        isAllSelected: import("vue").Ref<boolean>;
                        selection: import("vue").Ref<T_5[]>;
                        reserveSelection: import("vue").Ref<boolean>;
                        selectOnIndeterminate: import("vue").Ref<boolean>;
                        selectable: import("vue").Ref<(row: T_5, index: number) => boolean>;
                        filters: import("vue").Ref<import("./store/index").StoreFilter>;
                        filteredData: any;
                        sortingColumn: any;
                        sortProp: any;
                        sortOrder: any;
                        hoverRow: any;
                    }, column: TableColumnCtx<T_5>, parent: TableColumnCtx<T_5>): void;
                    sort(states: {
                        _currentRowKey: import("vue").Ref<string>;
                        currentRow: import("vue").Ref<T_5>;
                        expandRowKeys: import("vue").Ref<string[]>;
                        treeData: import("vue").Ref<unknown>;
                        indent: import("vue").Ref<number>;
                        lazy: import("vue").Ref<boolean>;
                        lazyTreeNodeMap: import("vue").Ref<{}>;
                        lazyColumnIdentifier: import("vue").Ref<string>;
                        childrenColumnName: import("vue").Ref<string>;
                        expandRows: import("vue").Ref<T_5[]>;
                        defaultExpandAll: import("vue").Ref<boolean>;
                        rowKey: import("vue").Ref<string>;
                        data: import("vue").Ref<T_5[]>;
                        _data: import("vue").Ref<T_5[]>;
                        isComplex: import("vue").Ref<boolean>;
                        _columns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        originColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        columns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        fixedColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        rightFixedColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        leafColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        fixedLeafColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        rightFixedLeafColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        leafColumnsLength: import("vue").Ref<number>;
                        fixedLeafColumnsLength: import("vue").Ref<number>;
                        rightFixedLeafColumnsLength: import("vue").Ref<number>;
                        isAllSelected: import("vue").Ref<boolean>;
                        selection: import("vue").Ref<T_5[]>;
                        reserveSelection: import("vue").Ref<boolean>;
                        selectOnIndeterminate: import("vue").Ref<boolean>;
                        selectable: import("vue").Ref<(row: T_5, index: number) => boolean>;
                        filters: import("vue").Ref<import("./store/index").StoreFilter>;
                        filteredData: any;
                        sortingColumn: any;
                        sortProp: any;
                        sortOrder: any;
                        hoverRow: any;
                    }, options: import("./table/defaults").Sort): void;
                    changeSortCondition(states: {
                        _currentRowKey: import("vue").Ref<string>;
                        currentRow: import("vue").Ref<T_5>;
                        expandRowKeys: import("vue").Ref<string[]>;
                        treeData: import("vue").Ref<unknown>;
                        indent: import("vue").Ref<number>;
                        lazy: import("vue").Ref<boolean>;
                        lazyTreeNodeMap: import("vue").Ref<{}>;
                        lazyColumnIdentifier: import("vue").Ref<string>;
                        childrenColumnName: import("vue").Ref<string>;
                        expandRows: import("vue").Ref<T_5[]>;
                        defaultExpandAll: import("vue").Ref<boolean>;
                        rowKey: import("vue").Ref<string>;
                        data: import("vue").Ref<T_5[]>;
                        _data: import("vue").Ref<T_5[]>;
                        isComplex: import("vue").Ref<boolean>;
                        _columns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        originColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        columns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        fixedColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        rightFixedColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        leafColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        fixedLeafColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        rightFixedLeafColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        leafColumnsLength: import("vue").Ref<number>;
                        fixedLeafColumnsLength: import("vue").Ref<number>;
                        rightFixedLeafColumnsLength: import("vue").Ref<number>;
                        isAllSelected: import("vue").Ref<boolean>;
                        selection: import("vue").Ref<T_5[]>;
                        reserveSelection: import("vue").Ref<boolean>;
                        selectOnIndeterminate: import("vue").Ref<boolean>;
                        selectable: import("vue").Ref<(row: T_5, index: number) => boolean>;
                        filters: import("vue").Ref<import("./store/index").StoreFilter>;
                        filteredData: any;
                        sortingColumn: any;
                        sortProp: any;
                        sortOrder: any;
                        hoverRow: any;
                    }, options: import("./table/defaults").Sort): void;
                    filterChange(_states: {
                        _currentRowKey: import("vue").Ref<string>;
                        currentRow: import("vue").Ref<T_5>;
                        expandRowKeys: import("vue").Ref<string[]>;
                        treeData: import("vue").Ref<unknown>;
                        indent: import("vue").Ref<number>;
                        lazy: import("vue").Ref<boolean>;
                        lazyTreeNodeMap: import("vue").Ref<{}>;
                        lazyColumnIdentifier: import("vue").Ref<string>;
                        childrenColumnName: import("vue").Ref<string>;
                        expandRows: import("vue").Ref<T_5[]>;
                        defaultExpandAll: import("vue").Ref<boolean>;
                        rowKey: import("vue").Ref<string>;
                        data: import("vue").Ref<T_5[]>;
                        _data: import("vue").Ref<T_5[]>;
                        isComplex: import("vue").Ref<boolean>;
                        _columns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        originColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        columns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        fixedColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        rightFixedColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        leafColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        fixedLeafColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        rightFixedLeafColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        leafColumnsLength: import("vue").Ref<number>;
                        fixedLeafColumnsLength: import("vue").Ref<number>;
                        rightFixedLeafColumnsLength: import("vue").Ref<number>;
                        isAllSelected: import("vue").Ref<boolean>;
                        selection: import("vue").Ref<T_5[]>;
                        reserveSelection: import("vue").Ref<boolean>;
                        selectOnIndeterminate: import("vue").Ref<boolean>;
                        selectable: import("vue").Ref<(row: T_5, index: number) => boolean>;
                        filters: import("vue").Ref<import("./store/index").StoreFilter>;
                        filteredData: any;
                        sortingColumn: any;
                        sortProp: any;
                        sortOrder: any;
                        hoverRow: any;
                    }, options: import("./table/defaults").Filter<T_5>): void;
                    toggleAllSelection(): void;
                    rowSelectedChanged(_states: any, row: T_5): void;
                    setHoverRow(states: {
                        _currentRowKey: import("vue").Ref<string>;
                        currentRow: import("vue").Ref<T_5>;
                        expandRowKeys: import("vue").Ref<string[]>;
                        treeData: import("vue").Ref<unknown>;
                        indent: import("vue").Ref<number>;
                        lazy: import("vue").Ref<boolean>;
                        lazyTreeNodeMap: import("vue").Ref<{}>;
                        lazyColumnIdentifier: import("vue").Ref<string>;
                        childrenColumnName: import("vue").Ref<string>;
                        expandRows: import("vue").Ref<T_5[]>;
                        defaultExpandAll: import("vue").Ref<boolean>;
                        rowKey: import("vue").Ref<string>;
                        data: import("vue").Ref<T_5[]>;
                        _data: import("vue").Ref<T_5[]>;
                        isComplex: import("vue").Ref<boolean>;
                        _columns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        originColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        columns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        fixedColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        rightFixedColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        leafColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        fixedLeafColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        rightFixedLeafColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                        leafColumnsLength: import("vue").Ref<number>;
                        fixedLeafColumnsLength: import("vue").Ref<number>;
                        rightFixedLeafColumnsLength: import("vue").Ref<number>;
                        isAllSelected: import("vue").Ref<boolean>;
                        selection: import("vue").Ref<T_5[]>;
                        reserveSelection: import("vue").Ref<boolean>;
                        selectOnIndeterminate: import("vue").Ref<boolean>;
                        selectable: import("vue").Ref<(row: T_5, index: number) => boolean>;
                        filters: import("vue").Ref<import("./store/index").StoreFilter>;
                        filteredData: any;
                        sortingColumn: any;
                        sortProp: any;
                        sortOrder: any;
                        hoverRow: any;
                    }, row: T_5): void;
                    setCurrentRow(_states: any, row: T_5): void;
                };
                commit: (name: "setData" | "insertColumn" | "removeColumn" | "sort" | "changeSortCondition" | "filterChange" | "toggleAllSelection" | "rowSelectedChanged" | "setHoverRow" | "setCurrentRow", ...args: any[]) => void;
                updateTableScrollY: () => void;
                assertRowKey: () => void;
                updateColumns: () => void;
                scheduleLayout: (needUpdateColumns?: boolean, immediate?: boolean) => void;
                isSelected: (row: any) => boolean;
                clearSelection: () => void;
                cleanSelection: () => void;
                toggleRowSelection: (row: T_5, selected?: any, emitChange?: boolean) => void;
                _toggleAllSelection: () => void;
                toggleAllSelection: any;
                updateSelectionByRowKey: () => void;
                updateAllSelected: () => void;
                updateFilters: (columns: any, values: any) => {};
                updateCurrentRow: (_currentRow: T_5) => void;
                updateSort: (column: any, prop: any, order: any) => void;
                execFilter: () => void;
                execSort: () => void;
                execQuery: (ignore?: any) => void;
                clearFilter: (columnKeys: any) => void;
                clearSort: () => void;
                toggleRowExpansion: (row: T_5, expanded?: boolean) => void;
                setExpandRowKeysAdapter: (val: string[]) => void;
                setCurrentRowKey: (key: string) => void;
                toggleRowExpansionAdapter: (row: T_5, expanded: boolean) => void;
                isRowExpanded: (row: T_5) => boolean;
                updateExpandRows: () => void;
                updateCurrentRowData: () => void;
                loadOrToggle: (row: any) => void;
                states: {
                    _currentRowKey: import("vue").Ref<string>;
                    currentRow: import("vue").Ref<T_5>;
                    expandRowKeys: import("vue").Ref<string[]>;
                    treeData: import("vue").Ref<unknown>;
                    indent: import("vue").Ref<number>;
                    lazy: import("vue").Ref<boolean>;
                    lazyTreeNodeMap: import("vue").Ref<{}>;
                    lazyColumnIdentifier: import("vue").Ref<string>;
                    childrenColumnName: import("vue").Ref<string>;
                    expandRows: import("vue").Ref<T_5[]>;
                    defaultExpandAll: import("vue").Ref<boolean>;
                    rowKey: import("vue").Ref<string>;
                    data: import("vue").Ref<T_5[]>;
                    _data: import("vue").Ref<T_5[]>;
                    isComplex: import("vue").Ref<boolean>;
                    _columns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                    originColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                    columns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                    fixedColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                    rightFixedColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                    leafColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                    fixedLeafColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                    rightFixedLeafColumns: import("vue").Ref<TableColumnCtx<T_5>[]>;
                    leafColumnsLength: import("vue").Ref<number>;
                    fixedLeafColumnsLength: import("vue").Ref<number>;
                    rightFixedLeafColumnsLength: import("vue").Ref<number>;
                    isAllSelected: import("vue").Ref<boolean>;
                    selection: import("vue").Ref<T_5[]>;
                    reserveSelection: import("vue").Ref<boolean>;
                    selectOnIndeterminate: import("vue").Ref<boolean>;
                    selectable: import("vue").Ref<(row: T_5, index: number) => boolean>;
                    filters: import("vue").Ref<import("./store/index").StoreFilter>;
                    filteredData: any;
                    sortingColumn: any;
                    sortProp: any;
                    sortOrder: any;
                    hoverRow: any;
                };
            };
        }) => import("vue").VNode<import("vue").RendererNode, import("vue").RendererElement, {
            [key: string]: any;
        }>;
        sortable: boolean;
        resizable: boolean;
        className: string;
    };
};
export declare function defaultRenderCell<T>({ row, column, $index, }: {
    row: T;
    column: TableColumnCtx<T>;
    $index: number;
}): string | import("vue").VNode<import("vue").RendererNode, import("vue").RendererElement, {
    [key: string]: any;
}>;
export declare function treeCellPrefix<T>({ row, treeNode, store, }: {
    row: T;
    treeNode: TreeNode;
    store: Store<T>;
}): any[];
