import { ComponentInternalInstance, Ref, PropType } from 'vue';
import { Sort } from '../table/defaults';
import { Store } from '../store';
export interface TableHeader extends ComponentInternalInstance {
    state: {
        onColumnsChange: any;
        onScrollableChange: any;
    };
    filterPanels: Ref<unknown>;
}
export interface TableHeaderProps<T> {
    fixed: string;
    store: Store<T>;
    border: boolean;
    defaultSort: Sort;
}
declare const _default: import("vue").DefineComponent<{
    fixed: {
        type: StringConstructor;
        default: string;
    };
    store: {
        required: true;
        type: PropType<{
            mutations: {
                setData(states: {
                    _currentRowKey: Ref<string>;
                    currentRow: Ref<any>;
                    expandRowKeys: Ref<string[]>;
                    treeData: Ref<unknown>;
                    indent: Ref<number>;
                    lazy: Ref<boolean>;
                    lazyTreeNodeMap: Ref<{}>;
                    lazyColumnIdentifier: Ref<string>;
                    childrenColumnName: Ref<string>;
                    expandRows: Ref<any[]>;
                    defaultExpandAll: Ref<boolean>;
                    rowKey: Ref<string>;
                    data: Ref<any[]>;
                    _data: Ref<any[]>;
                    isComplex: Ref<boolean>;
                    _columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    originColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumnsLength: Ref<number>;
                    fixedLeafColumnsLength: Ref<number>;
                    rightFixedLeafColumnsLength: Ref<number>;
                    isAllSelected: Ref<boolean>;
                    selection: Ref<any[]>;
                    reserveSelection: Ref<boolean>;
                    selectOnIndeterminate: Ref<boolean>;
                    selectable: Ref<(row: any, index: number) => boolean>;
                    filters: Ref<import("../store").StoreFilter>;
                    filteredData: any;
                    sortingColumn: any;
                    sortProp: any;
                    sortOrder: any;
                    hoverRow: any;
                }, data: any[]): void;
                insertColumn(states: {
                    _currentRowKey: Ref<string>;
                    currentRow: Ref<any>;
                    expandRowKeys: Ref<string[]>;
                    treeData: Ref<unknown>;
                    indent: Ref<number>;
                    lazy: Ref<boolean>;
                    lazyTreeNodeMap: Ref<{}>;
                    lazyColumnIdentifier: Ref<string>;
                    childrenColumnName: Ref<string>;
                    expandRows: Ref<any[]>;
                    defaultExpandAll: Ref<boolean>;
                    rowKey: Ref<string>;
                    data: Ref<any[]>;
                    _data: Ref<any[]>;
                    isComplex: Ref<boolean>;
                    _columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    originColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumnsLength: Ref<number>;
                    fixedLeafColumnsLength: Ref<number>;
                    rightFixedLeafColumnsLength: Ref<number>;
                    isAllSelected: Ref<boolean>;
                    selection: Ref<any[]>;
                    reserveSelection: Ref<boolean>;
                    selectOnIndeterminate: Ref<boolean>;
                    selectable: Ref<(row: any, index: number) => boolean>;
                    filters: Ref<import("../store").StoreFilter>;
                    filteredData: any;
                    sortingColumn: any;
                    sortProp: any;
                    sortOrder: any;
                    hoverRow: any;
                }, column: import("../table-column/defaults").TableColumnCtx<any>, parent: import("../table-column/defaults").TableColumnCtx<any>): void;
                removeColumn(states: {
                    _currentRowKey: Ref<string>;
                    currentRow: Ref<any>;
                    expandRowKeys: Ref<string[]>;
                    treeData: Ref<unknown>;
                    indent: Ref<number>;
                    lazy: Ref<boolean>;
                    lazyTreeNodeMap: Ref<{}>;
                    lazyColumnIdentifier: Ref<string>;
                    childrenColumnName: Ref<string>;
                    expandRows: Ref<any[]>;
                    defaultExpandAll: Ref<boolean>;
                    rowKey: Ref<string>;
                    data: Ref<any[]>;
                    _data: Ref<any[]>;
                    isComplex: Ref<boolean>;
                    _columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    originColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumnsLength: Ref<number>;
                    fixedLeafColumnsLength: Ref<number>;
                    rightFixedLeafColumnsLength: Ref<number>;
                    isAllSelected: Ref<boolean>;
                    selection: Ref<any[]>;
                    reserveSelection: Ref<boolean>;
                    selectOnIndeterminate: Ref<boolean>;
                    selectable: Ref<(row: any, index: number) => boolean>;
                    filters: Ref<import("../store").StoreFilter>;
                    filteredData: any;
                    sortingColumn: any;
                    sortProp: any;
                    sortOrder: any;
                    hoverRow: any;
                }, column: import("../table-column/defaults").TableColumnCtx<any>, parent: import("../table-column/defaults").TableColumnCtx<any>): void;
                sort(states: {
                    _currentRowKey: Ref<string>;
                    currentRow: Ref<any>;
                    expandRowKeys: Ref<string[]>;
                    treeData: Ref<unknown>;
                    indent: Ref<number>;
                    lazy: Ref<boolean>;
                    lazyTreeNodeMap: Ref<{}>;
                    lazyColumnIdentifier: Ref<string>;
                    childrenColumnName: Ref<string>;
                    expandRows: Ref<any[]>;
                    defaultExpandAll: Ref<boolean>;
                    rowKey: Ref<string>;
                    data: Ref<any[]>;
                    _data: Ref<any[]>;
                    isComplex: Ref<boolean>;
                    _columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    originColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumnsLength: Ref<number>;
                    fixedLeafColumnsLength: Ref<number>;
                    rightFixedLeafColumnsLength: Ref<number>;
                    isAllSelected: Ref<boolean>;
                    selection: Ref<any[]>;
                    reserveSelection: Ref<boolean>;
                    selectOnIndeterminate: Ref<boolean>;
                    selectable: Ref<(row: any, index: number) => boolean>;
                    filters: Ref<import("../store").StoreFilter>;
                    filteredData: any;
                    sortingColumn: any;
                    sortProp: any;
                    sortOrder: any;
                    hoverRow: any;
                }, options: Sort): void;
                changeSortCondition(states: {
                    _currentRowKey: Ref<string>;
                    currentRow: Ref<any>;
                    expandRowKeys: Ref<string[]>;
                    treeData: Ref<unknown>;
                    indent: Ref<number>;
                    lazy: Ref<boolean>;
                    lazyTreeNodeMap: Ref<{}>;
                    lazyColumnIdentifier: Ref<string>;
                    childrenColumnName: Ref<string>;
                    expandRows: Ref<any[]>;
                    defaultExpandAll: Ref<boolean>;
                    rowKey: Ref<string>;
                    data: Ref<any[]>;
                    _data: Ref<any[]>;
                    isComplex: Ref<boolean>;
                    _columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    originColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumnsLength: Ref<number>;
                    fixedLeafColumnsLength: Ref<number>;
                    rightFixedLeafColumnsLength: Ref<number>;
                    isAllSelected: Ref<boolean>;
                    selection: Ref<any[]>;
                    reserveSelection: Ref<boolean>;
                    selectOnIndeterminate: Ref<boolean>;
                    selectable: Ref<(row: any, index: number) => boolean>;
                    filters: Ref<import("../store").StoreFilter>;
                    filteredData: any;
                    sortingColumn: any;
                    sortProp: any;
                    sortOrder: any;
                    hoverRow: any;
                }, options: Sort): void;
                filterChange(_states: {
                    _currentRowKey: Ref<string>;
                    currentRow: Ref<any>;
                    expandRowKeys: Ref<string[]>;
                    treeData: Ref<unknown>;
                    indent: Ref<number>;
                    lazy: Ref<boolean>;
                    lazyTreeNodeMap: Ref<{}>;
                    lazyColumnIdentifier: Ref<string>;
                    childrenColumnName: Ref<string>;
                    expandRows: Ref<any[]>;
                    defaultExpandAll: Ref<boolean>;
                    rowKey: Ref<string>;
                    data: Ref<any[]>;
                    _data: Ref<any[]>;
                    isComplex: Ref<boolean>;
                    _columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    originColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumnsLength: Ref<number>;
                    fixedLeafColumnsLength: Ref<number>;
                    rightFixedLeafColumnsLength: Ref<number>;
                    isAllSelected: Ref<boolean>;
                    selection: Ref<any[]>;
                    reserveSelection: Ref<boolean>;
                    selectOnIndeterminate: Ref<boolean>;
                    selectable: Ref<(row: any, index: number) => boolean>;
                    filters: Ref<import("../store").StoreFilter>;
                    filteredData: any;
                    sortingColumn: any;
                    sortProp: any;
                    sortOrder: any;
                    hoverRow: any;
                }, options: import("../table/defaults").Filter<any>): void;
                toggleAllSelection(): void;
                rowSelectedChanged(_states: any, row: any): void;
                setHoverRow(states: {
                    _currentRowKey: Ref<string>;
                    currentRow: Ref<any>;
                    expandRowKeys: Ref<string[]>;
                    treeData: Ref<unknown>;
                    indent: Ref<number>;
                    lazy: Ref<boolean>;
                    lazyTreeNodeMap: Ref<{}>;
                    lazyColumnIdentifier: Ref<string>;
                    childrenColumnName: Ref<string>;
                    expandRows: Ref<any[]>;
                    defaultExpandAll: Ref<boolean>;
                    rowKey: Ref<string>;
                    data: Ref<any[]>;
                    _data: Ref<any[]>;
                    isComplex: Ref<boolean>;
                    _columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    originColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumnsLength: Ref<number>;
                    fixedLeafColumnsLength: Ref<number>;
                    rightFixedLeafColumnsLength: Ref<number>;
                    isAllSelected: Ref<boolean>;
                    selection: Ref<any[]>;
                    reserveSelection: Ref<boolean>;
                    selectOnIndeterminate: Ref<boolean>;
                    selectable: Ref<(row: any, index: number) => boolean>;
                    filters: Ref<import("../store").StoreFilter>;
                    filteredData: any;
                    sortingColumn: any;
                    sortProp: any;
                    sortOrder: any;
                    hoverRow: any;
                }, row: any): void;
                setCurrentRow(_states: any, row: any): void;
            };
            commit: (name: "setData" | "insertColumn" | "removeColumn" | "sort" | "changeSortCondition" | "filterChange" | "toggleAllSelection" | "rowSelectedChanged" | "setHoverRow" | "setCurrentRow", ...args: any[]) => void;
            updateTableScrollY: () => void;
            assertRowKey: () => void;
            updateColumns: () => void;
            scheduleLayout: (needUpdateColumns?: boolean, immediate?: boolean) => void;
            isSelected: (row: any) => boolean;
            clearSelection: () => void;
            cleanSelection: () => void;
            toggleRowSelection: (row: any, selected?: any, emitChange?: boolean) => void;
            _toggleAllSelection: () => void;
            toggleAllSelection: any;
            updateSelectionByRowKey: () => void;
            updateAllSelected: () => void;
            updateFilters: (columns: any, values: any) => {};
            updateCurrentRow: (_currentRow: any) => void;
            updateSort: (column: any, prop: any, order: any) => void;
            execFilter: () => void;
            execSort: () => void;
            execQuery: (ignore?: any) => void;
            clearFilter: (columnKeys: any) => void;
            clearSort: () => void;
            toggleRowExpansion: (row: any, expanded?: boolean) => void;
            setExpandRowKeysAdapter: (val: string[]) => void;
            setCurrentRowKey: (key: string) => void;
            toggleRowExpansionAdapter: (row: any, expanded: boolean) => void;
            isRowExpanded: (row: any) => boolean;
            updateExpandRows: () => void;
            updateCurrentRowData: () => void;
            loadOrToggle: (row: any) => void;
            states: {
                _currentRowKey: Ref<string>;
                currentRow: Ref<any>;
                expandRowKeys: Ref<string[]>;
                treeData: Ref<unknown>;
                indent: Ref<number>;
                lazy: Ref<boolean>;
                lazyTreeNodeMap: Ref<{}>;
                lazyColumnIdentifier: Ref<string>;
                childrenColumnName: Ref<string>;
                expandRows: Ref<any[]>;
                defaultExpandAll: Ref<boolean>;
                rowKey: Ref<string>;
                data: Ref<any[]>;
                _data: Ref<any[]>;
                isComplex: Ref<boolean>;
                _columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                originColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumnsLength: Ref<number>;
                fixedLeafColumnsLength: Ref<number>;
                rightFixedLeafColumnsLength: Ref<number>;
                isAllSelected: Ref<boolean>;
                selection: Ref<any[]>;
                reserveSelection: Ref<boolean>;
                selectOnIndeterminate: Ref<boolean>;
                selectable: Ref<(row: any, index: number) => boolean>;
                filters: Ref<import("../store").StoreFilter>;
                filteredData: any;
                sortingColumn: any;
                sortProp: any;
                sortOrder: any;
                hoverRow: any;
            };
        }>;
    };
    border: BooleanConstructor;
    defaultSort: {
        type: PropType<Sort>;
        default: () => {
            prop: string;
            order: string;
        };
    };
}, {
    columns: Ref<import("../table-column/defaults").TableColumnCtx<unknown>[]>;
    filterPanels: Ref<{}>;
    hasGutter: import("vue").ComputedRef<number>;
    onColumnsChange: (layout: import("../table-layout").default<unknown>) => void;
    onScrollableChange: (layout: import("../table-layout").default<unknown>) => void;
    columnRows: import("vue").ComputedRef<import("../table-column/defaults").TableColumnCtx<unknown>[]>;
    getHeaderRowClass: (rowIndex: number) => string;
    getHeaderRowStyle: (rowIndex: number) => any;
    getHeaderCellClass: (rowIndex: number, columnIndex: number, row: unknown, column: import("../table-column/defaults").TableColumnCtx<unknown>) => string;
    getHeaderCellStyle: (rowIndex: number, columnIndex: number, row: unknown, column: import("../table-column/defaults").TableColumnCtx<unknown>) => any;
    handleHeaderClick: (event: Event, column: import("../table-column/defaults").TableColumnCtx<unknown>) => void;
    handleHeaderContextMenu: (event: Event, column: import("../table-column/defaults").TableColumnCtx<unknown>) => void;
    handleMouseDown: (event: MouseEvent, column: import("../table-column/defaults").TableColumnCtx<unknown>) => void;
    handleMouseMove: (event: MouseEvent, column: import("../table-column/defaults").TableColumnCtx<unknown>) => void;
    handleMouseOut: () => void;
    handleSortClick: (event: Event, column: import("../table-column/defaults").TableColumnCtx<unknown>, givenOrder: string | boolean) => void;
    handleFilterClick: (event: Event) => void;
    isGroup: import("vue").ComputedRef<boolean>;
    toggleAllSelection: (event: Event) => void;
}, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, Record<string, any>, string, import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<{
    store: {
        mutations: {
            setData(states: {
                _currentRowKey: Ref<string>;
                currentRow: Ref<any>;
                expandRowKeys: Ref<string[]>;
                treeData: Ref<unknown>;
                indent: Ref<number>;
                lazy: Ref<boolean>;
                lazyTreeNodeMap: Ref<{}>;
                lazyColumnIdentifier: Ref<string>;
                childrenColumnName: Ref<string>;
                expandRows: Ref<any[]>;
                defaultExpandAll: Ref<boolean>;
                rowKey: Ref<string>;
                data: Ref<any[]>;
                _data: Ref<any[]>;
                isComplex: Ref<boolean>;
                _columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                originColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumnsLength: Ref<number>;
                fixedLeafColumnsLength: Ref<number>;
                rightFixedLeafColumnsLength: Ref<number>;
                isAllSelected: Ref<boolean>;
                selection: Ref<any[]>;
                reserveSelection: Ref<boolean>;
                selectOnIndeterminate: Ref<boolean>;
                selectable: Ref<(row: any, index: number) => boolean>;
                filters: Ref<import("../store").StoreFilter>;
                filteredData: any;
                sortingColumn: any;
                sortProp: any;
                sortOrder: any;
                hoverRow: any;
            }, data: any[]): void;
            insertColumn(states: {
                _currentRowKey: Ref<string>;
                currentRow: Ref<any>;
                expandRowKeys: Ref<string[]>;
                treeData: Ref<unknown>;
                indent: Ref<number>;
                lazy: Ref<boolean>;
                lazyTreeNodeMap: Ref<{}>;
                lazyColumnIdentifier: Ref<string>;
                childrenColumnName: Ref<string>;
                expandRows: Ref<any[]>;
                defaultExpandAll: Ref<boolean>;
                rowKey: Ref<string>;
                data: Ref<any[]>;
                _data: Ref<any[]>;
                isComplex: Ref<boolean>;
                _columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                originColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumnsLength: Ref<number>;
                fixedLeafColumnsLength: Ref<number>;
                rightFixedLeafColumnsLength: Ref<number>;
                isAllSelected: Ref<boolean>;
                selection: Ref<any[]>;
                reserveSelection: Ref<boolean>;
                selectOnIndeterminate: Ref<boolean>;
                selectable: Ref<(row: any, index: number) => boolean>;
                filters: Ref<import("../store").StoreFilter>;
                filteredData: any;
                sortingColumn: any;
                sortProp: any;
                sortOrder: any;
                hoverRow: any;
            }, column: import("../table-column/defaults").TableColumnCtx<any>, parent: import("../table-column/defaults").TableColumnCtx<any>): void;
            removeColumn(states: {
                _currentRowKey: Ref<string>;
                currentRow: Ref<any>;
                expandRowKeys: Ref<string[]>;
                treeData: Ref<unknown>;
                indent: Ref<number>;
                lazy: Ref<boolean>;
                lazyTreeNodeMap: Ref<{}>;
                lazyColumnIdentifier: Ref<string>;
                childrenColumnName: Ref<string>;
                expandRows: Ref<any[]>;
                defaultExpandAll: Ref<boolean>;
                rowKey: Ref<string>;
                data: Ref<any[]>;
                _data: Ref<any[]>;
                isComplex: Ref<boolean>;
                _columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                originColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumnsLength: Ref<number>;
                fixedLeafColumnsLength: Ref<number>;
                rightFixedLeafColumnsLength: Ref<number>;
                isAllSelected: Ref<boolean>;
                selection: Ref<any[]>;
                reserveSelection: Ref<boolean>;
                selectOnIndeterminate: Ref<boolean>;
                selectable: Ref<(row: any, index: number) => boolean>;
                filters: Ref<import("../store").StoreFilter>;
                filteredData: any;
                sortingColumn: any;
                sortProp: any;
                sortOrder: any;
                hoverRow: any;
            }, column: import("../table-column/defaults").TableColumnCtx<any>, parent: import("../table-column/defaults").TableColumnCtx<any>): void;
            sort(states: {
                _currentRowKey: Ref<string>;
                currentRow: Ref<any>;
                expandRowKeys: Ref<string[]>;
                treeData: Ref<unknown>;
                indent: Ref<number>;
                lazy: Ref<boolean>;
                lazyTreeNodeMap: Ref<{}>;
                lazyColumnIdentifier: Ref<string>;
                childrenColumnName: Ref<string>;
                expandRows: Ref<any[]>;
                defaultExpandAll: Ref<boolean>;
                rowKey: Ref<string>;
                data: Ref<any[]>;
                _data: Ref<any[]>;
                isComplex: Ref<boolean>;
                _columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                originColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumnsLength: Ref<number>;
                fixedLeafColumnsLength: Ref<number>;
                rightFixedLeafColumnsLength: Ref<number>;
                isAllSelected: Ref<boolean>;
                selection: Ref<any[]>;
                reserveSelection: Ref<boolean>;
                selectOnIndeterminate: Ref<boolean>;
                selectable: Ref<(row: any, index: number) => boolean>;
                filters: Ref<import("../store").StoreFilter>;
                filteredData: any;
                sortingColumn: any;
                sortProp: any;
                sortOrder: any;
                hoverRow: any;
            }, options: Sort): void;
            changeSortCondition(states: {
                _currentRowKey: Ref<string>;
                currentRow: Ref<any>;
                expandRowKeys: Ref<string[]>;
                treeData: Ref<unknown>;
                indent: Ref<number>;
                lazy: Ref<boolean>;
                lazyTreeNodeMap: Ref<{}>;
                lazyColumnIdentifier: Ref<string>;
                childrenColumnName: Ref<string>;
                expandRows: Ref<any[]>;
                defaultExpandAll: Ref<boolean>;
                rowKey: Ref<string>;
                data: Ref<any[]>;
                _data: Ref<any[]>;
                isComplex: Ref<boolean>;
                _columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                originColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumnsLength: Ref<number>;
                fixedLeafColumnsLength: Ref<number>;
                rightFixedLeafColumnsLength: Ref<number>;
                isAllSelected: Ref<boolean>;
                selection: Ref<any[]>;
                reserveSelection: Ref<boolean>;
                selectOnIndeterminate: Ref<boolean>;
                selectable: Ref<(row: any, index: number) => boolean>;
                filters: Ref<import("../store").StoreFilter>;
                filteredData: any;
                sortingColumn: any;
                sortProp: any;
                sortOrder: any;
                hoverRow: any;
            }, options: Sort): void;
            filterChange(_states: {
                _currentRowKey: Ref<string>;
                currentRow: Ref<any>;
                expandRowKeys: Ref<string[]>;
                treeData: Ref<unknown>;
                indent: Ref<number>;
                lazy: Ref<boolean>;
                lazyTreeNodeMap: Ref<{}>;
                lazyColumnIdentifier: Ref<string>;
                childrenColumnName: Ref<string>;
                expandRows: Ref<any[]>;
                defaultExpandAll: Ref<boolean>;
                rowKey: Ref<string>;
                data: Ref<any[]>;
                _data: Ref<any[]>;
                isComplex: Ref<boolean>;
                _columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                originColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumnsLength: Ref<number>;
                fixedLeafColumnsLength: Ref<number>;
                rightFixedLeafColumnsLength: Ref<number>;
                isAllSelected: Ref<boolean>;
                selection: Ref<any[]>;
                reserveSelection: Ref<boolean>;
                selectOnIndeterminate: Ref<boolean>;
                selectable: Ref<(row: any, index: number) => boolean>;
                filters: Ref<import("../store").StoreFilter>;
                filteredData: any;
                sortingColumn: any;
                sortProp: any;
                sortOrder: any;
                hoverRow: any;
            }, options: import("../table/defaults").Filter<any>): void;
            toggleAllSelection(): void;
            rowSelectedChanged(_states: any, row: any): void;
            setHoverRow(states: {
                _currentRowKey: Ref<string>;
                currentRow: Ref<any>;
                expandRowKeys: Ref<string[]>;
                treeData: Ref<unknown>;
                indent: Ref<number>;
                lazy: Ref<boolean>;
                lazyTreeNodeMap: Ref<{}>;
                lazyColumnIdentifier: Ref<string>;
                childrenColumnName: Ref<string>;
                expandRows: Ref<any[]>;
                defaultExpandAll: Ref<boolean>;
                rowKey: Ref<string>;
                data: Ref<any[]>;
                _data: Ref<any[]>;
                isComplex: Ref<boolean>;
                _columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                originColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumnsLength: Ref<number>;
                fixedLeafColumnsLength: Ref<number>;
                rightFixedLeafColumnsLength: Ref<number>;
                isAllSelected: Ref<boolean>;
                selection: Ref<any[]>;
                reserveSelection: Ref<boolean>;
                selectOnIndeterminate: Ref<boolean>;
                selectable: Ref<(row: any, index: number) => boolean>;
                filters: Ref<import("../store").StoreFilter>;
                filteredData: any;
                sortingColumn: any;
                sortProp: any;
                sortOrder: any;
                hoverRow: any;
            }, row: any): void;
            setCurrentRow(_states: any, row: any): void;
        };
        commit: (name: "setData" | "insertColumn" | "removeColumn" | "sort" | "changeSortCondition" | "filterChange" | "toggleAllSelection" | "rowSelectedChanged" | "setHoverRow" | "setCurrentRow", ...args: any[]) => void;
        updateTableScrollY: () => void;
        assertRowKey: () => void;
        updateColumns: () => void;
        scheduleLayout: (needUpdateColumns?: boolean, immediate?: boolean) => void;
        isSelected: (row: any) => boolean;
        clearSelection: () => void;
        cleanSelection: () => void;
        toggleRowSelection: (row: any, selected?: any, emitChange?: boolean) => void;
        _toggleAllSelection: () => void;
        toggleAllSelection: any;
        updateSelectionByRowKey: () => void;
        updateAllSelected: () => void;
        updateFilters: (columns: any, values: any) => {};
        updateCurrentRow: (_currentRow: any) => void;
        updateSort: (column: any, prop: any, order: any) => void;
        execFilter: () => void;
        execSort: () => void;
        execQuery: (ignore?: any) => void;
        clearFilter: (columnKeys: any) => void;
        clearSort: () => void;
        toggleRowExpansion: (row: any, expanded?: boolean) => void;
        setExpandRowKeysAdapter: (val: string[]) => void;
        setCurrentRowKey: (key: string) => void;
        toggleRowExpansionAdapter: (row: any, expanded: boolean) => void;
        isRowExpanded: (row: any) => boolean;
        updateExpandRows: () => void;
        updateCurrentRowData: () => void;
        loadOrToggle: (row: any) => void;
        states: {
            _currentRowKey: Ref<string>;
            currentRow: Ref<any>;
            expandRowKeys: Ref<string[]>;
            treeData: Ref<unknown>;
            indent: Ref<number>;
            lazy: Ref<boolean>;
            lazyTreeNodeMap: Ref<{}>;
            lazyColumnIdentifier: Ref<string>;
            childrenColumnName: Ref<string>;
            expandRows: Ref<any[]>;
            defaultExpandAll: Ref<boolean>;
            rowKey: Ref<string>;
            data: Ref<any[]>;
            _data: Ref<any[]>;
            isComplex: Ref<boolean>;
            _columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
            originColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
            columns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
            fixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
            rightFixedColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
            leafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
            fixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
            rightFixedLeafColumns: Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
            leafColumnsLength: Ref<number>;
            fixedLeafColumnsLength: Ref<number>;
            rightFixedLeafColumnsLength: Ref<number>;
            isAllSelected: Ref<boolean>;
            selection: Ref<any[]>;
            reserveSelection: Ref<boolean>;
            selectOnIndeterminate: Ref<boolean>;
            selectable: Ref<(row: any, index: number) => boolean>;
            filters: Ref<import("../store").StoreFilter>;
            filteredData: any;
            sortingColumn: any;
            sortProp: any;
            sortOrder: any;
            hoverRow: any;
        };
    };
    defaultSort: Sort;
    fixed: string;
    border: boolean;
} & {}>, {
    defaultSort: Sort;
    fixed: string;
    border: boolean;
}>;
export default _default;
