import type { ComponentPublicInstance, SetupContext, Ref } from 'vue';
import type { IPopperOptions, PopperInstance } from './defaults';
export declare type ElementType = ComponentPublicInstance | HTMLElement;
export declare type EmitType = 'update:visible' | 'after-enter' | 'after-leave' | 'before-enter' | 'before-leave';
export interface PopperEvents {
    onClick?: (e: Event) => void;
    onMouseenter?: (e: Event) => void;
    onMouseleave?: (e: Event) => void;
    onFocus?: (e: Event) => void;
    onBlur?: (e: Event) => void;
}
export declare type Nullable<T> = null | T;
export declare const DEFAULT_TRIGGER: string[];
export declare const UPDATE_VISIBLE_EVENT = "update:visible";
export default function (props: IPopperOptions, { emit }: SetupContext<EmitType[]>): {
    update: () => void;
    doDestroy: (forceDestroy?: boolean) => void;
    show: () => void;
    hide: () => void;
    onPopperMouseEnter: () => void;
    onPopperMouseLeave: () => void;
    onAfterEnter: () => void;
    onAfterLeave: () => void;
    onBeforeEnter: () => void;
    onBeforeLeave: () => void;
    initializePopper: () => void;
    isManualMode: () => boolean;
    arrowRef: Ref<HTMLElement>;
    events: PopperEvents;
    popperId: string;
    popperInstance: PopperInstance;
    popperRef: Ref<HTMLElement>;
    popperStyle: Ref<{
        alignContent?: string;
        alignItems?: string;
        alignSelf?: string;
        animationDelay?: string;
        animationDirection?: string;
        animationDuration?: string;
        animationFillMode?: string;
        animationIterationCount?: import("csstype").AnimationIterationCountProperty;
        animationName?: string;
        animationPlayState?: string;
        animationTimingFunction?: string;
        appearance?: import("csstype").AppearanceProperty;
        aspectRatio?: string;
        backdropFilter?: string;
        backfaceVisibility?: import("csstype").BackfaceVisibilityProperty;
        backgroundAttachment?: string;
        backgroundBlendMode?: string;
        backgroundClip?: string;
        backgroundColor?: string;
        backgroundImage?: string;
        backgroundOrigin?: string;
        backgroundPosition?: import("csstype").BackgroundPositionProperty<string | number>;
        backgroundPositionX?: import("csstype").BackgroundPositionXProperty<string | number>;
        backgroundPositionY?: import("csstype").BackgroundPositionYProperty<string | number>;
        backgroundRepeat?: string;
        backgroundSize?: import("csstype").BackgroundSizeProperty<string | number>;
        blockOverflow?: string;
        blockSize?: import("csstype").BlockSizeProperty<string | number>;
        borderBlockColor?: string;
        borderBlockEndColor?: string;
        borderBlockEndStyle?: import("csstype").BorderBlockEndStyleProperty;
        borderBlockEndWidth?: import("csstype").BorderBlockEndWidthProperty<string | number>;
        borderBlockStartColor?: string;
        borderBlockStartStyle?: import("csstype").BorderBlockStartStyleProperty;
        borderBlockStartWidth?: import("csstype").BorderBlockStartWidthProperty<string | number>;
        borderBlockStyle?: import("csstype").BorderBlockStyleProperty;
        borderBlockWidth?: import("csstype").BorderBlockWidthProperty<string | number>;
        borderBottomColor?: string;
        borderBottomLeftRadius?: import("csstype").BorderBottomLeftRadiusProperty<string | number>;
        borderBottomRightRadius?: import("csstype").BorderBottomRightRadiusProperty<string | number>;
        borderBottomStyle?: import("csstype").BorderBottomStyleProperty;
        borderBottomWidth?: import("csstype").BorderBottomWidthProperty<string | number>;
        borderCollapse?: import("csstype").BorderCollapseProperty;
        borderEndEndRadius?: import("csstype").BorderEndEndRadiusProperty<string | number>;
        borderEndStartRadius?: import("csstype").BorderEndStartRadiusProperty<string | number>;
        borderImageOutset?: import("csstype").BorderImageOutsetProperty<string | number>;
        borderImageRepeat?: string;
        borderImageSlice?: import("csstype").BorderImageSliceProperty;
        borderImageSource?: string;
        borderImageWidth?: import("csstype").BorderImageWidthProperty<string | number>;
        borderInlineColor?: string;
        borderInlineEndColor?: string;
        borderInlineEndStyle?: import("csstype").BorderInlineEndStyleProperty;
        borderInlineEndWidth?: import("csstype").BorderInlineEndWidthProperty<string | number>;
        borderInlineStartColor?: string;
        borderInlineStartStyle?: import("csstype").BorderInlineStartStyleProperty;
        borderInlineStartWidth?: import("csstype").BorderInlineStartWidthProperty<string | number>;
        borderInlineStyle?: import("csstype").BorderInlineStyleProperty;
        borderInlineWidth?: import("csstype").BorderInlineWidthProperty<string | number>;
        borderLeftColor?: string;
        borderLeftStyle?: import("csstype").BorderLeftStyleProperty;
        borderLeftWidth?: import("csstype").BorderLeftWidthProperty<string | number>;
        borderRightColor?: string;
        borderRightStyle?: import("csstype").BorderRightStyleProperty;
        borderRightWidth?: import("csstype").BorderRightWidthProperty<string | number>;
        borderSpacing?: import("csstype").BorderSpacingProperty<string | number>;
        borderStartEndRadius?: import("csstype").BorderStartEndRadiusProperty<string | number>;
        borderStartStartRadius?: import("csstype").BorderStartStartRadiusProperty<string | number>;
        borderTopColor?: string;
        borderTopLeftRadius?: import("csstype").BorderTopLeftRadiusProperty<string | number>;
        borderTopRightRadius?: import("csstype").BorderTopRightRadiusProperty<string | number>;
        borderTopStyle?: import("csstype").BorderTopStyleProperty;
        borderTopWidth?: import("csstype").BorderTopWidthProperty<string | number>;
        bottom?: import("csstype").BottomProperty<string | number>;
        boxDecorationBreak?: import("csstype").BoxDecorationBreakProperty;
        boxShadow?: string;
        boxSizing?: import("csstype").BoxSizingProperty;
        breakAfter?: import("csstype").BreakAfterProperty;
        breakBefore?: import("csstype").BreakBeforeProperty;
        breakInside?: import("csstype").BreakInsideProperty;
        captionSide?: import("csstype").CaptionSideProperty;
        caretColor?: string;
        clear?: import("csstype").ClearProperty;
        clipPath?: string;
        color?: string;
        colorAdjust?: import("csstype").ColorAdjustProperty;
        columnCount?: import("csstype").ColumnCountProperty;
        columnFill?: import("csstype").ColumnFillProperty;
        columnGap?: import("csstype").ColumnGapProperty<string | number>;
        columnRuleColor?: string;
        columnRuleStyle?: string;
        columnRuleWidth?: import("csstype").ColumnRuleWidthProperty<string | number>;
        columnSpan?: import("csstype").ColumnSpanProperty;
        columnWidth?: import("csstype").ColumnWidthProperty<string | number>;
        contain?: string;
        content?: string;
        counterIncrement?: string;
        counterReset?: string;
        counterSet?: string;
        cursor?: string;
        direction?: import("csstype").DirectionProperty;
        display?: string;
        emptyCells?: import("csstype").EmptyCellsProperty;
        filter?: string;
        flexBasis?: import("csstype").FlexBasisProperty<string | number>;
        flexDirection?: import("csstype").FlexDirectionProperty;
        flexGrow?: import("csstype").GlobalsNumber;
        flexShrink?: import("csstype").GlobalsNumber;
        flexWrap?: import("csstype").FlexWrapProperty;
        float?: import("csstype").FloatProperty;
        fontFamily?: string;
        fontFeatureSettings?: string;
        fontKerning?: import("csstype").FontKerningProperty;
        fontLanguageOverride?: string;
        fontOpticalSizing?: import("csstype").FontOpticalSizingProperty;
        fontSize?: import("csstype").FontSizeProperty<string | number>;
        fontSizeAdjust?: import("csstype").FontSizeAdjustProperty;
        fontStretch?: string;
        fontStyle?: string;
        fontSynthesis?: string;
        fontVariant?: string;
        fontVariantCaps?: import("csstype").FontVariantCapsProperty;
        fontVariantEastAsian?: string;
        fontVariantLigatures?: string;
        fontVariantNumeric?: string;
        fontVariantPosition?: import("csstype").FontVariantPositionProperty;
        fontVariationSettings?: string;
        fontWeight?: import("csstype").FontWeightProperty;
        gridAutoColumns?: import("csstype").GridAutoColumnsProperty<string | number>;
        gridAutoFlow?: string;
        gridAutoRows?: import("csstype").GridAutoRowsProperty<string | number>;
        gridColumnEnd?: import("csstype").GridColumnEndProperty;
        gridColumnStart?: import("csstype").GridColumnStartProperty;
        gridRowEnd?: import("csstype").GridRowEndProperty;
        gridRowStart?: import("csstype").GridRowStartProperty;
        gridTemplateAreas?: string;
        gridTemplateColumns?: import("csstype").GridTemplateColumnsProperty<string | number>;
        gridTemplateRows?: import("csstype").GridTemplateRowsProperty<string | number>;
        hangingPunctuation?: string;
        height?: import("csstype").HeightProperty<string | number>;
        hyphens?: import("csstype").HyphensProperty;
        imageOrientation?: string;
        imageRendering?: import("csstype").ImageRenderingProperty;
        imageResolution?: string;
        initialLetter?: import("csstype").InitialLetterProperty;
        inlineSize?: import("csstype").InlineSizeProperty<string | number>;
        inset?: import("csstype").InsetProperty<string | number>;
        insetBlock?: import("csstype").InsetBlockProperty<string | number>;
        insetBlockEnd?: import("csstype").InsetBlockEndProperty<string | number>;
        insetBlockStart?: import("csstype").InsetBlockStartProperty<string | number>;
        insetInline?: import("csstype").InsetInlineProperty<string | number>;
        insetInlineEnd?: import("csstype").InsetInlineEndProperty<string | number>;
        insetInlineStart?: import("csstype").InsetInlineStartProperty<string | number>;
        isolation?: import("csstype").IsolationProperty;
        justifyContent?: string;
        justifyItems?: string;
        justifySelf?: string;
        left?: import("csstype").LeftProperty<string | number>;
        letterSpacing?: import("csstype").LetterSpacingProperty<string | number>;
        lineBreak?: import("csstype").LineBreakProperty;
        lineHeight?: import("csstype").LineHeightProperty<string | number>;
        lineHeightStep?: import("csstype").LineHeightStepProperty<string | number>;
        listStyleImage?: string;
        listStylePosition?: import("csstype").ListStylePositionProperty;
        listStyleType?: string;
        marginBlock?: import("csstype").MarginBlockProperty<string | number>;
        marginBlockEnd?: import("csstype").MarginBlockEndProperty<string | number>;
        marginBlockStart?: import("csstype").MarginBlockStartProperty<string | number>;
        marginBottom?: import("csstype").MarginBottomProperty<string | number>;
        marginInline?: import("csstype").MarginInlineProperty<string | number>;
        marginInlineEnd?: import("csstype").MarginInlineEndProperty<string | number>;
        marginInlineStart?: import("csstype").MarginInlineStartProperty<string | number>;
        marginLeft?: import("csstype").MarginLeftProperty<string | number>;
        marginRight?: import("csstype").MarginRightProperty<string | number>;
        marginTop?: import("csstype").MarginTopProperty<string | number>;
        maskBorderMode?: import("csstype").MaskBorderModeProperty;
        maskBorderOutset?: import("csstype").MaskBorderOutsetProperty<string | number>;
        maskBorderRepeat?: string;
        maskBorderSlice?: import("csstype").MaskBorderSliceProperty;
        maskBorderSource?: string;
        maskBorderWidth?: import("csstype").MaskBorderWidthProperty<string | number>;
        maskClip?: string;
        maskComposite?: string;
        maskImage?: string;
        maskMode?: string;
        maskOrigin?: string;
        maskPosition?: import("csstype").MaskPositionProperty<string | number>;
        maskRepeat?: string;
        maskSize?: import("csstype").MaskSizeProperty<string | number>;
        maskType?: import("csstype").MaskTypeProperty;
        maxBlockSize?: import("csstype").MaxBlockSizeProperty<string | number>;
        maxHeight?: import("csstype").MaxHeightProperty<string | number>;
        maxInlineSize?: import("csstype").MaxInlineSizeProperty<string | number>;
        maxLines?: import("csstype").MaxLinesProperty;
        maxWidth?: import("csstype").MaxWidthProperty<string | number>;
        minBlockSize?: import("csstype").MinBlockSizeProperty<string | number>;
        minHeight?: import("csstype").MinHeightProperty<string | number>;
        minInlineSize?: import("csstype").MinInlineSizeProperty<string | number>;
        minWidth?: import("csstype").MinWidthProperty<string | number>;
        mixBlendMode?: import("csstype").MixBlendModeProperty;
        motionDistance?: import("csstype").OffsetDistanceProperty<string | number>;
        motionPath?: string;
        motionRotation?: string;
        objectFit?: import("csstype").ObjectFitProperty;
        objectPosition?: import("csstype").ObjectPositionProperty<string | number>;
        offsetAnchor?: import("csstype").OffsetAnchorProperty<string | number>;
        offsetDistance?: import("csstype").OffsetDistanceProperty<string | number>;
        offsetPath?: string;
        offsetRotate?: string;
        offsetRotation?: string;
        opacity?: import("csstype").OpacityProperty;
        order?: import("csstype").GlobalsNumber;
        orphans?: import("csstype").GlobalsNumber;
        outlineColor?: string;
        outlineOffset?: import("csstype").OutlineOffsetProperty<string | number>;
        outlineStyle?: string;
        outlineWidth?: import("csstype").OutlineWidthProperty<string | number>;
        overflowAnchor?: import("csstype").OverflowAnchorProperty;
        overflowBlock?: import("csstype").OverflowBlockProperty;
        overflowClipBox?: import("csstype").OverflowClipBoxProperty;
        overflowInline?: import("csstype").OverflowInlineProperty;
        overflowWrap?: import("csstype").OverflowWrapProperty;
        overflowX?: import("csstype").OverflowXProperty;
        overflowY?: import("csstype").OverflowYProperty;
        overscrollBehavior?: string;
        overscrollBehaviorBlock?: import("csstype").OverscrollBehaviorBlockProperty;
        overscrollBehaviorInline?: import("csstype").OverscrollBehaviorInlineProperty;
        overscrollBehaviorX?: import("csstype").OverscrollBehaviorXProperty;
        overscrollBehaviorY?: import("csstype").OverscrollBehaviorYProperty;
        paddingBlock?: import("csstype").PaddingBlockProperty<string | number>;
        paddingBlockEnd?: import("csstype").PaddingBlockEndProperty<string | number>;
        paddingBlockStart?: import("csstype").PaddingBlockStartProperty<string | number>;
        paddingBottom?: import("csstype").PaddingBottomProperty<string | number>;
        paddingInline?: import("csstype").PaddingInlineProperty<string | number>;
        paddingInlineEnd?: import("csstype").PaddingInlineEndProperty<string | number>;
        paddingInlineStart?: import("csstype").PaddingInlineStartProperty<string | number>;
        paddingLeft?: import("csstype").PaddingLeftProperty<string | number>;
        paddingRight?: import("csstype").PaddingRightProperty<string | number>;
        paddingTop?: import("csstype").PaddingTopProperty<string | number>;
        pageBreakAfter?: import("csstype").PageBreakAfterProperty;
        pageBreakBefore?: import("csstype").PageBreakBeforeProperty;
        pageBreakInside?: import("csstype").PageBreakInsideProperty;
        paintOrder?: string;
        perspective?: import("csstype").PerspectiveProperty<string | number>;
        perspectiveOrigin?: import("csstype").PerspectiveOriginProperty<string | number>;
        placeContent?: string;
        pointerEvents?: import("csstype").PointerEventsProperty;
        position?: import("csstype").PositionProperty;
        quotes?: string;
        resize?: import("csstype").ResizeProperty;
        right?: import("csstype").RightProperty<string | number>;
        rotate?: string;
        rowGap?: import("csstype").RowGapProperty<string | number>;
        rubyAlign?: import("csstype").RubyAlignProperty;
        rubyMerge?: import("csstype").RubyMergeProperty;
        rubyPosition?: import("csstype").RubyPositionProperty;
        scale?: import("csstype").ScaleProperty;
        scrollBehavior?: import("csstype").ScrollBehaviorProperty;
        scrollMargin?: import("csstype").ScrollMarginProperty<string | number>;
        scrollMarginBlock?: import("csstype").ScrollMarginBlockProperty<string | number>;
        scrollMarginBlockEnd?: import("csstype").ScrollMarginBlockEndProperty<string | number>;
        scrollMarginBlockStart?: import("csstype").ScrollMarginBlockStartProperty<string | number>;
        scrollMarginBottom?: import("csstype").ScrollMarginBottomProperty<string | number>;
        scrollMarginInline?: import("csstype").ScrollMarginInlineProperty<string | number>;
        scrollMarginInlineEnd?: import("csstype").ScrollMarginInlineEndProperty<string | number>;
        scrollMarginInlineStart?: import("csstype").ScrollMarginInlineStartProperty<string | number>;
        scrollMarginLeft?: import("csstype").ScrollMarginLeftProperty<string | number>;
        scrollMarginRight?: import("csstype").ScrollMarginRightProperty<string | number>;
        scrollMarginTop?: import("csstype").ScrollMarginTopProperty<string | number>;
        scrollPadding?: import("csstype").ScrollPaddingProperty<string | number>;
        scrollPaddingBlock?: import("csstype").ScrollPaddingBlockProperty<string | number>;
        scrollPaddingBlockEnd?: import("csstype").ScrollPaddingBlockEndProperty<string | number>;
        scrollPaddingBlockStart?: import("csstype").ScrollPaddingBlockStartProperty<string | number>;
        scrollPaddingBottom?: import("csstype").ScrollPaddingBottomProperty<string | number>;
        scrollPaddingInline?: import("csstype").ScrollPaddingInlineProperty<string | number>;
        scrollPaddingInlineEnd?: import("csstype").ScrollPaddingInlineEndProperty<string | number>;
        scrollPaddingInlineStart?: import("csstype").ScrollPaddingInlineStartProperty<string | number>;
        scrollPaddingLeft?: import("csstype").ScrollPaddingLeftProperty<string | number>;
        scrollPaddingRight?: import("csstype").ScrollPaddingRightProperty<string | number>;
        scrollPaddingTop?: import("csstype").ScrollPaddingTopProperty<string | number>;
        scrollSnapAlign?: string;
        scrollSnapMargin?: import("csstype").ScrollMarginProperty<string | number>;
        scrollSnapMarginBottom?: import("csstype").ScrollMarginBottomProperty<string | number>;
        scrollSnapMarginLeft?: import("csstype").ScrollMarginLeftProperty<string | number>;
        scrollSnapMarginRight?: import("csstype").ScrollMarginRightProperty<string | number>;
        scrollSnapMarginTop?: import("csstype").ScrollMarginTopProperty<string | number>;
        scrollSnapStop?: import("csstype").ScrollSnapStopProperty;
        scrollSnapType?: string;
        scrollbarColor?: string;
        scrollbarWidth?: import("csstype").ScrollbarWidthProperty;
        shapeImageThreshold?: import("csstype").ShapeImageThresholdProperty;
        shapeMargin?: import("csstype").ShapeMarginProperty<string | number>;
        shapeOutside?: string;
        tabSize?: import("csstype").TabSizeProperty<string | number>;
        tableLayout?: import("csstype").TableLayoutProperty;
        textAlign?: import("csstype").TextAlignProperty;
        textAlignLast?: import("csstype").TextAlignLastProperty;
        textCombineUpright?: string;
        textDecorationColor?: string;
        textDecorationLine?: string;
        textDecorationSkip?: string;
        textDecorationSkipInk?: import("csstype").TextDecorationSkipInkProperty;
        textDecorationStyle?: import("csstype").TextDecorationStyleProperty;
        textDecorationThickness?: import("csstype").TextDecorationThicknessProperty<string | number>;
        textDecorationWidth?: import("csstype").TextDecorationThicknessProperty<string | number>;
        textEmphasisColor?: string;
        textEmphasisPosition?: string;
        textEmphasisStyle?: string;
        textIndent?: import("csstype").TextIndentProperty<string | number>;
        textJustify?: import("csstype").TextJustifyProperty;
        textOrientation?: import("csstype").TextOrientationProperty;
        textOverflow?: string;
        textRendering?: import("csstype").TextRenderingProperty;
        textShadow?: string;
        textSizeAdjust?: string;
        textTransform?: import("csstype").TextTransformProperty;
        textUnderlineOffset?: import("csstype").TextUnderlineOffsetProperty<string | number>;
        textUnderlinePosition?: string;
        top?: import("csstype").TopProperty<string | number>;
        touchAction?: string;
        transform?: string;
        transformBox?: import("csstype").TransformBoxProperty;
        transformOrigin?: import("csstype").TransformOriginProperty<string | number>;
        transformStyle?: import("csstype").TransformStyleProperty;
        transitionDelay?: string;
        transitionDuration?: string;
        transitionProperty?: string;
        transitionTimingFunction?: string;
        translate?: import("csstype").TranslateProperty<string | number>;
        unicodeBidi?: import("csstype").UnicodeBidiProperty;
        userSelect?: import("csstype").UserSelectProperty;
        verticalAlign?: import("csstype").VerticalAlignProperty<string | number>;
        visibility?: import("csstype").VisibilityProperty;
        whiteSpace?: import("csstype").WhiteSpaceProperty;
        widows?: import("csstype").GlobalsNumber;
        width?: import("csstype").WidthProperty<string | number>;
        willChange?: string;
        wordBreak?: import("csstype").WordBreakProperty;
        wordSpacing?: import("csstype").WordSpacingProperty<string | number>;
        wordWrap?: import("csstype").WordWrapProperty;
        writingMode?: import("csstype").WritingModeProperty;
        zIndex?: import("csstype").ZIndexProperty;
        zoom?: import("csstype").ZoomProperty;
        all?: import("csstype").Globals;
        animation?: import("csstype").AnimationProperty;
        background?: import("csstype").BackgroundProperty<string | number>;
        border?: import("csstype").BorderProperty<string | number>;
        borderBlock?: import("csstype").BorderBlockProperty<string | number>;
        borderBlockEnd?: import("csstype").BorderBlockEndProperty<string | number>;
        borderBlockStart?: import("csstype").BorderBlockStartProperty<string | number>;
        borderBottom?: import("csstype").BorderBottomProperty<string | number>;
        borderColor?: string;
        borderImage?: import("csstype").BorderImageProperty;
        borderInline?: import("csstype").BorderInlineProperty<string | number>;
        borderInlineEnd?: import("csstype").BorderInlineEndProperty<string | number>;
        borderInlineStart?: import("csstype").BorderInlineStartProperty<string | number>;
        borderLeft?: import("csstype").BorderLeftProperty<string | number>;
        borderRadius?: import("csstype").BorderRadiusProperty<string | number>;
        borderRight?: import("csstype").BorderRightProperty<string | number>;
        borderStyle?: string;
        borderTop?: import("csstype").BorderTopProperty<string | number>;
        borderWidth?: import("csstype").BorderWidthProperty<string | number>;
        columnRule?: import("csstype").ColumnRuleProperty<string | number>;
        columns?: import("csstype").ColumnsProperty<string | number>;
        flex?: import("csstype").FlexProperty<string | number>;
        flexFlow?: string;
        font?: string;
        gap?: import("csstype").GapProperty<string | number>;
        grid?: string;
        gridArea?: import("csstype").GridAreaProperty;
        gridColumn?: import("csstype").GridColumnProperty;
        gridRow?: import("csstype").GridRowProperty;
        gridTemplate?: string;
        lineClamp?: import("csstype").LineClampProperty;
        listStyle?: string;
        margin?: import("csstype").MarginProperty<string | number>;
        mask?: import("csstype").MaskProperty<string | number>;
        maskBorder?: import("csstype").MaskBorderProperty;
        motion?: import("csstype").OffsetProperty<string | number>;
        offset?: import("csstype").OffsetProperty<string | number>;
        outline?: import("csstype").OutlineProperty<string | number>;
        overflow?: string;
        padding?: import("csstype").PaddingProperty<string | number>;
        placeItems?: string;
        placeSelf?: string;
        textDecoration?: import("csstype").TextDecorationProperty<string | number>;
        textEmphasis?: string;
        transition?: string;
        MozAnimationDelay?: string;
        MozAnimationDirection?: string;
        MozAnimationDuration?: string;
        MozAnimationFillMode?: string;
        MozAnimationIterationCount?: import("csstype").AnimationIterationCountProperty;
        MozAnimationName?: string;
        MozAnimationPlayState?: string;
        MozAnimationTimingFunction?: string;
        MozAppearance?: import("csstype").MozAppearanceProperty;
        MozBackfaceVisibility?: import("csstype").BackfaceVisibilityProperty;
        MozBorderBottomColors?: string;
        MozBorderEndColor?: string;
        MozBorderEndStyle?: import("csstype").BorderInlineEndStyleProperty;
        MozBorderEndWidth?: import("csstype").BorderInlineEndWidthProperty<string | number>;
        MozBorderLeftColors?: string;
        MozBorderRightColors?: string;
        MozBorderStartColor?: string;
        MozBorderStartStyle?: import("csstype").BorderInlineStartStyleProperty;
        MozBorderTopColors?: string;
        MozBoxSizing?: import("csstype").BoxSizingProperty;
        MozColumnCount?: import("csstype").ColumnCountProperty;
        MozColumnFill?: import("csstype").ColumnFillProperty;
        MozColumnGap?: import("csstype").ColumnGapProperty<string | number>;
        MozColumnRuleColor?: string;
        MozColumnRuleStyle?: string;
        MozColumnRuleWidth?: import("csstype").ColumnRuleWidthProperty<string | number>;
        MozColumnWidth?: import("csstype").ColumnWidthProperty<string | number>;
        MozContextProperties?: string;
        MozFloatEdge?: import("csstype").MozFloatEdgeProperty;
        MozFontFeatureSettings?: string;
        MozFontLanguageOverride?: string;
        MozForceBrokenImageIcon?: import("csstype").GlobalsNumber;
        MozHyphens?: import("csstype").HyphensProperty;
        MozImageRegion?: string;
        MozMarginEnd?: import("csstype").MarginInlineEndProperty<string | number>;
        MozMarginStart?: import("csstype").MarginInlineStartProperty<string | number>;
        MozOrient?: import("csstype").MozOrientProperty;
        MozOutlineRadiusBottomleft?: import("csstype").MozOutlineRadiusBottomleftProperty<string | number>;
        MozOutlineRadiusBottomright?: import("csstype").MozOutlineRadiusBottomrightProperty<string | number>;
        MozOutlineRadiusTopleft?: import("csstype").MozOutlineRadiusTopleftProperty<string | number>;
        MozOutlineRadiusTopright?: import("csstype").MozOutlineRadiusToprightProperty<string | number>;
        MozPaddingEnd?: import("csstype").PaddingInlineEndProperty<string | number>;
        MozPaddingStart?: import("csstype").PaddingInlineStartProperty<string | number>;
        MozPerspective?: import("csstype").PerspectiveProperty<string | number>;
        MozPerspectiveOrigin?: import("csstype").PerspectiveOriginProperty<string | number>;
        MozStackSizing?: import("csstype").MozStackSizingProperty;
        MozTabSize?: import("csstype").TabSizeProperty<string | number>;
        MozTextBlink?: import("csstype").MozTextBlinkProperty;
        MozTextSizeAdjust?: string;
        MozTransformOrigin?: import("csstype").TransformOriginProperty<string | number>;
        MozTransformStyle?: import("csstype").TransformStyleProperty;
        MozTransitionDelay?: string;
        MozTransitionDuration?: string;
        MozTransitionProperty?: string;
        MozTransitionTimingFunction?: string;
        MozUserFocus?: import("csstype").MozUserFocusProperty;
        MozUserModify?: import("csstype").MozUserModifyProperty;
        MozUserSelect?: import("csstype").UserSelectProperty;
        MozWindowDragging?: import("csstype").MozWindowDraggingProperty;
        MozWindowShadow?: import("csstype").MozWindowShadowProperty;
        msAccelerator?: import("csstype").MsAcceleratorProperty;
        msAlignSelf?: string;
        msBlockProgression?: import("csstype").MsBlockProgressionProperty;
        msContentZoomChaining?: import("csstype").MsContentZoomChainingProperty;
        msContentZoomLimitMax?: string;
        msContentZoomLimitMin?: string;
        msContentZoomSnapPoints?: string;
        msContentZoomSnapType?: import("csstype").MsContentZoomSnapTypeProperty;
        msContentZooming?: import("csstype").MsContentZoomingProperty;
        msFilter?: string;
        msFlexDirection?: import("csstype").FlexDirectionProperty;
        msFlexPositive?: import("csstype").GlobalsNumber;
        msFlowFrom?: string;
        msFlowInto?: string;
        msGridColumns?: import("csstype").GridAutoColumnsProperty<string | number>;
        msGridRows?: import("csstype").GridAutoRowsProperty<string | number>;
        msHighContrastAdjust?: import("csstype").MsHighContrastAdjustProperty;
        msHyphenateLimitChars?: import("csstype").MsHyphenateLimitCharsProperty;
        msHyphenateLimitLines?: import("csstype").MsHyphenateLimitLinesProperty;
        msHyphenateLimitZone?: import("csstype").MsHyphenateLimitZoneProperty<string | number>;
        msHyphens?: import("csstype").HyphensProperty;
        msImeAlign?: import("csstype").MsImeAlignProperty;
        msLineBreak?: import("csstype").LineBreakProperty;
        msOrder?: import("csstype").GlobalsNumber;
        msOverflowStyle?: import("csstype").MsOverflowStyleProperty;
        msOverflowX?: import("csstype").OverflowXProperty;
        msOverflowY?: import("csstype").OverflowYProperty;
        msScrollChaining?: import("csstype").MsScrollChainingProperty;
        msScrollLimitXMax?: import("csstype").MsScrollLimitXMaxProperty<string | number>;
        msScrollLimitXMin?: import("csstype").MsScrollLimitXMinProperty<string | number>;
        msScrollLimitYMax?: import("csstype").MsScrollLimitYMaxProperty<string | number>;
        msScrollLimitYMin?: import("csstype").MsScrollLimitYMinProperty<string | number>;
        msScrollRails?: import("csstype").MsScrollRailsProperty;
        msScrollSnapPointsX?: string;
        msScrollSnapPointsY?: string;
        msScrollSnapType?: import("csstype").MsScrollSnapTypeProperty;
        msScrollTranslation?: import("csstype").MsScrollTranslationProperty;
        msScrollbar3dlightColor?: string;
        msScrollbarArrowColor?: string;
        msScrollbarBaseColor?: string;
        msScrollbarDarkshadowColor?: string;
        msScrollbarFaceColor?: string;
        msScrollbarHighlightColor?: string;
        msScrollbarShadowColor?: string;
        msTextAutospace?: import("csstype").MsTextAutospaceProperty;
        msTextCombineHorizontal?: string;
        msTextOverflow?: string;
        msTouchAction?: string;
        msTouchSelect?: import("csstype").MsTouchSelectProperty;
        msTransform?: string;
        msTransformOrigin?: import("csstype").TransformOriginProperty<string | number>;
        msTransitionDelay?: string;
        msTransitionDuration?: string;
        msTransitionProperty?: string;
        msTransitionTimingFunction?: string;
        msUserSelect?: import("csstype").MsUserSelectProperty;
        msWordBreak?: import("csstype").WordBreakProperty;
        msWrapFlow?: import("csstype").MsWrapFlowProperty;
        msWrapMargin?: import("csstype").MsWrapMarginProperty<string | number>;
        msWrapThrough?: import("csstype").MsWrapThroughProperty;
        msWritingMode?: import("csstype").WritingModeProperty;
        OObjectFit?: import("csstype").ObjectFitProperty;
        OObjectPosition?: import("csstype").ObjectPositionProperty<string | number>;
        OTabSize?: import("csstype").TabSizeProperty<string | number>;
        OTextOverflow?: string;
        OTransformOrigin?: import("csstype").TransformOriginProperty<string | number>;
        WebkitAlignContent?: string;
        WebkitAlignItems?: string;
        WebkitAlignSelf?: string;
        WebkitAnimationDelay?: string;
        WebkitAnimationDirection?: string;
        WebkitAnimationDuration?: string;
        WebkitAnimationFillMode?: string;
        WebkitAnimationIterationCount?: import("csstype").AnimationIterationCountProperty;
        WebkitAnimationName?: string;
        WebkitAnimationPlayState?: string;
        WebkitAnimationTimingFunction?: string;
        WebkitAppearance?: import("csstype").WebkitAppearanceProperty;
        WebkitBackdropFilter?: string;
        WebkitBackfaceVisibility?: import("csstype").BackfaceVisibilityProperty;
        WebkitBackgroundClip?: string;
        WebkitBackgroundOrigin?: string;
        WebkitBackgroundSize?: import("csstype").BackgroundSizeProperty<string | number>;
        WebkitBorderBeforeColor?: string;
        WebkitBorderBeforeStyle?: string;
        WebkitBorderBeforeWidth?: import("csstype").WebkitBorderBeforeWidthProperty<string | number>;
        WebkitBorderBottomLeftRadius?: import("csstype").BorderBottomLeftRadiusProperty<string | number>;
        WebkitBorderBottomRightRadius?: import("csstype").BorderBottomRightRadiusProperty<string | number>;
        WebkitBorderImageSlice?: import("csstype").BorderImageSliceProperty;
        WebkitBorderTopLeftRadius?: import("csstype").BorderTopLeftRadiusProperty<string | number>;
        WebkitBorderTopRightRadius?: import("csstype").BorderTopRightRadiusProperty<string | number>;
        WebkitBoxDecorationBreak?: import("csstype").BoxDecorationBreakProperty;
        WebkitBoxReflect?: import("csstype").WebkitBoxReflectProperty<string | number>;
        WebkitBoxShadow?: string;
        WebkitBoxSizing?: import("csstype").BoxSizingProperty;
        WebkitClipPath?: string;
        WebkitColumnCount?: import("csstype").ColumnCountProperty;
        WebkitColumnFill?: import("csstype").ColumnFillProperty;
        WebkitColumnGap?: import("csstype").ColumnGapProperty<string | number>;
        WebkitColumnRuleColor?: string;
        WebkitColumnRuleStyle?: string;
        WebkitColumnRuleWidth?: import("csstype").ColumnRuleWidthProperty<string | number>;
        WebkitColumnSpan?: import("csstype").ColumnSpanProperty;
        WebkitColumnWidth?: import("csstype").ColumnWidthProperty<string | number>;
        WebkitFilter?: string;
        WebkitFlexBasis?: import("csstype").FlexBasisProperty<string | number>;
        WebkitFlexDirection?: import("csstype").FlexDirectionProperty;
        WebkitFlexGrow?: import("csstype").GlobalsNumber;
        WebkitFlexShrink?: import("csstype").GlobalsNumber;
        WebkitFlexWrap?: import("csstype").FlexWrapProperty;
        WebkitFontFeatureSettings?: string;
        WebkitFontKerning?: import("csstype").FontKerningProperty;
        WebkitFontVariantLigatures?: string;
        WebkitHyphens?: import("csstype").HyphensProperty;
        WebkitJustifyContent?: string;
        WebkitLineBreak?: import("csstype").LineBreakProperty;
        WebkitLineClamp?: import("csstype").WebkitLineClampProperty;
        WebkitMarginEnd?: import("csstype").MarginInlineEndProperty<string | number>;
        WebkitMarginStart?: import("csstype").MarginInlineStartProperty<string | number>;
        WebkitMaskAttachment?: string;
        WebkitMaskClip?: string;
        WebkitMaskComposite?: string;
        WebkitMaskImage?: string;
        WebkitMaskOrigin?: string;
        WebkitMaskPosition?: import("csstype").WebkitMaskPositionProperty<string | number>;
        WebkitMaskPositionX?: import("csstype").WebkitMaskPositionXProperty<string | number>;
        WebkitMaskPositionY?: import("csstype").WebkitMaskPositionYProperty<string | number>;
        WebkitMaskRepeat?: string;
        WebkitMaskRepeatX?: import("csstype").WebkitMaskRepeatXProperty;
        WebkitMaskRepeatY?: import("csstype").WebkitMaskRepeatYProperty;
        WebkitMaskSize?: import("csstype").WebkitMaskSizeProperty<string | number>;
        WebkitMaxInlineSize?: import("csstype").MaxInlineSizeProperty<string | number>;
        WebkitOrder?: import("csstype").GlobalsNumber;
        WebkitOverflowScrolling?: import("csstype").WebkitOverflowScrollingProperty;
        WebkitPaddingEnd?: import("csstype").PaddingInlineEndProperty<string | number>;
        WebkitPaddingStart?: import("csstype").PaddingInlineStartProperty<string | number>;
        WebkitPerspective?: import("csstype").PerspectiveProperty<string | number>;
        WebkitPerspectiveOrigin?: import("csstype").PerspectiveOriginProperty<string | number>;
        WebkitPrintColorAdjust?: import("csstype").ColorAdjustProperty;
        WebkitScrollSnapType?: string;
        WebkitShapeMargin?: import("csstype").ShapeMarginProperty<string | number>;
        WebkitTapHighlightColor?: string;
        WebkitTextCombine?: string;
        WebkitTextDecorationColor?: string;
        WebkitTextDecorationLine?: string;
        WebkitTextDecorationSkip?: string;
        WebkitTextDecorationStyle?: import("csstype").TextDecorationStyleProperty;
        WebkitTextEmphasisColor?: string;
        WebkitTextEmphasisPosition?: string;
        WebkitTextEmphasisStyle?: string;
        WebkitTextFillColor?: string;
        WebkitTextOrientation?: import("csstype").TextOrientationProperty;
        WebkitTextSizeAdjust?: string;
        WebkitTextStrokeColor?: string;
        WebkitTextStrokeWidth?: import("csstype").WebkitTextStrokeWidthProperty<string | number>;
        WebkitTextUnderlinePosition?: string;
        WebkitTouchCallout?: import("csstype").WebkitTouchCalloutProperty;
        WebkitTransform?: string;
        WebkitTransformOrigin?: import("csstype").TransformOriginProperty<string | number>;
        WebkitTransformStyle?: import("csstype").TransformStyleProperty;
        WebkitTransitionDelay?: string;
        WebkitTransitionDuration?: string;
        WebkitTransitionProperty?: string;
        WebkitTransitionTimingFunction?: string;
        WebkitUserModify?: import("csstype").WebkitUserModifyProperty;
        WebkitUserSelect?: import("csstype").UserSelectProperty;
        WebkitWritingMode?: import("csstype").WritingModeProperty;
        MozAnimation?: import("csstype").AnimationProperty;
        MozBorderImage?: import("csstype").BorderImageProperty;
        MozColumnRule?: import("csstype").ColumnRuleProperty<string | number>;
        MozColumns?: import("csstype").ColumnsProperty<string | number>;
        MozTransition?: string;
        msContentZoomLimit?: string;
        msContentZoomSnap?: string;
        msFlex?: import("csstype").FlexProperty<string | number>;
        msScrollLimit?: string;
        msScrollSnapX?: string;
        msScrollSnapY?: string;
        msTransition?: string;
        WebkitAnimation?: import("csstype").AnimationProperty;
        WebkitBorderBefore?: import("csstype").WebkitBorderBeforeProperty<string | number>;
        WebkitBorderImage?: import("csstype").BorderImageProperty;
        WebkitBorderRadius?: import("csstype").BorderRadiusProperty<string | number>;
        WebkitColumnRule?: import("csstype").ColumnRuleProperty<string | number>;
        WebkitColumns?: import("csstype").ColumnsProperty<string | number>;
        WebkitFlex?: import("csstype").FlexProperty<string | number>;
        WebkitFlexFlow?: string;
        WebkitMask?: import("csstype").WebkitMaskProperty<string | number>;
        WebkitTextEmphasis?: string;
        WebkitTextStroke?: import("csstype").WebkitTextStrokeProperty<string | number>;
        WebkitTransition?: string;
        boxAlign?: import("csstype").BoxAlignProperty;
        boxDirection?: import("csstype").BoxDirectionProperty;
        boxFlex?: import("csstype").GlobalsNumber;
        boxFlexGroup?: import("csstype").GlobalsNumber;
        boxLines?: import("csstype").BoxLinesProperty;
        boxOrdinalGroup?: import("csstype").GlobalsNumber;
        boxOrient?: import("csstype").BoxOrientProperty;
        boxPack?: import("csstype").BoxPackProperty;
        clip?: string;
        fontVariantAlternates?: string;
        gridColumnGap?: import("csstype").GridColumnGapProperty<string | number>;
        gridGap?: import("csstype").GridGapProperty<string | number>;
        gridRowGap?: import("csstype").GridRowGapProperty<string | number>;
        imeMode?: import("csstype").ImeModeProperty;
        offsetBlock?: import("csstype").InsetBlockProperty<string | number>;
        offsetBlockEnd?: import("csstype").InsetBlockEndProperty<string | number>;
        offsetBlockStart?: import("csstype").InsetBlockStartProperty<string | number>;
        offsetInline?: import("csstype").InsetInlineProperty<string | number>;
        offsetInlineEnd?: import("csstype").InsetInlineEndProperty<string | number>;
        offsetInlineStart?: import("csstype").InsetInlineStartProperty<string | number>;
        scrollSnapCoordinate?: import("csstype").ScrollSnapCoordinateProperty<string | number>;
        scrollSnapDestination?: import("csstype").ScrollSnapDestinationProperty<string | number>;
        scrollSnapPointsX?: string;
        scrollSnapPointsY?: string;
        scrollSnapTypeX?: import("csstype").ScrollSnapTypeXProperty;
        scrollSnapTypeY?: import("csstype").ScrollSnapTypeYProperty;
        scrollbarTrackColor?: string;
        textCombineHorizontal?: string;
        KhtmlBoxAlign?: import("csstype").BoxAlignProperty;
        KhtmlBoxDirection?: import("csstype").BoxDirectionProperty;
        KhtmlBoxFlex?: import("csstype").GlobalsNumber;
        KhtmlBoxFlexGroup?: import("csstype").GlobalsNumber;
        KhtmlBoxLines?: import("csstype").BoxLinesProperty;
        KhtmlBoxOrdinalGroup?: import("csstype").GlobalsNumber;
        KhtmlBoxOrient?: import("csstype").BoxOrientProperty;
        KhtmlBoxPack?: import("csstype").BoxPackProperty;
        KhtmlLineBreak?: import("csstype").LineBreakProperty;
        KhtmlOpacity?: import("csstype").OpacityProperty;
        KhtmlUserSelect?: import("csstype").UserSelectProperty;
        MozBackgroundClip?: string;
        MozBackgroundInlinePolicy?: import("csstype").BoxDecorationBreakProperty;
        MozBackgroundOrigin?: string;
        MozBackgroundSize?: import("csstype").BackgroundSizeProperty<string | number>;
        MozBinding?: string;
        MozBorderRadius?: import("csstype").BorderRadiusProperty<string | number>;
        MozBorderRadiusBottomleft?: import("csstype").BorderBottomLeftRadiusProperty<string | number>;
        MozBorderRadiusBottomright?: import("csstype").BorderBottomRightRadiusProperty<string | number>;
        MozBorderRadiusTopleft?: import("csstype").BorderTopLeftRadiusProperty<string | number>;
        MozBorderRadiusTopright?: import("csstype").BorderTopRightRadiusProperty<string | number>;
        MozBoxAlign?: import("csstype").BoxAlignProperty;
        MozBoxDirection?: import("csstype").BoxDirectionProperty;
        MozBoxFlex?: import("csstype").GlobalsNumber;
        MozBoxOrdinalGroup?: import("csstype").GlobalsNumber;
        MozBoxOrient?: import("csstype").BoxOrientProperty;
        MozBoxPack?: import("csstype").BoxPackProperty;
        MozBoxShadow?: string;
        MozOpacity?: import("csstype").OpacityProperty;
        MozOutline?: import("csstype").OutlineProperty<string | number>;
        MozOutlineColor?: string;
        MozOutlineRadius?: import("csstype").MozOutlineRadiusProperty<string | number>;
        MozOutlineStyle?: string;
        MozOutlineWidth?: import("csstype").OutlineWidthProperty<string | number>;
        MozTextAlignLast?: import("csstype").TextAlignLastProperty;
        MozTextDecorationColor?: string;
        MozTextDecorationLine?: string;
        MozTextDecorationStyle?: import("csstype").TextDecorationStyleProperty;
        MozUserInput?: import("csstype").MozUserInputProperty;
        msImeMode?: import("csstype").ImeModeProperty;
        msScrollbarTrackColor?: string;
        OAnimation?: import("csstype").AnimationProperty;
        OAnimationDelay?: string;
        OAnimationDirection?: string;
        OAnimationDuration?: string;
        OAnimationFillMode?: string;
        OAnimationIterationCount?: import("csstype").AnimationIterationCountProperty;
        OAnimationName?: string;
        OAnimationPlayState?: string;
        OAnimationTimingFunction?: string;
        OBackgroundSize?: import("csstype").BackgroundSizeProperty<string | number>;
        OBorderImage?: import("csstype").BorderImageProperty;
        OTransform?: string;
        OTransition?: string;
        OTransitionDelay?: string;
        OTransitionDuration?: string;
        OTransitionProperty?: string;
        OTransitionTimingFunction?: string;
        WebkitBoxAlign?: import("csstype").BoxAlignProperty;
        WebkitBoxDirection?: import("csstype").BoxDirectionProperty;
        WebkitBoxFlex?: import("csstype").GlobalsNumber;
        WebkitBoxFlexGroup?: import("csstype").GlobalsNumber;
        WebkitBoxLines?: import("csstype").BoxLinesProperty;
        WebkitBoxOrdinalGroup?: import("csstype").GlobalsNumber;
        WebkitBoxOrient?: import("csstype").BoxOrientProperty;
        WebkitBoxPack?: import("csstype").BoxPackProperty;
        WebkitScrollSnapPointsX?: string;
        WebkitScrollSnapPointsY?: string;
        alignmentBaseline?: import("csstype").AlignmentBaselineProperty;
        baselineShift?: import("csstype").BaselineShiftProperty<string | number>;
        clipRule?: import("csstype").ClipRuleProperty;
        colorInterpolation?: import("csstype").ColorInterpolationProperty;
        colorRendering?: import("csstype").ColorRenderingProperty;
        dominantBaseline?: import("csstype").DominantBaselineProperty;
        fill?: string;
        fillOpacity?: import("csstype").GlobalsNumber;
        fillRule?: import("csstype").FillRuleProperty;
        floodColor?: string;
        floodOpacity?: import("csstype").GlobalsNumber;
        glyphOrientationVertical?: import("csstype").GlyphOrientationVerticalProperty;
        lightingColor?: string;
        marker?: string;
        markerEnd?: string;
        markerMid?: string;
        markerStart?: string;
        shapeRendering?: import("csstype").ShapeRenderingProperty;
        stopColor?: string;
        stopOpacity?: import("csstype").GlobalsNumber;
        stroke?: string;
        strokeDasharray?: import("csstype").StrokeDasharrayProperty<string | number>;
        strokeDashoffset?: import("csstype").StrokeDashoffsetProperty<string | number>;
        strokeLinecap?: import("csstype").StrokeLinecapProperty;
        strokeLinejoin?: import("csstype").StrokeLinejoinProperty;
        strokeMiterlimit?: import("csstype").GlobalsNumber;
        strokeOpacity?: import("csstype").GlobalsNumber;
        strokeWidth?: import("csstype").StrokeWidthProperty<string | number>;
        textAnchor?: import("csstype").TextAnchorProperty;
        vectorEffect?: import("csstype").VectorEffectProperty;
    }>;
    triggerRef: Ref<ElementType>;
    visibility: import("vue").WritableComputedRef<boolean>;
};
export * from './defaults';
