import { SelectProps } from './defaults';
import type { ExtractPropTypes, CSSProperties } from 'vue';
import type { Option } from './select.types';
declare const useSelect: (props: ExtractPropTypes<typeof SelectProps>, emit: any) => {
    collapseTagSize: import("vue").ComputedRef<any>;
    currentPlaceholder: import("vue").ComputedRef<string>;
    expanded: import("vue").Ref<boolean>;
    emptyText: import("vue").ComputedRef<string | false>;
    popupHeight: import("vue").ComputedRef<number>;
    debounce: import("vue").ComputedRef<0 | 300>;
    filteredOptions: import("vue").ComputedRef<any[]>;
    iconClass: import("vue").ComputedRef<"" | "arrow-up is-reverse" | "arrow-up">;
    inputWrapperStyle: import("vue").ComputedRef<CSSProperties>;
    popperSize: import("vue").Ref<number>;
    shouldShowPlaceholder: import("vue").ComputedRef<boolean>;
    selectDisabled: import("vue").ComputedRef<any>;
    selectSize: import("vue").ComputedRef<any>;
    showClearBtn: import("vue").ComputedRef<boolean>;
    states: {
        inputValue: string;
        displayInputValue: string;
        calculatedWidth: number;
        cachedPlaceholder: string;
        cachedOptions: {
            [x: string]: any;
            label: string;
            created?: boolean;
            value: any;
        }[];
        createdOptions: {
            [x: string]: any;
            label: string;
            created?: boolean;
            value: any;
        }[];
        createdLabel: string;
        createdSelected: boolean;
        currentPlaceholder: string;
        hoveringIndex: number;
        comboBoxHovering: boolean;
        isOnComposition: boolean;
        isSilentBlur: boolean;
        isComposing: boolean;
        inputLength: number;
        inputWidth: number;
        initialInputHeight: number;
        previousQuery: any;
        query: string;
        selectedLabel: string;
        softFocus: boolean;
        tagInMultiLine: boolean;
    };
    calculatorRef: import("vue").Ref<HTMLElement>;
    controlRef: any;
    inputRef: any;
    menuRef: any;
    popper: any;
    selectRef: any;
    selectionRef: any;
    popperRef: import("vue").ComputedRef<any>;
    debouncedOnInputChange: import("lodash").DebouncedFunc<() => void>;
    debouncedQueryChange: import("lodash").DebouncedFunc<(e: any) => void>;
    deleteTag: (event: MouseEvent, tag: Option) => void;
    getLabel: (item: unknown) => any;
    getValueKey: (item: unknown) => unknown;
    handleBlur: () => void;
    handleClear: () => void;
    handleClickOutside: () => void;
    handleDel: (e: KeyboardEvent) => void;
    handleEsc: () => void;
    handleFocus: (event: FocusEvent) => void;
    handleInputBoxClick: () => void;
    handleMenuEnter: () => void;
    toggleMenu: () => void;
    scrollTo: (index: number) => void;
    onCompositionUpdate: (e: CompositionEvent) => void;
    onInput: () => void;
    onKeyboardNavigate: (direction: 'forward' | 'backward') => void;
    onKeyboardSelect: () => void;
    onSelect: (option: Option, idx: number, byClick?: boolean) => void;
    onUpdateInputValue: (val: string) => void;
};
export default useSelect;
