import { setLocale } from './locale';
import { setConfig } from './utils/config';
import isServer from './utils/isServer';
import affix from './el-affix';
export { default as ElAffix } from './el-affix';
import alert from './el-alert';
export { default as ElAlert } from './el-alert';
import aside from './el-aside';
export { default as ElAside } from './el-aside';
import autocomplete from './el-autocomplete';
export { default as ElAutocomplete } from './el-autocomplete';
import avatar from './el-avatar';
export { default as ElAvatar } from './el-avatar';
import backtop from './el-backtop';
export { default as ElBacktop } from './el-backtop';
import badge from './el-badge';
export { default as ElBadge } from './el-badge';
import breadcrumb from './el-breadcrumb';
export { default as ElBreadcrumb } from './el-breadcrumb';
import breadcrumbItem from './el-breadcrumb-item';
export { default as ElBreadcrumbItem } from './el-breadcrumb-item';
import button from './el-button';
export { default as ElButton } from './el-button';
import buttonGroup from './el-button-group';
export { default as ElButtonGroup } from './el-button-group';
import calendar from './el-calendar';
export { default as ElCalendar } from './el-calendar';
import card from './el-card';
export { default as ElCard } from './el-card';
import carousel from './el-carousel';
export { default as ElCarousel } from './el-carousel';
import carouselItem from './el-carousel-item';
export { default as ElCarouselItem } from './el-carousel-item';
import cascader from './el-cascader';
export { default as ElCascader } from './el-cascader';
import cascaderPanel from './el-cascader-panel';
export { default as ElCascaderPanel } from './el-cascader-panel';
import checkbox from './el-checkbox';
export { default as ElCheckbox } from './el-checkbox';
import checkboxButton from './el-checkbox-button';
export { default as ElCheckboxButton } from './el-checkbox-button';
import checkboxGroup from './el-checkbox-group';
export { default as ElCheckboxGroup } from './el-checkbox-group';
import col from './el-col';
export { default as ElCol } from './el-col';
import collapse from './el-collapse';
export { default as ElCollapse } from './el-collapse';
import collapseItem from './el-collapse-item';
export { default as ElCollapseItem } from './el-collapse-item';
import collapseTransition from './el-collapse-transition';
export { default as ElCollapseTransition } from './el-collapse-transition';
import colorPicker from './el-color-picker';
export { default as ElColorPicker } from './el-color-picker';
import container from './el-container';
export { default as ElContainer } from './el-container';
import configProvider from './el-config-provider';
export { default as ElConfigProvider } from './el-config-provider';
import datePicker from './el-date-picker';
export { default as ElDatePicker } from './el-date-picker';
import dialog from './el-dialog';
export { default as ElDialog } from './el-dialog';
import divider from './el-divider';
export { default as ElDivider } from './el-divider';
import drawer from './el-drawer';
export { default as ElDrawer } from './el-drawer';
import dropdown from './el-dropdown';
export { default as ElDropdown } from './el-dropdown';
import dropdownItem from './el-dropdown-item';
export { default as ElDropdownItem } from './el-dropdown-item';
import dropdownMenu from './el-dropdown-menu';
export { default as ElDropdownMenu } from './el-dropdown-menu';
import empty from './el-empty';
export { default as ElEmpty } from './el-empty';
import footer from './el-footer';
export { default as ElFooter } from './el-footer';
import form from './el-form';
export { default as ElForm } from './el-form';
import formItem from './el-form-item';
export { default as ElFormItem } from './el-form-item';
import header from './el-header';
export { default as ElHeader } from './el-header';
import icon from './el-icon';
export { default as ElIcon } from './el-icon';
import image from './el-image';
export { default as ElImage } from './el-image';
import imageViewer from './el-image-viewer';
export { default as ElImageViewer } from './el-image-viewer';
import input from './el-input';
export { default as ElInput } from './el-input';
import inputNumber from './el-input-number';
export { default as ElInputNumber } from './el-input-number';
import link from './el-link';
export { default as ElLink } from './el-link';
import main from './el-main';
export { default as ElMain } from './el-main';
import menu from './el-menu';
export { default as ElMenu } from './el-menu';
import menuItem from './el-menu-item';
export { default as ElMenuItem } from './el-menu-item';
import menuItemGroup from './el-menu-item-group';
export { default as ElMenuItemGroup } from './el-menu-item-group';
import option from './el-option';
export { default as ElOption } from './el-option';
import optionGroup from './el-option-group';
export { default as ElOptionGroup } from './el-option-group';
import pageHeader from './el-page-header';
export { default as ElPageHeader } from './el-page-header';
import pagination from './el-pagination';
export { default as ElPagination } from './el-pagination';
import popconfirm from './el-popconfirm';
export { default as ElPopconfirm } from './el-popconfirm';
import popper from './el-popper';
export { default as ElPopper } from './el-popper';
import progress from './el-progress';
export { default as ElProgress } from './el-progress';
import radio from './el-radio';
export { default as ElRadio } from './el-radio';
import radioButton from './el-radio-button';
export { default as ElRadioButton } from './el-radio-button';
import radioGroup from './el-radio-group';
export { default as ElRadioGroup } from './el-radio-group';
import rate from './el-rate';
export { default as ElRate } from './el-rate';
import row from './el-row';
export { default as ElRow } from './el-row';
import scrollbar from './el-scrollbar';
export { default as ElScrollbar } from './el-scrollbar';
import select from './el-select';
export { default as ElSelect } from './el-select';
import slider from './el-slider';
export { default as ElSlider } from './el-slider';
import step from './el-step';
export { default as ElStep } from './el-step';
import steps from './el-steps';
export { default as ElSteps } from './el-steps';
import submenu from './el-submenu';
export { default as ElSubmenu } from './el-submenu';
import _switch from './el-switch';
export { default as ElSwitch } from './el-switch';
import tabPane from './el-tab-pane';
export { default as ElTabPane } from './el-tab-pane';
import table from './el-table';
export { default as ElTable } from './el-table';
import tableColumn from './el-table-column';
export { default as ElTableColumn } from './el-table-column';
import tabs from './el-tabs';
export { default as ElTabs } from './el-tabs';
import tag from './el-tag';
export { default as ElTag } from './el-tag';
import timePicker from './el-time-picker';
export { default as ElTimePicker } from './el-time-picker';
import timeSelect from './el-time-select';
export { default as ElTimeSelect } from './el-time-select';
import timeline from './el-timeline';
export { default as ElTimeline } from './el-timeline';
import timelineItem from './el-timeline-item';
export { default as ElTimelineItem } from './el-timeline-item';
import tooltip from './el-tooltip';
export { default as ElTooltip } from './el-tooltip';
import transfer from './el-transfer';
export { default as ElTransfer } from './el-transfer';
import tree from './el-tree';
export { default as ElTree } from './el-tree';
import upload from './el-upload';
export { default as ElUpload } from './el-upload';
import space from './el-space';
export { default as ElSpace } from './el-space';
import skeleton from './el-skeleton';
export { default as ElSkeleton } from './el-skeleton';
import skeletonItem from './el-skeleton-item';
export { default as ElSkeletonItem } from './el-skeleton-item';
import checkTag from './el-check-tag';
export { default as ElCheckTag } from './el-check-tag';
import descriptions from './el-descriptions';
export { default as ElDescriptions } from './el-descriptions';
import descriptionsItem from './el-descriptions-item';
export { default as ElDescriptionsItem } from './el-descriptions-item';
import result from './el-result';
export { default as ElResult } from './el-result';
import selectV2 from './el-select-v2';
export { default as ElSelectV2 } from './el-select-v2';
import infiniteScroll from './el-infinite-scroll';
export { default as ElInfiniteScroll } from './el-infinite-scroll';
import loading from './el-loading';
export { default as ElLoading } from './el-loading';
import message from './el-message';
export { default as ElMessage } from './el-message';
import messageBox from './el-message-box';
export { default as ElMessageBox } from './el-message-box';
import notification from './el-notification';
export { default as ElNotification } from './el-notification';
import popover from './el-popover';
export { default as ElPopover } from './el-popover';
import dayjs from 'dayjs';
export * from './hooks';

var components = /*#__PURE__*/Object.freeze({
  __proto__: null,
  ElAffix: affix,
  ElAlert: alert,
  ElAside: aside,
  ElAutocomplete: autocomplete,
  ElAvatar: avatar,
  ElBacktop: backtop,
  ElBadge: badge,
  ElBreadcrumb: breadcrumb,
  ElBreadcrumbItem: breadcrumbItem,
  ElButton: button,
  ElButtonGroup: buttonGroup,
  ElCalendar: calendar,
  ElCard: card,
  ElCarousel: carousel,
  ElCarouselItem: carouselItem,
  ElCascader: cascader,
  ElCascaderPanel: cascaderPanel,
  ElCheckbox: checkbox,
  ElCheckboxButton: checkboxButton,
  ElCheckboxGroup: checkboxGroup,
  ElCol: col,
  ElCollapse: collapse,
  ElCollapseItem: collapseItem,
  ElCollapseTransition: collapseTransition,
  ElColorPicker: colorPicker,
  ElContainer: container,
  ElConfigProvider: configProvider,
  ElDatePicker: datePicker,
  ElDialog: dialog,
  ElDivider: divider,
  ElDrawer: drawer,
  ElDropdown: dropdown,
  ElDropdownItem: dropdownItem,
  ElDropdownMenu: dropdownMenu,
  ElEmpty: empty,
  ElFooter: footer,
  ElForm: form,
  ElFormItem: formItem,
  ElHeader: header,
  ElIcon: icon,
  ElImage: image,
  ElImageViewer: imageViewer,
  ElInput: input,
  ElInputNumber: inputNumber,
  ElLink: link,
  ElMain: main,
  ElMenu: menu,
  ElMenuItem: menuItem,
  ElMenuItemGroup: menuItemGroup,
  ElOption: option,
  ElOptionGroup: optionGroup,
  ElPageHeader: pageHeader,
  ElPagination: pagination,
  ElPopconfirm: popconfirm,
  ElPopper: popper,
  ElProgress: progress,
  ElRadio: radio,
  ElRadioButton: radioButton,
  ElRadioGroup: radioGroup,
  ElRate: rate,
  ElRow: row,
  ElScrollbar: scrollbar,
  ElSelect: select,
  ElSlider: slider,
  ElStep: step,
  ElSteps: steps,
  ElSubmenu: submenu,
  ElSwitch: _switch,
  ElTabPane: tabPane,
  ElTable: table,
  ElTableColumn: tableColumn,
  ElTabs: tabs,
  ElTag: tag,
  ElTimePicker: timePicker,
  ElTimeSelect: timeSelect,
  ElTimeline: timeline,
  ElTimelineItem: timelineItem,
  ElTooltip: tooltip,
  ElTransfer: transfer,
  ElTree: tree,
  ElUpload: upload,
  ElSpace: space,
  ElSkeleton: skeleton,
  ElSkeletonItem: skeletonItem,
  ElCheckTag: checkTag,
  ElDescriptions: descriptions,
  ElDescriptionsItem: descriptionsItem,
  ElResult: result,
  ElSelectV2: selectV2
});

var plugins = /*#__PURE__*/Object.freeze({
  __proto__: null,
  ElInfiniteScroll: infiniteScroll,
  ElLoading: loading,
  ElMessage: message,
  ElMessageBox: messageBox,
  ElNotification: notification,
  ElPopover: popover
});

const version = '1.0.2-beta.71';

if (!isServer) {
    const _window = window;
    if (!_window.dayjs) {
        _window.dayjs = dayjs;
    }
}
const version$1 = version;
const defaultInstallOpt = {
    size: '',
    zIndex: 2000,
};
const install = (app, opt) => {
    const option = Object.assign(defaultInstallOpt, opt);
    app.config.globalProperties.$ELEMENT = option;
    setConfig(option);
    Object.keys(components).forEach(c => {
        app.use(components[c]);
    });
    Object.keys(plugins).forEach(plugin => {
        app.use(plugins[plugin]);
    });
};
const locale = setLocale;
var index = {
    version: version$1,
    install,
    locale,
};

export default index;
export { install, locale, version$1 as version };
