import { PropType } from 'vue';
import { Store } from '../store';
import { Sort, SummaryMethod } from '../table/defaults';
export interface TableFooter<T> {
    fixed: string;
    store: Store<T>;
    summaryMethod: SummaryMethod<T>;
    sumText: string;
    border: boolean;
    defaultSort: Sort;
}
declare const _default: import("vue").DefineComponent<{
    fixed: {
        type: StringConstructor;
        default: string;
    };
    store: {
        required: true;
        type: PropType<{
            mutations: {
                setData(states: {
                    _currentRowKey: import("vue").Ref<string>;
                    currentRow: import("vue").Ref<any>;
                    expandRowKeys: import("vue").Ref<string[]>;
                    treeData: import("vue").Ref<unknown>;
                    indent: import("vue").Ref<number>;
                    lazy: import("vue").Ref<boolean>;
                    lazyTreeNodeMap: import("vue").Ref<{}>;
                    lazyColumnIdentifier: import("vue").Ref<string>;
                    childrenColumnName: import("vue").Ref<string>;
                    expandRows: import("vue").Ref<any[]>;
                    defaultExpandAll: import("vue").Ref<boolean>;
                    rowKey: import("vue").Ref<string>;
                    data: import("vue").Ref<any[]>;
                    _data: import("vue").Ref<any[]>;
                    isComplex: import("vue").Ref<boolean>;
                    _columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    originColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumnsLength: import("vue").Ref<number>;
                    fixedLeafColumnsLength: import("vue").Ref<number>;
                    rightFixedLeafColumnsLength: import("vue").Ref<number>;
                    isAllSelected: import("vue").Ref<boolean>;
                    selection: import("vue").Ref<any[]>;
                    reserveSelection: import("vue").Ref<boolean>;
                    selectOnIndeterminate: import("vue").Ref<boolean>;
                    selectable: import("vue").Ref<(row: any, index: number) => boolean>;
                    filters: import("vue").Ref<import("../store").StoreFilter>;
                    filteredData: any;
                    sortingColumn: any;
                    sortProp: any;
                    sortOrder: any;
                    hoverRow: any;
                }, data: any[]): void;
                insertColumn(states: {
                    _currentRowKey: import("vue").Ref<string>;
                    currentRow: import("vue").Ref<any>;
                    expandRowKeys: import("vue").Ref<string[]>;
                    treeData: import("vue").Ref<unknown>;
                    indent: import("vue").Ref<number>;
                    lazy: import("vue").Ref<boolean>;
                    lazyTreeNodeMap: import("vue").Ref<{}>;
                    lazyColumnIdentifier: import("vue").Ref<string>;
                    childrenColumnName: import("vue").Ref<string>;
                    expandRows: import("vue").Ref<any[]>;
                    defaultExpandAll: import("vue").Ref<boolean>;
                    rowKey: import("vue").Ref<string>;
                    data: import("vue").Ref<any[]>;
                    _data: import("vue").Ref<any[]>;
                    isComplex: import("vue").Ref<boolean>;
                    _columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    originColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumnsLength: import("vue").Ref<number>;
                    fixedLeafColumnsLength: import("vue").Ref<number>;
                    rightFixedLeafColumnsLength: import("vue").Ref<number>;
                    isAllSelected: import("vue").Ref<boolean>;
                    selection: import("vue").Ref<any[]>;
                    reserveSelection: import("vue").Ref<boolean>;
                    selectOnIndeterminate: import("vue").Ref<boolean>;
                    selectable: import("vue").Ref<(row: any, index: number) => boolean>;
                    filters: import("vue").Ref<import("../store").StoreFilter>;
                    filteredData: any;
                    sortingColumn: any;
                    sortProp: any;
                    sortOrder: any;
                    hoverRow: any;
                }, column: import("../table-column/defaults").TableColumnCtx<any>, parent: import("../table-column/defaults").TableColumnCtx<any>): void;
                removeColumn(states: {
                    _currentRowKey: import("vue").Ref<string>;
                    currentRow: import("vue").Ref<any>;
                    expandRowKeys: import("vue").Ref<string[]>;
                    treeData: import("vue").Ref<unknown>;
                    indent: import("vue").Ref<number>;
                    lazy: import("vue").Ref<boolean>;
                    lazyTreeNodeMap: import("vue").Ref<{}>;
                    lazyColumnIdentifier: import("vue").Ref<string>;
                    childrenColumnName: import("vue").Ref<string>;
                    expandRows: import("vue").Ref<any[]>;
                    defaultExpandAll: import("vue").Ref<boolean>;
                    rowKey: import("vue").Ref<string>;
                    data: import("vue").Ref<any[]>;
                    _data: import("vue").Ref<any[]>;
                    isComplex: import("vue").Ref<boolean>;
                    _columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    originColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumnsLength: import("vue").Ref<number>;
                    fixedLeafColumnsLength: import("vue").Ref<number>;
                    rightFixedLeafColumnsLength: import("vue").Ref<number>;
                    isAllSelected: import("vue").Ref<boolean>;
                    selection: import("vue").Ref<any[]>;
                    reserveSelection: import("vue").Ref<boolean>;
                    selectOnIndeterminate: import("vue").Ref<boolean>;
                    selectable: import("vue").Ref<(row: any, index: number) => boolean>;
                    filters: import("vue").Ref<import("../store").StoreFilter>;
                    filteredData: any;
                    sortingColumn: any;
                    sortProp: any;
                    sortOrder: any;
                    hoverRow: any;
                }, column: import("../table-column/defaults").TableColumnCtx<any>, parent: import("../table-column/defaults").TableColumnCtx<any>): void;
                sort(states: {
                    _currentRowKey: import("vue").Ref<string>;
                    currentRow: import("vue").Ref<any>;
                    expandRowKeys: import("vue").Ref<string[]>;
                    treeData: import("vue").Ref<unknown>;
                    indent: import("vue").Ref<number>;
                    lazy: import("vue").Ref<boolean>;
                    lazyTreeNodeMap: import("vue").Ref<{}>;
                    lazyColumnIdentifier: import("vue").Ref<string>;
                    childrenColumnName: import("vue").Ref<string>;
                    expandRows: import("vue").Ref<any[]>;
                    defaultExpandAll: import("vue").Ref<boolean>;
                    rowKey: import("vue").Ref<string>;
                    data: import("vue").Ref<any[]>;
                    _data: import("vue").Ref<any[]>;
                    isComplex: import("vue").Ref<boolean>;
                    _columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    originColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumnsLength: import("vue").Ref<number>;
                    fixedLeafColumnsLength: import("vue").Ref<number>;
                    rightFixedLeafColumnsLength: import("vue").Ref<number>;
                    isAllSelected: import("vue").Ref<boolean>;
                    selection: import("vue").Ref<any[]>;
                    reserveSelection: import("vue").Ref<boolean>;
                    selectOnIndeterminate: import("vue").Ref<boolean>;
                    selectable: import("vue").Ref<(row: any, index: number) => boolean>;
                    filters: import("vue").Ref<import("../store").StoreFilter>;
                    filteredData: any;
                    sortingColumn: any;
                    sortProp: any;
                    sortOrder: any;
                    hoverRow: any;
                }, options: Sort): void;
                changeSortCondition(states: {
                    _currentRowKey: import("vue").Ref<string>;
                    currentRow: import("vue").Ref<any>;
                    expandRowKeys: import("vue").Ref<string[]>;
                    treeData: import("vue").Ref<unknown>;
                    indent: import("vue").Ref<number>;
                    lazy: import("vue").Ref<boolean>;
                    lazyTreeNodeMap: import("vue").Ref<{}>;
                    lazyColumnIdentifier: import("vue").Ref<string>;
                    childrenColumnName: import("vue").Ref<string>;
                    expandRows: import("vue").Ref<any[]>;
                    defaultExpandAll: import("vue").Ref<boolean>;
                    rowKey: import("vue").Ref<string>;
                    data: import("vue").Ref<any[]>;
                    _data: import("vue").Ref<any[]>;
                    isComplex: import("vue").Ref<boolean>;
                    _columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    originColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumnsLength: import("vue").Ref<number>;
                    fixedLeafColumnsLength: import("vue").Ref<number>;
                    rightFixedLeafColumnsLength: import("vue").Ref<number>;
                    isAllSelected: import("vue").Ref<boolean>;
                    selection: import("vue").Ref<any[]>;
                    reserveSelection: import("vue").Ref<boolean>;
                    selectOnIndeterminate: import("vue").Ref<boolean>;
                    selectable: import("vue").Ref<(row: any, index: number) => boolean>;
                    filters: import("vue").Ref<import("../store").StoreFilter>;
                    filteredData: any;
                    sortingColumn: any;
                    sortProp: any;
                    sortOrder: any;
                    hoverRow: any;
                }, options: Sort): void;
                filterChange(_states: {
                    _currentRowKey: import("vue").Ref<string>;
                    currentRow: import("vue").Ref<any>;
                    expandRowKeys: import("vue").Ref<string[]>;
                    treeData: import("vue").Ref<unknown>;
                    indent: import("vue").Ref<number>;
                    lazy: import("vue").Ref<boolean>;
                    lazyTreeNodeMap: import("vue").Ref<{}>;
                    lazyColumnIdentifier: import("vue").Ref<string>;
                    childrenColumnName: import("vue").Ref<string>;
                    expandRows: import("vue").Ref<any[]>;
                    defaultExpandAll: import("vue").Ref<boolean>;
                    rowKey: import("vue").Ref<string>;
                    data: import("vue").Ref<any[]>;
                    _data: import("vue").Ref<any[]>;
                    isComplex: import("vue").Ref<boolean>;
                    _columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    originColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumnsLength: import("vue").Ref<number>;
                    fixedLeafColumnsLength: import("vue").Ref<number>;
                    rightFixedLeafColumnsLength: import("vue").Ref<number>;
                    isAllSelected: import("vue").Ref<boolean>;
                    selection: import("vue").Ref<any[]>;
                    reserveSelection: import("vue").Ref<boolean>;
                    selectOnIndeterminate: import("vue").Ref<boolean>;
                    selectable: import("vue").Ref<(row: any, index: number) => boolean>;
                    filters: import("vue").Ref<import("../store").StoreFilter>;
                    filteredData: any;
                    sortingColumn: any;
                    sortProp: any;
                    sortOrder: any;
                    hoverRow: any;
                }, options: import("../table/defaults").Filter<any>): void;
                toggleAllSelection(): void;
                rowSelectedChanged(_states: any, row: any): void;
                setHoverRow(states: {
                    _currentRowKey: import("vue").Ref<string>;
                    currentRow: import("vue").Ref<any>;
                    expandRowKeys: import("vue").Ref<string[]>;
                    treeData: import("vue").Ref<unknown>;
                    indent: import("vue").Ref<number>;
                    lazy: import("vue").Ref<boolean>;
                    lazyTreeNodeMap: import("vue").Ref<{}>;
                    lazyColumnIdentifier: import("vue").Ref<string>;
                    childrenColumnName: import("vue").Ref<string>;
                    expandRows: import("vue").Ref<any[]>;
                    defaultExpandAll: import("vue").Ref<boolean>;
                    rowKey: import("vue").Ref<string>;
                    data: import("vue").Ref<any[]>;
                    _data: import("vue").Ref<any[]>;
                    isComplex: import("vue").Ref<boolean>;
                    _columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    originColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    fixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    rightFixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                    leafColumnsLength: import("vue").Ref<number>;
                    fixedLeafColumnsLength: import("vue").Ref<number>;
                    rightFixedLeafColumnsLength: import("vue").Ref<number>;
                    isAllSelected: import("vue").Ref<boolean>;
                    selection: import("vue").Ref<any[]>;
                    reserveSelection: import("vue").Ref<boolean>;
                    selectOnIndeterminate: import("vue").Ref<boolean>;
                    selectable: import("vue").Ref<(row: any, index: number) => boolean>;
                    filters: import("vue").Ref<import("../store").StoreFilter>;
                    filteredData: any;
                    sortingColumn: any;
                    sortProp: any;
                    sortOrder: any;
                    hoverRow: any;
                }, row: any): void;
                setCurrentRow(_states: any, row: any): void;
            };
            commit: (name: "sort" | "insertColumn" | "removeColumn" | "setData" | "changeSortCondition" | "filterChange" | "toggleAllSelection" | "rowSelectedChanged" | "setHoverRow" | "setCurrentRow", ...args: any[]) => void;
            updateTableScrollY: () => void;
            assertRowKey: () => void;
            updateColumns: () => void;
            scheduleLayout: (needUpdateColumns?: boolean, immediate?: boolean) => void;
            isSelected: (row: any) => boolean;
            clearSelection: () => void;
            cleanSelection: () => void;
            toggleRowSelection: (row: any, selected?: any, emitChange?: boolean) => void;
            _toggleAllSelection: () => void;
            toggleAllSelection: any;
            updateSelectionByRowKey: () => void;
            updateAllSelected: () => void;
            updateFilters: (columns: any, values: any) => {};
            updateCurrentRow: (_currentRow: any) => void;
            updateSort: (column: any, prop: any, order: any) => void;
            execFilter: () => void;
            execSort: () => void;
            execQuery: (ignore?: any) => void;
            clearFilter: (columnKeys: any) => void;
            clearSort: () => void;
            toggleRowExpansion: (row: any, expanded?: boolean) => void;
            setExpandRowKeysAdapter: (val: string[]) => void;
            setCurrentRowKey: (key: string) => void;
            toggleRowExpansionAdapter: (row: any, expanded: boolean) => void;
            isRowExpanded: (row: any) => boolean;
            updateExpandRows: () => void;
            updateCurrentRowData: () => void;
            loadOrToggle: (row: any) => void;
            states: {
                _currentRowKey: import("vue").Ref<string>;
                currentRow: import("vue").Ref<any>;
                expandRowKeys: import("vue").Ref<string[]>;
                treeData: import("vue").Ref<unknown>;
                indent: import("vue").Ref<number>;
                lazy: import("vue").Ref<boolean>;
                lazyTreeNodeMap: import("vue").Ref<{}>;
                lazyColumnIdentifier: import("vue").Ref<string>;
                childrenColumnName: import("vue").Ref<string>;
                expandRows: import("vue").Ref<any[]>;
                defaultExpandAll: import("vue").Ref<boolean>;
                rowKey: import("vue").Ref<string>;
                data: import("vue").Ref<any[]>;
                _data: import("vue").Ref<any[]>;
                isComplex: import("vue").Ref<boolean>;
                _columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                originColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumnsLength: import("vue").Ref<number>;
                fixedLeafColumnsLength: import("vue").Ref<number>;
                rightFixedLeafColumnsLength: import("vue").Ref<number>;
                isAllSelected: import("vue").Ref<boolean>;
                selection: import("vue").Ref<any[]>;
                reserveSelection: import("vue").Ref<boolean>;
                selectOnIndeterminate: import("vue").Ref<boolean>;
                selectable: import("vue").Ref<(row: any, index: number) => boolean>;
                filters: import("vue").Ref<import("../store").StoreFilter>;
                filteredData: any;
                sortingColumn: any;
                sortProp: any;
                sortOrder: any;
                hoverRow: any;
            };
        }>;
    };
    summaryMethod: PropType<SummaryMethod<any>>;
    sumText: StringConstructor;
    border: BooleanConstructor;
    defaultSort: {
        type: PropType<Sort>;
        default: () => {
            prop: string;
            order: string;
        };
    };
}, {
    getRowClasses: (column: import("../table-column/defaults").TableColumnCtx<any>, cellIndex: number) => string[];
    hasGutter: import("vue").ComputedRef<number>;
    columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
}, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, Record<string, any>, string, import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<{
    fixed: string;
    store: {
        mutations: {
            setData(states: {
                _currentRowKey: import("vue").Ref<string>;
                currentRow: import("vue").Ref<any>;
                expandRowKeys: import("vue").Ref<string[]>;
                treeData: import("vue").Ref<unknown>;
                indent: import("vue").Ref<number>;
                lazy: import("vue").Ref<boolean>;
                lazyTreeNodeMap: import("vue").Ref<{}>;
                lazyColumnIdentifier: import("vue").Ref<string>;
                childrenColumnName: import("vue").Ref<string>;
                expandRows: import("vue").Ref<any[]>;
                defaultExpandAll: import("vue").Ref<boolean>;
                rowKey: import("vue").Ref<string>;
                data: import("vue").Ref<any[]>;
                _data: import("vue").Ref<any[]>;
                isComplex: import("vue").Ref<boolean>;
                _columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                originColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumnsLength: import("vue").Ref<number>;
                fixedLeafColumnsLength: import("vue").Ref<number>;
                rightFixedLeafColumnsLength: import("vue").Ref<number>;
                isAllSelected: import("vue").Ref<boolean>;
                selection: import("vue").Ref<any[]>;
                reserveSelection: import("vue").Ref<boolean>;
                selectOnIndeterminate: import("vue").Ref<boolean>;
                selectable: import("vue").Ref<(row: any, index: number) => boolean>;
                filters: import("vue").Ref<import("../store").StoreFilter>;
                filteredData: any;
                sortingColumn: any;
                sortProp: any;
                sortOrder: any;
                hoverRow: any;
            }, data: any[]): void;
            insertColumn(states: {
                _currentRowKey: import("vue").Ref<string>;
                currentRow: import("vue").Ref<any>;
                expandRowKeys: import("vue").Ref<string[]>;
                treeData: import("vue").Ref<unknown>;
                indent: import("vue").Ref<number>;
                lazy: import("vue").Ref<boolean>;
                lazyTreeNodeMap: import("vue").Ref<{}>;
                lazyColumnIdentifier: import("vue").Ref<string>;
                childrenColumnName: import("vue").Ref<string>;
                expandRows: import("vue").Ref<any[]>;
                defaultExpandAll: import("vue").Ref<boolean>;
                rowKey: import("vue").Ref<string>;
                data: import("vue").Ref<any[]>;
                _data: import("vue").Ref<any[]>;
                isComplex: import("vue").Ref<boolean>;
                _columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                originColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumnsLength: import("vue").Ref<number>;
                fixedLeafColumnsLength: import("vue").Ref<number>;
                rightFixedLeafColumnsLength: import("vue").Ref<number>;
                isAllSelected: import("vue").Ref<boolean>;
                selection: import("vue").Ref<any[]>;
                reserveSelection: import("vue").Ref<boolean>;
                selectOnIndeterminate: import("vue").Ref<boolean>;
                selectable: import("vue").Ref<(row: any, index: number) => boolean>;
                filters: import("vue").Ref<import("../store").StoreFilter>;
                filteredData: any;
                sortingColumn: any;
                sortProp: any;
                sortOrder: any;
                hoverRow: any;
            }, column: import("../table-column/defaults").TableColumnCtx<any>, parent: import("../table-column/defaults").TableColumnCtx<any>): void;
            removeColumn(states: {
                _currentRowKey: import("vue").Ref<string>;
                currentRow: import("vue").Ref<any>;
                expandRowKeys: import("vue").Ref<string[]>;
                treeData: import("vue").Ref<unknown>;
                indent: import("vue").Ref<number>;
                lazy: import("vue").Ref<boolean>;
                lazyTreeNodeMap: import("vue").Ref<{}>;
                lazyColumnIdentifier: import("vue").Ref<string>;
                childrenColumnName: import("vue").Ref<string>;
                expandRows: import("vue").Ref<any[]>;
                defaultExpandAll: import("vue").Ref<boolean>;
                rowKey: import("vue").Ref<string>;
                data: import("vue").Ref<any[]>;
                _data: import("vue").Ref<any[]>;
                isComplex: import("vue").Ref<boolean>;
                _columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                originColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumnsLength: import("vue").Ref<number>;
                fixedLeafColumnsLength: import("vue").Ref<number>;
                rightFixedLeafColumnsLength: import("vue").Ref<number>;
                isAllSelected: import("vue").Ref<boolean>;
                selection: import("vue").Ref<any[]>;
                reserveSelection: import("vue").Ref<boolean>;
                selectOnIndeterminate: import("vue").Ref<boolean>;
                selectable: import("vue").Ref<(row: any, index: number) => boolean>;
                filters: import("vue").Ref<import("../store").StoreFilter>;
                filteredData: any;
                sortingColumn: any;
                sortProp: any;
                sortOrder: any;
                hoverRow: any;
            }, column: import("../table-column/defaults").TableColumnCtx<any>, parent: import("../table-column/defaults").TableColumnCtx<any>): void;
            sort(states: {
                _currentRowKey: import("vue").Ref<string>;
                currentRow: import("vue").Ref<any>;
                expandRowKeys: import("vue").Ref<string[]>;
                treeData: import("vue").Ref<unknown>;
                indent: import("vue").Ref<number>;
                lazy: import("vue").Ref<boolean>;
                lazyTreeNodeMap: import("vue").Ref<{}>;
                lazyColumnIdentifier: import("vue").Ref<string>;
                childrenColumnName: import("vue").Ref<string>;
                expandRows: import("vue").Ref<any[]>;
                defaultExpandAll: import("vue").Ref<boolean>;
                rowKey: import("vue").Ref<string>;
                data: import("vue").Ref<any[]>;
                _data: import("vue").Ref<any[]>;
                isComplex: import("vue").Ref<boolean>;
                _columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                originColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumnsLength: import("vue").Ref<number>;
                fixedLeafColumnsLength: import("vue").Ref<number>;
                rightFixedLeafColumnsLength: import("vue").Ref<number>;
                isAllSelected: import("vue").Ref<boolean>;
                selection: import("vue").Ref<any[]>;
                reserveSelection: import("vue").Ref<boolean>;
                selectOnIndeterminate: import("vue").Ref<boolean>;
                selectable: import("vue").Ref<(row: any, index: number) => boolean>;
                filters: import("vue").Ref<import("../store").StoreFilter>;
                filteredData: any;
                sortingColumn: any;
                sortProp: any;
                sortOrder: any;
                hoverRow: any;
            }, options: Sort): void;
            changeSortCondition(states: {
                _currentRowKey: import("vue").Ref<string>;
                currentRow: import("vue").Ref<any>;
                expandRowKeys: import("vue").Ref<string[]>;
                treeData: import("vue").Ref<unknown>;
                indent: import("vue").Ref<number>;
                lazy: import("vue").Ref<boolean>;
                lazyTreeNodeMap: import("vue").Ref<{}>;
                lazyColumnIdentifier: import("vue").Ref<string>;
                childrenColumnName: import("vue").Ref<string>;
                expandRows: import("vue").Ref<any[]>;
                defaultExpandAll: import("vue").Ref<boolean>;
                rowKey: import("vue").Ref<string>;
                data: import("vue").Ref<any[]>;
                _data: import("vue").Ref<any[]>;
                isComplex: import("vue").Ref<boolean>;
                _columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                originColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumnsLength: import("vue").Ref<number>;
                fixedLeafColumnsLength: import("vue").Ref<number>;
                rightFixedLeafColumnsLength: import("vue").Ref<number>;
                isAllSelected: import("vue").Ref<boolean>;
                selection: import("vue").Ref<any[]>;
                reserveSelection: import("vue").Ref<boolean>;
                selectOnIndeterminate: import("vue").Ref<boolean>;
                selectable: import("vue").Ref<(row: any, index: number) => boolean>;
                filters: import("vue").Ref<import("../store").StoreFilter>;
                filteredData: any;
                sortingColumn: any;
                sortProp: any;
                sortOrder: any;
                hoverRow: any;
            }, options: Sort): void;
            filterChange(_states: {
                _currentRowKey: import("vue").Ref<string>;
                currentRow: import("vue").Ref<any>;
                expandRowKeys: import("vue").Ref<string[]>;
                treeData: import("vue").Ref<unknown>;
                indent: import("vue").Ref<number>;
                lazy: import("vue").Ref<boolean>;
                lazyTreeNodeMap: import("vue").Ref<{}>;
                lazyColumnIdentifier: import("vue").Ref<string>;
                childrenColumnName: import("vue").Ref<string>;
                expandRows: import("vue").Ref<any[]>;
                defaultExpandAll: import("vue").Ref<boolean>;
                rowKey: import("vue").Ref<string>;
                data: import("vue").Ref<any[]>;
                _data: import("vue").Ref<any[]>;
                isComplex: import("vue").Ref<boolean>;
                _columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                originColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumnsLength: import("vue").Ref<number>;
                fixedLeafColumnsLength: import("vue").Ref<number>;
                rightFixedLeafColumnsLength: import("vue").Ref<number>;
                isAllSelected: import("vue").Ref<boolean>;
                selection: import("vue").Ref<any[]>;
                reserveSelection: import("vue").Ref<boolean>;
                selectOnIndeterminate: import("vue").Ref<boolean>;
                selectable: import("vue").Ref<(row: any, index: number) => boolean>;
                filters: import("vue").Ref<import("../store").StoreFilter>;
                filteredData: any;
                sortingColumn: any;
                sortProp: any;
                sortOrder: any;
                hoverRow: any;
            }, options: import("../table/defaults").Filter<any>): void;
            toggleAllSelection(): void;
            rowSelectedChanged(_states: any, row: any): void;
            setHoverRow(states: {
                _currentRowKey: import("vue").Ref<string>;
                currentRow: import("vue").Ref<any>;
                expandRowKeys: import("vue").Ref<string[]>;
                treeData: import("vue").Ref<unknown>;
                indent: import("vue").Ref<number>;
                lazy: import("vue").Ref<boolean>;
                lazyTreeNodeMap: import("vue").Ref<{}>;
                lazyColumnIdentifier: import("vue").Ref<string>;
                childrenColumnName: import("vue").Ref<string>;
                expandRows: import("vue").Ref<any[]>;
                defaultExpandAll: import("vue").Ref<boolean>;
                rowKey: import("vue").Ref<string>;
                data: import("vue").Ref<any[]>;
                _data: import("vue").Ref<any[]>;
                isComplex: import("vue").Ref<boolean>;
                _columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                originColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                fixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                rightFixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
                leafColumnsLength: import("vue").Ref<number>;
                fixedLeafColumnsLength: import("vue").Ref<number>;
                rightFixedLeafColumnsLength: import("vue").Ref<number>;
                isAllSelected: import("vue").Ref<boolean>;
                selection: import("vue").Ref<any[]>;
                reserveSelection: import("vue").Ref<boolean>;
                selectOnIndeterminate: import("vue").Ref<boolean>;
                selectable: import("vue").Ref<(row: any, index: number) => boolean>;
                filters: import("vue").Ref<import("../store").StoreFilter>;
                filteredData: any;
                sortingColumn: any;
                sortProp: any;
                sortOrder: any;
                hoverRow: any;
            }, row: any): void;
            setCurrentRow(_states: any, row: any): void;
        };
        commit: (name: "sort" | "insertColumn" | "removeColumn" | "setData" | "changeSortCondition" | "filterChange" | "toggleAllSelection" | "rowSelectedChanged" | "setHoverRow" | "setCurrentRow", ...args: any[]) => void;
        updateTableScrollY: () => void;
        assertRowKey: () => void;
        updateColumns: () => void;
        scheduleLayout: (needUpdateColumns?: boolean, immediate?: boolean) => void;
        isSelected: (row: any) => boolean;
        clearSelection: () => void;
        cleanSelection: () => void;
        toggleRowSelection: (row: any, selected?: any, emitChange?: boolean) => void;
        _toggleAllSelection: () => void;
        toggleAllSelection: any;
        updateSelectionByRowKey: () => void;
        updateAllSelected: () => void;
        updateFilters: (columns: any, values: any) => {};
        updateCurrentRow: (_currentRow: any) => void;
        updateSort: (column: any, prop: any, order: any) => void;
        execFilter: () => void;
        execSort: () => void;
        execQuery: (ignore?: any) => void;
        clearFilter: (columnKeys: any) => void;
        clearSort: () => void;
        toggleRowExpansion: (row: any, expanded?: boolean) => void;
        setExpandRowKeysAdapter: (val: string[]) => void;
        setCurrentRowKey: (key: string) => void;
        toggleRowExpansionAdapter: (row: any, expanded: boolean) => void;
        isRowExpanded: (row: any) => boolean;
        updateExpandRows: () => void;
        updateCurrentRowData: () => void;
        loadOrToggle: (row: any) => void;
        states: {
            _currentRowKey: import("vue").Ref<string>;
            currentRow: import("vue").Ref<any>;
            expandRowKeys: import("vue").Ref<string[]>;
            treeData: import("vue").Ref<unknown>;
            indent: import("vue").Ref<number>;
            lazy: import("vue").Ref<boolean>;
            lazyTreeNodeMap: import("vue").Ref<{}>;
            lazyColumnIdentifier: import("vue").Ref<string>;
            childrenColumnName: import("vue").Ref<string>;
            expandRows: import("vue").Ref<any[]>;
            defaultExpandAll: import("vue").Ref<boolean>;
            rowKey: import("vue").Ref<string>;
            data: import("vue").Ref<any[]>;
            _data: import("vue").Ref<any[]>;
            isComplex: import("vue").Ref<boolean>;
            _columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
            originColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
            columns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
            fixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
            rightFixedColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
            leafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
            fixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
            rightFixedLeafColumns: import("vue").Ref<import("../table-column/defaults").TableColumnCtx<any>[]>;
            leafColumnsLength: import("vue").Ref<number>;
            fixedLeafColumnsLength: import("vue").Ref<number>;
            rightFixedLeafColumnsLength: import("vue").Ref<number>;
            isAllSelected: import("vue").Ref<boolean>;
            selection: import("vue").Ref<any[]>;
            reserveSelection: import("vue").Ref<boolean>;
            selectOnIndeterminate: import("vue").Ref<boolean>;
            selectable: import("vue").Ref<(row: any, index: number) => boolean>;
            filters: import("vue").Ref<import("../store").StoreFilter>;
            filteredData: any;
            sortingColumn: any;
            sortProp: any;
            sortOrder: any;
            hoverRow: any;
        };
    };
    defaultSort: Sort;
    border: boolean;
} & {
    summaryMethod?: SummaryMethod<any>;
    sumText?: string;
}>, {
    fixed: string;
    defaultSort: Sort;
    border: boolean;
}>;
export default _default;
