# @turf/union

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## union

Takes two [(Multi)Polygon(s)][1] and returns a combined polygon. If the input polygons are not contiguous, this function returns a [MultiPolygon][2] feature.

**Parameters**

-   `polygon1` **[Feature][3]&lt;([Polygon][4] \| [MultiPolygon][5])>** input Polygon feature
-   `polygon2` **[Feature][3]&lt;([Polygon][4] \| [MultiPolygon][5])>** Polygon feature to difference from polygon1
-   `options` **[Object][6]** Optional Parameters (optional, default `{}`)
    -   `options.properties` **[Object][6]** Translate Properties to output Feature (optional, default `{}`)

**Examples**

```javascript
var poly1 = turf.polygon([[
    [-82.574787, 35.594087],
    [-82.574787, 35.615581],
    [-82.545261, 35.615581],
    [-82.545261, 35.594087],
    [-82.574787, 35.594087]
]], {"fill": "#0f0"});
var poly2 = turf.polygon([[
    [-82.560024, 35.585153],
    [-82.560024, 35.602602],
    [-82.52964, 35.602602],
    [-82.52964, 35.585153],
    [-82.560024, 35.585153]
]], {"fill": "#00f"});

var union = turf.union(poly1, poly2);

//addToMap
var addToMap = [poly1, poly2, union];
```

Returns **[Feature][3]&lt;([Polygon][4] \| [MultiPolygon][5])>** a combined [Polygon][1] or [MultiPolygon][2] feature

[1]: https://tools.ietf.org/html/rfc7946#section-3.1.6

[2]: https://tools.ietf.org/html/rfc7946#section-3.1.7

[3]: https://tools.ietf.org/html/rfc7946#section-3.2

[4]: https://tools.ietf.org/html/rfc7946#section-3.1.6

[5]: https://tools.ietf.org/html/rfc7946#section-3.1.7

[6]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/union
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
