# @turf/transform-translate

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## transformTranslate

Moves any geojson Feature or Geometry of a specified distance along a Rhumb Line
on the provided direction angle.

**Parameters**

-   `geojson` **[GeoJSON][1]** object to be translated
-   `distance` **[number][2]** length of the motion; negative values determine motion in opposite direction
-   `direction` **[number][2]** of the motion; angle from North in decimal degrees, positive clockwise
-   `options` **[Object][3]** Optional parameters (optional, default `{}`)
    -   `options.units` **[string][4]** in which `distance` will be express; miles, kilometers, degrees, or radians (optional, default `'kilometers'`)
    -   `options.zTranslation` **[number][2]** length of the vertical motion, same unit of distance (optional, default `0`)
    -   `options.mutate` **[boolean][5]** allows GeoJSON input to be mutated (significant performance increase if true) (optional, default `false`)

**Examples**

```javascript
var poly = turf.polygon([[[0,29],[3.5,29],[2.5,32],[0,29]]]);
var translatedPoly = turf.transformTranslate(poly, 100, 35);

//addToMap
var addToMap = [poly, translatedPoly];
translatedPoly.properties = {stroke: '#F00', 'stroke-width': 4};
```

Returns **[GeoJSON][1]** the translated GeoJSON object

[1]: https://tools.ietf.org/html/rfc7946#section-3

[2]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[4]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[5]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/transform-translate
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
