# @turf/polygon-to-line

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## polygonToLine

Converts a [Polygon][1] to [(Multi)LineString][2] or [MultiPolygon][3] to a [FeatureCollection][4] of [(Multi)LineString][2].

**Parameters**

-   `poly` **[Feature][5]&lt;([Polygon][6] \| [MultiPolygon][7])>** Feature to convert
-   `options` **[Object][8]** Optional parameters (optional, default `{}`)
    -   `options.properties` **[Object][8]** translates GeoJSON properties to Feature (optional, default `{}`)

**Examples**

```javascript
var poly = turf.polygon([[[125, -30], [145, -30], [145, -20], [125, -20], [125, -30]]]);

var line = turf.polygonToLine(poly);

//addToMap
var addToMap = [line];
```

Returns **([FeatureCollection][9] \| [Feature][5]&lt;([LineString][10] | MultiLinestring)>)** converted (Multi)Polygon to (Multi)LineString

[1]: https://tools.ietf.org/html/rfc7946#section-3.1.6

[2]: https://tools.ietf.org/html/rfc7946#section-3.1.4

[3]: https://tools.ietf.org/html/rfc7946#section-3.1.7

[4]: https://tools.ietf.org/html/rfc7946#section-3.3

[5]: https://tools.ietf.org/html/rfc7946#section-3.2

[6]: https://tools.ietf.org/html/rfc7946#section-3.1.6

[7]: https://tools.ietf.org/html/rfc7946#section-3.1.7

[8]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[9]: https://tools.ietf.org/html/rfc7946#section-3.3

[10]: https://tools.ietf.org/html/rfc7946#section-3.1.4

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/polygon-to-line
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
