/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.statistics.manager.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.reform.fill.dao.BizReformDemandAnalysisLibraryDao;
import com.artfess.reform.fill.manager.BizReformDemandAnalysisLibraryManager;
import com.artfess.reform.fill.manager.BizReformDemandAssignmentManager;
import com.artfess.reform.fill.model.BizReformDemandAnalysisLibrary;
import com.artfess.reform.fill.model.BizReformDemandAssignment;
import com.artfess.reform.fill.vo.DemandAnalysisLibraryNumVo;
import com.artfess.reform.fill.vo.DemandAssignmentVo;
import com.artfess.reform.fill.vo.IterationAddVO;
import com.artfess.reform.fill.vo.IterationUpdateVO;
import com.artfess.reform.majorProjects.dao.PilotBrandPushDao;
import com.artfess.reform.majorProjects.dao.PilotExperiencePushDao;
import com.artfess.reform.majorProjects.dao.PilotQuantitativeObjectivesPushDao;
import com.artfess.reform.majorProjects.dao.PilotSpecificMeasuresDao;
import com.artfess.reform.majorProjects.dao.PilotSpecificScheduleDao;
import com.artfess.reform.majorProjects.manager.PilotMeasuresPushManager;
import com.artfess.reform.majorProjects.model.PilotBrandPush;
import com.artfess.reform.majorProjects.model.PilotExperiencePush;
import com.artfess.reform.majorProjects.model.PilotMeasuresPush;
import com.artfess.reform.majorProjects.model.PilotSpecificSchedule;
import com.artfess.reform.majorProjects.vo.QuantitativeObjectivesVo;
import com.artfess.reform.statistics.dao.BizScoringProjectBrandDao;
import com.artfess.reform.statistics.dao.BizScoringProjectIterationDao;
import com.artfess.reform.statistics.dao.BizScoringProjectMeasureDao;
import com.artfess.reform.statistics.dao.BizScoringProjectSynDao;
import com.artfess.reform.statistics.dao.BizScoringProjectTargetDao;
import com.artfess.reform.statistics.manager.ProjectLargeScreeManager;
import com.artfess.reform.statistics.model.BizScoringProjectBrand;
import com.artfess.reform.statistics.model.BizScoringProjectIteration;
import com.artfess.reform.statistics.model.BizScoringProjectMeasure;
import com.artfess.reform.statistics.model.BizScoringProjectSyn;
import com.artfess.reform.statistics.model.BizScoringProjectTarget;
import com.artfess.reform.statistics.vo.BrandLineChartVO;
import com.artfess.reform.statistics.vo.ComplianceRateVo;
import com.artfess.reform.statistics.vo.ComplianceVo;
import com.artfess.reform.statistics.vo.CountyChartVo;
import com.artfess.reform.statistics.vo.CountyIndexVo;
import com.artfess.reform.statistics.vo.IterationVo;
import com.artfess.reform.statistics.vo.MonthPlanNumVO;
import com.artfess.reform.statistics.vo.MonthPlanTypeNumVO;
import com.artfess.reform.statistics.vo.OverViewComplianceCountVo;
import com.artfess.reform.statistics.vo.OverViewComplianceInfoVo;
import com.artfess.reform.statistics.vo.OverViewComplianceStatusCountVo;
import com.artfess.reform.statistics.vo.OverViewComplianceStatusInfoVo;
import com.artfess.reform.statistics.vo.OverViewComplianceStatusVo;
import com.artfess.reform.statistics.vo.OverviewComplianceVo;
import com.artfess.reform.statistics.vo.ScheduleVo;
import com.artfess.reform.utils.BizUtils;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ProjectLargeScreeManagerImpl
implements ProjectLargeScreeManager {
    @Resource
    private BizScoringProjectSynDao synDao;
    @Resource
    private BizScoringProjectBrandDao brandDao;
    @Resource
    private BizScoringProjectMeasureDao measureDao;
    @Resource
    private BizScoringProjectTargetDao targetDao;
    @Resource
    private PilotSpecificScheduleDao scheduleDao;
    @Resource
    private PilotMeasuresPushManager pilotMeasuresPushManager;
    @Resource
    private BizScoringProjectIterationDao iterationDao;
    @Resource
    private BizReformDemandAnalysisLibraryManager demandManager;
    @Resource
    private BizReformDemandAnalysisLibraryDao demandAnalysisLibraryDao;
    @Resource
    private BizReformDemandAssignmentManager demandRecordMaanger;
    @Resource
    private SysDictionaryManager sdm;
    @Resource
    private PilotSpecificMeasuresDao pilotSpecificMeasuresDao;
    @Resource
    private PilotQuantitativeObjectivesPushDao pilotQuantitativeObjectivesPushDao;
    @Resource
    private PilotSpecificScheduleDao pilotSpecificScheduleDao;
    @Resource
    private PilotExperiencePushDao pilotExperiencePushDao;
    @Resource
    private PilotBrandPushDao pilotBrandPushDao;

    @Override
    public JSONArray indexRank(String type, Integer year, Integer month) {
        Assert.notNull((Object)type, (String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONArray data = new JSONArray();
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (month == null || month == 0) {
            month = LocalDate.now().getMonthValue();
        }
        switch (type) {
            case "composite": {
                List<BizScoringProjectSyn> synList = this.synDao.queryLatest(year, month, null, null);
                List<BizScoringProjectSyn> lastQData = this.synDao.queryLatest(year, month - 1, "M", null);
                synList.forEach(syn -> lastQData.forEach(ld -> {
                    if (syn.getProjectId().equals(ld.getProjectId())) {
                        syn.setTrend(ld.getAllSn() - syn.getAllSn());
                    }
                }));
                data.addAll(synList);
                break;
            }
            case "single": {
                List<Object> brandList = this.brandDao.queryLatestNo1(year, month, null);
                brandList = brandList == null ? Lists.newArrayList() : brandList;
                for (Object brand : brandList) {
                    CountyIndexVo wVo = new CountyIndexVo("\u54c1\u724c\u663e\u793a\u5ea6");
                    wVo.setCounty(((BizScoringProjectBrand)((Object)brand)).getProjectName());
                    wVo.setHoldNum(String.valueOf(((BizScoringProjectBrand)((Object)brand)).getHoldNum()));
                    data.add((Object)wVo);
                }
                List<Object> measureList = this.measureDao.queryLatestNo1(year, month, null);
                measureList = measureList == null ? Lists.newArrayList() : measureList;
                for (BizScoringProjectMeasure measure : measureList) {
                    CountyIndexVo wVo = new CountyIndexVo("\u5177\u4f53\u63aa\u65bd\u63a8\u8fdb\u529b");
                    wVo.setCounty(measure.getProjectName());
                    wVo.setHoldNum(String.valueOf(measure.getHoldNum()));
                    data.add((Object)wVo);
                }
                List<Object> targetList = this.targetDao.queryLatestNo1(year, month, null);
                targetList = targetList == null ? Lists.newArrayList() : targetList;
                for (BizScoringProjectTarget target : targetList) {
                    CountyIndexVo wVo = new CountyIndexVo("\u91cf\u5316\u76ee\u6807\u63a8\u8fdb\u529b");
                    wVo.setCounty(target.getProjectName());
                    wVo.setHoldNum(String.valueOf(target.getHoldNum()));
                    data.add((Object)wVo);
                }
                break;
            }
            default: {
                throw new RuntimeException("type\u4f20\u9012\u9519\u8bef\uff0c\u5141\u8bb8\u503c\uff1acomposite \u7efc\u5408\u6392\u540d,single \u5355\u9879");
            }
        }
        return data;
    }

    @Override
    public JSONObject monthPlanNum(String projectId, Integer year, Integer month) {
        MonthPlanNumVO monthPlanNumVO;
        JSONObject result = new JSONObject();
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (month == null || month == 0) {
            month = LocalDate.now().getMonthValue();
        }
        if ((monthPlanNumVO = this.scheduleDao.queryMonthPlanNum(year, month, projectId)).getTotalNum() == 0) {
            monthPlanNumVO.setFinishRate(new BigDecimal(0));
        } else {
            BigDecimal finishRate = new BigDecimal(monthPlanNumVO.getFinishNum()).divide(new BigDecimal(monthPlanNumVO.getTotalNum()), 4, 4).multiply(new BigDecimal(100));
            monthPlanNumVO.setFinishRate(finishRate);
        }
        List<MonthPlanNumVO> list = this.scheduleDao.queryMonthPlanNumAll(year, month, projectId);
        Map<String, Long> map = list.stream().collect(Collectors.groupingBy(MonthPlanNumVO::getDegree, Collectors.counting()));
        result.put("total", (Object)monthPlanNumVO);
        result.put("degree", map);
        return result;
    }

    @Override
    public List<MonthPlanNumVO> monthPlanNumForProject(Integer year, Integer month) {
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (month == null || month == 0) {
            month = LocalDate.now().getMonthValue();
        }
        List<MonthPlanNumVO> list = this.scheduleDao.queryMonthPlanNumAll(year, month, null);
        return list;
    }

    @Override
    public JSONObject monthPlanNumDetails(Integer year, Integer month, String projectId) {
        JSONObject result = new JSONObject();
        MonthPlanNumVO monthPlanNumVO = this.scheduleDao.queryMonthPlanNum(year, month, projectId);
        List<MonthPlanTypeNumVO> typeNum = this.scheduleDao.queryMonthPlanNumForType(year, month, projectId);
        result.put("total", (Object)monthPlanNumVO);
        result.put("typeNum", typeNum);
        return result;
    }

    @Override
    public JSONObject targetNum(Integer year, Integer month) {
        JSONObject result = new JSONObject();
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (month == null || month == 0) {
            month = LocalDate.now().getMonthValue();
        }
        return null;
    }

    @Override
    public JSONObject demandHeatList(Integer year, Integer month) {
        JSONObject result = new JSONObject();
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (month == null || month == 0) {
            month = LocalDate.now().getMonthValue();
        }
        List<CountyChartVo> chartData = this.demandManager.chartDataForLargeScreen(year, month);
        result.put("chart", chartData);
        List<DemandAnalysisLibraryNumVo> demandData = this.demandAnalysisLibraryDao.countNum(year, month, null);
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"year(MEETING_DATE_)", (Object)year)).le((Object)"month(MEETING_DATE_)", (Object)month);
        int count = this.demandRecordMaanger.count((Wrapper)queryWrapper);
        if (count > 0) {
            for (DemandAnalysisLibraryNumVo numVo : demandData) {
                BigDecimal f = new BigDecimal(numVo.getListNum()).divide(new BigDecimal(count), 2, 4);
                BigDecimal qualityRate = new BigDecimal(numVo.getProjectNum()).add(f);
                numVo.setQualityRate(qualityRate);
            }
        }
        result.put("demandRank", demandData);
        return result;
    }

    @Override
    public JSONObject demandDetailList(QueryFilter<BizReformDemandAssignment> queryFilter) {
        JSONObject result = new JSONObject();
        List querys = queryFilter.getQuerys();
        Object flagYear = null;
        Object flagMonth = null;
        if (querys != null && querys.size() > 0) {
            for (QueryField field : querys) {
                if (field.getProperty().trim().toLowerCase().equals("a.propulsive_year_") || field.getProperty().trim().toLowerCase().equals("a.propulsiveyear")) {
                    flagYear = field.getValue();
                    continue;
                }
                if (!field.getProperty().trim().toLowerCase().equals("a.propulsive_month_") && !field.getProperty().trim().toLowerCase().equals("a.propulsivemonth")) continue;
                flagMonth = field.getValue();
            }
        }
        if (flagYear == null) {
            flagYear = LocalDate.now().getYear();
            queryFilter.addFilter("a.PROPULSIVE_YEAR_", flagYear, QueryOP.EQUAL);
        }
        if (flagMonth == null) {
            flagMonth = LocalDate.now().getMonthValue();
            queryFilter.addFilter("a.PROPULSIVE_MONTH_", flagMonth, QueryOP.LESS_EQUAL);
        }
        List demandData = this.demandManager.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"DEMAND_YEAR_", flagYear)).le((Object)"DEMAND_MONTH_", flagMonth)).eq((Object)"STATUS_", (Object)5));
        List ssly = this.sdm.queryDictListItemsByCode("ggbb_ssly");
        Map<Integer, List<BizReformDemandAnalysisLibrary>> domainGroupDeman = demandData.stream().collect(Collectors.groupingBy(BizReformDemandAnalysisLibrary::getDemandField));
        ArrayList domainChart = Lists.newArrayList();
        domainGroupDeman.entrySet().forEach(en -> domainChart.add(new CountyChartVo(BizUtils.getDicValueByCode((List<DictModel>)ssly, (Integer)en.getKey()), (Integer)((List)en.getValue()).size())));
        result.put("domainChart", (Object)domainChart);
        List cyzt = this.sdm.queryDictListItemsByCode("ggbb_cyzt");
        Map<Integer, List<BizReformDemandAnalysisLibrary>> processGroupDeman = demandData.stream().collect(Collectors.groupingBy(BizReformDemandAnalysisLibrary::getDemandAdoptionStatus));
        ArrayList processChart = Lists.newArrayList();
        processGroupDeman.entrySet().forEach(en -> processChart.add(new CountyChartVo(BizUtils.getDicValueByCode((List<DictModel>)cyzt, (Integer)en.getKey()), (Integer)((List)en.getValue()).size())));
        Map<Integer, List<BizReformDemandAssignment>> processStatuasGroup = this.demandRecordMaanger.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROPULSIVE_YEAR_", flagYear)).le((Object)"PROPULSIVE_MONTH_", flagMonth)).isNotNull((Object)"DEMAND_STATUS_")).stream().collect(Collectors.groupingBy(BizReformDemandAssignment::getDemandStatus));
        AtomicInteger pushNum = new AtomicInteger();
        processStatuasGroup.entrySet().forEach(psg -> {
            if ((Integer)psg.getKey() == 1) {
                pushNum.set(pushNum.get() + ((List)psg.getValue()).size());
            }
            if ((Integer)psg.getKey() == 2) {
                pushNum.set(pushNum.get() + ((List)psg.getValue()).size());
            }
            if ((Integer)psg.getKey() == 3) {
                processChart.add(new CountyChartVo("\u5b8c\u6210\u9500\u53f7", (Integer)((List)psg.getValue()).size()));
            }
        });
        processChart.add(new CountyChartVo("\u4ea4\u529e\u533a\u53bf\u843d\u5b9e", (Integer)pushNum.get()));
        result.put("processChart", (Object)processChart);
        queryFilter.addFilter("a.is_dele_", (Object)"0", QueryOP.EQUAL);
        PageList<DemandAssignmentVo> recordList = this.demandRecordMaanger.queryDemandAssignment(queryFilter);
        result.put("recordList", recordList);
        return result;
    }

    @Override
    public List<BrandLineChartVO> brandLineChart(String projectId, Integer year, Integer month) {
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (month == null || month == 0) {
            month = LocalDate.now().getMonthValue();
        }
        List<BrandLineChartVO> list = this.brandDao.brandLineChart(projectId, year, month);
        boolean existsTwelveMonths = IntStream.rangeClosed(1, 12).allMatch(monthl -> list.stream().anyMatch(vo -> vo.getFillMonth() == monthl));
        if (!existsTwelveMonths) {
            Integer finalYear = year;
            IntStream.rangeClosed(1, 12).filter(monthl -> list.stream().noneMatch(vo -> vo.getFillMonth() == monthl)).mapToObj(monthl -> new BrandLineChartVO(finalYear, monthl, 0, 0, 0)).forEach(list::add);
        }
        list.sort(Comparator.comparingInt(BrandLineChartVO::getFillMonth));
        return list;
    }

    @Override
    public List<BrandLineChartVO> queryBrandForProject(String projectId, Integer year, Integer month) {
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (month == null || month == 0) {
            month = LocalDate.now().getMonthValue();
        }
        List<BrandLineChartVO> list = this.brandDao.queryBrandForProject(projectId, year, month);
        return list;
    }

    @Override
    public List<PilotBrandPush> queryBrandForProjectInfo(String projectId, Integer year, Integer month) {
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (month == null || month == 0) {
            month = LocalDate.now().getMonthValue();
        }
        return this.pilotBrandPushDao.queryBrandForProjectInfo(projectId, year, month);
    }

    @Override
    public List<BizScoringProjectIteration> queryIterationForProject(Integer year, Integer month) {
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (month == null || month == 0) {
            month = LocalDate.now().getMonthValue();
        }
        List<BizScoringProjectIteration> list = this.iterationDao.queryIterationByDate(year, null, month);
        return list;
    }

    @Override
    public IterationVo queryIterationForProjectInfo(String projectId, Integer year, Integer month) {
        List<IterationAddVO> addVOS = this.pilotSpecificMeasuresDao.iterationAdd(projectId, year, month);
        List<IterationUpdateVO> updateVOS = this.pilotSpecificMeasuresDao.iterationUpdate(projectId, year, month);
        IterationVo iIterationVo = new IterationVo();
        iIterationVo.setIterationAddVO(addVOS);
        iIterationVo.setIterationUpdateVO(updateVOS);
        return iIterationVo;
    }

    @Override
    public ScheduleVo achievementCount(String projectId, Integer year, Integer month) {
        ScheduleVo scheduleVo = new ScheduleVo();
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (month == null || month == 0) {
            month = LocalDate.now().getMonthValue();
        }
        Integer platformCount = this.scheduleDao.achievementCount(projectId, year, month, 6);
        scheduleVo.setPlatformCount(platformCount);
        Integer oldPlatformCount = this.scheduleDao.achievementCount(projectId, year, month - 1, 6);
        int platformChain = platformCount - oldPlatformCount;
        scheduleVo.setPlatformChain(platformChain);
        Integer achievementCount = this.scheduleDao.achievementCount(projectId, year, month, 5);
        scheduleVo.setAchievementCount(achievementCount);
        Integer oldAchievementCount = this.scheduleDao.achievementCount(projectId, year, month - 1, 5);
        int achievementChain = achievementCount - oldAchievementCount;
        scheduleVo.setAchievementChain(achievementChain);
        Integer scenarioCount = this.scheduleDao.achievementCount(projectId, year, month, 7);
        scheduleVo.setScenarioCount(scenarioCount);
        Integer oldScenarioCount = this.scheduleDao.achievementCount(projectId, year, month - 1, 7);
        int scenarioChain = scenarioCount - oldScenarioCount;
        scheduleVo.setScenarioChain(scenarioChain);
        return scheduleVo;
    }

    @Override
    public PageList<PilotMeasuresPush> achievementInfo(QueryFilter<PilotMeasuresPush> queryFilter) {
        return this.pilotMeasuresPushManager.achievementInfo(queryFilter);
    }

    @Override
    public ComplianceRateVo complianceRateCount(String projectId, Integer year, Integer month) {
        if (year == null || year < 0) {
            year = LocalDate.now().getYear();
        }
        if (month == null || month < 1 || month > 12) {
            month = LocalDate.now().getMonthValue();
        }
        ComplianceRateVo complianceRateVo = new ComplianceRateVo();
        ComplianceVo rateVo = this.pilotQuantitativeObjectivesPushDao.complianceRateCount(projectId, year, month);
        complianceRateVo.setNewComplianceRate(rateVo.getComplianceRate());
        complianceRateVo.setNum(rateVo.getNum());
        ComplianceVo endOfMonthRateCount = this.pilotQuantitativeObjectivesPushDao.endOfMonthRateCount(projectId, year, month);
        complianceRateVo.setOldComplianceRate(endOfMonthRateCount.getComplianceRate());
        complianceRateVo.setReachedCount(endOfMonthRateCount.getNum());
        return complianceRateVo;
    }

    @Override
    public OverViewComplianceStatusVo overviewComplianceStatusInfo(Integer year, Integer month) {
        if (year == null || year < 0) {
            year = LocalDate.now().getYear();
        }
        if (month == null || month < 1 || month > 12) {
            month = LocalDate.now().getMonthValue();
        }
        List<OverViewComplianceStatusInfoVo> overViewComplianceStatusInfoVoList = this.pilotQuantitativeObjectivesPushDao.overViewComplianceStatusInfoVo(year, month);
        List noList = overViewComplianceStatusInfoVoList.stream().distinct().map(OverViewComplianceStatusInfoVo::getNo).collect(Collectors.toList());
        double excellentRate = (double)noList.size() * 0.2;
        double qualifiedRate = (double)noList.size() * 0.3;
        long excellentNum = 0L;
        long qualifiedNum = 0L;
        excellentNum = Math.round(excellentRate) == 0L ? 1L : Math.round(excellentRate);
        qualifiedNum = Math.round(qualifiedRate) == 0L ? 1L : Math.round(qualifiedRate);
        Integer excessCount = 0;
        Integer reachedCount = 0;
        if (noList.size() >= 1) {
            Integer excellentNo = (Integer)noList.get((int)excellentNum - 1);
            List<Object> qualifiedNo = new ArrayList();
            if (noList.size() > 1) {
                qualifiedNo = noList.subList((int)excellentNum, (int)excellentNum + (int)qualifiedNum);
            }
            for (OverViewComplianceStatusInfoVo overViewComplianceStatusInfoVo : overViewComplianceStatusInfoVoList) {
                Integer n;
                Integer n2;
                if (overViewComplianceStatusInfoVo.getNo() <= excellentNo) {
                    overViewComplianceStatusInfoVo.setGrade(1);
                    n2 = excessCount;
                    n = excessCount = Integer.valueOf(excessCount + 1);
                    continue;
                }
                if (qualifiedNo.contains(overViewComplianceStatusInfoVo.getNo())) {
                    overViewComplianceStatusInfoVo.setGrade(2);
                    n2 = reachedCount;
                    n = reachedCount = Integer.valueOf(reachedCount + 1);
                    continue;
                }
                overViewComplianceStatusInfoVo.setGrade(3);
            }
        }
        OverViewComplianceStatusVo overViewComplianceStatusVo = new OverViewComplianceStatusVo();
        OverViewComplianceStatusCountVo overViewComplianceStatusCountVo = new OverViewComplianceStatusCountVo();
        overViewComplianceStatusCountVo.setExcessCount(excessCount);
        overViewComplianceStatusCountVo.setReachedCount(reachedCount);
        overViewComplianceStatusCountVo.setNotReachedCount(overViewComplianceStatusInfoVoList.size() - excessCount - reachedCount);
        overViewComplianceStatusVo.setOverViewComplianceStatusCountVo(overViewComplianceStatusCountVo);
        overViewComplianceStatusVo.setOverViewComplianceStatusInfoVoList(overViewComplianceStatusInfoVoList);
        return overViewComplianceStatusVo;
    }

    @Override
    public OverviewComplianceVo overviewComplianceInfo(String projectId, Integer year, Integer month) {
        if (year == null || year < 0) {
            year = LocalDate.now().getYear();
        }
        if (month == null || month < 1 || month > 12) {
            month = LocalDate.now().getMonthValue();
        }
        List<OverViewComplianceInfoVo> complianceInfoVos = this.pilotQuantitativeObjectivesPushDao.overViewComplianceInfo(projectId, year, month);
        OverViewComplianceCountVo overViewComplianceCountVo = this.pilotQuantitativeObjectivesPushDao.overViewComplianceCount(projectId, year, month);
        OverviewComplianceVo overviewComplianceVo = new OverviewComplianceVo();
        overviewComplianceVo.setOverviewComplianceCountVo(overViewComplianceCountVo);
        overviewComplianceVo.setOverviewComplianceInfoVoList(complianceInfoVos);
        return overviewComplianceVo;
    }

    @Override
    public List<PilotSpecificSchedule> schedulePlanInfo(String projectId, Integer year, Integer month) {
        if (year == null || year < 0) {
            year = LocalDate.now().getYear();
        }
        if (month == null || month < 1 || month > 12) {
            month = LocalDate.now().getMonthValue();
        }
        return this.pilotSpecificScheduleDao.schedulePlanInfo(projectId, year, month);
    }

    @Override
    public List<PilotExperiencePush> pilotExperiencePushInfo(String projectId, Integer year, Integer month) {
        if (year == null || year < 0) {
            year = LocalDate.now().getYear();
        }
        if (month == null || month < 1 || month > 12) {
            month = LocalDate.now().getMonthValue();
        }
        return this.pilotExperiencePushDao.pilotExperiencePushInfo(projectId, year, month);
    }

    @Override
    public List<QuantitativeObjectivesVo> quantitativeObjectivesInfo(String projectId, Integer year, Integer month) {
        if (year == null || year < 0) {
            year = LocalDate.now().getYear();
        }
        if (month == null || month < 1 || month > 12) {
            month = LocalDate.now().getMonthValue();
        }
        return this.pilotQuantitativeObjectivesPushDao.quantitativeObjectivesInfo(projectId, year, month);
    }
}

