/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.statistics.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.vo.MeasureListVO;
import com.artfess.reform.statistics.dao.BizScoringProjectMeasureDao;
import com.artfess.reform.statistics.manager.BizScoringProjectMeasureManager;
import com.artfess.reform.statistics.model.BizScoringProjectMeasure;
import com.artfess.reform.utils.CumputeUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizScoringProjectMeasureManagerImpl
extends BaseManagerImpl<BizScoringProjectMeasureDao, BizScoringProjectMeasure>
implements BizScoringProjectMeasureManager {
    @Resource
    private BizScoringProjectMeasureDao bizScoringProjectMeasureDao;

    @Override
    public IPage<MeasureListVO> select4Cockpit(QueryFilter<BizScoringProjectMeasure> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        LocalDateTime now = LocalDateTime.now();
        int year = now.getYear();
        Integer type = 1;
        List querys = queryFilter.getQuerys();
        for (QueryField query : querys) {
            if (!"type".equals(query.getProperty())) continue;
            type = (Integer)query.getValue();
        }
        return this.bizScoringProjectMeasureDao.select4Cockpit((IPage<BizScoringProjectMeasure>)this.convert2IPage(pageBean), type, year);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<BizScoringProjectMeasure> getList() {
        LocalDate now = LocalDate.now();
        LocalDate lastDay = now.with(TemporalAdjusters.lastDayOfMonth());
        List<BizScoringProjectMeasure> list = this.bizScoringProjectMeasureDao.statisticsNum(now.getYear(), null, null);
        if (list != null && list.size() > 0) {
            ArrayList<BigDecimal> regimeList = new ArrayList<BigDecimal>();
            ArrayList<BigDecimal> appPlatformList = new ArrayList<BigDecimal>();
            for (BizScoringProjectMeasure bizScoringProjectMeasure : list) {
                BigDecimal regimeRate = new BigDecimal(bizScoringProjectMeasure.getActualRegimeNum()).divide(new BigDecimal(bizScoringProjectMeasure.getRegimeNum()), 2, 4);
                BigDecimal appPlatformRate = new BigDecimal(bizScoringProjectMeasure.getActualAppNum() + bizScoringProjectMeasure.getActualPlatformNum()).divide(new BigDecimal(bizScoringProjectMeasure.getAppNum() + bizScoringProjectMeasure.getPlatformNum()), 2, 4);
                bizScoringProjectMeasure.setRegimeRate(regimeRate);
                bizScoringProjectMeasure.setAppPlatformRate(appPlatformRate);
                regimeList.add(regimeRate);
                appPlatformList.add(appPlatformRate);
            }
            CumputeUtil util = new CumputeUtil(3);
            for (BizScoringProjectMeasure scoringProjectMeasure : list) {
                BigDecimal regimeRate = scoringProjectMeasure.getRegimeRate();
                BigDecimal appPlatformRate = scoringProjectMeasure.getAppPlatformRate();
                BigDecimal regimeScore = util.cumpute3(regimeList.toArray(new BigDecimal[regimeList.size()]), regimeRate, new BigDecimal(15), false);
                BigDecimal appPlatformScore = util.cumpute3(appPlatformList.toArray(new BigDecimal[appPlatformList.size()]), appPlatformRate, new BigDecimal(15), false);
                BigDecimal measureScore = regimeScore.add(appPlatformScore);
                scoringProjectMeasure.setMeasureScore(measureScore);
                scoringProjectMeasure.setAppPlatformScore(appPlatformScore);
                scoringProjectMeasure.setRegimeScore(regimeScore);
            }
            Object var7_9 = null;
            if (now.getMonthValue() != 1 && now.getDayOfMonth() == lastDay.getDayOfMonth()) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"HOLD_NUM_", (Object)1);
                queryWrapper.eq((Object)"FILL_YEAR_", (Object)now.getYear());
                queryWrapper.eq((Object)"FILL_YEAR_", (Object)(now.getMonthValue() - 1));
                queryWrapper.eq((Object)"FILL_TYPE_", (Object)"M");
                List NO1List = this.bizScoringProjectMeasureDao.selectList((Wrapper)queryWrapper);
                if (NO1List != null && NO1List.size() > 0) {
                    BizScoringProjectMeasure bizScoringProjectMeasure = (BizScoringProjectMeasure)((Object)NO1List.get(0));
                }
            }
            list = list.stream().sorted((s1, s2) -> -s1.getMeasureScore().compareTo(s2.getMeasureScore())).collect(Collectors.toList());
            List snlist = list.stream().collect(Collectors.groupingBy(BizScoringProjectMeasure::getMeasureScore)).entrySet().stream().sorted((s1, s2) -> -((BigDecimal)s1.getKey()).compareTo((BigDecimal)s2.getKey())).collect(Collectors.toList());
            Integer index = 1;
            for (Map.Entry entry : snlist) {
                for (BizScoringProjectMeasure measure : (List)entry.getValue()) {
                    void var7_11;
                    measure.setMeasureSn(index);
                    if (lastDay.getDayOfMonth() != now.getDayOfMonth()) continue;
                    if (var7_11 == null && index == 1) {
                        measure.setHoldNum(0);
                        continue;
                    }
                    if (var7_11 != null && !var7_11.getProjectId().equals(measure.getProjectId()) && index == 1) {
                        measure.setHoldNum(0);
                        continue;
                    }
                    if (var7_11 == null || !var7_11.getProjectId().equals(measure.getProjectId()) || index != 1) continue;
                    measure.setHoldNum(var7_11.getHoldNum() + 1);
                }
                index = index + 1;
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Transactional
    public List<BizScoringProjectMeasure> countScore(LocalDate countDate) {
        LocalDate now = LocalDate.now();
        if (countDate == null) {
            countDate = now;
        }
        LocalDate lastDay = countDate.with(TemporalAdjusters.lastDayOfMonth());
        List<BizScoringProjectMeasure> list = this.bizScoringProjectMeasureDao.statisticsNum(countDate.getYear(), null, null);
        if (list != null && list.size() > 0) {
            ArrayList<BigDecimal> regimeList = new ArrayList<BigDecimal>();
            ArrayList<BigDecimal> appPlatformList = new ArrayList<BigDecimal>();
            for (BizScoringProjectMeasure bizScoringProjectMeasure : list) {
                bizScoringProjectMeasure.setFillDate(countDate);
                bizScoringProjectMeasure.setFillYear(countDate.getYear());
                bizScoringProjectMeasure.setFillQuarter(BizScoringProjectMeasureManagerImpl.getSeasonDay(countDate));
                bizScoringProjectMeasure.setFillMonth(countDate.getMonthValue());
                bizScoringProjectMeasure.setFillType(BizScoringProjectMeasureManagerImpl.getFillType(countDate));
                BigDecimal regimeRate = new BigDecimal(bizScoringProjectMeasure.getActualRegimeNum()).divide(new BigDecimal(bizScoringProjectMeasure.getRegimeNum()), 2, 4);
                BigDecimal appPlatformRate = new BigDecimal(bizScoringProjectMeasure.getActualAppNum() + bizScoringProjectMeasure.getActualPlatformNum()).divide(new BigDecimal(bizScoringProjectMeasure.getAppNum() + bizScoringProjectMeasure.getPlatformNum()), 2, 4);
                bizScoringProjectMeasure.setRegimeRate(regimeRate);
                bizScoringProjectMeasure.setAppPlatformRate(appPlatformRate);
                regimeList.add(regimeRate);
                appPlatformList.add(appPlatformRate);
            }
            CumputeUtil util = new CumputeUtil(3);
            for (BizScoringProjectMeasure scoringProjectMeasure : list) {
                BigDecimal regimeRate = scoringProjectMeasure.getRegimeRate();
                BigDecimal appPlatformRate = scoringProjectMeasure.getAppPlatformRate();
                BigDecimal regimeScore = util.cumpute3(regimeList.toArray(new BigDecimal[regimeList.size()]), regimeRate, new BigDecimal(15), false);
                BigDecimal appPlatformScore = util.cumpute3(appPlatformList.toArray(new BigDecimal[appPlatformList.size()]), appPlatformRate, new BigDecimal(15), false);
                BigDecimal measureScore = regimeScore.add(appPlatformScore);
                scoringProjectMeasure.setMeasureScore(measureScore);
                scoringProjectMeasure.setAppPlatformScore(appPlatformScore);
                scoringProjectMeasure.setRegimeScore(regimeScore);
            }
            ArrayList arrayList = new ArrayList();
            if (countDate.getMonthValue() != 1 && countDate.getDayOfMonth() == lastDay.getDayOfMonth()) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"MEASURE_SN_", (Object)1);
                queryWrapper.eq((Object)"FILL_YEAR_", (Object)countDate.getYear());
                queryWrapper.eq((Object)"FILL_MONTH_", (Object)(countDate.getMonthValue() - 1));
                queryWrapper.eq((Object)"FILL_TYPE_", (Object)"M");
                List list2 = this.bizScoringProjectMeasureDao.selectList((Wrapper)queryWrapper);
            }
            list = list.stream().sorted((s1, s2) -> -s1.getMeasureScore().compareTo(s2.getMeasureScore())).collect(Collectors.toList());
            List snlist = list.stream().collect(Collectors.groupingBy(BizScoringProjectMeasure::getMeasureScore)).entrySet().stream().sorted((s1, s2) -> -((BigDecimal)s1.getKey()).compareTo((BigDecimal)s2.getKey())).collect(Collectors.toList());
            Integer index = 1;
            for (Map.Entry entry : snlist) {
                block3: for (BizScoringProjectMeasure measure : (List)entry.getValue()) {
                    void var8_12;
                    measure.setMeasureSn(index);
                    if (lastDay.getDayOfMonth() != countDate.getDayOfMonth()) continue;
                    if ((var8_12 == null || var8_12.size() == 0) && index == 1) {
                        measure.setHoldNum(0);
                        continue;
                    }
                    if (var8_12 == null || var8_12.size() <= 0 || index != 1) continue;
                    for (BizScoringProjectMeasure NO1 : var8_12) {
                        if (NO1.getProjectId().equals(measure.getProjectId())) {
                            measure.setHoldNum(NO1.getHoldNum() + 1);
                            continue block3;
                        }
                        measure.setHoldNum(0);
                    }
                }
                index = index + ((List)entry.getValue()).size();
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"FILL_DATE_", (Object)countDate);
            this.bizScoringProjectMeasureDao.delete((Wrapper)queryWrapper);
            this.saveBatch(list);
        }
        return list;
    }

    public static String getFillType(LocalDate dateTime) {
        LocalDate lastDay;
        String type = "D";
        int month = dateTime.getMonthValue();
        int day = dateTime.getDayOfMonth();
        if (day == (lastDay = dateTime.with(TemporalAdjusters.lastDayOfMonth())).getDayOfMonth()) {
            type = "M";
            if (month == 3 || month == 6 || month == 9 || month == 12) {
                type = "Q";
            }
        }
        return type;
    }

    public static int getSeasonDay(LocalDate dateTime) {
        return Integer.valueOf(dateTime.getMonthValue() + 2) / 3;
    }
}

