/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.statistics.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.statistics.dao.BizScoringProjectIterationDao;
import com.artfess.reform.statistics.manager.BizScoringProjectIterationManager;
import com.artfess.reform.statistics.model.BizScoringProjectIteration;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class BizScoringProjectIterationManagerImpl
extends BaseManagerImpl<BizScoringProjectIterationDao, BizScoringProjectIteration>
implements BizScoringProjectIterationManager {
    @Override
    public List<BizScoringProjectIteration> countScore(LocalDate countDate) {
        LocalDate now = LocalDate.now();
        if (countDate == null) {
            countDate = now;
        }
        int season = BizScoringProjectIterationManagerImpl.getSeasonDay(countDate);
        int month = countDate.getMonthValue();
        List<BizScoringProjectIteration> list = ((BizScoringProjectIterationDao)this.baseMapper).queryIterationByDate(countDate.getYear(), season, month);
        if (list != null && list.size() > 0) {
            String type = BizScoringProjectIterationManagerImpl.getFillType(countDate);
            for (BizScoringProjectIteration iteration : list) {
                iteration.setFillDate(countDate);
                iteration.setFillYear(countDate.getYear());
                iteration.setFillQuarter(season);
                iteration.setFillMonth(month);
                iteration.setFillType(type);
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"FILL_DATE_", (Object)countDate);
            ((BizScoringProjectIterationDao)this.baseMapper).delete((Wrapper)queryWrapper);
            this.saveBatch(list);
        }
        return list;
    }

    public static String getFillType(LocalDate dateTime) {
        LocalDate lastDay;
        String type = "D";
        int month = dateTime.getMonthValue();
        int day = dateTime.getDayOfMonth();
        if (day == (lastDay = dateTime.with(TemporalAdjusters.lastDayOfMonth())).getDayOfMonth()) {
            type = "M";
            if (month == 3 || month == 6 || month == 9 || month == 12) {
                type = "Q";
            }
        }
        return type;
    }

    public static int getSeasonDay(LocalDate dateTime) {
        return Integer.valueOf(dateTime.getMonthValue() + 2) / 3;
    }
}

