/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.statistics.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.statistics.dao.BizScoringCountyWorkableDao;
import com.artfess.reform.statistics.manager.BizScoringCountyWorkableManager;
import com.artfess.reform.statistics.model.BizScoringCountyWorkable;
import com.artfess.reform.utils.CumputeUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizScoringCountyWorkableManagerImpl
extends BaseManagerImpl<BizScoringCountyWorkableDao, BizScoringCountyWorkable>
implements BizScoringCountyWorkableManager {
    @Override
    @Transactional
    public List<BizScoringCountyWorkable> countScore(LocalDate countDate) {
        LocalDate now = LocalDate.now();
        if (countDate == null) {
            countDate = now;
        }
        LocalDate lastDay = countDate.with(TemporalAdjusters.lastDayOfMonth());
        List<BizScoringCountyWorkable> pilotCount = ((BizScoringCountyWorkableDao)this.baseMapper).countPilot(countDate);
        if (pilotCount != null && pilotCount.size() > 0) {
            QueryWrapper queryWrapper;
            for (BizScoringCountyWorkable workable : pilotCount) {
                workable.setFillDate(countDate);
                workable.setFillYear(countDate.getYear());
                workable.setFillQuarter(BizScoringCountyWorkableManagerImpl.getSeasonDay(countDate));
                workable.setFillMonth(countDate.getMonthValue());
                workable.setFillType(BizScoringCountyWorkableManagerImpl.getFillType(countDate));
                if (workable.getProjectEndNum() != 0) {
                    BigDecimal passRate = new BigDecimal(workable.getPassNum()).divide(new BigDecimal(workable.getProjectEndNum()), 4, 4);
                    workable.setPassRate(passRate.multiply(new BigDecimal(100)));
                } else {
                    workable.setPassRate(new BigDecimal(0));
                }
                if (workable.getNationalEndNum() != 0) {
                    BigDecimal nationalpassRate = new BigDecimal(workable.getNationalPassNum()).divide(new BigDecimal(workable.getNationalEndNum()), 4, 4);
                    workable.setNationalPassRate(nationalpassRate.multiply(new BigDecimal(100)));
                } else {
                    workable.setNationalPassRate(new BigDecimal(100));
                }
                if (workable.getCityEndNum() != 0) {
                    BigDecimal cityPassRate = new BigDecimal(workable.getCityPassNum()).divide(new BigDecimal(workable.getCityEndNum()), 4, 4);
                    workable.setCityPassRate(cityPassRate.multiply(new BigDecimal(100)));
                } else {
                    workable.setCityPassRate(new BigDecimal(100));
                }
                if (workable.getAddSn() <= 9) {
                    workable.setAddGrade("A");
                } else if (17 >= workable.getAddSn() && workable.getAddSn() > 9) {
                    workable.setAddGrade("B");
                } else if (25 >= workable.getAddSn() && workable.getAddSn() > 17) {
                    workable.setAddGrade("C");
                } else if (33 >= workable.getAddSn() && workable.getAddSn() > 25) {
                    workable.setAddGrade("D");
                } else if (workable.getAddSn() > 33) {
                    workable.setAddGrade("E");
                }
                if (workable.getNationalProjectSn() <= 9) {
                    workable.setNationalProjectGrade("A");
                } else if (17 >= workable.getNationalProjectSn() && workable.getNationalProjectSn() > 9) {
                    workable.setNationalProjectGrade("B");
                } else if (25 >= workable.getNationalProjectSn() && workable.getNationalProjectSn() > 17) {
                    workable.setNationalProjectGrade("C");
                } else if (33 >= workable.getNationalProjectSn() && workable.getNationalProjectSn() > 25) {
                    workable.setNationalProjectGrade("D");
                } else if (workable.getNationalProjectSn() > 33) {
                    workable.setNationalProjectGrade("E");
                }
                if (workable.getCityProjectSn() <= 9) {
                    workable.setCityProjectGrade("A");
                    continue;
                }
                if (17 >= workable.getCityProjectSn() && workable.getCityProjectSn() > 9) {
                    workable.setCityProjectGrade("B");
                    continue;
                }
                if (25 >= workable.getCityProjectSn() && workable.getCityProjectSn() > 17) {
                    workable.setCityProjectGrade("C");
                    continue;
                }
                if (33 >= workable.getCityProjectSn() && workable.getCityProjectSn() > 25) {
                    workable.setCityProjectGrade("D");
                    continue;
                }
                if (workable.getCityProjectSn() <= 33) continue;
                workable.setCityProjectGrade("E");
            }
            BigDecimal[] nationalList = (BigDecimal[])pilotCount.stream().map(BizScoringCountyWorkable::getNationalProjectNum).map(BigDecimal::new).toArray(BigDecimal[]::new);
            BigDecimal[] nationalPassList = (BigDecimal[])pilotCount.stream().map(BizScoringCountyWorkable::getNationalPassRate).toArray(BigDecimal[]::new);
            BigDecimal[] cityList = (BigDecimal[])pilotCount.stream().map(BizScoringCountyWorkable::getCityProjectNum).map(BigDecimal::new).toArray(BigDecimal[]::new);
            BigDecimal[] cityPassList = (BigDecimal[])pilotCount.stream().map(BizScoringCountyWorkable::getCityPassRate).toArray(BigDecimal[]::new);
            CumputeUtil util = new CumputeUtil(2);
            for (BizScoringCountyWorkable workable : pilotCount) {
                BigDecimal nationalPassRate = workable.getNationalPassRate();
                Integer nationalProjectNum = workable.getNationalProjectNum();
                BigDecimal nationalProjectScore = util.cumpute2(nationalList, new BigDecimal(nationalProjectNum), new BigDecimal(10));
                BigDecimal nationalPassScore = util.cumpute2(nationalPassList, nationalPassRate, new BigDecimal(3.5), false);
                BigDecimal cityPassRate = workable.getCityPassRate();
                Integer cityProjectNum = workable.getCityProjectNum();
                BigDecimal cityProjectScore = util.cumpute2(cityList, new BigDecimal(cityProjectNum), new BigDecimal(8));
                Iterator cityPassScore = util.cumpute2(cityPassList, cityPassRate, new BigDecimal(3.5), false);
                BigDecimal workScore = nationalProjectScore.add(nationalPassScore).add(cityProjectScore).add((BigDecimal)((Object)cityPassScore)).setScale(2, 4);
                workable.setNationalProjectScore(nationalProjectScore);
                workable.setNationalPassScore(nationalPassScore);
                workable.setCityProjectScore(cityProjectScore);
                workable.setCityPassScore((BigDecimal)((Object)cityPassScore));
                workable.setWorkableScore(workScore);
            }
            List NO1List = new ArrayList();
            int month = countDate.getMonthValue();
            if ((month == 6 || month == 9 || month == 12) && countDate.getDayOfMonth() == lastDay.getDayOfMonth()) {
                queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"WORKABLE_ALL_SN_", (Object)1);
                queryWrapper.eq((Object)"FILL_YEAR_", (Object)countDate.getYear());
                queryWrapper.eq((Object)"FILL_QUARTER_", (Object)(BizScoringCountyWorkableManagerImpl.getSeasonDay(countDate) - 1));
                queryWrapper.eq((Object)"FILL_TYPE_", (Object)"Q");
                NO1List = this.list((Wrapper)queryWrapper);
            }
            queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"FILL_YEAR_", (Object)countDate.getYear());
            queryWrapper.eq((Object)"FILL_QUARTER_", (Object)(BizScoringCountyWorkableManagerImpl.getSeasonDay(countDate) - 1));
            queryWrapper.eq((Object)"FILL_TYPE_", (Object)"Q");
            List holdList = this.list((Wrapper)queryWrapper);
            HashMap snmap = new HashMap();
            if (holdList != null && holdList.size() > 0) {
                holdList.forEach(hold -> {
                    if (hold.getHoldNum() != null) {
                        snmap.put(hold.getUnitCode(), hold.getHoldNum());
                    }
                });
            }
            pilotCount = pilotCount.stream().sorted((s1, s2) -> -s1.getWorkableScore().compareTo(s2.getWorkableScore())).collect(Collectors.toList());
            List snList = pilotCount.stream().collect(Collectors.groupingBy(BizScoringCountyWorkable::getWorkableScore)).entrySet().stream().sorted((s1, s2) -> -((BigDecimal)s1.getKey()).compareTo((BigDecimal)s2.getKey())).collect(Collectors.toList());
            Integer index = 1;
            for (Map.Entry entry : snList) {
                block3: for (BizScoringCountyWorkable workable : (List)entry.getValue()) {
                    workable.setWorkableAllSn(index);
                    if ((month == 3 || month == 6 || month == 9 || month == 12) && lastDay.getDayOfMonth() == countDate.getDayOfMonth()) {
                        if ((NO1List == null || NO1List.size() == 0) && index == 1) {
                            workable.setHoldNum(0);
                            continue;
                        }
                        if (NO1List == null || NO1List.size() <= 0 || index != 1) continue;
                        for (BizScoringCountyWorkable NO1 : NO1List) {
                            if (NO1.getUnitCode().equals(workable.getUnitCode())) {
                                workable.setHoldNum(NO1.getHoldNum() + 1);
                                continue block3;
                            }
                            workable.setHoldNum(0);
                        }
                        continue;
                    }
                    if (snmap.isEmpty()) continue;
                    workable.setHoldNum((Integer)snmap.get(workable.getUnitCode()));
                }
                index = index + ((List)entry.getValue()).size();
            }
            pilotCount = pilotCount.stream().sorted((s1, s2) -> -s1.getPassRate().compareTo(s2.getPassRate())).collect(Collectors.toList());
            List passSnList = pilotCount.stream().collect(Collectors.groupingBy(BizScoringCountyWorkable::getPassRate)).entrySet().stream().sorted((s1, s2) -> -((BigDecimal)s1.getKey()).compareTo((BigDecimal)s2.getKey())).collect(Collectors.toList());
            Integer passIndex = 1;
            for (Map.Entry entry : passSnList) {
                for (BizScoringCountyWorkable workable : (List)entry.getValue()) {
                    workable.setPassSn(passIndex);
                    if (passIndex <= 9) {
                        workable.setPassGrade("A");
                        continue;
                    }
                    if (17 >= passIndex && passIndex > 9) {
                        workable.setPassGrade("B");
                        continue;
                    }
                    if (25 >= passIndex && passIndex > 17) {
                        workable.setPassGrade("C");
                        continue;
                    }
                    if (33 >= passIndex && passIndex > 25) {
                        workable.setPassGrade("D");
                        continue;
                    }
                    if (passIndex <= 33) continue;
                    workable.setPassGrade("E");
                }
                passIndex = passIndex + ((List)entry.getValue()).size();
            }
            QueryWrapper delWrapper = new QueryWrapper();
            delWrapper.eq((Object)"FILL_DATE_", (Object)countDate);
            ((BizScoringCountyWorkableDao)this.baseMapper).delete((Wrapper)delWrapper);
            this.saveBatch(pilotCount);
        }
        return pilotCount;
    }

    public static String getFillType(LocalDate dateTime) {
        LocalDate lastDay;
        String type = "D";
        int month = dateTime.getMonthValue();
        int day = dateTime.getDayOfMonth();
        if (day == (lastDay = dateTime.with(TemporalAdjusters.lastDayOfMonth())).getDayOfMonth()) {
            type = "M";
            if (month == 3 || month == 6 || month == 9 || month == 12) {
                type = "Q";
            }
        }
        return type;
    }

    public static int getSeasonDay(LocalDate dateTime) {
        return Integer.valueOf(dateTime.getMonthValue() + 2) / 3;
    }
}

