/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.majorProjects.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.majorProjects.dao.PilotQuantitativeObjectivesPushDao;
import com.artfess.reform.majorProjects.dao.PilotSpecificSchedulePushDao;
import com.artfess.reform.majorProjects.manager.MunicipalMajorProjectManagementManager;
import com.artfess.reform.majorProjects.manager.PilotObjectivesDetailsManager;
import com.artfess.reform.majorProjects.manager.PilotProjectFillManager;
import com.artfess.reform.majorProjects.manager.PilotQuantitativeObjectivesManager;
import com.artfess.reform.majorProjects.manager.PilotQuantitativeObjectivesPushManager;
import com.artfess.reform.majorProjects.model.MouthFieldEnum;
import com.artfess.reform.majorProjects.model.MunicipalMajorProjectManagement;
import com.artfess.reform.majorProjects.model.PilotObjectivesDetails;
import com.artfess.reform.majorProjects.model.PilotProjectFill;
import com.artfess.reform.majorProjects.model.PilotQuantitativeObjectives;
import com.artfess.reform.majorProjects.model.PilotQuantitativeObjectivesPush;
import com.artfess.reform.majorProjects.vo.FillPushExamineVo;
import com.artfess.reform.majorProjects.vo.ObjectivesPushExamine;
import com.artfess.reform.majorProjects.vo.ObjectivesPushExamineAndProjectVo;
import com.artfess.reform.majorProjects.vo.PilotQuantitativeMonthPlanVo;
import com.artfess.reform.majorProjects.vo.PilotQuantitativeObjectivesPushVo;
import com.artfess.reform.majorProjects.vo.PilotQuantitativeTargetListVo;
import com.artfess.reform.majorProjects.vo.QuantitativeObjectivesPushFillQueryDetailVo;
import com.artfess.reform.majorProjects.vo.QuantitativeObjectivesPushFillQueryVo;
import com.artfess.reform.majorProjects.vo.QuantitativeObjectivesPushVo;
import com.artfess.reform.utils.BizUtils;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PilotQuantitativeObjectivesPushManagerImpl
extends BaseManagerImpl<PilotQuantitativeObjectivesPushDao, PilotQuantitativeObjectivesPush>
implements PilotQuantitativeObjectivesPushManager {
    @Resource
    private PilotQuantitativeObjectivesManager pilotQuantitativeObjectivesManager;
    @Resource
    private MunicipalMajorProjectManagementManager municipalMajorProjectManagementManager;
    @Resource
    private AchieveStatusLogManager achieveStatusLogManager;
    @Resource
    private PilotObjectivesDetailsManager pilotObjectivesDetailsManager;
    @Resource
    private SysDictionaryManager sysDictionaryManager;
    @Resource
    private PilotSpecificSchedulePushDao pilotSpecificSchedulePushDao;
    @Resource
    private PilotProjectFillManager pilotProjectFillManager;

    @Override
    public void objectivesPushSave(List<PilotQuantitativeObjectivesPush> pilotQuantitativeObjectivesPushList) {
        Assert.notNull(pilotQuantitativeObjectivesPushList, (String)"\u63a8\u8fdb\u60c5\u51b5\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        pilotQuantitativeObjectivesPushList.stream().forEach(p -> {
            String projectId = p.getProjectId();
            String objectivesMeasuresId = p.getObjectivesMeasuresId();
            Assert.notNull((Object)projectId, (String)"\u9879\u76eeID\u672a\u8bbe\u7f6e\uff0c\u8bf7\u5148\u8bbe\u7f6e\u9879\u76eeID\uff01");
            Assert.notNull((Object)objectivesMeasuresId, (String)"\u8fdb\u5ea6\u8ba1\u5212ID\u672a\u8bbe\u7f6e\uff0c\u8bf7\u5148\u8bbe\u7f6e\u8fdb\u5ea6\u8ba1\u5212ID\uff01");
            LocalDate pushDate = p.getPushDate();
            p.setPushDate(pushDate);
        });
        this.saveBatch(pilotQuantitativeObjectivesPushList);
    }

    @Override
    public void objectivesPushSaveSaveAndCommit(List<PilotQuantitativeObjectivesPush> pilotQuantitativeObjectivesPushList) {
        Assert.notNull(pilotQuantitativeObjectivesPushList, (String)"\u63a8\u8fdb\u60c5\u51b5\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        pilotQuantitativeObjectivesPushList.stream().forEach(p -> {
            String projectId = p.getProjectId();
            String objectivesMeasuresId = p.getObjectivesMeasuresId();
            Assert.notNull((Object)projectId, (String)"\u9879\u76eeID\u672a\u8bbe\u7f6e\uff0c\u8bf7\u5148\u8bbe\u7f6e\u9879\u76eeID\uff01");
            Assert.notNull((Object)objectivesMeasuresId, (String)"\u8fdb\u5ea6I\u8ba1\u5212D\u672a\u8bbe\u7f6e\uff0c\u8bf7\u5148\u8bbe\u7f6e\u8fdb\u5ea6\u8ba1\u5212ID\uff01");
        });
        this.saveOrUpdateBatch(pilotQuantitativeObjectivesPushList);
        List shzt = this.sysDictionaryManager.queryDictListItemsByCode("shzt");
        ArrayList<AchieveStatusLogAndAuditResultVo> logList = new ArrayList<AchieveStatusLogAndAuditResultVo>();
        pilotQuantitativeObjectivesPushList.stream().forEach(p -> {
            AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
            logVo.setBizId(p.getId());
            logVo.setModeType(6);
            logVo.setModuleTableName("BIZ_PILOT_QUANTITATIVE_OBJECTIVES_PUSH");
            logVo.setItemTitle("\u5e02\u7ea7\u91cd\u5927\u6539\u9769\u9879\u76ee\u3010\u6539\u9769\u65b9\u6848\u91cf\u5316\u76ee\u6807\u63a8\u8fdb\u60c5\u51b5\u3011\u63d0\u4ea4");
            logVo.setStatus("1");
            logVo.setOperateInfo(BizUtils.getDicValueByCode((List<DictModel>)shzt, 1));
            logVo.setApprovalResults(0);
            logVo.setCreateOrgId(ContextUtil.getCurrentOrgId());
            logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
            logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
            logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
            logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
            logVo.setOperateUserId(ContextUtil.getCurrentUserId());
            logVo.setOperateUserName(ContextUtil.getCurrentUserName());
            logVo.setOperateDate(LocalDateTime.now());
            logVo.setModeType(0);
            logVo.setPriority(0);
            logList.add(logVo);
        });
        this.achieveStatusLogManager.createAchieveStatusLogAndAuditResultBatch(logList);
    }

    @Override
    public void objectivesPushExamine(ObjectivesPushExamine objectivesPushExamine) {
        Assert.notNull((Object)objectivesPushExamine, (String)"\u63a8\u8fdb\u60c5\u51b5\u5ba1\u6838\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull(objectivesPushExamine.getIds(), (String)"\u63a8\u8fdb\u60c5\u51b5\u5ba1\u6838\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)objectivesPushExamine.getStatus(), (String)"\u63a8\u8fdb\u60c5\u51b5\u5ba1\u6838\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        UpdateWrapper pilotQuantitativeObjectivesPushUpdateWrapper = new UpdateWrapper();
        ((UpdateWrapper)pilotQuantitativeObjectivesPushUpdateWrapper.set((Object)"STATUS_", (Object)objectivesPushExamine.getStatus())).in((Object)"ID_", objectivesPushExamine.getIds());
        this.update((Wrapper)pilotQuantitativeObjectivesPushUpdateWrapper);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"id_", objectivesPushExamine.getIds());
        List list = this.list((Wrapper)queryWrapper);
        List shzt = this.sysDictionaryManager.queryDictListItemsByCode("shzt");
        ArrayList<AchieveStatusLogAndAuditResultVo> logList = new ArrayList<AchieveStatusLogAndAuditResultVo>();
        if (null != list && list.size() > 0) {
            for (PilotQuantitativeObjectivesPush pilotQuantitativeObjectivesPush : list) {
                String objectivesMeasuresId = pilotQuantitativeObjectivesPush.getObjectivesMeasuresId();
                PilotQuantitativeObjectives pilotQuantitativeObjectives = (PilotQuantitativeObjectives)this.pilotQuantitativeObjectivesManager.get((Serializable)((Object)objectivesMeasuresId));
                AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
                if (5 == objectivesPushExamine.getStatus()) {
                    LocalDate pushDate = pilotQuantitativeObjectivesPush.getPushDate();
                    if (null != pushDate) {
                        PilotObjectivesDetails pilotObjectivesDetails;
                        BigDecimal yearValue;
                        QueryWrapper pilotObjectivesDetailsQueryWrapper = new QueryWrapper();
                        ((QueryWrapper)pilotObjectivesDetailsQueryWrapper.eq((Object)"YEAR_", (Object)pushDate.getYear())).eq((Object)"OBJECTIVES_ID_", (Object)objectivesMeasuresId);
                        List pilotObjectivesDetailsList = this.pilotObjectivesDetailsManager.list((Wrapper)pilotObjectivesDetailsQueryWrapper);
                        if (null != pilotObjectivesDetailsList && pilotObjectivesDetailsList.size() > 0 && null != (yearValue = (pilotObjectivesDetails = (PilotObjectivesDetails)((Object)pilotObjectivesDetailsList.get(0))).getYearValue()) && pilotQuantitativeObjectivesPush.getPushProgress() != null) {
                            if (yearValue.compareTo(BigDecimal.ZERO) == 0) {
                                pilotQuantitativeObjectives.setComplianceRate(BigDecimal.ZERO);
                            } else {
                                BigDecimal complianceRate = pilotQuantitativeObjectivesPush.getPushProgress().divide(yearValue, 4, 4);
                                UpdateWrapper pilotQuantitativeObjectivesUpdateWrapper = new UpdateWrapper();
                                ((UpdateWrapper)pilotQuantitativeObjectivesUpdateWrapper.set((Object)"COMPLIANCE_RATE_", (Object)complianceRate.stripTrailingZeros())).set((Object)"REFORM_QUANTITATIVE_OBJECTIVES_VALUE_", (Object)pilotQuantitativeObjectivesPush.getPushProgress());
                                if (pilotQuantitativeObjectivesPush.getPushProgress().compareTo(yearValue) == 0 || pilotQuantitativeObjectivesPush.getPushProgress().compareTo(yearValue) > 0) {
                                    pilotQuantitativeObjectivesUpdateWrapper.set((Object)"PROGRESS_STATUS_", (Object)3);
                                }
                                pilotQuantitativeObjectivesUpdateWrapper.eq((Object)"ID_", (Object)pilotQuantitativeObjectives.getId());
                                this.pilotQuantitativeObjectivesManager.update((Wrapper)pilotQuantitativeObjectivesUpdateWrapper);
                            }
                        }
                    }
                    logVo.setFinish(true);
                } else {
                    UpdateWrapper pilotQuantitativeObjectivesUpdateWrapper = new UpdateWrapper();
                    ((UpdateWrapper)pilotQuantitativeObjectivesUpdateWrapper.set((Object)"PROGRESS_STATUS_", (Object)2)).eq((Object)"ID_", (Object)pilotQuantitativeObjectives.getId());
                    this.pilotQuantitativeObjectivesManager.update((Wrapper)pilotQuantitativeObjectivesUpdateWrapper);
                }
                logVo.setBizId(pilotQuantitativeObjectivesPush.getId());
                logVo.setModeType(6);
                logVo.setModuleTableName("BIZ_PILOT_QUANTITATIVE_OBJECTIVES_PUSH");
                logVo.setItemTitle("\u5e02\u7ea7\u91cd\u5927\u6539\u9769\u9879\u76ee\u3010\u6539\u9769\u65b9\u6848\u91cf\u5316\u76ee\u6807\u63a8\u8fdb\u60c5\u51b5\u3011\u5ba1\u6838");
                logVo.setStatus(String.valueOf(objectivesPushExamine.getStatus()));
                logVo.setOperateInfo(BizUtils.getDicValueByCode((List<DictModel>)shzt, objectivesPushExamine.getStatus()));
                logVo.setApprovalResults(0);
                logVo.setCreateOrgId(ContextUtil.getCurrentOrgId());
                logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
                logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
                logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
                logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
                logVo.setOperateUserId(ContextUtil.getCurrentUserId());
                logVo.setOperateUserName(ContextUtil.getCurrentUserName());
                logVo.setOperateDate(LocalDateTime.now());
                logVo.setModeType(0);
                logVo.setPriority(0);
                logVo.setApprovalComments(objectivesPushExamine.getApprovalComments());
                logList.add(logVo);
            }
            this.achieveStatusLogManager.createAchieveStatusLogAndAuditResultBatch(logList);
        }
    }

    @Override
    public PageList<ObjectivesPushExamineAndProjectVo> objectivesPushListByPage(QueryFilter<PilotQuantitativeObjectivesPush> queryFilter) {
        ArrayList<ObjectivesPushExamineAndProjectVo> listVo = new ArrayList<ObjectivesPushExamineAndProjectVo>();
        PageList pageList = this.query(queryFilter);
        List list = pageList.getRows();
        HashMap<String, MunicipalMajorProjectManagement> projectMap = new HashMap<String, MunicipalMajorProjectManagement>();
        HashMap<String, PilotQuantitativeObjectives> objectivesMap = new HashMap<String, PilotQuantitativeObjectives>();
        if (null != list && list.size() > 0) {
            for (PilotQuantitativeObjectivesPush pilotQuantitativeObjectivesPush : list) {
                MunicipalMajorProjectManagement municipalMajorProjectManagement;
                ObjectivesPushExamineAndProjectVo vo = new ObjectivesPushExamineAndProjectVo();
                vo.setPilotQuantitativeObjectivesPush(pilotQuantitativeObjectivesPush);
                String objectivesMeasuresId = pilotQuantitativeObjectivesPush.getObjectivesMeasuresId();
                PilotQuantitativeObjectives pilotQuantitativeObjectives = (PilotQuantitativeObjectives)((Object)objectivesMap.get(objectivesMeasuresId));
                if (null == pilotQuantitativeObjectives) {
                    pilotQuantitativeObjectives = (PilotQuantitativeObjectives)this.pilotQuantitativeObjectivesManager.get((Serializable)((Object)objectivesMeasuresId));
                    QueryWrapper pilotObjectivesDetailsQueryWrapper = new QueryWrapper();
                    ((QueryWrapper)pilotObjectivesDetailsQueryWrapper.eq((Object)"YEAR_", (Object)LocalDate.now().getYear())).eq((Object)"OBJECTIVES_ID_", (Object)objectivesMeasuresId);
                    List pilotObjectivesDetailsList = this.pilotObjectivesDetailsManager.list((Wrapper)pilotObjectivesDetailsQueryWrapper);
                    if (null != pilotObjectivesDetailsList && pilotObjectivesDetailsList.size() > 0) {
                        pilotQuantitativeObjectives.setReformQuantitativeObjectives(((PilotObjectivesDetails)((Object)pilotObjectivesDetailsList.get(0))).getYearValue().toPlainString());
                    }
                    objectivesMap.put(objectivesMeasuresId, pilotQuantitativeObjectives);
                }
                vo.setPilotQuantitativeObjectives(pilotQuantitativeObjectives);
                String projectId = "";
                if (null != pilotQuantitativeObjectives) {
                    projectId = pilotQuantitativeObjectives.getProjectId();
                }
                if (StringUtils.isBlank((CharSequence)projectId)) {
                    projectId = pilotQuantitativeObjectivesPush.getProjectId();
                }
                if (null == (municipalMajorProjectManagement = (MunicipalMajorProjectManagement)((Object)projectMap.get(projectId)))) {
                    municipalMajorProjectManagement = (MunicipalMajorProjectManagement)this.municipalMajorProjectManagementManager.get((Serializable)((Object)projectId));
                    projectMap.put(projectId, municipalMajorProjectManagement);
                }
                vo.setMunicipalMajorProjectManagement(municipalMajorProjectManagement);
                listVo.add(vo);
            }
        }
        PageList result = new PageList();
        result.setRows(listVo);
        result.setPage(pageList.getPage());
        result.setPageSize(pageList.getPageSize());
        result.setTotal(pageList.getTotal());
        return result;
    }

    @Override
    public List<PilotQuantitativeObjectivesPushVo> queryListByFillId(String fileId, String projectId, String isHis) {
        return this.pilotSpecificSchedulePushDao.queryListByFillId(fileId, projectId, isHis);
    }

    @Override
    public List<PilotQuantitativeTargetListVo> queryTargetListByFillYearMonth(Integer fillYear, Integer fillMonth) {
        Calendar calendar;
        String monthValueFieldName = "";
        if (fillMonth > 12 || fillMonth < 1) {
            calendar = Calendar.getInstance();
            fillMonth = calendar.get(2) + 1;
        }
        if (fillYear == null) {
            calendar = Calendar.getInstance();
            fillYear = calendar.get(1);
        }
        if (fillMonth == 1) {
            monthValueFieldName = "JAN_VALUE_";
        } else if (fillMonth == 2) {
            monthValueFieldName = "FEB_VALUE_";
        } else if (fillMonth == 3) {
            monthValueFieldName = "MAR_VALUE_";
        } else if (fillMonth == 4) {
            monthValueFieldName = "APR_VALUE_";
        } else if (fillMonth == 5) {
            monthValueFieldName = "MAY_VALUE_";
        } else if (fillMonth == 6) {
            monthValueFieldName = "JUN_VALUE_";
        } else if (fillMonth == 7) {
            monthValueFieldName = "JUL_VALUE_";
        } else if (fillMonth == 8) {
            monthValueFieldName = "AUG_VALUE_";
        } else if (fillMonth == 9) {
            monthValueFieldName = "SEP_VALUE_";
        } else if (fillMonth == 10) {
            monthValueFieldName = "OCT_VALUE_";
        } else if (fillMonth == 11) {
            monthValueFieldName = "NOV_VALUE_";
        } else if (fillMonth == 12) {
            monthValueFieldName = "DEC_VALUE_";
        }
        return this.pilotSpecificSchedulePushDao.queryTargetListByFillYearMonth(fillYear, fillMonth, monthValueFieldName);
    }

    @Override
    public List<PilotQuantitativeMonthPlanVo> queryMonthPlanListByFillYearMonth(Integer fillYear, Integer fillMonth) {
        Calendar calendar;
        if (fillMonth > 12 || fillMonth < 1) {
            calendar = Calendar.getInstance();
            fillMonth = calendar.get(2) + 1;
        }
        if (fillYear == null) {
            calendar = Calendar.getInstance();
            fillYear = calendar.get(1);
        }
        return this.pilotSpecificSchedulePushDao.queryMonthPlanListByFillYearMonth(fillYear, fillMonth);
    }

    @Override
    @Transactional
    public void quantitativeObjectivesPushSave(QuantitativeObjectivesPushVo quantitativeObjectivesPushVo) {
        Assert.notNull((Object)quantitativeObjectivesPushVo, (String)"\u63a8\u8fdb\u60c5\u51b5\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull(quantitativeObjectivesPushVo.getPilotQuantitativeObjectivesPushList(), (String)"\u63a8\u8fdb\u60c5\u51b5\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)((Object)quantitativeObjectivesPushVo.getPilotProjectFill()), (String)"\u586b\u62a5\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)quantitativeObjectivesPushVo.getPilotProjectFill().getProjectId(), (String)"\u586b\u62a5\u6570\u636e\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        PilotProjectFill pilotProjectFill = quantitativeObjectivesPushVo.getPilotProjectFill();
        if (pilotProjectFill == null) {
            pilotProjectFill = new PilotProjectFill();
        }
        if (pilotProjectFill.getFillDate() == null) {
            pilotProjectFill.setFillDate(LocalDate.now());
        }
        pilotProjectFill.setFillYear(pilotProjectFill.getFillDate().getYear());
        pilotProjectFill.setFillMonth(pilotProjectFill.getFillDate().getMonthValue());
        int quarter = (pilotProjectFill.getFillDate().getMonthValue() - 1) / 3 + 1;
        pilotProjectFill.setFillQuarter(quarter);
        if (StringUtils.isBlank((CharSequence)pilotProjectFill.getUnitId())) {
            pilotProjectFill.setUnitId(ContextUtil.getCurrentOrgId());
            pilotProjectFill.setUnitCode(ContextUtil.getCurrentOrgCode());
            pilotProjectFill.setUnitName(ContextUtil.getCurrentOrgName());
            pilotProjectFill.setUnitGrade(ContextUtil.getCurrentGrade());
        }
        pilotProjectFill.setStatus(0);
        pilotProjectFill.setFlowType(1);
        this.pilotProjectFillManager.saveOrUpdate((Object)pilotProjectFill);
        List<PilotQuantitativeObjectivesPush> pilotQuantitativeObjectivesPushList = quantitativeObjectivesPushVo.getPilotQuantitativeObjectivesPushList();
        for (PilotQuantitativeObjectivesPush p : pilotQuantitativeObjectivesPushList) {
            String projectId = p.getProjectId();
            String objectivesMeasuresId = p.getObjectivesMeasuresId();
            if (StringUtils.isBlank((CharSequence)projectId)) {
                p.setProjectId(pilotProjectFill.getProjectId());
            }
            Assert.notNull((Object)objectivesMeasuresId, (String)"\u91cf\u5316\u76ee\u6807ID\u672a\u8bbe\u7f6e\uff0c\u8bf7\u5148\u8bbe\u7f6e\u91cf\u5316\u76ee\u6807ID\uff01");
            LocalDate pushDate = p.getPushDate();
            if (null != pushDate) {
                BigDecimal detailsMonthValue;
                BigDecimal divide;
                BigDecimal pushProgress = p.getPushProgress();
                Integer pushYear = pushDate.getYear();
                if (null != pushYear && StringUtils.isNotBlank((CharSequence)objectivesMeasuresId) && pushProgress != null) {
                    BigDecimal detailsYearValue = this.pilotObjectivesDetailsManager.getYearValue(pushYear, objectivesMeasuresId);
                    if (null != detailsYearValue && detailsYearValue.compareTo(new BigDecimal(0)) == 1) {
                        divide = pushProgress.divide(detailsYearValue, 4, 4);
                        p.setComplianceRate(divide);
                    } else {
                        p.setComplianceRate(new BigDecimal(100));
                    }
                }
                if (null != (detailsMonthValue = this.pilotObjectivesDetailsManager.getMonthValue(pushYear, pushDate.getMonthValue(), objectivesMeasuresId)) && detailsMonthValue.compareTo(new BigDecimal(0)) == 1) {
                    divide = pushProgress.divide(detailsMonthValue, 4, 4).multiply(new BigDecimal(100));
                    p.setMonthRate(divide);
                } else {
                    p.setComplianceRate(new BigDecimal(100));
                }
            }
            p.setFillId(pilotProjectFill.getId());
            p.setIsDele("0");
        }
        this.saveOrUpdateBatch(pilotQuantitativeObjectivesPushList);
    }

    @Override
    @Transactional
    public void quantitativeObjectivesPushSaveSaveAndCommit(QuantitativeObjectivesPushVo quantitativeObjectivesPushVo) {
        Assert.notNull((Object)quantitativeObjectivesPushVo, (String)"\u63a8\u8fdb\u60c5\u51b5\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull(quantitativeObjectivesPushVo.getPilotQuantitativeObjectivesPushList(), (String)"\u63a8\u8fdb\u60c5\u51b5\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)((Object)quantitativeObjectivesPushVo.getPilotProjectFill()), (String)"\u586b\u62a5\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)quantitativeObjectivesPushVo.getPilotProjectFill().getProjectId(), (String)"\u586b\u62a5\u6570\u636e\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        PilotProjectFill pilotProjectFill = quantitativeObjectivesPushVo.getPilotProjectFill();
        if (pilotProjectFill == null) {
            pilotProjectFill = new PilotProjectFill();
        }
        if (pilotProjectFill.getFillDate() == null) {
            pilotProjectFill.setFillDate(LocalDate.now());
        }
        pilotProjectFill.setFillYear(pilotProjectFill.getFillDate().getYear());
        pilotProjectFill.setFillMonth(pilotProjectFill.getFillDate().getMonthValue());
        int quarter = (pilotProjectFill.getFillDate().getMonthValue() - 1) / 3 + 1;
        pilotProjectFill.setFillQuarter(quarter);
        if (StringUtils.isBlank((CharSequence)pilotProjectFill.getUnitId())) {
            pilotProjectFill.setUnitId(ContextUtil.getCurrentOrgId());
            pilotProjectFill.setUnitCode(ContextUtil.getCurrentOrgCode());
            pilotProjectFill.setUnitName(ContextUtil.getCurrentOrgName());
            pilotProjectFill.setUnitGrade(ContextUtil.getCurrentGrade());
        }
        pilotProjectFill.setStatus(1);
        pilotProjectFill.setFlowType(1);
        this.pilotProjectFillManager.saveOrUpdate((Object)pilotProjectFill);
        List<PilotQuantitativeObjectivesPush> pilotQuantitativeObjectivesPushList = quantitativeObjectivesPushVo.getPilotQuantitativeObjectivesPushList();
        for (PilotQuantitativeObjectivesPush p : pilotQuantitativeObjectivesPushList) {
            String projectId = p.getProjectId();
            String objectivesMeasuresId = p.getObjectivesMeasuresId();
            if (StringUtils.isBlank((CharSequence)projectId)) {
                p.setProjectId(pilotProjectFill.getProjectId());
            }
            Assert.notNull((Object)objectivesMeasuresId, (String)"\u91cf\u5316\u76ee\u6807ID\u672a\u8bbe\u7f6e\uff0c\u8bf7\u5148\u8bbe\u7f6e\u91cf\u5316\u76ee\u6807ID\uff01");
            LocalDate pushDate = p.getPushDate();
            if (null != pushDate) {
                BigDecimal pushProgress = p.getPushProgress();
                Integer pushYear = pushDate.getYear();
                if (null != pushYear && StringUtils.isNotBlank((CharSequence)objectivesMeasuresId) && pushProgress != null) {
                    BigDecimal detailsYearValue = this.pilotObjectivesDetailsManager.getYearValue(pushYear, objectivesMeasuresId);
                    if (null != detailsYearValue && detailsYearValue.compareTo(new BigDecimal(0)) == 1) {
                        BigDecimal divide = pushProgress.divide(detailsYearValue, 4, 4).multiply(new BigDecimal(100));
                        p.setComplianceRate(divide);
                    } else {
                        p.setComplianceRate(new BigDecimal(100));
                    }
                    BigDecimal detailsMonthValue = this.pilotObjectivesDetailsManager.getMonthValue(pushYear, pushDate.getMonthValue(), objectivesMeasuresId);
                    if (null != detailsMonthValue && detailsMonthValue.compareTo(new BigDecimal(0)) == 1) {
                        BigDecimal divide = pushProgress.divide(detailsMonthValue, 4, 4).multiply(new BigDecimal(100));
                        p.setMonthRate(divide);
                    } else {
                        p.setComplianceRate(new BigDecimal(100));
                    }
                }
            }
            p.setFillId(pilotProjectFill.getId());
            p.setIsDele("0");
        }
        this.saveOrUpdateBatch(pilotQuantitativeObjectivesPushList);
        pilotProjectFill.setApprovalComments("\u63d0\u4ea4\u6570\u636e");
        this.pilotProjectFillManager.createLog(pilotProjectFill, "\u5e02\u7ea7\u91cd\u5927\u9879\u76ee\u91cf\u5316\u76ee\u6807\u63a8\u8fdb");
    }

    @Override
    public void quantitativeObjectivesPushExamine(FillPushExamineVo fillPushExamineVo) {
        this.pilotProjectFillManager.examineVo(fillPushExamineVo);
    }

    @Override
    public PageList<QuantitativeObjectivesPushFillQueryVo> quantitativeObjectivesPushListByPage(QueryFilter<PilotProjectFill> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("FLOW_TYPE_", (Object)1, QueryOP.EQUAL);
        return this.pilotProjectFillManager.queyrQuantitativeObjectivesPushFillList(queryFilter);
    }

    @Override
    public QuantitativeObjectivesPushFillQueryDetailVo getDetails(String id) {
        List<PilotQuantitativeObjectivesPushVo> pilotQuantitativeObjectivesPushList;
        Assert.notNull((Object)id, (String)"\u6761\u4ef6\u683c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        QuantitativeObjectivesPushFillQueryDetailVo pilotProjectFillQueryVo = new QuantitativeObjectivesPushFillQueryDetailVo();
        PilotProjectFill pilotProjectFill = (PilotProjectFill)this.pilotProjectFillManager.get((Serializable)((Object)id));
        pilotProjectFillQueryVo.setPilotProjectFill(pilotProjectFill);
        if (null != pilotProjectFill) {
            if (pilotProjectFill.getStatus() == 2 || pilotProjectFill.getStatus() == 4) {
                AchieveStatusLog log = this.achieveStatusLogManager.queryAchieveStatusLogByBizIdAndStatus(pilotProjectFill.getId(), pilotProjectFill.getStatus());
                pilotProjectFill.setApprovalComments(log.getApprovalComments());
            }
            MunicipalMajorProjectManagement municipalMajorProjectManagement = this.municipalMajorProjectManagementManager.getMunicipalMajorProjectManagement((Serializable)((Object)pilotProjectFill.getProjectId()));
            pilotProjectFillQueryVo.setMunicipalMajorProjectManagement(municipalMajorProjectManagement);
            pilotQuantitativeObjectivesPushList = this.queryListByFillId(pilotProjectFill.getId(), pilotProjectFill.getProjectId(), "false");
            LocalDate fillDate = pilotProjectFill.getFillDate();
            if (null != pilotQuantitativeObjectivesPushList && pilotQuantitativeObjectivesPushList.size() > 0 && null != fillDate) {
                pilotQuantitativeObjectivesPushList.stream().forEach(p -> {
                    List pilotObjectivesDetails = this.pilotObjectivesDetailsManager.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"OBJECTIVES_ID_", (Object)p.getObjectivesMeasuresId())).eq((Object)"YEAR_", (Object)fillDate.getYear()));
                    if (null != pilotObjectivesDetails && pilotObjectivesDetails.size() > 0) {
                        PilotObjectivesDetails pilotObjectivesDetails1 = (PilotObjectivesDetails)((Object)((Object)pilotObjectivesDetails.get(0)));
                        p.setReformQuantitativeObjectivesYear(pilotObjectivesDetails1.getYearValue().toPlainString());
                        Map map = BeanUtils.beanToMap((Object)((Object)pilotObjectivesDetails1));
                        Object o = map.get(MouthFieldEnum.getDescByCode(String.valueOf(fillDate.getMonthValue())));
                        if (null != o) {
                            BigDecimal mouthValue = (BigDecimal)o;
                            p.setReformQuantitativeObjectivesMouth(mouthValue.toPlainString());
                        }
                    }
                });
            }
        } else {
            throw new BaseException("\u672a\u627e\u5230\u76f8\u5173\u5ba1\u6838\u4fe1\u606f");
        }
        pilotProjectFillQueryVo.setPilotQuantitativeObjectivesPushList(pilotQuantitativeObjectivesPushList);
        return pilotProjectFillQueryVo;
    }

    @Override
    public QuantitativeObjectivesPushFillQueryDetailVo getHistoryDetails(String projectId, LocalDate fillDate) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        if (null == fillDate) {
            fillDate = LocalDate.now();
        }
        QuantitativeObjectivesPushFillQueryDetailVo pilotProjectFillQueryVo = new QuantitativeObjectivesPushFillQueryDetailVo();
        PilotProjectFill historyPilotProjectFill = this.pilotProjectFillManager.getHistoryPilotProjectFill(projectId, 1, fillDate);
        pilotProjectFillQueryVo.setPilotProjectFillHistory(historyPilotProjectFill);
        if (null != historyPilotProjectFill) {
            if (historyPilotProjectFill.getStatus() == 2 || historyPilotProjectFill.getStatus() == 4) {
                AchieveStatusLog log = this.achieveStatusLogManager.queryAchieveStatusLogByBizIdAndStatus(historyPilotProjectFill.getId(), historyPilotProjectFill.getStatus());
                historyPilotProjectFill.setApprovalComments(log.getApprovalComments());
            }
            List<PilotQuantitativeObjectivesPushVo> pilotQuantitativeObjectivesPushHistoryList = this.queryListByFillId(historyPilotProjectFill.getId(), historyPilotProjectFill.getProjectId(), "true");
            LocalDate historyFillDate = historyPilotProjectFill.getFillDate();
            if (null != pilotQuantitativeObjectivesPushHistoryList && pilotQuantitativeObjectivesPushHistoryList.size() > 0 && null != fillDate) {
                pilotQuantitativeObjectivesPushHistoryList.stream().forEach(p -> {
                    List pilotObjectivesDetails = this.pilotObjectivesDetailsManager.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"OBJECTIVES_ID_", (Object)p.getObjectivesMeasuresId())).eq((Object)"YEAR_", (Object)historyFillDate.getYear()));
                    if (null != pilotObjectivesDetails && pilotObjectivesDetails.size() > 0) {
                        PilotObjectivesDetails pilotObjectivesDetails1 = (PilotObjectivesDetails)((Object)((Object)pilotObjectivesDetails.get(0)));
                        p.setReformQuantitativeObjectivesYear(pilotObjectivesDetails1.getYearValue().toPlainString());
                        Map map = BeanUtils.beanToMap((Object)((Object)pilotObjectivesDetails1));
                        Object o = map.get(MouthFieldEnum.getDescByCode(String.valueOf(historyFillDate.getMonthValue())));
                        if (null != o) {
                            BigDecimal mouthValue = (BigDecimal)o;
                            p.setReformQuantitativeObjectivesMouth(mouthValue.toPlainString());
                        }
                    }
                });
            }
            pilotProjectFillQueryVo.setPilotQuantitativeObjectivesPushHistoryList(pilotQuantitativeObjectivesPushHistoryList);
        }
        return pilotProjectFillQueryVo;
    }

    @Override
    public void quantitativeObjectivesPushCommit(String id) {
        Assert.notNull((Object)id, (String)"\u586b\u62a5ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        PilotProjectFill pilotProjectFill = (PilotProjectFill)this.pilotProjectFillManager.get((Serializable)((Object)id));
        if (pilotProjectFill == null) {
            throw new BaseException("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u586b\u62a5\u6570\u636e\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01");
        }
        if (pilotProjectFill.getFillDate() == null) {
            pilotProjectFill.setFillDate(LocalDate.now());
        }
        pilotProjectFill.setFillYear(pilotProjectFill.getFillDate().getYear());
        pilotProjectFill.setFillMonth(pilotProjectFill.getFillDate().getMonthValue());
        int quarter = (pilotProjectFill.getFillDate().getMonthValue() - 1) / 3 + 1;
        pilotProjectFill.setFillQuarter(quarter);
        if (StringUtils.isBlank((CharSequence)pilotProjectFill.getUnitId())) {
            pilotProjectFill.setUnitId(ContextUtil.getCurrentOrgId());
            pilotProjectFill.setUnitCode(ContextUtil.getCurrentOrgCode());
            pilotProjectFill.setUnitName(ContextUtil.getCurrentOrgName());
            pilotProjectFill.setUnitGrade(ContextUtil.getCurrentGrade());
        }
        pilotProjectFill.setStatus(1);
        pilotProjectFill.setFlowType(1);
        this.pilotProjectFillManager.saveOrUpdate((Object)pilotProjectFill);
    }

    @Override
    public int countQuantitativeObjectivesPush(String id) {
        Assert.notNull((Object)id, (String)"\u91cf\u5316\u76ee\u6807ID");
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"OBJECTIVES_MEASURES_ID_", (Object)id)).eq((Object)"IS_DELE_", (Object)0);
        return this.count((Wrapper)queryWrapper);
    }
}

