/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.majorProjects.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.majorProjects.dao.PilotQuantitativeObjectivesDao;
import com.artfess.reform.majorProjects.manager.PilotObjectivesDetailsManager;
import com.artfess.reform.majorProjects.manager.PilotQuantitativeObjectivesManager;
import com.artfess.reform.majorProjects.manager.PilotQuantitativeObjectivesPushManager;
import com.artfess.reform.majorProjects.model.MouthFieldEnum;
import com.artfess.reform.majorProjects.model.PilotObjectivesDetails;
import com.artfess.reform.majorProjects.model.PilotQuantitativeObjectives;
import com.artfess.reform.majorProjects.model.PilotQuantitativeObjectivesPush;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class PilotQuantitativeObjectivesManagerImpl
extends BaseManagerImpl<PilotQuantitativeObjectivesDao, PilotQuantitativeObjectives>
implements PilotQuantitativeObjectivesManager {
    @Resource
    private PilotQuantitativeObjectivesPushManager pilotQuantitativeObjectivesPushManager;
    @Resource
    private PilotObjectivesDetailsManager pilotObjectivesDetailsManager;

    @Override
    public void removeByProjectId(String projectId) {
        super.remove((Wrapper)new QueryWrapper().eq((Object)"PROJECT_ID_", (Object)projectId));
        this.pilotQuantitativeObjectivesPushManager.remove((Wrapper)new QueryWrapper().eq((Object)"PROJECT_ID_", (Object)projectId));
    }

    @Override
    public boolean saveBatch(List<PilotQuantitativeObjectives> entityList) {
        boolean b = super.saveBatch(entityList);
        for (PilotQuantitativeObjectives pilotQuantitativeObjectives : entityList) {
            List<PilotQuantitativeObjectivesPush> pilotQuantitativeObjectivesPushList = pilotQuantitativeObjectives.getPilotQuantitativeObjectivesPushList();
            if (null == pilotQuantitativeObjectivesPushList || pilotQuantitativeObjectivesPushList.size() <= 0) continue;
            pilotQuantitativeObjectivesPushList.stream().forEach(p -> {
                p.setObjectivesMeasuresId(pilotQuantitativeObjectives.getId());
                p.setProjectId(pilotQuantitativeObjectives.getProjectId());
                p.setLastTime(new Date().getTime());
            });
            this.pilotQuantitativeObjectivesPushManager.saveBatch(pilotQuantitativeObjectivesPushList);
        }
        return b;
    }

    public boolean saveOrUpdate(PilotQuantitativeObjectives pilotQuantitativeObjectives) {
        boolean b = super.saveOrUpdate((Object)pilotQuantitativeObjectives);
        List<PilotQuantitativeObjectivesPush> pilotQuantitativeObjectivesPushList = pilotQuantitativeObjectives.getPilotQuantitativeObjectivesPushList();
        if (null != pilotQuantitativeObjectivesPushList && pilotQuantitativeObjectivesPushList.size() > 0) {
            pilotQuantitativeObjectivesPushList.stream().forEach(p -> {
                p.setObjectivesMeasuresId(pilotQuantitativeObjectives.getId());
                p.setProjectId(pilotQuantitativeObjectives.getProjectId());
                p.setLastTime(new Date().getTime());
            });
            this.pilotQuantitativeObjectivesPushManager.saveOrUpdateBatch(pilotQuantitativeObjectivesPushList);
        }
        return b;
    }

    @Override
    public List<PilotQuantitativeObjectives> queryListByProjectId(String projectId) {
        List list = super.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROJECT_ID_", (Object)projectId)).eq((Object)"IS_DELE_", (Object)"0"));
        if (null != list && list.size() > 0) {
            for (PilotQuantitativeObjectives pilotQuantitativeObjectives : list) {
                List pilotQuantitativeObjectivesPushList = this.pilotQuantitativeObjectivesPushManager.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"OBJECTIVES_MEASURES_ID_", (Object)pilotQuantitativeObjectives.getId())).eq((Object)"IS_DELE_", (Object)"0"));
                pilotQuantitativeObjectives.setPilotQuantitativeObjectivesPushList(pilotQuantitativeObjectivesPushList);
                List pilotObjectivesDetails = this.pilotObjectivesDetailsManager.list((Wrapper)new QueryWrapper().eq((Object)"OBJECTIVES_ID_", (Object)pilotQuantitativeObjectives.getId()));
                pilotQuantitativeObjectives.setPilotObjectivesDetailsList(pilotObjectivesDetails);
            }
        }
        return list;
    }

    @Override
    public List<PilotQuantitativeObjectives> queryPilotQuantitativeObjectivesListByProjectId(String projectId) {
        List list = super.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROJECT_ID_", (Object)projectId)).eq((Object)"IS_DELE_", (Object)"0"));
        if (null != list && list.size() > 0) {
            for (PilotQuantitativeObjectives pilotQuantitativeObjectives : list) {
                List pilotObjectivesDetails = this.pilotObjectivesDetailsManager.list((Wrapper)new QueryWrapper().eq((Object)"OBJECTIVES_ID_", (Object)pilotQuantitativeObjectives.getId()));
                pilotQuantitativeObjectives.setPilotObjectivesDetailsList(pilotObjectivesDetails);
            }
        }
        return list;
    }

    @Override
    public List<PilotQuantitativeObjectives> queryListByProjectId(String projectId, LocalDate fillDate) {
        List list;
        if (null == fillDate) {
            fillDate = LocalDate.now();
        }
        if (null != (list = super.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROJECT_ID_", (Object)projectId)).eq((Object)"IS_DELE_", (Object)"0"))) && list.size() > 0) {
            for (PilotQuantitativeObjectives pilotQuantitativeObjectives : list) {
                List pilotObjectivesDetails = this.pilotObjectivesDetailsManager.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"OBJECTIVES_ID_", (Object)pilotQuantitativeObjectives.getId())).eq((Object)"YEAR_", (Object)fillDate.getYear()));
                pilotQuantitativeObjectives.setPilotObjectivesDetailsList(pilotObjectivesDetails);
                if (null == pilotObjectivesDetails || pilotObjectivesDetails.size() <= 0) continue;
                PilotObjectivesDetails pilotObjectivesDetails1 = (PilotObjectivesDetails)((Object)pilotObjectivesDetails.get(0));
                pilotQuantitativeObjectives.setReformQuantitativeObjectivesYear(pilotObjectivesDetails1.getYearValue().toPlainString());
                try {
                    Map map = PilotQuantitativeObjectivesManagerImpl.beanToMap((Object)pilotObjectivesDetails1);
                    Object o = map.get(MouthFieldEnum.getDescByCode(String.valueOf(fillDate.getMonthValue())));
                    if (null == o) continue;
                    BigDecimal mouthValue = (BigDecimal)o;
                    pilotQuantitativeObjectives.setReformQuantitativeObjectivesMouth(mouthValue.toPlainString());
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    public static Map beanToMap(Object object) throws IllegalAccessException {
        Field[] fields;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            map.put(field.getName(), field.get(object));
        }
        return map;
    }
}

