/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.majorProjects.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.majorProjects.dao.PilotMeasuresPushDao;
import com.artfess.reform.majorProjects.manager.PilotMeasuresPushManager;
import com.artfess.reform.majorProjects.model.PilotMeasuresPush;
import com.artfess.reform.majorProjects.model.PilotProjectFill;
import com.artfess.reform.majorProjects.vo.PilotMeasuresPushVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class BizPilotMeasuresPushManagerImpl
extends BaseManagerImpl<PilotMeasuresPushDao, PilotMeasuresPush>
implements PilotMeasuresPushManager {
    @Resource
    private PilotMeasuresPushDao pilotMeasuresPushDao;
    @Resource
    private FileManager fileManager;

    @Override
    public List<PilotMeasuresPushVo> queryListByFillId(String fillId, String projectId, String isHis) {
        List<PilotMeasuresPushVo> pilotMeasuresPushVoList = this.pilotMeasuresPushDao.queryListByFillId(fillId, projectId, isHis);
        if (null != pilotMeasuresPushVoList && pilotMeasuresPushVoList.size() > 0) {
            for (PilotMeasuresPushVo p : pilotMeasuresPushVoList) {
                p.setDefaultFileList(this.fileManager.queryFileByBizId(p.getId(), "ProjectPlanPush"));
            }
        }
        return pilotMeasuresPushVoList;
    }

    public boolean saveOrUpdateBatch(Collection<PilotMeasuresPush> list) {
        boolean b = super.saveOrUpdateBatch(list);
        if (null != list && list.size() > 0) {
            list.stream().forEach(p -> {
                List<DefaultFile> defaultFileList = p.getDefaultFileList();
                if (null != defaultFileList && defaultFileList.size() > 0) {
                    List fileList = defaultFileList.stream().map(f -> f.getId()).collect(Collectors.toList());
                    this.fileManager.updateFileBizIdByIds(fileList, p.getId(), "ProjectPlanPush");
                }
            });
        }
        return b;
    }

    public boolean saveOrUpdate(PilotMeasuresPush entity) {
        boolean b = super.saveOrUpdate((Object)entity);
        List<DefaultFile> defaultFileList = entity.getDefaultFileList();
        if (null != defaultFileList && defaultFileList.size() > 0) {
            List fileList = defaultFileList.stream().map(f -> f.getId()).collect(Collectors.toList());
            this.fileManager.updateFileBizIdByIds(fileList, entity.getId(), "ProjectPlanPush");
        }
        return b;
    }

    public boolean save(PilotMeasuresPush entity) {
        boolean b = super.save((Object)entity);
        List<DefaultFile> defaultFileList = entity.getDefaultFileList();
        if (null != defaultFileList && defaultFileList.size() > 0) {
            List fileList = defaultFileList.stream().map(f -> f.getId()).collect(Collectors.toList());
            this.fileManager.updateFileBizIdByIds(fileList, entity.getId(), "ProjectPlanPush");
        }
        return b;
    }

    public boolean saveBatch(Collection<PilotMeasuresPush> list) {
        boolean b = super.saveBatch(list);
        if (null != list && list.size() > 0) {
            list.stream().forEach(p -> {
                List<DefaultFile> defaultFileList = p.getDefaultFileList();
                if (null != defaultFileList && defaultFileList.size() > 0) {
                    List fileList = defaultFileList.stream().map(f -> f.getId()).collect(Collectors.toList());
                    this.fileManager.updateFileBizIdByIds(fileList, p.getId(), "ProjectPlanPush");
                }
            });
        }
        return b;
    }

    @Override
    public void updateStatusByProjectFill(PilotProjectFill pilotProjectFill) {
        if (null == pilotProjectFill || StringUtils.isBlank((CharSequence)pilotProjectFill.getId())) {
            return;
        }
        String fillId = pilotProjectFill.getId();
        Integer status = pilotProjectFill.getStatus();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"FILL_ID_", (Object)fillId)).eq((Object)"IS_DELE_", (Object)0);
        List list = this.list((Wrapper)queryWrapper);
        if (null != list && list.size() > 0) {
            ArrayList<String> ids = new ArrayList<String>();
            for (PilotMeasuresPush p : list) {
                if (p.getStatus() != null && "1".equalsIgnoreCase(p.getIsOver()) && p.getStatus() == 5) continue;
                ids.add(p.getId());
            }
            if (null != ids && ids.size() > 0) {
                UpdateWrapper updateWrapper = new UpdateWrapper();
                updateWrapper.set((Object)"STATUS_", (Object)status);
                updateWrapper.in((Object)"ID_", ids);
                this.update((Wrapper)updateWrapper);
            }
        }
    }

    @Override
    public PageList<PilotMeasuresPushVo> queryList(QueryFilter<PilotMeasuresPush> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<PilotMeasuresPushVo> result = ((PilotMeasuresPushDao)this.baseMapper).queryList((IPage<PilotMeasuresPush>)this.convert2IPage(pageBean), (Wrapper<PilotMeasuresPush>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        if (null != result.getRecords() && result.getRecords().size() > 0) {
            for (PilotMeasuresPushVo p : result.getRecords()) {
                p.setDefaultFileList(this.fileManager.queryFileByBizId(p.getId(), "ProjectPlanPush"));
            }
        }
        return new PageList(result);
    }

    @Override
    public PageList<PilotMeasuresPush> achievementInfo(QueryFilter<PilotMeasuresPush> queryFilter) {
        IPage<PilotMeasuresPush> iPage = ((PilotMeasuresPushDao)this.baseMapper).achievementInfo((IPage<PilotMeasuresPush>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<PilotMeasuresPush>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Override
    public PilotMeasuresPush achievementFindById(String id) {
        Assert.notNull((Object)id, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a");
        PilotMeasuresPush entity = (PilotMeasuresPush)((Object)this.pilotMeasuresPushDao.selectById((Serializable)((Object)id)));
        List files = this.fileManager.queryFileByBizId(id);
        if (files != null && files.size() > 0) {
            entity.setDefaultFileList(files);
        }
        return entity;
    }

    @Override
    public int countPilotMeasuresPushPush(String id) {
        Assert.notNull((Object)id, (String)"\u8ba1\u5212ID\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"PLAN_ID_", (Object)id)).gt((Object)"status_", (Object)0)).eq((Object)"IS_DELE_", (Object)0);
        return this.count((Wrapper)queryWrapper);
    }
}

