/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.majorProjects.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.majorProjects.dao.PilotExperiencePushDao;
import com.artfess.reform.majorProjects.manager.MunicipalMajorProjectManagementManager;
import com.artfess.reform.majorProjects.manager.PilotExperiencePushManager;
import com.artfess.reform.majorProjects.manager.PilotProjectFillManager;
import com.artfess.reform.majorProjects.model.MunicipalMajorProjectManagement;
import com.artfess.reform.majorProjects.model.PilotExperiencePush;
import com.artfess.reform.majorProjects.model.PilotProjectFill;
import com.artfess.reform.majorProjects.vo.PilotExperiencePushVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizPilotExperiencePushManagerImpl
extends BaseManagerImpl<PilotExperiencePushDao, PilotExperiencePush>
implements PilotExperiencePushManager {
    @Resource
    private FileManager fileManager;
    @Resource
    private PilotProjectFillManager pilotProjectFillManager;
    @Resource
    private MunicipalMajorProjectManagementManager municipalMajorProjectManagementManager;
    @Autowired
    private AchieveStatusLogManager achieveStatusLogManager;

    @Override
    @Transactional
    public boolean saveOrUpdateList(List<PilotExperiencePush> list) {
        boolean result = super.saveOrUpdateBatch(list);
        if (null != list && list.size() > 0) {
            list.stream().forEach(p -> {
                List<DefaultFile> defaultFileList = p.getDefaultFileList();
                if (null != defaultFileList && defaultFileList.size() > 0) {
                    List fileList = defaultFileList.stream().map(f -> f.getId()).collect(Collectors.toList());
                    this.fileManager.updateFileBizIdByIds(fileList, p.getId());
                }
            });
        }
        return result;
    }

    @Override
    public PageList<PilotExperiencePush> queryByPage(QueryFilter<PilotExperiencePush> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<PilotExperiencePush> result = ((PilotExperiencePushDao)this.baseMapper).queryByPage((IPage<PilotExperiencePush>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<PilotExperiencePush>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List list = result.getRecords();
        if (null != list && list.size() > 0) {
            list.stream().forEach(p -> p.setDefaultFileList(this.fileManager.queryFileByBizId(p.getId())));
        }
        return new PageList(result);
    }

    @Override
    public List<PilotProjectFill> queryHistory(QueryFilter<PilotProjectFill> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        List result = this.pilotProjectFillManager.query(queryFilter).getRows();
        if (BeanUtils.isNotEmpty((Object)result) && result.size() > 0) {
            ArrayList dataList = new ArrayList();
            for (PilotProjectFill ppf : result) {
                if (BeanUtils.isNotEmpty((Object)ppf.getStatus()) && (ppf.getStatus() == 2 || ppf.getStatus() == 4)) {
                    QueryWrapper logQW = new QueryWrapper();
                    ((QueryWrapper)((QueryWrapper)((QueryWrapper)logQW.eq((Object)"BIZ_ID_", (Object)ppf.getId())).eq((Object)"APPROVAL_RESULTS_", (Object)"1")).orderByDesc((Object)"LAST_TIME_")).last("limit 1");
                    AchieveStatusLog achieveStatusLog = (AchieveStatusLog)((Object)this.achieveStatusLogManager.getBaseMapper().selectOne((Wrapper)logQW));
                    ppf.setApprovalComments(achieveStatusLog.getApprovalComments());
                }
                QueryWrapper pilotExperiencePushQW = new QueryWrapper();
                pilotExperiencePushQW.eq((Object)"FILL_ID_", (Object)ppf.getId());
                List pilotExperiencePushes = ((PilotExperiencePushDao)this.baseMapper).selectList((Wrapper)pilotExperiencePushQW);
                ppf.setPilotExperiencePushList(pilotExperiencePushes);
                if (!BeanUtils.isNotEmpty((Object)pilotExperiencePushes) || pilotExperiencePushes.size() <= 0) continue;
                dataList.addAll(pilotExperiencePushes);
            }
            if (null != dataList && dataList.size() > 0) {
                dataList.stream().forEach(p -> p.setDefaultFileList(this.fileManager.queryFileByBizId(p.getId())));
            }
        }
        return result;
    }

    @Override
    public PilotExperiencePush detailedById(String id) {
        PilotExperiencePush result = (PilotExperiencePush)((Object)super.getById((Serializable)((Object)id)));
        result.setDefaultFileList(this.fileManager.queryFileByBizId(id));
        return result;
    }

    @Override
    @Transactional
    public boolean removeByIds(String ids) {
        boolean result = super.removeByIds(Arrays.asList(ids.split(",")));
        return result;
    }

    @Override
    @Transactional
    public void saveDraftOrCommit(PilotExperiencePushVo pilotExperiencePushVo) {
        List<PilotExperiencePush> list = pilotExperiencePushVo.getPilotExperiencePushList();
        String projectId = list.get(0).getProjectId();
        Integer status = BeanUtils.isNotEmpty((Object)pilotExperiencePushVo.getStatus()) ? pilotExperiencePushVo.getStatus() : 0;
        List fillIds = list.stream().filter(s -> BeanUtils.isNotEmpty((Object)s.getFillId())).map(s -> s.getFillId()).collect(Collectors.toList());
        String fillId = "";
        LocalDate data = LocalDate.now();
        int monthValue = data.getMonthValue();
        int quarter = (monthValue - 1) / 3 + 1;
        if (BeanUtils.isEmpty(fillIds) || fillIds.size() <= 0) {
            PilotProjectFill pilotProjectFill = new PilotProjectFill();
            pilotProjectFill.setProjectId(projectId);
            pilotProjectFill.setFlowType(3);
            pilotProjectFill.setFillDate(data);
            pilotProjectFill.setFillYear(data.getYear());
            pilotProjectFill.setFillMonth(monthValue);
            pilotProjectFill.setFillQuarter(quarter);
            pilotProjectFill.setUnitId(ContextUtil.getCurrentOrgId());
            pilotProjectFill.setUnitName(ContextUtil.getCurrentOrgName());
            pilotProjectFill.setUnitCode(ContextUtil.getCurrentOrgCode());
            pilotProjectFill.setUnitGrade(ContextUtil.getCurrentOrgGrade());
            pilotProjectFill.setStatus(status);
            this.pilotProjectFillManager.save((Object)pilotProjectFill);
            fillId = pilotProjectFill.getId();
        } else {
            fillId = (String)fillIds.get(0);
            UpdateWrapper pilotProjectFillUW = new UpdateWrapper();
            ((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)pilotProjectFillUW.set((Object)"FILL_DATE_", (Object)data)).set((Object)"FILL_YEAR_", (Object)data.getYear())).set((Object)"FILL_QUARTER_", (Object)quarter)).set((Object)"FILL_MONTH_", (Object)monthValue)).set((Object)"STATUS_", (Object)status)).eq((Object)"ID_", (Object)fillId);
            this.pilotProjectFillManager.update((Wrapper)pilotProjectFillUW);
        }
        if (status == 1) {
            this.setApprovalLog(fillId, projectId, status, "\u4e0a\u62a5");
        }
        if (null != list && list.size() > 0) {
            String finalFillId = fillId;
            list.stream().forEach(p -> p.setFillId(finalFillId));
            this.saveOrUpdateList(list);
        }
    }

    @Override
    @Transactional
    public boolean updateAuditStatus(PilotProjectFill pilotProjectFill) {
        boolean result = this.pilotProjectFillManager.updateById((Object)pilotProjectFill);
        this.setApprovalLog(pilotProjectFill.getId(), pilotProjectFill.getProjectId(), pilotProjectFill.getStatus(), pilotProjectFill.getApprovalComments());
        return result;
    }

    @Transactional
    public void setApprovalLog(String id, String projectId, Integer status, String approvalComments) {
        MunicipalMajorProjectManagement project = (MunicipalMajorProjectManagement)((Object)this.municipalMajorProjectManagementManager.getById((Serializable)((Object)projectId)));
        String title = project.getProjectName();
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(id);
        logVo.setModeType(1);
        logVo.setBizType("6-3");
        logVo.setApprovalComments(approvalComments);
        logVo.setModuleTableName("BIZ_PILOT_PROJECT_FILL");
        if (status == 0) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u5f55\u5165\uff01");
            logVo.setOperateInfo("\u9700\u6c42\u4ea4\u529e\u63a8\u8fdb\u4fe1\u606f\u5f55\u5165\uff01");
            logVo.setApprovalResults(0);
        } else if (status == 1) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u63a8\u8fdb\u8bb0\u5f55\u63d0\u4ea4\u5ba1\u6838\uff01");
            logVo.setOperateInfo("\u63d0\u4ea4\u5ba1\u6838");
            logVo.setApprovalResults(0);
        } else if (status == 2) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u63a8\u8fdb\u8bb0\u5f55\u5ba1\u6838\u9a73\u56de\uff01");
            logVo.setOperateInfo("\u5ba1\u6838\u9a73\u56de");
            logVo.setApprovalResults(1);
        } else if (status == 3) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u63a8\u8fdb\u8bb0\u5f55\u5ba1\u6838\u901a\u8fc7\uff01");
            logVo.setOperateInfo("\u5ba1\u6838\u901a\u8fc7");
            logVo.setApprovalResults(0);
        } else if (status == 4) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u63a8\u8fdb\u8bb0\u5f55\u6539\u9769\u529e\u9a73\u56de\uff01");
            logVo.setOperateInfo("\u6539\u9769\u529e\u9a73\u56de");
            logVo.setApprovalResults(1);
        } else if (status == 5) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u63a8\u8fdb\u8bb0\u5f55\u6539\u9769\u529e\u901a\u8fc7\uff01");
            logVo.setOperateInfo("\u6539\u9769\u529e\u901a\u8fc7");
            logVo.setApprovalResults(0);
        }
        logVo.setStatus(status.toString());
        logVo.setModeType(0);
        logVo.setPriority(0);
        logVo.setCreateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        logVo.setOperateDate(LocalDateTime.now());
        this.achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
    }

    @Override
    public List<PilotExperiencePush> queryListByFillId(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"FILL_ID_", (Object)id)).eq((Object)"IS_DELE_", (Object)0);
        List<PilotExperiencePush> list = this.list((Wrapper<PilotExperiencePush>)queryWrapper);
        if (null != list && list.size() > 0) {
            list.stream().forEach(p -> p.setDefaultFileList(this.fileManager.queryFileByBizId(p.getId())));
        }
        return list;
    }

    public boolean save(PilotExperiencePush entity) {
        boolean save = super.save((Object)entity);
        ArrayList<String> ids = new ArrayList<String>(1);
        ids.add(entity.getId());
        this.fileManager.updateFileBizIdByIds(ids, entity.getId());
        return save;
    }

    public boolean saveBatch(Collection<PilotExperiencePush> list) {
        boolean b = this.saveOrUpdateBatch(list);
        if (null != list && list.size() > 0) {
            list.stream().forEach(p -> {
                List<DefaultFile> defaultFileList = p.getDefaultFileList();
                if (null != defaultFileList && defaultFileList.size() > 0) {
                    List fileList = defaultFileList.stream().map(f -> f.getId()).collect(Collectors.toList());
                    this.fileManager.updateFileBizIdByIds(fileList, p.getId());
                }
            });
        }
        return b;
    }

    public boolean saveOrUpdate(PilotExperiencePush entity) {
        boolean b = super.saveOrUpdate((Object)entity);
        ArrayList<String> ids = new ArrayList<String>(1);
        ids.add(entity.getId());
        this.fileManager.updateFileBizIdByIds(ids, entity.getId());
        return b;
    }

    public PageList<PilotExperiencePush> query(QueryFilter<PilotExperiencePush> queryFilter) {
        PageList query = super.query(queryFilter);
        List list = query.getRows();
        if (null != list && list.size() > 0) {
            list.stream().forEach(p -> p.setDefaultFileList(this.fileManager.queryFileByBizId(p.getId())));
        }
        return query;
    }

    public List<PilotExperiencePush> list(Wrapper<PilotExperiencePush> queryWrapper) {
        List list = super.list(queryWrapper);
        if (null != list && list.size() > 0) {
            list.stream().forEach(p -> p.setDefaultFileList(this.fileManager.queryFileByBizId(p.getId())));
        }
        return list;
    }
}

