/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.fill.manager.impl;

import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.fill.manager.UniversalWayManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UniversalWayManagerImpl
implements UniversalWayManager {
    @Resource
    FileManager fileManager;

    @Override
    public void attachmentUpdates(List<String> fileId, String bizId) {
        if (null != fileId && fileId.size() > 0) {
            this.fileManager.update((Wrapper)((UpdateWrapper)new UpdateWrapper().in((Object)"id_", fileId)).set((Object)"biz_id_", (Object)bizId));
        }
    }

    @Override
    public Map<String, Integer> setLocalDate(LocalDate time) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("year", time.getYear());
        map.put("month", time.getMonthValue());
        map.put("quarter", (time.getMonthValue() + 2) / 3);
        map.put("week", time.getDayOfWeek().getValue());
        return map;
    }

    @Override
    public Map<String, Integer> setDate(Date time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("year", calendar.get(1));
        map.put("month", calendar.get(2) + 1);
        int month = calendar.get(2) + 1;
        map.put("quarter", (month + 2) / 3);
        map.put("week", calendar.get(3));
        return map;
    }

    @Override
    @Transactional
    public void deleteFiles(String bizId) {
        List fileIds = this.fileManager.queryFileByBizId(bizId);
        List<String> collect = fileIds.stream().map(DefaultFile::getId).collect(Collectors.toList());
        String[] strings = new String[collect.size()];
        try {
            this.fileManager.delSysFileByIds(collect.toArray(strings));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

