/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.fill.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.dao.BizReformSatisfactionManagementDao;
import com.artfess.reform.fill.manager.BizReformSatisfactionDistrictsManager;
import com.artfess.reform.fill.manager.BizReformSatisfactionManagementManager;
import com.artfess.reform.fill.manager.UniversalWayManager;
import com.artfess.reform.fill.model.BizReformSatisfactionDistricts;
import com.artfess.reform.fill.model.BizReformSatisfactionManagement;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizReformSatisfactionManagementManagerImpl
extends BaseManagerImpl<BizReformSatisfactionManagementDao, BizReformSatisfactionManagement>
implements BizReformSatisfactionManagementManager {
    @Resource
    BizReformSatisfactionDistrictsManager bizReformSatisfactionDistrictsManager;
    @Autowired
    UniversalWayManager universalWayManager;
    @Resource
    AchieveStatusLogManager achieveStatusLogManager;
    @Resource
    FileManager fileManager;

    @Override
    public PageList<BizReformSatisfactionManagement> queryByPage(QueryFilter<BizReformSatisfactionManagement> queryFilter, boolean isAffirm) {
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin() && !isAffirm) {
            queryFilter.addFilter("CREATE_ORG_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        IPage bizIdmMemberAnnualFeeIPage = ((BizReformSatisfactionManagementDao)this.baseMapper).selectPage(this.convert2IPage(queryFilter.getPageBean()), this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(bizIdmMemberAnnualFeeIPage);
    }

    @Override
    @Transactional
    public String saveOrUpdateSatisfaction(BizReformSatisfactionManagement bizReformSatisfactionManagement) {
        bizReformSatisfactionManagement.setScoringDate(new Date());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"SCORING_YEAR_", (Object)bizReformSatisfactionManagement.getScoringYear());
        queryWrapper.eq((Object)"SCORING_QUARTER_", (Object)bizReformSatisfactionManagement.getScoringQuarter());
        queryWrapper.ne(StringUtil.isNotEmpty((String)bizReformSatisfactionManagement.getId()), (Object)"id_", (Object)bizReformSatisfactionManagement.getId());
        int count = ((BizReformSatisfactionManagementDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
        if (count > 0) {
            throw new ApplicationException("\u5df2\u7ecf\u5b58\u5728\u3010" + bizReformSatisfactionManagement.getScoringYear() + "\u3011\u5e74\u3010" + bizReformSatisfactionManagement.getScoringQuarter() + "\u3011\u5b63\u5ea6\u7684\u6570\u636e\u4e86\uff01");
        }
        this.saveOrUpdate((Object)bizReformSatisfactionManagement);
        String id = bizReformSatisfactionManagement.getId();
        List<BizReformSatisfactionDistricts> list = bizReformSatisfactionManagement.getBizReformSatisfactionDistricts();
        if (list != null && list.size() > 0) {
            this.bizReformSatisfactionDistrictsManager.batchUpdate(bizReformSatisfactionManagement);
        }
        if (BeanUtils.isNotEmpty(bizReformSatisfactionManagement.getIds())) {
            this.universalWayManager.attachmentUpdates(bizReformSatisfactionManagement.getIds(), bizReformSatisfactionManagement.getId());
        }
        this.setApprovalLog(id, bizReformSatisfactionManagement.getStatus(), "");
        return id;
    }

    @Override
    public void updateStatusById(String id, Integer status, String approvalComments) {
        if ((status == 2 || status == 4) && StringUtil.isEmpty((String)approvalComments)) {
            throw new ApplicationException("\u8bf7\u586b\u5199\u9a73\u56de\u7406\u7531");
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)((UpdateWrapper)updateWrapper.eq((Object)"id_", (Object)id)).set((Object)"status_", (Object)status)).set((Object)"audit_time_", (Object)LocalDateTime.now());
        super.update((Wrapper)updateWrapper);
        this.setApprovalLog(id, status, approvalComments);
    }

    @Override
    public BizReformSatisfactionManagement getById(String id) {
        Assert.hasText((String)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        BizReformSatisfactionManagement satisfaction = (BizReformSatisfactionManagement)((Object)((BizReformSatisfactionManagementDao)this.baseMapper).selectById((Serializable)((Object)id)));
        if (satisfaction != null) {
            List<BizReformSatisfactionDistricts> list;
            List files;
            if (satisfaction.getStatus() == 2 || satisfaction.getStatus() == 4) {
                AchieveStatusLog log = this.achieveStatusLogManager.queryAchieveStatusLogByBizIdAndStatus(satisfaction.getId(), satisfaction.getStatus());
                satisfaction.setApprovalComments(log.getApprovalComments());
            }
            if ((files = this.fileManager.queryFileByBizId(id)) != null && files.size() > 0) {
                satisfaction.setFileList(files);
            }
            if ((list = this.bizReformSatisfactionDistrictsManager.queryBySatisfactionId(id)) != null && list.size() > 0) {
                satisfaction.setBizReformSatisfactionDistricts(list);
            }
        }
        return satisfaction;
    }

    @Override
    @Transactional
    public CommonResult<String> deleteBatchByIds(String id) {
        String[] ids;
        Assert.hasText((String)id, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        for (String res : ids = id.split(",")) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"ID_", (Object)res);
            queryWrapper.gt((Object)"STATUS_", (Object)0);
            Integer num = ((BizReformSatisfactionManagementDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
            if (num > 0) {
                return new CommonResult(false, "\u5df2\u901a\u8fc7\u5ba1\u6838\u6216\u6b63\u5728\u5ba1\u6838\u4e2d\u7684\u65b9\u6848\u65e0\u6cd5\u5220\u9664");
            }
            this.bizReformSatisfactionDistrictsManager.remove((Wrapper)new QueryWrapper().eq(StringUtil.isNotEmpty((String)res), (Object)"satisfaction_id_", (Object)res));
            ((BizReformSatisfactionManagementDao)this.baseMapper).deleteById((Serializable)((Object)res));
            this.universalWayManager.deleteFiles(res);
        }
        return new CommonResult(true, "\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public PageList<BizReformSatisfactionManagement> pageList(QueryFilter<BizReformSatisfactionManagement> queryFilter) {
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin()) {
            queryFilter.addFilter("CREATE_ORG_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        PageList model = this.query(queryFilter);
        return model;
    }

    @Override
    public PageList<BizReformSatisfactionManagement> auditQuery(QueryFilter<BizReformSatisfactionManagement> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("CREATE_ORG_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        queryFilter.addFilter("STATUS_", (Object)0, QueryOP.NOT_EQUAL);
        PageList model = this.query(queryFilter);
        return model;
    }

    @Override
    public PageList<BizReformSatisfactionManagement> reformQuery(QueryFilter<BizReformSatisfactionManagement> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        PageList model = this.query(queryFilter);
        return model;
    }

    @Transactional
    public void setApprovalLog(String id, Integer status, String approvalComments) {
        BizReformSatisfactionManagement satisfaction = (BizReformSatisfactionManagement)((Object)((BizReformSatisfactionManagementDao)this.baseMapper).selectById((Serializable)((Object)id)));
        String title = satisfaction.getScoringYear() + "\u5e74" + satisfaction.getScoringQuarter() + "\u5b63\u5ea6 " + satisfaction.getEstigationName();
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(id);
        logVo.setModeType(1);
        logVo.setBizType("7");
        logVo.setModuleTableName("biz_reform_satisfaction_management");
        logVo.setApprovalComments(approvalComments);
        if (status % 2 == 0) {
            logVo.setApprovalResults(1);
        } else {
            logVo.setApprovalResults(0);
        }
        if (status == 0) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u5f55\u5165\uff01");
            logVo.setOperateInfo("\u533a\u53bf\u6ee1\u610f\u5ea6\u8c03\u67e5\u4fe1\u606f\u5f55\u5165\uff01");
            logVo.setApprovalResults(0);
        } else if (status == 1) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u63d0\u4ea4\u5ba1\u6838\uff01");
            logVo.setOperateInfo("\u63d0\u4ea4\u5ba1\u6838");
            logVo.setApprovalResults(0);
        } else if (status == 2) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u5ba1\u6838\u9a73\u56de\uff01");
            logVo.setOperateInfo("\u5ba1\u6838\u9a73\u56de");
            logVo.setApprovalResults(1);
        } else if (status == 3) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u5ba1\u6838\u901a\u8fc7\uff01");
            logVo.setOperateInfo("\u5ba1\u6838\u901a\u8fc7");
            logVo.setApprovalResults(0);
        } else if (status == 4) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u6539\u9769\u529e\u9a73\u56de\uff01");
            logVo.setOperateInfo("\u6539\u9769\u529e\u9a73\u56de");
            logVo.setApprovalResults(1);
        } else if (status == 5) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u6539\u9769\u529e\u901a\u8fc7\uff01");
            logVo.setOperateInfo("\u6539\u9769\u529e\u901a\u8fc7");
            logVo.setApprovalResults(0);
        }
        logVo.setStatus(status.toString());
        logVo.setModeType(0);
        logVo.setPriority(0);
        logVo.setCreateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateDate(LocalDateTime.now());
        this.achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
    }
}

