/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.fill.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.fill.dao.BizReformSatisfactionDistrictsDao;
import com.artfess.reform.fill.dao.BizReformSatisfactionManagementDao;
import com.artfess.reform.fill.manager.BizReformSatisfactionDistrictsManager;
import com.artfess.reform.fill.model.BizReformSatisfactionDistricts;
import com.artfess.reform.fill.model.BizReformSatisfactionManagement;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.temporal.IsoFields;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizReformSatisfactionDistrictsManagerImpl
extends BaseManagerImpl<BizReformSatisfactionDistrictsDao, BizReformSatisfactionDistricts>
implements BizReformSatisfactionDistrictsManager {
    @Resource
    private BizReformSatisfactionManagementDao reformSatisfactionManagementDao;
    @Resource
    private OrgDao orgDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<BizReformSatisfactionDistricts> list, String satisfactionId) {
        BizReformSatisfactionManagement management = (BizReformSatisfactionManagement)((Object)this.reformSatisfactionManagementDao.selectById((Serializable)((Object)satisfactionId)));
        Assert.notNull((Object)((Object)management), (String)"\u6539\u9769\u533a\u53bf\u6ee1\u610f\u5ea6\u7ba1\u7406\u4e3b\u8868\u6570\u636e\u4e0d\u5b58\u5728");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"SATISFACTION_ID_", (Object)satisfactionId);
        ((BizReformSatisfactionDistrictsDao)this.baseMapper).delete((Wrapper)queryWrapper);
        List<BizReformSatisfactionDistricts> No1List = ((BizReformSatisfactionDistrictsDao)this.baseMapper).getAfterQuarterFirst(management.getScoringYear(), management.getScoringQuarter() - 1);
        List orgList = this.orgDao.groupOrg();
        Map<String, Org> orgMap = orgList.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        list.forEach(detail -> {
            detail.setSatisfactionId(satisfactionId);
            if (orgMap.containsKey(detail.getUnitCode())) {
                Org org = (Org)orgMap.get(detail.getUnitCode());
                detail.setUnitName(org.getName());
                detail.setUnitId(org.getId());
                detail.setUnitGrade(org.getGrade());
            }
            if ((null == No1List || No1List.size() == 0) && detail.getAllSn() == 1.0) {
                detail.setHoldNum(0);
            }
            if (null != No1List && No1List.size() > 0 && detail.getAllSn() == 1.0) {
                for (BizReformSatisfactionDistricts no1 : No1List) {
                    if (detail.getAllSn() == 1.0 && detail.getUnitCode().equals(no1.getUnitCode())) {
                        detail.setHoldNum(no1.getHoldNum() + 1);
                        break;
                    }
                    if (detail.getAllSn() != 1.0 || detail.getUnitCode().equals(no1.getUnitCode())) continue;
                    detail.setHoldNum(0);
                }
            }
        });
        boolean b = this.saveBatch(list);
        return b;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean batchUpdate(BizReformSatisfactionManagement t) {
        Assert.hasText((String)t.getId(), (String)"\u8bf7\u9009\u62e9\u8981\u4fee\u6539\u6539\u9769\u533a\u53bf\u6ee1\u610f\u5ea6\u7ba1\u7406\u4e3b\u8868id");
        List<BizReformSatisfactionDistricts> list = t.getBizReformSatisfactionDistricts();
        list.forEach(detail -> detail.setSatisfactionId(t.getId()));
        boolean b = this.saveOrUpdateBatch(list);
        return b;
    }

    @Override
    public List<BizReformSatisfactionDistricts> queryBySatisfactionId(String satisfactionId) {
        Assert.hasText((String)satisfactionId, (String)"\u6539\u9769\u533a\u53bf\u6ee1\u610f\u5ea6\u7ba1\u7406\u4e3b\u8868id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"SATISFACTION_ID_", (Object)satisfactionId);
        List list = ((BizReformSatisfactionDistrictsDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        return list;
    }

    @Override
    public List<BizReformSatisfactionDistricts> qureyFieldByUnitCode(String unitCode, Integer scoringYear, Integer scoringQuarter) {
        Assert.hasText((String)unitCode, (String)"\u533a\u53bf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (scoringYear == null || scoringYear == 0) {
            scoringYear = LocalDate.now().getYear();
        }
        if (scoringQuarter == null || scoringQuarter == 0) {
            scoringQuarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        List<BizReformSatisfactionDistricts> list = ((BizReformSatisfactionDistrictsDao)this.baseMapper).qureyFieldByUnitCode(unitCode, scoringYear, scoringQuarter);
        return list;
    }
}

