/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.fill.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.dao.BizReformDemandAssignmentRecordDao;
import com.artfess.reform.fill.manager.BizReformDemandAssignmentManager;
import com.artfess.reform.fill.manager.BizReformDemandAssignmentRecordManager;
import com.artfess.reform.fill.manager.UniversalWayManager;
import com.artfess.reform.fill.model.BizReformDemandAssignment;
import com.artfess.reform.fill.model.BizReformDemandAssignmentRecord;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizReformDemandAssignmentRecordManagerImpl
extends BaseManagerImpl<BizReformDemandAssignmentRecordDao, BizReformDemandAssignmentRecord>
implements BizReformDemandAssignmentRecordManager {
    @Resource
    private BizReformDemandAssignmentManager assignmentManager;
    @Resource
    private AchieveStatusLogManager achieveStatusLogManager;
    @Resource
    private UniversalWayManager universalWayManager;

    @Override
    @Transactional
    public String insertInfo(BizReformDemandAssignmentRecord record) {
        if (record.getStatus() == null) {
            record.setStatus(0);
        }
        record.setReportingUnitId(ContextUtil.getCurrentOrgId());
        record.setReportingUnitName(ContextUtil.getCurrentOrgName());
        record.setResponsibleUnitCode(ContextUtil.getCurrentOrgCode());
        record.setResponsibleUnitGrade(ContextUtil.getCurrentOrgGrade());
        record.setReportingTime(LocalDateTime.now());
        ((BizReformDemandAssignmentRecordDao)this.baseMapper).insert((Object)record);
        if (BeanUtils.isNotEmpty(record.getIds())) {
            this.universalWayManager.attachmentUpdates(record.getIds(), record.getId());
        }
        this.setApprovalLog(record.getId(), record.getProjectId(), record.getStatus(), "", record.getApprovalResults());
        return record.getId();
    }

    @Override
    @Transactional
    public String updateInfo(BizReformDemandAssignmentRecord record) {
        boolean check;
        BizReformDemandAssignmentRecord old = (BizReformDemandAssignmentRecord)((Object)((BizReformDemandAssignmentRecordDao)this.baseMapper).selectById((Serializable)((Object)record.getId())));
        boolean bl = check = old == null || old.getStatus() != record.getStatus();
        if (old.getStatus() == 0 || old.getStatus() == 2 || old.getStatus() == 4) {
            ((BizReformDemandAssignmentRecordDao)this.baseMapper).updateById((Object)record);
            if (check) {
                this.setApprovalLog(record.getId(), record.getProjectId(), record.getStatus(), "", record.getApprovalResults());
            }
            if (BeanUtils.isNotEmpty(record.getIds())) {
                this.universalWayManager.attachmentUpdates(record.getIds(), record.getId());
            }
        } else {
            throw new ApplicationException("\u5df2\u5f00\u59cb\u5ba1\u6838\u4e0d\u80fd\u4fee\u6539\uff01");
        }
        return record.getId();
    }

    @Override
    @Transactional
    public void updateAuditStatus(BizReformDemandAssignmentRecord record) {
        BizReformDemandAssignmentRecord entity;
        if (record.getStatus().equals(5)) {
            this.assignmentManager.updateDemandStatus(record.getProjectId(), record.getPropulsiveStatus());
        }
        boolean check = (entity = (BizReformDemandAssignmentRecord)((Object)super.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ID_", (Object)record.getId())).eq((Object)"IS_DELE_", (Object)"0"), false))) == null || entity.getStatus() != record.getStatus();
        ((BizReformDemandAssignmentRecordDao)this.baseMapper).updateById((Object)record);
        if (check) {
            this.setApprovalLog(record.getId(), record.getProjectId(), record.getStatus(), record.getApprovalComments(), record.getApprovalResults());
        }
    }

    @Transactional
    public void setApprovalLog(String id, String projectId, Integer status, String approvalComments, Integer approvalResults) {
        BizReformDemandAssignment assignment = (BizReformDemandAssignment)((Object)this.assignmentManager.getById((Serializable)((Object)projectId)));
        String title = assignment.getDemandTopic();
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(id);
        logVo.setModeType(1);
        logVo.setBizType("2");
        logVo.setApprovalComments(approvalComments);
        logVo.setModuleTableName("biz_reform_demand_assignment_record");
        if (approvalResults != null && approvalResults == 2) {
            if (status == 0) {
                logVo.setItemTitle("\u3010" + title + "\u3011\u64a4\u56de\u4e3a\u8349\u7a3f");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u8349\u7a3f\uff01");
            } else if (status == 1) {
                logVo.setItemTitle("\u3010" + title + "\u3011\u64a4\u56de\u4e3a\u63d0\u4ea4\u672a\u5ba1\u6838");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u63d0\u4ea4\u672a\u5ba1\u6838");
            } else if (status == 3) {
                logVo.setItemTitle("\u3010" + title + "\u3011\u64a4\u56de\u4e3a\u5ba1\u6838\u901a\u8fc7");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u5ba1\u6838\u901a\u8fc7");
            }
            logVo.setApprovalResults(2);
        } else if (status == 0) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u5f55\u5165\uff01");
            logVo.setOperateInfo("\u9700\u6c42\u4ea4\u529e\u63a8\u8fdb\u4fe1\u606f\u5f55\u5165\uff01");
            logVo.setApprovalResults(0);
        } else if (status == 1) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u63a8\u8fdb\u8bb0\u5f55\u63d0\u4ea4\u5ba1\u6838\uff01");
            logVo.setOperateInfo("\u63d0\u4ea4\u5ba1\u6838");
            logVo.setApprovalResults(0);
        } else if (status == 2) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u63a8\u8fdb\u8bb0\u5f55\u5ba1\u6838\u9a73\u56de\uff01");
            logVo.setOperateInfo("\u5ba1\u6838\u9a73\u56de");
            logVo.setApprovalResults(1);
        } else if (status == 3) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u63a8\u8fdb\u8bb0\u5f55\u5ba1\u6838\u901a\u8fc7\uff01");
            logVo.setOperateInfo("\u5ba1\u6838\u901a\u8fc7");
            logVo.setApprovalResults(0);
        } else if (status == 4) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u63a8\u8fdb\u8bb0\u5f55\u6539\u9769\u529e\u9a73\u56de\uff01");
            logVo.setOperateInfo("\u6539\u9769\u529e\u9a73\u56de");
            logVo.setApprovalResults(1);
        } else if (status == 5) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u63a8\u8fdb\u8bb0\u5f55\u6539\u9769\u529e\u901a\u8fc7\uff01");
            logVo.setOperateInfo("\u6539\u9769\u529e\u901a\u8fc7");
            logVo.setApprovalResults(0);
        }
        logVo.setStatus(status.toString());
        logVo.setModeType(0);
        logVo.setPriority(0);
        logVo.setCreateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateDate(LocalDateTime.now());
        this.achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
    }
}

