/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.fill.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.fill.dao.BizPilotAdvanceResultDao;
import com.artfess.reform.fill.manager.BizPilotAdvanceResultManager;
import com.artfess.reform.fill.model.BizPilotAdvanceResult;
import com.artfess.reform.statistics.vo.CountyPilotReformVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.time.LocalDate;
import java.time.temporal.IsoFields;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BizPilotAdvanceResultManagerImpl
extends BaseManagerImpl<BizPilotAdvanceResultDao, BizPilotAdvanceResult>
implements BizPilotAdvanceResultManager {
    @Resource
    private FileManager fileManager;

    @Override
    public List<CountyPilotReformVo> count(int type, Integer year, Integer quarter, String unitCode) {
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        List<CountyPilotReformVo> data = ((BizPilotAdvanceResultDao)this.baseMapper).count(type, year, quarter, unitCode);
        return data;
    }

    @Override
    public PageList<BizPilotAdvanceResult> pilotResultDetail(QueryFilter<BizPilotAdvanceResult> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        Map queryMap = queryFilter.getParams();
        if (queryMap.isEmpty()) {
            queryMap.put("year", LocalDate.now().getYear());
            queryMap.put("quarter", LocalDate.now().get(IsoFields.QUARTER_OF_YEAR));
            queryFilter.setParams(queryMap);
        }
        queryFilter.addFilter("p.is_dele_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("r.is_dele_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("p.STATUS_", (Object)5, QueryOP.EQUAL);
        IPage<BizPilotAdvanceResult> result = ((BizPilotAdvanceResultDao)this.baseMapper).queryResult((IPage<BizPilotAdvanceResult>)this.convert2IPage(pageBean), (Wrapper<BizPilotAdvanceResult>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        PageList data = new PageList(result);
        if (data.getRows() != null && data.getRows().size() > 0) {
            this.fillFiles(data.getRows());
        }
        return data;
    }

    public List<BizPilotAdvanceResult> list(Wrapper<BizPilotAdvanceResult> queryWrapper) {
        return this.fillFiles(super.list(queryWrapper));
    }

    public List<BizPilotAdvanceResult> list() {
        return this.fillFiles(super.list());
    }

    private List<BizPilotAdvanceResult> fillFiles(List<BizPilotAdvanceResult> data) {
        if (data != null && data.size() > 0) {
            ArrayList<String> bizIds = new ArrayList<String>();
            for (BizPilotAdvanceResult result : data) {
                bizIds.add(result.getId());
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"BIZ_CODE_", (Object)"PilotResult")).in((Object)"BIZ_ID_", bizIds);
            List files = this.fileManager.list((Wrapper)queryWrapper);
            if (files != null && files.size() > 0) {
                data.forEach(d -> d.setFileList(files.stream().filter(f -> f.getBizId().equals(d.getId())).collect(Collectors.toList())));
            }
        }
        return data;
    }
}

