/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.fill.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.fill.dao.BizBlockageCardTransferDao;
import com.artfess.reform.fill.manager.BizBlockageCardTransferManager;
import com.artfess.reform.fill.manager.BizBlockageCardTransferRecordManager;
import com.artfess.reform.fill.model.BizBlockageCardTransfer;
import com.artfess.reform.fill.model.BizBlockageCardTransferRecord;
import com.artfess.reform.fill.vo.BlockageCardTransferVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizBlockageCardTransferManagerImpl
extends BaseManagerImpl<BizBlockageCardTransferDao, BizBlockageCardTransfer>
implements BizBlockageCardTransferManager {
    @Resource
    private BizBlockageCardTransferRecordManager bizBlockageCardTransferRecordManager;
    @Resource
    private FileManager fileManager;
    @Resource
    private AchieveStatusLogManager achieveStatusLogManager;

    @Override
    @Transactional
    public String inertInfo(BizBlockageCardTransfer blockageCard) {
        LocalDate date = LocalDate.now();
        blockageCard.setPropulsiveStatus(1);
        blockageCard.setBlockageDate(date);
        blockageCard.setBlockageYear(date.getYear());
        blockageCard.setBlockageQuarter(Integer.valueOf(date.getMonthValue() + 2) / 3);
        blockageCard.setBlockageMonth(date.getMonthValue());
        ((BizBlockageCardTransferDao)this.baseMapper).insert((Object)blockageCard);
        return blockageCard.getId();
    }

    @Override
    @Transactional
    public CommonResult<String> deleteById(String id) {
        Assert.hasText((String)id, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (this.records(id).size() > 0) {
            return new CommonResult(false, "\u5df2\u63d0\u4ea4\u63a8\u8fdb\u8bb0\u5f55\u7684\u4ea4\u529e\u65e0\u6cd5\u5220\u9664");
        }
        ((BizBlockageCardTransferDao)this.baseMapper).deleteById((Serializable)((Object)id));
        return new CommonResult(true, "\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public PageList<BizBlockageCardTransfer> queryPageList(QueryFilter<BizBlockageCardTransfer> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BizBlockageCardTransfer> result = ((BizBlockageCardTransferDao)this.baseMapper).queryPageList((IPage<BizBlockageCardTransfer>)this.convert2IPage(pageBean), (Wrapper<BizBlockageCardTransfer>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public PageList<BizBlockageCardTransfer> queryAudit(QueryFilter<BizBlockageCardTransfer> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BizBlockageCardTransfer> result = ((BizBlockageCardTransferDao)this.baseMapper).queryAudit((IPage<BizBlockageCardTransfer>)this.convert2IPage(pageBean), (Wrapper<BizBlockageCardTransfer>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public PageList<BlockageCardTransferVo> queryBlockageCardDetailList(QueryFilter<BizBlockageCardTransfer> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BlockageCardTransferVo> result = ((BizBlockageCardTransferDao)this.baseMapper).queryBlockageCardDetailList((IPage<BizBlockageCardTransfer>)this.convert2IPage(pageBean), (Wrapper<BizBlockageCardTransfer>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional
    public boolean updatePropulsiveStatus(String id, Integer propulsiveStatus) {
        Assert.hasText((String)id, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)propulsiveStatus, (String)"\u63a8\u8fdb\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.set((Object)"PROPULSIVE_STATUS_", (Object)propulsiveStatus)).eq((Object)"ID_", (Object)id);
        ((BizBlockageCardTransferDao)this.baseMapper).update(null, (Wrapper)updateWrapper);
        return true;
    }

    @Override
    public BizBlockageCardTransfer queryById(String id) {
        Assert.hasText((String)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        BizBlockageCardTransfer blockageCard = (BizBlockageCardTransfer)((Object)((BizBlockageCardTransferDao)this.baseMapper).selectById((Serializable)((Object)id)));
        if (blockageCard != null) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"PROJECT_ID_", (Object)id);
            queryWrapper.orderByDesc((Object)"CREATE_TIME_");
            queryWrapper.last("LIMIT 2");
            List recordList = this.bizBlockageCardTransferRecordManager.list((Wrapper)queryWrapper);
            if (BeanUtils.isNotEmpty((Object)recordList)) {
                blockageCard.setRecords(recordList);
                for (BizBlockageCardTransferRecord record : recordList) {
                    if (record.getStatus() == 5) {
                        record.setIsHis(true);
                    } else {
                        record.setIsHis(false);
                    }
                    if (record.getStatus() == 2 || record.getStatus() == 4) {
                        AchieveStatusLog log = this.achieveStatusLogManager.queryAchieveStatusLogByBizIdAndStatus(record.getId(), record.getStatus());
                        record.setApprovalComments(log.getApprovalComments());
                    }
                    QueryWrapper fileQuery = new QueryWrapper();
                    fileQuery.eq((Object)"biz_id_", (Object)record.getId());
                    List filesList = this.fileManager.list((Wrapper)fileQuery);
                    record.setFiles(filesList);
                }
            }
        }
        return blockageCard;
    }

    @Override
    public List<BizBlockageCardTransferRecord> records(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"PROJECT_ID_", (Object)projectId);
        queryWrapper.orderByDesc((Object)"CREATE_TIME_");
        return this.bizBlockageCardTransferRecordManager.list((Wrapper)queryWrapper);
    }

    @Override
    public List<BizBlockageCardTransfer> problemSolvingDetail(String unitCode, Integer year, Integer quarter) {
        return ((BizBlockageCardTransferDao)this.baseMapper).problemSolvingDetail(unitCode, year, quarter);
    }
}

