/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.fill.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.reform.fill.manager.BizReformDemandAnalysisLibraryManager;
import com.artfess.reform.fill.model.BizReformDemandAnalysisLibrary;
import com.artfess.sysConfig.persistence.manager.SysDictionaryDetailManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizReformDemandAnalysisLibrary/v1/"})
@Api(tags={"\u6539\u9769\u9700\u6c42\u57fa\u7840\u4fe1\u606f"})
@ApiGroup(group={"group_biz"})
public class BizReformDemandAnalysisLibraryController
extends BaseController<BizReformDemandAnalysisLibraryManager, BizReformDemandAnalysisLibrary> {
    @Autowired
    SysDictionaryDetailManager sysDictionaryDetailManager;

    @PostMapping(value={"/getList"})
    @ApiOperation(value="\u9700\u6c42\u5f55\u5165\u5206\u9875\u67e5\u8be2")
    public PageList<BizReformDemandAnalysisLibrary> getList(@RequestBody QueryFilter<BizReformDemandAnalysisLibrary> queryFilter, @RequestParam(name="isAffirm", required=true) Boolean isAffirm) {
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin() && !isAffirm.booleanValue()) {
            queryFilter.addFilter("d.CREATE_ORG_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        return ((BizReformDemandAnalysisLibraryManager)this.baseService).queryByPage(queryFilter);
    }

    @RequestMapping(value={"demandExport"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6539\u9769\u9700\u6c42\u5217\u8868", httpMethod="POST", notes="\u5bfc\u51fa\u6539\u9769\u9700\u6c42\u5217\u8868")
    public void demandExport(HttpServletResponse response, @ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        try {
            PageList pageList = super.query(queryFilter);
            ArrayList<Map> list = new ArrayList<Map>();
            if (BeanUtils.isNotEmpty((Object)pageList.getRows())) {
                for (BizReformDemandAnalysisLibrary demand : pageList.getRows()) {
                    String jsonStr = JsonUtil.toJson((Object)((Object)demand));
                    Map map = JsonUtil.toMap((String)jsonStr);
                    if (map.get("demandSourceChannel") != null) {
                        String demandSourceChannel = map.get("demandSourceChannel").toString();
                        String demandSourceChannelText = this.sysDictionaryDetailManager.getTextByValue("ggbb_lyqd", demandSourceChannel);
                        map.put("demandSourceChannelText", demandSourceChannelText);
                    } else {
                        map.put("demandSourceChannelText", "");
                    }
                    if (map.get("demandField") != null) {
                        String demandField = map.get("demandField").toString();
                        String demandFieldText = this.sysDictionaryDetailManager.getTextByValue("ggbb_ssly", demandField);
                        map.put("demandFieldText", demandFieldText);
                    } else {
                        map.put("demandFieldText", "");
                    }
                    if (map.get("demandRunway") != null) {
                        String demandRunway = map.get("demandRunway").toString();
                        String demandRunwayText = this.sysDictionaryDetailManager.getTextByValue("ggbb_sspd", demandRunway);
                        map.put("demandRunwayText", demandRunwayText);
                    } else {
                        map.put("demandRunwayText", "");
                    }
                    if (map.get("demandAdoptionStatus") != null) {
                        String demandAdoptionStatus = map.get("demandAdoptionStatus").toString();
                        String demandAdoptionStatusText = this.sysDictionaryDetailManager.getTextByValue("ggbb_cyzt", demandAdoptionStatus);
                        map.put("demandAdoptionStatusText", demandAdoptionStatusText);
                    } else {
                        map.put("demandAdoptionStatusText", "");
                    }
                    if (map.get("status") != null) {
                        String status = map.get("status").toString();
                        String statusText = this.sysDictionaryDetailManager.getTextByValue("shzt", status);
                        map.put("statusText", statusText);
                    } else {
                        map.put("statusText", "");
                    }
                    list.add(map);
                }
            }
            String tempName = "\u6539\u9769\u9700\u6c42\u6570\u636e";
            LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
            exportMaps.put("demandTopic", "\u9700\u6c42\u9898\u76ee");
            exportMaps.put("reportUnitName", "\u9700\u6c42\u4e0a\u62a5\u533a\u53bf");
            exportMaps.put("demandDate", "\u9700\u6c42\u4e0a\u62a5\u65e5\u671f");
            exportMaps.put("demandSourceChannelText", "\u6765\u6e90\u6e20\u9053");
            exportMaps.put("demandFieldText", "\u6240\u5c5e\u9886\u57df");
            exportMaps.put("demandRunwayText", "\u6240\u5c5e\u8dd1\u9053");
            exportMaps.put("demandAdoptionStatusText", "\u91c7\u7528\u72b6\u6001");
            exportMaps.put("statusText", "\u5ba1\u6838\u72b6\u6001");
            HSSFWorkbook book = ExcelUtil.exportExcel((String)tempName, (int)24, exportMaps, list);
            ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)tempName, (HttpServletResponse)response);
        }
        catch (Exception e) {
            throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@RequestBody BizReformDemandAnalysisLibrary bizReformDemandAnalysisLibrary) {
        String id = ((BizReformDemandAnalysisLibraryManager)this.baseService).insertDemand(bizReformDemandAnalysisLibrary);
        if (StringUtil.isEmpty((String)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f\uff01", (Object)id);
    }

    @PostMapping(value={"/updateInfo"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateInfo(@RequestBody BizReformDemandAnalysisLibrary bizReformDemandAnalysisLibrary) {
        String id = ((BizReformDemandAnalysisLibraryManager)this.baseService).updateDemand(bizReformDemandAnalysisLibrary);
        if (StringUtil.isEmpty((String)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult(true, "\u4fee\u6539\u6210\u529f\uff01", (Object)id);
    }

    @DeleteMapping(value={"/"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        boolean result = ((BizReformDemandAnalysisLibraryManager)this.baseService).deleteBatchByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/updateAuditStatus"})
    @ApiOperation(value="\u5ba1\u6838\u72b6\u6001\u4fee\u6539")
    public CommonResult<String> updateAuditStatus(@RequestBody BizReformDemandAnalysisLibrary bizReformDemandAnalysisLibrary) {
        String id = ((BizReformDemandAnalysisLibraryManager)this.baseService).updateAuditStatus(bizReformDemandAnalysisLibrary);
        if (StringUtil.isEmpty((String)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult(true, "\u6210\u529f\uff01", (Object)id);
    }

    @PostMapping(value={"/updateAdoptStatus"})
    @ApiOperation(value="\u91c7\u7eb3\u72b6\u6001\u4fee\u6539")
    public CommonResult<String> updateAdoptStatus(@RequestBody BizReformDemandAnalysisLibrary bizReformDemandAnalysisLibrary) {
        String id = ((BizReformDemandAnalysisLibraryManager)this.baseService).updateAdoptStatus(bizReformDemandAnalysisLibrary);
        if (StringUtil.isEmpty((String)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult(true, "\u6210\u529f\uff01", (Object)id);
    }
}

