/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.fill.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.reform.fill.manager.BizBlockageCardTransferManager;
import com.artfess.reform.fill.model.BizBlockageCardTransfer;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizBlockageCardTransfer/v1/"})
@Api(tags={"\u5835\u70b9\u5361\u70b9\u57fa\u7840\u4fe1\u606f"})
@ApiGroup(group={"group_biz"})
public class BizBlockageCardTransferController
extends BaseController<BizBlockageCardTransferManager, BizBlockageCardTransfer> {
    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@RequestBody BizBlockageCardTransfer blockageCardTransfer) {
        String id = ((BizBlockageCardTransferManager)this.baseService).inertInfo(blockageCardTransfer);
        if (StringUtil.isEmpty((String)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult(true, "\u6210\u529f\uff01", (Object)id);
    }

    @PostMapping(value={"/updateInfo"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateInfo(@RequestBody BizBlockageCardTransfer bizBlockageCardTransfer) {
        if (((BizBlockageCardTransferManager)this.baseService).records(bizBlockageCardTransfer.getId()).size() > 0) {
            return new CommonResult(false, "\u5df2\u63d0\u4ea4\u63a8\u8fdb\u8bb0\u5f55\u7684\u4ea4\u529e\u65e0\u6cd5\u4fee\u6539");
        }
        return super.updateById((Model)bizBlockageCardTransfer);
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((BizBlockageCardTransferManager)this.baseService).deleteById(id);
    }

    @PostMapping(value={"/queryPageList"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5f55\u5165\u754c\u9762\u7684\u5206\u9875\u67e5\u8be2")
    public PageList<BizBlockageCardTransfer> queryPageList(@RequestBody QueryFilter<BizBlockageCardTransfer> queryFilter) {
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin()) {
            queryFilter.addFilter("a.create_org_id_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        queryFilter.addFilter("a.is_dele_", (Object)"0", QueryOP.EQUAL);
        List sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("a.last_time_", Direction.DESC));
        queryFilter.setSorter(sorter);
        return ((BizBlockageCardTransferManager)this.baseService).queryPageList(queryFilter);
    }

    @PostMapping(value={"/queryAudit"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5ba1\u6838\u5206\u9875\u67e5\u8be2")
    public PageList<BizBlockageCardTransfer> queryAudit(@RequestBody QueryFilter<BizBlockageCardTransfer> queryFilter, @RequestParam(name="isAffirm", required=true) Boolean isAffirm) {
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin() && !isAffirm.booleanValue()) {
            queryFilter.addFilter("a.UNIT_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        queryFilter.addFilter("a.is_dele_", (Object)"0", QueryOP.EQUAL);
        List sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("r.last_time_", Direction.DESC));
        queryFilter.setSorter(sorter);
        return ((BizBlockageCardTransferManager)this.baseService).queryAudit(queryFilter);
    }

    @PostMapping(value={"/queryById"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u4ea4\u529e\u8be6\u60c5\u4e0e\u63a8\u8fdb\u5ba1\u6279\u8bb0\u5f55")
    public BizBlockageCardTransfer queryById(@RequestParam(name="id", required=true) String id) {
        BizBlockageCardTransfer blockageCard = ((BizBlockageCardTransferManager)this.baseService).queryById(id);
        return blockageCard;
    }
}

