/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.approvalLog.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.approvalLog.dao.AchieveStatusLogDao;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.manager.AuditResultManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.approvalLog.model.AuditResult;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class AchieveStatusLogManagerImpl
extends BaseManagerImpl<AchieveStatusLogDao, AchieveStatusLog>
implements AchieveStatusLogManager {
    @Resource
    private AuditResultManager auditResultManager;

    public void create(AchieveStatusLog achieveStatusLog) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("BIZ_ID_", achieveStatusLog.getBizId());
        achieveStatusLog.setSn(this.getNextSequence(map));
        if (null == achieveStatusLog.getOperateDate()) {
            achieveStatusLog.setOperateDate(LocalDateTime.now());
        }
        super.create((Model)achieveStatusLog);
    }

    @Override
    @Transactional
    public boolean createAchieveStatusLogAndAuditResult(AchieveStatusLogAndAuditResultVo achieveStatusLogAndAuditResultVo) {
        AuditResult auditResult;
        AchieveStatusLog achieveStatusLog = new AchieveStatusLog();
        BeanUtils.copyProperties((Object)((Object)achieveStatusLogAndAuditResultVo), (Object)((Object)achieveStatusLog));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("BIZ_ID_", achieveStatusLogAndAuditResultVo.getBizId());
        achieveStatusLog.setSn(this.getNextSequence(map));
        if (null == achieveStatusLog.getOperateDate()) {
            achieveStatusLog.setOperateDate(LocalDateTime.now());
        }
        boolean b = this.save((Object)achieveStatusLog);
        QueryWrapper auditResultQueryWrapper = new QueryWrapper();
        ((QueryWrapper)auditResultQueryWrapper.eq((Object)"BIZ_ID_", (Object)achieveStatusLog.getBizId())).eq((Object)"APPROVAL_STATUS_", (Object)0);
        List auditResultList = this.auditResultManager.list((Wrapper)auditResultQueryWrapper);
        if (null != auditResultList && auditResultList.size() > 0) {
            auditResult = (AuditResult)((Object)auditResultList.get(0));
            if (StringUtils.isNotBlank((CharSequence)achieveStatusLogAndAuditResultVo.getOperateDeptId())) {
                auditResult.setReportUnitId(achieveStatusLogAndAuditResultVo.getOperateDeptId());
                auditResult.setReportUnitName(achieveStatusLogAndAuditResultVo.getOperateDeptName());
            } else {
                auditResult.setReportUnitId(achieveStatusLogAndAuditResultVo.getOperateOrgId());
                auditResult.setReportUnitName(achieveStatusLogAndAuditResultVo.getOperateOrgName());
            }
            auditResult.setReportId(achieveStatusLogAndAuditResultVo.getOperateUserId());
            auditResult.setReceiveName(achieveStatusLogAndAuditResultVo.getOperateOrgName());
            auditResult.setReceiveLoginAccount(ContextUtil.getCurrentUserAccount());
            auditResult.setReceiveTime(achieveStatusLogAndAuditResultVo.getOperateDate());
            auditResult.setApprovalResults(achieveStatusLogAndAuditResultVo.getApprovalResults());
            auditResult.setApprovalComments(achieveStatusLogAndAuditResultVo.getApprovalComments());
            auditResult.setApprovalStatus(1);
            this.auditResultManager.update((Model)auditResult);
        }
        if (!achieveStatusLogAndAuditResultVo.isFinish()) {
            auditResult = new AuditResult();
            BeanUtils.copyProperties((Object)((Object)achieveStatusLogAndAuditResultVo), (Object)((Object)auditResult));
            if (StringUtils.isNotBlank((CharSequence)achieveStatusLogAndAuditResultVo.getOperateDeptId())) {
                auditResult.setSendDeptId(achieveStatusLogAndAuditResultVo.getOperateDeptId());
                auditResult.setSendDeptName(achieveStatusLogAndAuditResultVo.getOperateDeptName());
            } else {
                auditResult.setSendDeptId(achieveStatusLogAndAuditResultVo.getOperateOrgId());
                auditResult.setSendDeptName(achieveStatusLogAndAuditResultVo.getOperateOrgName());
            }
            auditResult.setSendUserId(achieveStatusLogAndAuditResultVo.getOperateUserId());
            auditResult.setSendUserName(achieveStatusLogAndAuditResultVo.getOperateOrgName());
            auditResult.setSendLoginName(ContextUtil.getCurrentUserAccount());
            auditResult.setSendDate(achieveStatusLog.getOperateDate());
            auditResult.setApprovalStatus(0);
            this.auditResultManager.save((Object)auditResult);
        }
        return b;
    }

    @Override
    @Transactional
    public boolean createAchieveStatusLogAndAuditResultBatch(List<AchieveStatusLogAndAuditResultVo> achieveStatusLogAndAuditResultVoList) {
        if (null != achieveStatusLogAndAuditResultVoList && achieveStatusLogAndAuditResultVoList.size() > 0) {
            ArrayList<AchieveStatusLog> achieveStatusLogList = new ArrayList<AchieveStatusLog>(achieveStatusLogAndAuditResultVoList.size());
            ArrayList<AuditResult> auditResultSaveList = new ArrayList<AuditResult>(achieveStatusLogAndAuditResultVoList.size());
            ArrayList<AuditResult> auditResultUpdateList = new ArrayList<AuditResult>();
            for (AchieveStatusLogAndAuditResultVo achieveStatusLogAndAuditResultVo : achieveStatusLogAndAuditResultVoList) {
                AuditResult auditResult;
                AchieveStatusLog achieveStatusLog = new AchieveStatusLog();
                BeanUtils.copyProperties((Object)((Object)achieveStatusLogAndAuditResultVo), (Object)((Object)achieveStatusLog));
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("BIZ_ID_", achieveStatusLogAndAuditResultVo.getBizId());
                achieveStatusLog.setSn(1);
                if (null == achieveStatusLog.getOperateDate()) {
                    achieveStatusLog.setOperateDate(LocalDateTime.now());
                }
                achieveStatusLogList.add(achieveStatusLog);
                QueryWrapper auditResultQueryWrapper = new QueryWrapper();
                ((QueryWrapper)auditResultQueryWrapper.eq((Object)"BIZ_ID_", (Object)achieveStatusLog.getBizId())).eq((Object)"APPROVAL_STATUS_", (Object)0);
                List auditResultList = this.auditResultManager.list((Wrapper)auditResultQueryWrapper);
                if (null != auditResultList && auditResultList.size() > 0) {
                    auditResult = (AuditResult)((Object)auditResultList.get(0));
                    if (StringUtils.isNotBlank((CharSequence)achieveStatusLogAndAuditResultVo.getOperateDeptId())) {
                        auditResult.setReportUnitId(achieveStatusLogAndAuditResultVo.getOperateDeptId());
                        auditResult.setReportUnitName(achieveStatusLogAndAuditResultVo.getOperateDeptName());
                    } else {
                        auditResult.setReportUnitId(achieveStatusLogAndAuditResultVo.getOperateOrgId());
                        auditResult.setReportUnitName(achieveStatusLogAndAuditResultVo.getOperateOrgName());
                    }
                    auditResult.setReportId(achieveStatusLogAndAuditResultVo.getOperateUserId());
                    auditResult.setReceiveName(achieveStatusLogAndAuditResultVo.getOperateOrgName());
                    auditResult.setReceiveLoginAccount(ContextUtil.getCurrentUserAccount());
                    auditResult.setReceiveTime(achieveStatusLogAndAuditResultVo.getOperateDate());
                    auditResult.setApprovalResults(achieveStatusLogAndAuditResultVo.getApprovalResults());
                    auditResult.setApprovalComments(achieveStatusLogAndAuditResultVo.getApprovalComments());
                    auditResult.setApprovalStatus(1);
                    auditResultUpdateList.add(auditResult);
                }
                if (achieveStatusLogAndAuditResultVo.isFinish()) continue;
                auditResult = new AuditResult();
                BeanUtils.copyProperties((Object)((Object)achieveStatusLogAndAuditResultVo), (Object)((Object)auditResult));
                if (StringUtils.isNotBlank((CharSequence)achieveStatusLogAndAuditResultVo.getOperateDeptId())) {
                    auditResult.setSendDeptId(achieveStatusLogAndAuditResultVo.getOperateDeptId());
                    auditResult.setSendDeptName(achieveStatusLogAndAuditResultVo.getOperateDeptName());
                } else {
                    auditResult.setSendDeptId(achieveStatusLogAndAuditResultVo.getOperateOrgId());
                    auditResult.setSendDeptName(achieveStatusLogAndAuditResultVo.getOperateOrgName());
                }
                auditResult.setSendUserId(achieveStatusLogAndAuditResultVo.getOperateUserId());
                auditResult.setSendUserName(achieveStatusLogAndAuditResultVo.getOperateOrgName());
                auditResult.setSendLoginName(ContextUtil.getCurrentUserAccount());
                auditResult.setSendDate(achieveStatusLog.getOperateDate());
                auditResult.setApprovalStatus(0);
                auditResultSaveList.add(auditResult);
            }
            boolean b = this.saveBatch(achieveStatusLogList);
            if (null != auditResultUpdateList && auditResultUpdateList.size() > 0) {
                this.auditResultManager.saveOrUpdateBatch(auditResultUpdateList);
            }
            if (null != auditResultSaveList && auditResultSaveList.size() > 0) {
                this.auditResultManager.saveBatch(auditResultSaveList);
            }
        }
        return true;
    }

    @Override
    public AchieveStatusLog queryAchieveStatusLogByBizIdAndStatus(String bizId, Integer status) {
        Assert.hasText((String)"bizId", (String)"\u4e1a\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"BIZ_ID_", (Object)bizId);
        queryWrapper.eq(com.artfess.base.util.BeanUtils.isNotEmpty((Object)status), (Object)"STATUS_", (Object)status);
        queryWrapper.orderByDesc((Object)"OPERATE_DATE_");
        queryWrapper.last(" limit 1");
        AchieveStatusLog log = (AchieveStatusLog)((Object)((AchieveStatusLogDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
        return log;
    }

    @Override
    public List<AchieveStatusLog> process(String bizId) {
        Assert.notNull((Object)bizId, (String)"\u9700\u8981\u67e5\u8be2\u7684id\u4e0d\u80fd\u4e3a\u7a7a");
        List list = super.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"BIZ_ID_", (Object)bizId)).orderByAsc((Object)"OPERATE_DATE_"));
        return list;
    }
}

