package com.artfess.reform.statistics.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author 黎沐华
 * @since  2023/4/6 15:40
 */
@Data
public class StatementDetailVo {

    @ApiModelProperty(value = "评比区县NAME（关联组织机构表NAME）")
    private String unitName;

    @ApiModelProperty(value = "评比区县CODE（关联组织机构表编码）")
    private String unitCode;

    @ApiModelProperty(value = "评比区县GRADE（关联组织机构表级别）")
    private Integer unitGrade;

    @ApiModelProperty(value = "承接国家级和市级试点项目数(项)")
    private Integer workableProjectNum;

    @ApiModelProperty(value = "承接的国家级和市级试点按时通过验收率（%）")
    private BigDecimal workablePassRate;

    @ApiModelProperty(value = "承接的国家级和市级试点按时通过验收率排名")
    private Integer workablePassSn;

    @ApiModelProperty(value = "承接的国家级和市级试点按时通过验收率排名分档")
    private String workablePassGrade;

    @ApiModelProperty(value = "承接的国家级和市级试点本年度新增数量")
    private Integer workableAddNum;

    @ApiModelProperty(value = "承接的国家级和市级试点本年度新增数量排名")
    private Integer workableAddSn;

    @ApiModelProperty(value = "承接的国家级和市级试点本年度新增数量排名分档")
    private String workableAddGrade;

    @ApiModelProperty(value = "承接的市级试点本年度新增数量")
    private Integer workableCityAddNum;

    @ApiModelProperty(value = "承接的市级试点本年度新增数量排名")
    private Integer workableCityAddSn;

    @ApiModelProperty(value = "承接的市级试点本年度新增数量排名分档")
    private String workableCityAddGrade;

    @ApiModelProperty(value = "承接的国家级试点本年度新增数量")
    private Integer workableNationalAddNum;

    @ApiModelProperty(value = "承接的国家级试点本年度新增数量排名")
    private Integer workableNationalAddSn;

    @ApiModelProperty(value = "承接的国家级试点本年度新增数量排名分档")
    private String workableNationalAddGrade;

    @ApiModelProperty(value = "承接国家级试点项目数量")
    private Integer nationalProjectNum;

    @ApiModelProperty(value = "承接国家级试点项目数量得分")
    private BigDecimal nationalProjectScore;

    @ApiModelProperty(value = "承接国家级试点项目按时验收数量")
    private Integer nationalPassNum;

    @ApiModelProperty(value = "承接国家级试点项目按时验收率")
    private BigDecimal nationalPassRate;

    @ApiModelProperty(value = "承接国家级试点项目按时验收率分档情况")
    private String nationalPassGrade;

    @ApiModelProperty(value = "承接市级试点项目按时验收率排名")
    private Integer nationalPassSn;

    @ApiModelProperty(value = "承接国家级试点项目数量排名")
    private Integer nationalProjectSn;

    @ApiModelProperty(value = "承接国家级试点项目数量排名分档")
    private String nationalProjectGrade;

    @ApiModelProperty(value = "承接市级试点项目数量")
    private Integer cityProjectNum;

    @ApiModelProperty(value = "承接市级试点项目数量得分")
    private BigDecimal cityProjectScore;

    @ApiModelProperty(value = "承接市级试点项目按时验收数量")
    private Integer cityPassNum;

    @ApiModelProperty(value = "承接市级试点项目按时验收率")
    private BigDecimal cityPassRate;

    @ApiModelProperty(value = "承接市级试点项目按时验收率分档情况")
    private String cityPassGrade;

    @ApiModelProperty(value = "承接市级试点项目按时验收率排名")
    private String cityPassSn;

    @ApiModelProperty(value = "承接市级试点项目数量排名")
    private Integer cityProjectSn;

    @ApiModelProperty(value = "承接市级试点项目数量排名分档")
    private String cityProjectGrade;

    @ApiModelProperty(value = "落实改革力得分")
    private BigDecimal workableScore;

    @ApiModelProperty(value = "落实改革力得分区域排名")
    private Integer workableRegionSn;

    @ApiModelProperty(value = "落实改革力得分全市排名")
    private Integer workableAllSn;

    @ApiModelProperty(value = "落实改革力蝉联次数")
    private Integer workableHoldNum;

    @ApiModelProperty(value = "改革经验获全国性肯定评价（件次）")
    private Integer nationwideNum = 0;

    @ApiModelProperty(value = "改革经验获全国性肯定评价（件次）排名")
    private Integer nationwideSn;

    @ApiModelProperty(value = "改革经验获全国性肯定评价（件次）排名分档")
    private String nationwideGrade;

    @ApiModelProperty(value = "改革经验获全市推广（件次）")
    private Integer cityNum = 0;

    @ApiModelProperty(value = "改革经验获全市推广（件次）排名")
    private Integer citySn;

    @ApiModelProperty(value = "改革经验获全市推广（件次）排名分档")
    private String cityGrade;

    @ApiModelProperty(value = "改革经验被5家中央媒体深度专题报道（件次）")
    private Integer mediaNum = 0;

    @ApiModelProperty(value = "改革经验被5家中央媒体深度专题报道（件次）排名")
    private Integer mediaSn;

    @ApiModelProperty(value = "改革经验被5家中央媒体深度专题报道（件次）排名分档")
    private String mediaGrade;

    @ApiModelProperty(value = "品牌显示度得分")
    private BigDecimal brandScore;

    @ApiModelProperty(value = "品牌显示度综合得分区域排名")
    private Integer brandRegionSn;

    @ApiModelProperty(value = "品牌显示度综合得分全市排名")
    private Integer brandAllSn;

    @ApiModelProperty(value = "品牌显示度蝉联次数")
    private Integer brandHoldNum;

    @ApiModelProperty(value = "社情民意电话调查满意度（%）", notes = "即满意度区县结果表BIZ_REFORM_SATISFACTION_DISTRICTS中的综合得分")
    private BigDecimal satisfied;

    @ApiModelProperty(value = "社情民意电话调查满意度得分")
    private BigDecimal satisfiedScore;

    @ApiModelProperty(value = "社情民意电话调查满意度得分排名")
    private Integer satisfiedAllSn;

    @ApiModelProperty(value = "社情民意电话调查满意度得分排名分档")
    private String satisfiedGrade;

    @ApiModelProperty(value = "引发重大负面舆情或群体性事件（件次）")
    private Integer opinionNum;

    @ApiModelProperty(value = "引发重大负面舆情或群体性事件（扣分）")
    private BigDecimal opinionDeScore;

    @ApiModelProperty(value = "改革风险得分")
    private BigDecimal opinionScore;

    @ApiModelProperty(value = "数字重庆建设")
    private BigDecimal digitRate;

    @ApiModelProperty(value = "数字重庆建设排名")
    private Integer digitSn;

    @ApiModelProperty(value = "数字重庆建设排名分档")
    private String digitGrade;

    @ApiModelProperty(value = "国企改革进展进展率")
    private BigDecimal reformRate;

    @ApiModelProperty(value = "国企改革进展进展率分档情况")
    private String reformGrade;

    @ApiModelProperty(value = "国企改革进展进展率排名")
    private Integer reformSn;

    @ApiModelProperty(value = "制造业“亩均论英雄”改革进展率")
    private BigDecimal manufacturingIndustryRate;

    @ApiModelProperty(value = "制造业“亩均论英雄”改革进展率分档情况")
    private String manufacturingIndustryGrade;

    @ApiModelProperty(value = "制造业“亩均论英雄”改革进展进展率排名")
    private Integer manufacturingIndustrySn;

    @ApiModelProperty(value = "建立企业上市助推机制进展(分)")
    private BigDecimal listedCompaniesDivide;

    @ApiModelProperty(value = "建立企业上市助推机制进展率分档情况")
    private String listedCompaniesGrade;

    @ApiModelProperty(value = "建立企业上市助推机制进展率排名")
    private Integer listedCompaniesSn;

    @ApiModelProperty(value = "打造“信用重庆”升级版进展率")
    private BigDecimal creditRate;

    @ApiModelProperty(value = "打造“信用重庆”升级版进展率分档情况")
    private String creditGrade;

    @ApiModelProperty(value = "打造“信用重庆”升级版进展率排名")
    private Integer creditSn;

    @ApiModelProperty(value = "改革风险得分全市排名")
    private Integer opinionAllSn;

    @ApiModelProperty(value = "综合得分", notes = "得分减去扣分后的最终结果")
    private BigDecimal score;

    @ApiModelProperty(value = "综合得分区域排名")
    private Integer regionSn;

    @ApiModelProperty(value = "综合得分全市排名")
    private Integer allSn;

    @ApiModelProperty(value = "综合得分全市排名分档")
    private String allGrade;

    @ApiModelProperty(value = "综合得分蝉联次数")
    private Integer holdNum;

    @ApiModelProperty(value = "区县序号")
    private Integer orderNo;

    public StatementDetailVo() {
    }

    public StatementDetailVo(String unitName, String unitCode, Integer unitGrade) {
        this.unitName = unitName;
        this.unitCode = unitCode;
        this.unitGrade = unitGrade;
    }

}
