package com.artfess.reform.statistics.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;

/**
 * @author chens
 * @since 2023/6/2 10:40
 */
@Data
@ApiModel("区县综合得分情况")
public class CountySynVo {

    @ApiModelProperty(value = "评比日期")
    private LocalDate fillDate;

    @ApiModelProperty(value = "评比年")
    private Integer fillYear;

    @ApiModelProperty(value = "评比季度")
    private Integer fillQuarter;

    @ApiModelProperty(value = "评比区县NAME（关联组织机构表NAME）")
    private String unitName;

    @ApiModelProperty(value = "评比区县CODE（关联组织机构表编码）")
    private String unitCode;

    @ApiModelProperty(value = "评比区县GRADE（关联组织机构表级别）")
    private Integer unitGrade;

    @ApiModelProperty(value = "A档数量")
    private Integer ANum;

    @ApiModelProperty(value = "B档数量")
    private Integer BNum;

    @ApiModelProperty(value = "C档数量")
    private Integer CNum;

    @ApiModelProperty(value = "D档数量")
    private Integer DNum;

    @ApiModelProperty(value = "E档数量")
    private Integer ENum;

    @ApiModelProperty(value = "综合得分情况（A:3 分，B:1分，C:0分，D:-1分，E:-3）")
    private Integer synScore;

    @ApiModelProperty(value = "综合得分全市排名")
    private Integer synSn;

    @ApiModelProperty(value = "综合得分全市排名分档")
    private String synGrade;
}
