package com.artfess.reform.statistics.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 区县落实改革力评分结果
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2023-03-27
 */
@Data
@TableName("BIZ_SCORING_COUNTY_WORKABLE")
@ApiModel(value="BizScoringCountyWorkable对象", description="区县落实改革力评分结果")
public class BizScoringCountyWorkable extends BaseModel<BizScoringCountyWorkable>{

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "评比日期")
    @TableField("FILL_DATE_")
    private LocalDate fillDate;

    @ApiModelProperty(value = "评比年")
    @TableField("FILL_YEAR_")
    private Integer fillYear;

    @ApiModelProperty(value = "评比季度")
    @TableField("FILL_QUARTER_")
    private Integer fillQuarter;

    @ApiModelProperty(value = "评比月")
    @TableField("FILL_MONTH_")
    private Integer fillMonth;

    @ApiModelProperty(value = "评比类型（日：D，月：M，季度：Q，年：Y）")
    @TableField("FILL_TYPE_")
    private String fillType;

    @ApiModelProperty(value = "评比区县NAME（关联组织机构表NAME）")
    @TableField("UNIT_NAME_")
    private String unitName;

    @ApiModelProperty(value = "评比区县CODE（关联组织机构表编码）")
    @TableField("UNIT_CODE_")
    private String unitCode;

    @ApiModelProperty(value = "评比区县GRADE（关联组织机构表级别）")
    @TableField("UNIT_GRADE_")
    private String unitGrade;

    @ApiModelProperty(value = "承接国家级和市级试点项目数(项)")
    @TableField("PROJECT_NUM_")
    private Integer projectNum;

    @ApiModelProperty(value = "承接国家级和市级试点项目得分")
    @TableField("PROJECT_SCORE_")
    private BigDecimal projectScore;

    @ApiModelProperty(value = "本年度新增国家级和市级试点项目数")
    @TableField("ADD_NUM_")
    private Integer addNum;

    @ApiModelProperty(value = "本年度新增国家级和市级试点项目数全市排名")
    @TableField("ADD_SN_")
    private Integer addSn;

    @ApiModelProperty(value = "本年度新增国家级和市级试点项目数全市排名档次（A，B，C，D，E）")
    @TableField("ADD_GRADE_")
    private String addGrade;

    @ApiModelProperty(value = "承接国家级和市级试点项目按时验收(项)")
    @TableField("PASS_NUM_")
    private Integer passNum;

    @ApiModelProperty(value = "承接的国家级和市级试点按时通过验收率（%）")
    @TableField("PASS_RATE_")
    private BigDecimal passRate;

    @ApiModelProperty(value = "承接的国家级和市级试点按时通过验收率得分")
    @TableField("PASS_SCORE_")
    private BigDecimal passScore;

    @ApiModelProperty(value = "承接的国家级和市级试点按时通过验收率全市排名")
    @TableField("PASS_SN_")
    private Integer passSn;

    @ApiModelProperty(value = "承接的国家级和市级试点按时通过验收率全市排名档次（A，B，C，D，E）")
    @TableField("PASS_GRADE_")
    private String passGrade;

    @ApiModelProperty(value = "国家级试点项目数量")
    @TableField("NATIONAL_PROJECT_NUM_")
    private Integer nationalProjectNum;

    @ApiModelProperty(value = "国家级试点项目数量得分")
    @TableField("NATIONAL_PROJECT_SCORE_")
    private BigDecimal nationalProjectScore;

    @ApiModelProperty(value = "国家级试点项目本年度新增数量")
    @TableField("NATIONAL_ADD_NUM_")
    private Integer nationalAddNum;

    @ApiModelProperty(value = "国家级试点项目本年度新增数量排名")
    @TableField("NATIONAL_ADD_SN_")
    private Integer nationalAddSn;

    @ApiModelProperty(value = "国家级试点项目本年度新增数量得分")
    @TableField("NATIONAL_ADD_GRADE_")
    private String nationalAddGrade;

    @ApiModelProperty(value = "国家级试点项目按时验收数量")
    @TableField("NATIONAL_PASS_NUM_")
    private Integer nationalPassNum;

    @ApiModelProperty(value = "国家级试点项目按时验收率")
    @TableField("NATIONAL_PASS_RATE_")
    private BigDecimal nationalPassRate;

    @ApiModelProperty(value = "国家级试点项目按时验收率得分")
    @TableField("NATIONAL_PASS_SCORE_")
    private BigDecimal nationalPassScore;

    @ApiModelProperty(value = "国家级试点项目按时验收率分档情况")
    @TableField("NATIONAL_PASS_GRADE_")
    private String nationalPassGrade;

    @ApiModelProperty(value = "承接的国家级按时通过验收率全市排名")
    @TableField("NATIONAL_PASS_SN_")
    private Integer nationalPassSn;

    @ApiModelProperty(value = "国家级试点项目全市排名")
    @TableField("NATIONAL_PROJECT_SN_")
    private Integer nationalProjectSn;

    @ApiModelProperty(value = "国家级试点项目全市排名档次（A：1~9，B:10~17，C：18~25，D：26~33，E:34~41）")
    @TableField("NATIONAL_PROJECT_GRADE_")
    private String nationalProjectGrade;

    @ApiModelProperty(value = "市级试点项目数量")
    @TableField("CITY_PROJECT_NUM_")
    private Integer cityProjectNum;

    @ApiModelProperty(value = "市级试点项目数量得分")
    @TableField("CITY_PROJECT_SCORE_")
    private BigDecimal cityProjectScore;

    @ApiModelProperty(value = "市级试点项目本年度新增数量")
    @TableField("CITY_ADD_NUM_")
    private Integer cityAddNum;

    @ApiModelProperty(value = "市级试点项目本年度新增数量排名")
    @TableField("CITY_ADD_SN_")
    private Integer cityAddSn;

    @ApiModelProperty(value = "市级试点项目本年度新增数量得分")
    @TableField("CITY_ADD_GRADE_")
    private String cityAddGrade;

    @ApiModelProperty(value = "市级试点项目按时验收数量")
    @TableField("CITY_PASS_NUM_")
    private Integer cityPassNum;

    @ApiModelProperty(value = "市级试点项目按时验收率")
    @TableField("CITY_PASS_RATE_")
    private BigDecimal cityPassRate;

    @ApiModelProperty(value = "市级试点项目按时验收率得分")
    @TableField("CITY_PASS_SCORE_")
    private BigDecimal cityPassScore;

    @ApiModelProperty(value = "市级试点项目按时验收率分档情况")
    @TableField("CITY_PASS_GRADE_")
    private String cityPassGrade;

    @ApiModelProperty(value = "承接的市级按时通过验收率全市排名")
    @TableField("CITY_PASS_SN_")
    private Integer cityPassSn;

    @ApiModelProperty(value = "市级试点项目全市排名")
    @TableField("CITY_PROJECT_SN_")
    private Integer cityProjectSn;

    @ApiModelProperty(value = "市级试点项目全市排名档次（A：1~9，B:10~17，C：18~25，D：26~33，E:34~41）")
    @TableField("CITY_PROJECT_GRADE_")
    private String cityProjectGrade;

    @ApiModelProperty(value = "承接国家级与市级试点项目应该验收数量")
    @TableField("PROJECT_END_NUM_")
    private Integer projectEndNum;

    @ApiModelProperty(value = "承接国家级试点项目应该验收数量")
    @TableField("NATIONAL_END_NUM_")
    private Integer nationalEndNum;

    @ApiModelProperty(value = "承接市级试点项目应该验收数量")
    @TableField("CITY_END_NUM_")
    private Integer cityEndNum;

    @ApiModelProperty(value = "落实改革力得分")
    @TableField("WORKABLE_SCORE_")
    private BigDecimal workableScore;

    @ApiModelProperty(value = "落实改革力得分区域排名")
    @TableField("WORKABLE_REGION_SN_")
    private Integer workableRegionSn;

    @ApiModelProperty(value = "落实改革力得分全市排名")
    @TableField("WORKABLE_ALL_SN_")
    private Integer workableAllSn;

    @ApiModelProperty(value = "蝉联次数")
    @TableField("HOLD_NUM_")
    private Integer holdNum;

    @ApiModelProperty(value = "创建时间", hidden=true)
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value="create_time_", fill=FieldFill.INSERT, select=true)
    private LocalDateTime createTime;

    @ApiModelProperty(value = "最后更新时间戳")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="LAST_TIME_", fill= FieldFill.INSERT_UPDATE, select=false)
    private Long lastTime;

    @ApiModelProperty(value = "市级项目推进个数")
    @TableField(exist = false)
    private Integer cityPushNum;

    @ApiModelProperty(value = "国家级项目推进个数")
    @TableField(exist = false)
    private Integer nationalPushNum;



}
