package com.artfess.reform.statistics.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.*;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.reform.fill.manager.BizBlockageCardTransferManager;
import com.artfess.reform.fill.manager.BizReformDemandAnalysisLibraryManager;
import com.artfess.reform.fill.manager.BizReformDemandAssignmentManager;
import com.artfess.reform.fill.manager.BizReformPilotManagementManager;
import com.artfess.reform.fill.manager.BizReformSatisfactionDistrictsManager;
import com.artfess.reform.fill.model.*;
import com.artfess.reform.fill.vo.BlockageCardTransferVo;
import com.artfess.reform.fill.vo.DemandAssignmentVo;
import com.artfess.reform.fill.vo.EffectDryingCompetitionExportVo;
import com.artfess.reform.statistics.manager.CountyLargeScreeManager;
import com.artfess.reform.statistics.model.BizScoringCountyBrand;
import com.artfess.reform.statistics.vo.*;
import com.artfess.sysConfig.persistence.manager.SysDictionaryDetailManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.ss.usermodel.*;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.*;

/**
 * 区县改革报表大屏接口
 *
 * @author 黎沐华
 * @since 2023/3/31 19:59
 */
@Slf4j
@RestController
@Api(tags = "区县改革报表大屏接口")
@RequestMapping("/county/largeScreen/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class CountyLargeScreeController {

    @Resource
    private CountyLargeScreeManager baseManager;

    @Resource
    private BizReformDemandAnalysisLibraryManager demandAnalysisLibraryManager;

    @Resource
    private BizReformDemandAssignmentManager demandRecordMaanger;

    @Resource
    private BizBlockageCardTransferManager blockageCardTransferManager;

    @Resource
    private  BizReformSatisfactionDistrictsManager satisfactionDistrictsManager;

    @Resource
    private  BizReformPilotManagementManager pilotManagementManager;

    @Resource
    private SysDictionaryDetailManager sysDictionaryDetailManager;

    @PostMapping("/importantIndex")
    @ApiOperation(value = "重点关注", notes = "重点关注")
    public CommonResult<String> importantIndex(@RequestParam(required = false) Integer year, @RequestParam(required = false) Integer quarter) {
        CoreIndexVo data = baseManager.importantIndex(year,quarter);
        return CommonResult.success(data, "查询成功");
    }

    @PostMapping("/indexRank")
    @ApiOperation(value = "逐优榜", notes = "追逐优榜")
    public CommonResult<String> indexRank(@RequestParam(required = false) Integer year, @RequestParam(required = false) Integer quarter) {
        List<CountySynVo> data = baseManager.indexRank(year,quarter);
        return CommonResult.success(data, "查询成功");
    }

    @PostMapping("/indexRankExport")
    @ApiOperation(value = "逐优榜excel导出", notes = "追逐优榜")
    public void indexRankExport(HttpServletResponse response,@RequestParam(required = false) Integer year, @RequestParam(required = false) Integer quarter) throws Exception {
        List<CountySynVo> rows = baseManager.indexRank(year, quarter);
        List<Map<String, Object>> list = new ArrayList<>();
        int no=1;
        if (rows != null && rows.size() > 0) {
            for (CountySynVo row : rows) {
                String jsonStr = JsonUtil.toJson(row);
                Map<String, Object> map = JsonUtil.toMap(jsonStr);
                map.put("no",no);
                list.add(map);
                no++;
            }
            String tempName = "创先争优";
            Map<String, String> exportMaps = new LinkedHashMap<>();
            exportMaps.put("no", "序号");
            exportMaps.put("unitName", "涉及区县");
            exportMaps.put("anum", "A档");
            exportMaps.put("bnum", "B档");
            exportMaps.put("cnum", "C档");
            exportMaps.put("dnum", "D档");
//            exportMaps.put("enum", "E档");
            exportMaps.put("synScore", "得分");
            exportMaps.put("synSn", "排名");
            exportMaps.put("grade", "总档位");
            HSSFWorkbook book = ExcelUtil.exportExcel(tempName, 24, exportMaps, list);
            //设置excel表头高度
            HSSFSheet sheet = book.getSheetAt(0);
            HSSFRow hssfRow = sheet.getRow(0);
            hssfRow.setHeightInPoints(25);
            ExcelUtil.downloadExcel(book, tempName, response);
        }
    }

    @PostMapping("/pilotReform")
    @ApiOperation(value = "改革试点", notes = "")
    public CommonResult<String> pilotReform(@RequestParam(required = false) Integer year, @RequestParam(required = false) Integer quarter, @RequestParam(required = false) String unitCode) {
        Assert.isTrue(quarter == null || (quarter >= 1 && quarter <= 4), "季度传递错误，允许值【1~4】");
        CountyPilotReformVo data = baseManager.pilotReform(year, quarter, unitCode);
        return CommonResult.success(data, "查询成功");
    }

    @PostMapping("/pilotResultDetail")
    @ApiOperation(value = "改革试点成果详情", notes = "切换成果类型，查询字段RESULT_FORM_，参考字典ggsd_cgxs")
    public PageList<BizPilotAdvanceResult> pilotResultDetail(@ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter<BizPilotAdvanceResult> queryFilter) {
        return baseManager.pilotResultDetail(queryFilter);
    }

    @PostMapping("/pilotLedger")
    @ApiOperation(value = "改革试点台账")
    public CommonResult<String> pilotLedger(@RequestParam(required = false) Integer year, @RequestParam(required = false) Integer quarter) {
        List<CountyChartVo> data = baseManager.pilotLedger(year,quarter);
        return CommonResult.success(data, "查询成功");
    }

    @PostMapping("/pilotLedgerDetail")
    @ApiOperation(value = "重点关注-改革试点台账详情数据", notes = "切换层级参数PILOT_LEVEL_，（使用字典，1：国家级，2：市级）")
    public PageList<BizReformPilotManagement> pilotLedgerDetail(@ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter<BizReformPilotManagement> queryFilter) {
        return baseManager.pilotLedgerDetail(queryFilter);
    }

    @PostMapping("/pilotLedgerDetail_spc")
    @ApiOperation(value = "试点示范-改革试点台账详情数据", notes = "切换层级参数PILOT_LEVEL_，（使用字典，1：国家级，2：市级）")
    public PageList<BizReformPilotManagement> pilotLedgerDetailSpc(@ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter<BizReformPilotManagement> queryFilter) {
        return baseManager.pilotLedgerDetail(queryFilter);
    }

    @PostMapping("/pilotLedgerDetailExport")
    @ApiOperation(value = "改革试点台账详情数据导出", notes = "切换层级参数PILOT_LEVEL_，（使用字典，1：国家级，2：市级）")
    public void pilotLedgerDetailExport(HttpServletResponse response,@ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter<BizReformPilotManagement> queryFilter) throws Exception {
        List<BizReformPilotManagement> rows = pilotManagementManager.queryLatest(queryFilter);
        List<Map<String, Object> > list = new ArrayList<>();
            if(rows!=null && rows.size()>0){
            for (BizReformPilotManagement demand : rows) {
                String jsonStr = JsonUtil.toJson(demand);
                Map<String, Object> map = JsonUtil.toMap(jsonStr);
                list.add(map);
        }
        String tempName = "试点项目台账数据";
        Map<String, String> exportMaps = new LinkedHashMap<String, String>();
        exportMaps.put("pilotProjectName", "试点项目名称");
        exportMaps.put("docNo", "试点项目文号");
        exportMaps.put("pilotLevelText", "试点层级");
        exportMaps.put("pilotSupervisorText", "主管部委");
        exportMaps.put("unitName", "市级主管部门");
        exportMaps.put("pilotFieldText", "所属领域");
        exportMaps.put("pilotRunwayText", "所属跑道");
        exportMaps.put("startTime", "部署时间");
        exportMaps.put("acceptanceTime", "预计验收时间");
        exportMaps.put("invsUnitName", "上报区县");
        exportMaps.put("propulsiveDetails", "开展工作");
        exportMaps.put("invActualTime", "实际验收时间");
        exportMaps.put("propulsiveStatusText", "推进状态");
        HSSFWorkbook book = ExcelUtil.exportExcel(tempName, 24, exportMaps, list);
        ExcelUtil.downloadExcel(book, tempName, response);
    }

//    @PostMapping("/queryLatest")
//    @ApiOperation(value = "改革试点台账详情数据导出", notes = "切换层级参数PILOT_LEVEL_，（使用字典，1：国家级，2：市级）")
//    public void queryLatest(HttpServletResponse response,@ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter<BizReformPilotManagement> queryFilter) throws Exception {
//        List<BizReformPilotManagement> rows = pilotManagementManager.queryLatest(queryFilter);
//        List<Map<String, Object> > list = new ArrayList<>();
//        String pilotLevelStr = "";
//        if(rows!=null && rows.size()>0){
//            for (BizReformPilotManagement demand : rows) {
//                String jsonStr = JsonUtil.toJson(demand);
//                Map<String, Object> map = JsonUtil.toMap(jsonStr);
//
//                if (map.get("pilotLevel") != null && map.get("pilotLevel").toString().equals("1") && map.get("pilotSupervisor") != null) {
//                    String pilotSupervisor = map.get("pilotSupervisor").toString();
//                    String pilotSupervisorText = sysDictionaryDetailManager.getTextByValue("zgbw", pilotSupervisor);
//                    map.put("pilotSupervisorText", pilotSupervisorText);
//                } else {
//                    map.put("pilotSupervisorText", "");
//                }
//
//                if (map.get("pilotLevel") != null) {
//                    String pilotLevel = map.get("pilotLevel").toString();
//                    pilotLevelStr = pilotLevel;
//                    String pilotLevelText = sysDictionaryDetailManager.getTextByValue("sdcj", pilotLevel);
//                    map.put("pilotLevelText", pilotLevelText);
//                } else {
//                    map.put("pilotLevelText", "");
//                }
//
//                if (map.get("pilotField") != null) {
//                    String pilotField = map.get("pilotField").toString();
//                    String pilotFieldText = sysDictionaryDetailManager.getTextByValue("ggbb_ssly", pilotField);
//                    map.put("pilotFieldText", pilotFieldText);
//                } else {
//                    map.put("pilotFieldText", "");
//                }
//
//                if (map.get("pilotRunway") != null) {
//                    String pilotRunway = map.get("pilotRunway").toString();
//                    String pilotRunwayText = sysDictionaryDetailManager.getTextByValue("ggbb_sspd", pilotRunway);
//                    map.put("pilotRunwayText", pilotRunwayText);
//                } else {
//                    map.put("pilotRunwayText", "");
//                }
//
//                if (map.get("propulsiveStatus") != null) {
//                    String propulsiveStatus = map.get("propulsiveStatus").toString();
//                    String propulsiveStatusText = sysDictionaryDetailManager.getTextByValue("sd_tjzt", propulsiveStatus);
//                    map.put("propulsiveStatusText", propulsiveStatusText);
//                } else {
//                    map.put("propulsiveStatusText", "未启动");
//                }
//                list.add(map);
//
//            }
//        }
//        String tempName = "试点项目台账数据";
//        Map<String, String> exportMaps = new LinkedHashMap<String, String>();
//
//        exportMaps.put("pilotProjectName", "试点项目名称");
//        exportMaps.put("docNo", "试点项目文号");
//        exportMaps.put("pilotLevelText", "试点层级");
//        if(pilotLevelStr.equals("1")){
//            exportMaps.put("pilotSupervisorText", "主管部委");
//        }
//        exportMaps.put("unitName", "市级主管部门");
//        exportMaps.put("pilotFieldText", "所属领域");
//        exportMaps.put("pilotRunwayText", "所属跑道");
//        exportMaps.put("startTime", "部署时间");
//        exportMaps.put("acceptanceTime", "预计验收时间");
//        exportMaps.put("invsUnitName", "上报区县");
//        exportMaps.put("propulsiveDetails", "开展工作");
//        exportMaps.put("actualTime", "实际验收时间");
//        exportMaps.put("propulsiveStatusText", "推进状态");
//        HSSFWorkbook book = ExcelUtil.exportExcel(tempName, 24, exportMaps, list);
//        ExcelUtil.downloadExcel(book, tempName, response);
//
    }

    @PostMapping("/pilotPushDetailforUnit")
    @ApiOperation(value = "查询区县改革试点项目推进详情", notes = "查询区县改革试点项目推进详情")
    public BizReformPilotManagement pilotPushDetail(@ApiParam(name = "id", value = "试点项目ID") @RequestParam String id,
                                                    @ApiParam(name = "unitCode", value = "试点项目推进区县code") @RequestParam String unitCode) {
        return baseManager.pilotPushDetail(id,unitCode);
    }

    @PostMapping("/brandReform")
    @ApiOperation(value = "改革品牌榜")
    public CommonResult<String> brandReform(@ApiParam("年份，非必要，默认当年，只影响图表数据") @RequestParam(required = false) Integer year,@RequestParam(required = false) Integer quarter) {
       List<Integer> effectForm =new ArrayList<>();
        effectForm.add(1);
        effectForm.add(2);
//        effectForm.add(3);
        CountyBrandVo data = baseManager.brandReform(year, quarter,"",effectForm);
        return CommonResult.success(data, "查询成功");
    }

    @PostMapping("/brandReformDetails")
    @ApiOperation(value = "查询区县改革品牌榜详情")
    public CommonResult<String> brandReformDetails(@ApiParam("区县编码") @RequestParam(required = true) String unitCode,
                                            @ApiParam("年份，非必要，默认当年，只影响图表数据") @RequestParam(required = false) Integer year,
                                            @RequestParam(required =false) Integer quarter, @RequestBody QueryFilter<BizEffectEffectiveness> queryFilter) {
        List<Integer> list = new ArrayList<>();
        list.add(1);
        list.add(2);
        queryFilter.addFilter("e.effect_Form_",list,QueryOP.IN);
        List<BizEffectEffectiveness> details = baseManager.brandReformDetails(unitCode, year,quarter,queryFilter);
        return CommonResult.success(details, "查询成功");
    }

    @PostMapping("/brandReformDetailsExport")
    @ApiOperation(value = "区县改革品牌榜详情excel导出")
    public void brandReformDetails(HttpServletResponse response,@ApiParam("区县编码") @RequestParam(required = true) String unitCode,
                                                   @ApiParam("年份，非必要，默认当年，只影响图表数据") @RequestParam(required = false) Integer year,
                                                   @RequestParam(required =false) Integer quarter, @RequestBody QueryFilter<BizEffectEffectiveness> queryFilter) {

        try {
            List<Integer> effectFormList = new ArrayList<>();
            effectFormList.add(1);
            effectFormList.add(2);
            queryFilter.addFilter("e.effect_Form_",effectFormList,QueryOP.IN);
            List<BizEffectEffectiveness> details = baseManager.brandReformDetails(unitCode, year,quarter,queryFilter);
            List<Map<String, Object>> list = new ArrayList<>();
            if(BeanUtils.isNotEmpty(details)){
                int i=1;
                for (BizEffectEffectiveness effect : details) {
                    String jsonStr = JsonUtil.toJson(effect);
                    Map<String, Object> map = JsonUtil.toMap(jsonStr);
                    //序号
                    map.put("sn",i);
                    i++;
                    //成效形式
                    if(map.get("effectForm")!=null){
                        String effectForm = map.get("effectForm").toString();
                        String effectFormText = sysDictionaryDetailManager.getTextByValue("cxxs",effectForm);
                        map.put("effectFormText",effectFormText);
                    }else{
                        map.put("effectFormText","");
                    }

                    //具体情形
                    if(map.get("specificDetails")!=null){
                        String specificDetails = map.get("specificDetails").toString();
                        String specificDetailsText = sysDictionaryDetailManager.getTextByValue("cxxs-jtqx",specificDetails);
                        map.put("specificDetailsText",specificDetailsText);
                    }else{
                        map.put("specificDetailsText","");
                    }

                    list.add(map);
                }
            }
            String tempName = "品牌显示度台账";
            Map<String, String> exportMaps = new LinkedHashMap<String, String>();
            exportMaps.put("sn", "序号");
            exportMaps.put("effectTopic", "改革事项");
            exportMaps.put("createOrgName", "填报区县");
            exportMaps.put("effectFormText", "成效形式");
            exportMaps.put("specificDetailsText", "具体情形");
            exportMaps.put("solveProblem", "解决问题");
            exportMaps.put("result", "主要成果");
            HSSFWorkbook book = ExcelUtil.exportTemplateExcel(tempName, exportMaps, list,1,"excel/effectCockpit.xls");
            ExcelUtil.downloadExcel(book, tempName, response);
            FileOutputStream fileOutputStream = new FileOutputStream("C:/Users/PC/Desktop/品牌显示度台账.xls");
            book.write(fileOutputStream);
        } catch (Exception e) {
            throw new RuntimeException("导出失败：" + e.getMessage());
        }
    }

    @PostMapping("/citywidePromotionRank")
    @ApiOperation(value = "全市推广排行榜", notes = "type: 1：全市推广，2：全国+媒体推广")
    public CommonResult<String> citywidePromotionRank(@RequestParam(required = false) Integer year, @RequestParam(required = false) Integer quarter, @RequestParam(required = true) Integer type) {
        List<BizScoringCountyBrand> data = baseManager.citywidePromotionRank(year,quarter,type);
        return CommonResult.success(data, "查询成功");
    }

    @PostMapping("/cityPromotionDetail")
    @ApiOperation(value = "全市推广一本账数据")
    public PageList<BizEffectEffectiveness> cityPromotionDetail(
            @ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter<BizEffectEffectiveness> queryFilter) {
        return baseManager.cityPromotionDetail(queryFilter);
    }

    @PostMapping("/gisIndex")
    @ApiOperation(value = "Gis指数数据", notes = "type: composite 综合评价指数、workable 改革落实力、brand 品牌显示度、satisfaction 改革满意度、risk 风险管控力")
    public JSONArray gisIndex(@RequestParam String type,@RequestParam(required = false) Integer year, @RequestParam(required = false) Integer quarter) {
        return baseManager.gisIndex(type,year,quarter);
    }

    @PostMapping("/satisfactionRealityDate")
    @ApiOperation(value = "满意度实际数据日期", notes = "满意度实际数据日期")
    public CommonResult<String> satisfactionRealityDate(@RequestParam(required = false) Integer year, @RequestParam(required = false) Integer quarter) {
        String str = baseManager.satisfactionRealityDate(year,quarter);
        return CommonResult.success(str, "查询成功");
    }

    @PostMapping("/currentStatementFile")
    @ApiOperation(value = "报表综合分析·当前文档")
    public JSONObject currentStatementFile(
            @ApiParam(name = "year", value = "年份，非必须，默认当年") @RequestParam(required = false) Integer year,
            @ApiParam(name = "quarter", value = "季度，非必须，默认当年当季") @RequestParam(required = false) Integer quarter) {
        Assert.isTrue(quarter == null || (quarter >= 1 && quarter <= 4), "季度传递错误，允许值【1~4】");
        return baseManager.currentStatementFile(year,quarter);
    }

    @PostMapping("/historyStatementFile")
    @ApiOperation(value = "报表综合分析·历史文档")
    public JSONObject historyStatementFile(
            @ApiParam(name = "year", value = "年份，非必须，默认当年") @RequestParam(required = false) Integer year){
        return baseManager.historyStatementFile(year);
    }

    @PostMapping("/statementDetail")
    @ApiOperation(value = "报表综合分析·详细")
    public List<StatementDetailVo> statementDetail(@ApiParam(name = "year", value = "年份，非必须，参数只影响历史报告") @RequestParam(required = false) Integer year,
                                                   @ApiParam(name = "quarter", value = "季度，非必须，参数只影响历史报告") @RequestParam(required = false) Integer quarter) {
        Assert.isTrue(quarter == null || (quarter >= 1 && quarter <= 4), "季度传递错误，允许值【1~4】");
        return baseManager.statementDetail(year, quarter);
    }


    @RequestMapping(value = "statementDetailExport", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "区县报表导出", httpMethod = "POST", notes = "区县报表导出")
    public void statementDetailExport(HttpServletResponse response,@ApiParam(name = "year", value = "年份，非必须，参数只影响历史报告") @RequestParam(required = false) Integer year,
                                                   @ApiParam(name = "quarter", value = "季度，非必须，参数只影响历史报告") @RequestParam(required = false) Integer quarter,@RequestParam(required = false) boolean isShow)throws Exception {
        Assert.isTrue(quarter == null || (quarter >= 1 && quarter <= 4), "季度传递错误，允许值【1~4】");
        String path="";
        if (year>=2023&&quarter<=2){
            path="excel/firstEditionIndex.xls";
        }else {
            path="excel/secondEditionIndex.xls";
        }
        List<StatementDetailVo>  rows = baseManager.statementDetail(year, quarter);
        List<Map<String, Object> > list = new ArrayList<>();
        if(rows!=null && rows.size()>0){
            for (StatementDetailVo demand : rows) {
                String jsonStr = JsonUtil.toJson(demand);
                Map<String, Object> map = JsonUtil.toMap(jsonStr);
                list.add(map);
            }
        }
        String tempName = "区县改革报表数据";
        Map<String, String> exportMaps = new LinkedHashMap<String, String>();
        exportMaps.put("unitName", "区县");
        exportMaps.put("allSn", "排名");
        exportMaps.put("allGrade", "分档");
        exportMaps.put("digitRate", "数字重庆建设进展（%）");
        exportMaps.put("nationalProjectGrade", "承接国家级试点项目档次");
        exportMaps.put("nationalProjectNum", "承接国家级试点项目数");
        exportMaps.put("nationwideGrade", "改革经验获全国性肯定评价档次");
        exportMaps.put("nationwideNum", "改革经验获全国性肯定评价");
        exportMaps.put("cityGrade", "改革经验获全市推广档次");
        exportMaps.put("cityNum", "改革经验获全市推广");
        exportMaps.put("cityGrade", "改革经验获全市推广档次");
        exportMaps.put("cityNum", "改革经验获全市推广");
        exportMaps.put("satisfiedGrade", "社情民意电话调查满意度档次");
        exportMaps.put("satisfied", "社情民意电话调查满意度");
        if (year>=2023&&quarter>2) {
            exportMaps.put("workableNationalAddGrade","新增国家试点项目数档次");
            exportMaps.put("workableNationalAddNum","新增国家试点项目数");
            exportMaps.put("listedCompaniesGrade","建立企业上市助推机制进展档次");
            exportMaps.put("listedCompaniesDivide","建立企业上市助推机制得分");
            exportMaps.put("creditGrade","打造\"信用重庆\"升级版进展档次");
            exportMaps.put("creditRate","打造\"信用重庆\"升级版得分");
        }
        if (isShow){
            if (year>=2023&&quarter<=2){
                path= "excel/firstCompleteIndex.xls";
                exportMaps.put("workableNationalAddGrade","新增国家试点项目数档次");
                exportMaps.put("workableNationalAddNum","新增国家试点项目数");
                exportMaps.put("listedCompaniesGrade","建立企业上市助推机制进展档次");
                exportMaps.put("listedCompaniesDivide","建立企业上市助推机制得分");
                exportMaps.put("creditGrade","打造\"信用重庆\"升级版进展档次");
                exportMaps.put("creditRate","打造\"信用重庆\"升级版得分");
            }else {
                path="excel/secondCompleteIndex.xls";
            }
            exportMaps.put("nationalPassGrade","承接的国家试点按时通过验收率档次");
            exportMaps.put("nationalPassRate","承接的国家试点按时通过验收率");
            exportMaps.put("reformGrade","国企改革进展档次");
            exportMaps.put("reformRate","国企改革进展");
            exportMaps.put("manufacturingIndustryGrade","制造业\"亩均论英雄\"改革进展档次");
            exportMaps.put("manufacturingIndustryRate","制造业\"亩均论英雄\"改革进展");
        }
        HSSFWorkbook book = ExcelUtil.exportTemplateExcel(tempName,exportMaps,list,2,path);
        ExcelUtil.downloadExcel(book,tempName,response);
    }

    @PostMapping("/queryCoreIndex")
    @ApiOperation(value = "二级·大屏核心指数")
    public CoreIndexVo queryCoreIndex(@ApiParam(name = "year", value = "年份，非必须，参数只影响历史报告") @RequestParam(required = false) Integer year,
                                      @ApiParam(name = "quarter", value = "季度，非必须，参数只影响历史报告") @RequestParam(required = false) Integer quarter,
                                      @ApiParam(name = "unitCode", value = "区县编码") @RequestParam(required = true) String unitCode
    ) {
        Assert.isTrue(quarter == null || (quarter >= 1 && quarter <= 4), "季度传递错误，允许值【1~4】");
        return baseManager.queryCoreIndex(unitCode, year, quarter);
    }

    @PostMapping("/queryFieldSatisfaction")
    @ApiOperation(value = "二级·查询5个领域满意度数据")
    public List<BizReformSatisfactionDistricts> queryFieldSatisfaction(@ApiParam(name = "year", value = "年份，非必须，参数只影响历史报告") @RequestParam(required = false) Integer year,
                                                               @ApiParam(name = "quarter", value = "季度，非必须，参数只影响历史报告") @RequestParam(required = false) Integer quarter,
                                                               @ApiParam(name = "unitCode", value = "区县编码") @RequestParam(required = true) String unitCode
    ) {
        Assert.isTrue(quarter == null || (quarter >= 1 && quarter <= 4), "季度传递错误，允许值【1~4】");
        return satisfactionDistrictsManager.qureyFieldByUnitCode(unitCode, year, quarter);
    }

    @PostMapping("/queryIndexSn")
    @ApiOperation(value = "二级·大屏指数排行")
    public CoreIndexVo queryIndexSn(@ApiParam(name = "year", value = "年份，非必须，参数只影响历史报告") @RequestParam(required = false) Integer year,
                                    @ApiParam(name = "quarter", value = "季度，非必须，参数只影响历史报告") @RequestParam(required = false) Integer quarter,
                                    @ApiParam(name = "unitCode", value = "区县编码") @RequestParam(required = true) String unitCode) {
        Assert.isTrue(quarter == null || (quarter >= 1 && quarter <= 4), "季度传递错误，允许值【1~4】");
        return baseManager.queryIndexSn(unitCode, year, quarter);
    }

    @PostMapping("/reformDemand_sec")
    @ApiOperation(value = "二级·改革需求")
    public JSONObject reformDemand(@ApiParam(name = "year", value = "年份，非必须，参数只影响历史报告") @RequestParam(required = false) Integer year,
                                   @ApiParam(name = "quarter", value = "季度，非必须，参数只影响历史报告") @RequestParam(required = false) Integer quarter,
                                   @RequestParam(required = true) String unitCode){
        return baseManager.reformDemand(year,quarter,unitCode);
    }

    @PostMapping("/reformDemandDetails_sec")
    @ApiOperation(value = "二级·改革需求详情")
    public  PageList<BizReformDemandAnalysisLibrary> reformDemandDetails(@RequestBody QueryFilter<BizReformDemandAnalysisLibrary> queryFilter){
        queryFilter.addFilter("STATUS_", 5, QueryOP.EQUAL);
        queryFilter.addFilter("IS_DELE_", "0", QueryOP.EQUAL);
        return demandAnalysisLibraryManager.query(queryFilter);
    }

    @PostMapping("/reformDemandDetailList_sec")
    @ApiOperation(value = "二级·改革需求清单详情")
    public PageList<DemandAssignmentVo>  reformDemandDetailList(@ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter<BizReformDemandAssignment> queryFilter) {
        // 清单数据
        queryFilter.addFilter("a.is_dele_", "0", QueryOP.EQUAL);
        PageList<DemandAssignmentVo> recordList = demandRecordMaanger.queryDemandAssignment(queryFilter);
        return recordList;
    }

    @PostMapping("/problemSolving_sec")
    @ApiOperation(value = "二级·问题破解")
    public JSONObject problemSolving(@ApiParam(name = "year", value = "年份，非必须，参数只影响历史报告") @RequestParam(required = false) Integer year,
                                     @ApiParam(name = "quarter", value = "季度，非必须，参数只影响历史报告") @RequestParam(required = false) Integer quarter,
                                     @RequestParam(required = true) String unitCode){
        return baseManager.problemSolving(year,quarter,unitCode);
    }

    @PostMapping("/problemSolvingDetail_sec")
    @ApiOperation(value = "二级·问题破解详情")
    public PageList<BlockageCardTransferVo> problemSolving(@ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter<BizBlockageCardTransfer> queryFilter){
        return blockageCardTransferManager.queryBlockageCardDetailList(queryFilter);
    }

    @PostMapping("/brandBuild_sec")
    @ApiOperation(value = "二级·品牌创建")
    public JSONObject brandBuild(@ApiParam(name = "year", value = "年份，非必须，参数只影响历史报告") @RequestParam(required = false) Integer year,
                                 @ApiParam(name = "quarter", value = "季度，非必须，参数只影响历史报告") @RequestParam(required = false) Integer quarter,
                                 @RequestParam(required = true) String unitCode,
                                 @RequestBody QueryFilter<BizEffectEffectiveness> queryFilter){
        return baseManager.brandBuild(year,quarter,unitCode,queryFilter);
    }

    @PostMapping("/pilotLedgerDetail_sec")
    @ApiOperation(value = "二级.改革试点台账详情数据", notes = "切换层级参数PILOT_LEVEL_，（使用字典，1：国家级，2：市级）")
    public PageList<BizReformPilotManagement> pilotLedgerDetailSec(@ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter<BizReformPilotManagement> queryFilter) {
        return baseManager.pilotLedgerDetailSec(queryFilter);
    }

    @PostMapping("/satisfaction_files")
    @ApiOperation(value = "满意度分析报告")
    public BizReformSatisfactionManagement satisfactionFiles(@ApiParam(name = "year", value = "年份，必须") @RequestParam(value = "year") Integer year,
                                                             @ApiParam(name = "quarter", value = "季度，必须") @RequestParam(value = "quarter")Integer quarter) {
        return baseManager.getByFiles(year,quarter);
    }

//    @PostMapping("/isLook")
//    @ApiOperation(value = "判断是否能够查看区县大屏权限")
//    public CommonResult<String> isLook() {
//        Boolean look = baseManager.isLook();
//        return new CommonResult<>(look,"查询成功");
//    }

}
