package com.artfess.reform.majorProjects.model;

import java.math.BigDecimal;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.base.typehandle.StringConvert2IntHandler;
import com.baomidou.mybatisplus.annotation.*;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 改革方案明确的量化目标表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
@Data
@TableName("BIZ_PILOT_QUANTITATIVE_OBJECTIVES")
@ApiModel(value="BizPilotQuantitativeObjectives对象", description="改革方案明确的量化目标表")
public class PilotQuantitativeObjectives extends AutoFillFullModel<PilotQuantitativeObjectives> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "重大项目ID（关联市级重大改革项目管理表ID）")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "量化目标")
    @TableField("REFORM_QUANTITATIVE_OBJECTIVES_")
    private String reformQuantitativeObjectives;

    @ApiModelProperty(value = "目标单位")
    @TableField("REFORM_QUANTITATIVE_OBJECTIVES_UNIT_")
    private String reformQuantitativeObjectivesUnit;

    @ApiModelProperty(value = "最新进度值")
    @TableField("REFORM_QUANTITATIVE_OBJECTIVES_VALUE_")
    private BigDecimal reformQuantitativeObjectivesValue;

    @ApiModelProperty(value = "最新完成率")
    @TableField("COMPLIANCE_RATE_")
    private BigDecimal complianceRate;

    @ApiModelProperty(value = "推进状态（1：未开始，2：进行中，3：已完成）")
    @TableField("PROGRESS_STATUS_")
    private Integer progressStatus;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "月度目标")
    @TableField(exist = false)
    private String reformQuantitativeObjectivesMouth;

    @ApiModelProperty(value = "年度目标")
    @TableField(exist = false)
    private String reformQuantitativeObjectivesYear;

    @TableLogic
    @TableField(value = "IS_DELE_",typeHandler = StringConvert2IntHandler.class)
    @ApiModelProperty(name="isDelete",notes="是否已删除 0：未删除 1：已删除（新增、更新数据时不需要传入）")
    protected String isDele = "0";

    @ApiModelProperty(value = "改革方案明确的量化目标的计划值集合")
    @TableField(exist = false)
    private List<PilotObjectivesDetails> pilotObjectivesDetailsList;

    @ApiModelProperty(value = "改革方案量化目标进度计划推进情况集合")
    @TableField(exist = false)
    private List<PilotQuantitativeObjectivesPush> pilotQuantitativeObjectivesPushList;
}
