package com.artfess.reform.majorProjects.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.model.BizReformDemandAssignment;
import com.artfess.reform.majorProjects.manager.MunicipalMajorProjectManagementManager;
import com.artfess.reform.majorProjects.manager.PilotProjectFillManager;
import com.artfess.reform.majorProjects.model.*;
import com.artfess.reform.majorProjects.dao.PilotExperiencePushDao;
import com.artfess.reform.majorProjects.manager.PilotExperiencePushManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.majorProjects.vo.PilotExperiencePushVo;
import com.artfess.reform.majorProjects.vo.PilotProjectFillCreateVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.exception.BaseException;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 项目经验推广总结情况 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-13
 */
@Service
public class BizPilotExperiencePushManagerImpl extends BaseManagerImpl<PilotExperiencePushDao, PilotExperiencePush> implements PilotExperiencePushManager {


    @Resource
    private FileManager fileManager;

    @Resource
    private PilotProjectFillManager pilotProjectFillManager;
    @Resource
    private MunicipalMajorProjectManagementManager municipalMajorProjectManagementManager;
    @Autowired
    private AchieveStatusLogManager achieveStatusLogManager;

    @Override
    @Transactional
    public boolean saveOrUpdateList(List<PilotExperiencePush> list) {
        boolean result = super.saveOrUpdateBatch(list);
        if(null != list && list.size() > 0){
            list.stream().forEach(p->{
                List<DefaultFile> defaultFileList = p.getDefaultFileList();
                if(null != defaultFileList && defaultFileList.size() > 0){
                    List<String> fileList = defaultFileList.stream().map(f -> f.getId()).collect(Collectors.toList());
                    // 修改附件bizId
                    fileManager.updateFileBizIdByIds(fileList, p.getId());
                }
            });
        }
        return result;
    }

    @Override
    public PageList<PilotExperiencePush> queryByPage(QueryFilter<PilotExperiencePush> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        IPage<PilotExperiencePush> result = baseMapper.queryByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter,currentModelClass()));
        List<PilotExperiencePush> list = result.getRecords();

        if(null != list && list.size() > 0){
            list.stream().forEach(p->{
                p.setDefaultFileList(fileManager.queryFileByBizId(p.getId()));
            });
        }
        return new PageList<>(result);
    }


    @Override
    public List<PilotProjectFill> queryHistory(QueryFilter<PilotProjectFill> queryFilter) {
        //1.查询审核表最近操作的两条数据
        queryFilter.addFilter("IS_DELE_","0",QueryOP.EQUAL);
        List<PilotProjectFill> result = pilotProjectFillManager.query(queryFilter).getRows();
        //2.查询这两条的经验推广数据
        if(BeanUtils.isNotEmpty(result) && result.size()>0){
            List<PilotExperiencePush> dataList = new ArrayList<>();
            for(PilotProjectFill ppf : result){
                if(BeanUtils.isNotEmpty(ppf.getStatus())){
                    if(ppf.getStatus()==2||ppf.getStatus()==4){
                        QueryWrapper<AchieveStatusLog> logQW = new QueryWrapper<>();
                        logQW.eq("BIZ_ID_",ppf.getId()).eq("APPROVAL_RESULTS_","1")
                                .orderByDesc("LAST_TIME_").last("limit 1");
                        AchieveStatusLog achieveStatusLog = achieveStatusLogManager.getBaseMapper().selectOne(logQW);
                        ppf.setApprovalComments(achieveStatusLog.getApprovalComments());
                    }
                }


                QueryWrapper<PilotExperiencePush> pilotExperiencePushQW = new QueryWrapper<>();
                pilotExperiencePushQW.eq("FILL_ID_",ppf.getId());
                List<PilotExperiencePush> pilotExperiencePushes = baseMapper.selectList(pilotExperiencePushQW);
                ppf.setPilotExperiencePushList(pilotExperiencePushes);
                if(BeanUtils.isNotEmpty(pilotExperiencePushes)&&pilotExperiencePushes.size()>0){
                    dataList.addAll(pilotExperiencePushes);
                }
            }

            if(null != dataList && dataList.size() > 0){
                dataList.stream().forEach(p->{
                    p.setDefaultFileList(fileManager.queryFileByBizId(p.getId()));
                });
            }
        }

        return result;
    }


    @Override
    public PilotExperiencePush detailedById(String id) {
        PilotExperiencePush result = super.getById(id);
        result.setDefaultFileList(fileManager.queryFileByBizId(id));
        return result;
    }

    @Override
    @Transactional
    public boolean removeByIds(String ids) {
        boolean result = super.removeByIds(Arrays.asList(ids.split(",")));
        return result;
    }

    @Override
    @Transactional
    public void saveDraftOrCommit(PilotExperiencePushVo pilotExperiencePushVo) {
        List<PilotExperiencePush> list = pilotExperiencePushVo.getPilotExperiencePushList();
        String projectId = list.get(0).getProjectId();
        Integer status = BeanUtils.isNotEmpty(pilotExperiencePushVo.getStatus())?pilotExperiencePushVo.getStatus():0;

        List<String> fillIds = list.stream().filter(s -> BeanUtils.isNotEmpty(s.getFillId())).map(s -> s.getFillId()).collect(Collectors.toList());
        String fillId = "";

        LocalDate data = LocalDate.now();
        int monthValue = data.getMonthValue();
        int quarter = (monthValue - 1) / 3 + 1;
        //如果经验推广数据里不包含填报ID，说明这次是新增，创建一条填报数据，否则为编辑就不需要创建
        if(BeanUtils.isEmpty(fillIds) || fillIds.size()<=0){
            // 1.保存填报信息
            PilotProjectFill pilotProjectFill = new PilotProjectFill();
            pilotProjectFill.setProjectId(projectId);
            pilotProjectFill.setFlowType(3);
            pilotProjectFill.setFillDate(data);
            pilotProjectFill.setFillYear(data.getYear());
            pilotProjectFill.setFillMonth(monthValue);
            pilotProjectFill.setFillQuarter(quarter);
            pilotProjectFill.setUnitId(ContextUtil.getCurrentOrgId());
            pilotProjectFill.setUnitName(ContextUtil.getCurrentOrgName());
            pilotProjectFill.setUnitCode(ContextUtil.getCurrentOrgCode());
            pilotProjectFill.setUnitGrade(ContextUtil.getCurrentOrgGrade());
            pilotProjectFill.setStatus(status);
            pilotProjectFillManager.save(pilotProjectFill);
            fillId = pilotProjectFill.getId();
        }else {
            fillId = fillIds.get(0);
            //更新填报数据
            UpdateWrapper<PilotProjectFill> pilotProjectFillUW = new UpdateWrapper<>();
            pilotProjectFillUW.set("FILL_DATE_",data).set("FILL_YEAR_",data.getYear())
                    .set("FILL_QUARTER_",quarter).set("FILL_MONTH_",monthValue)
                    .set("STATUS_",status).eq("ID_",fillId);
            pilotProjectFillManager.update(pilotProjectFillUW);
        }


        if(status==1){
            //如果状态是上报的话，增加操作日志记录
            setApprovalLog(fillId,projectId,status,"上报");
        }

        //项目经验推广总结情况集合
        if (null != list && list.size() > 0) {
            String finalFillId = fillId;
            list.stream().forEach(p -> {
                p.setFillId(finalFillId);
            });
            saveOrUpdateList(list);
        }
    }


//    @Override
//    @Transactional
//    public void saveDraftOrCommit(PilotProjectFill pilotProjectFill) {
//        // 1.保存填报信息
//        if(BeanUtils.isEmpty(pilotProjectFill)) throw new BaseException("填报审核记录未关联项目id");
//        LocalDate fillDate = pilotProjectFill.getFillDate();
//        Integer status = BeanUtils.isNotEmpty(pilotProjectFill.getStatus())?pilotProjectFill.getStatus():0;
//        if(BeanUtils.isEmpty(fillDate)) throw new BaseException("填报日期不能为空");
//        int quarter = (fillDate.getMonthValue() - 1) / 3 + 1;
//        pilotProjectFill.setFillYear(fillDate.getYear());
//        pilotProjectFill.setFillMonth(fillDate.getMonthValue());
//        pilotProjectFill.setFillQuarter(quarter);
//        pilotProjectFill.setUnitId(ContextUtil.getCurrentOrgId());
//        pilotProjectFill.setUnitName(ContextUtil.getCurrentOrgName());
//        pilotProjectFill.setUnitCode(ContextUtil.getCurrentOrgCode());
//        pilotProjectFill.setUnitGrade(ContextUtil.getCurrentOrgGrade());
//        pilotProjectFill.setStatus(status);
//        pilotProjectFillManager.saveOrUpdate(pilotProjectFill);
//
//        if(status==1){
//            setApprovalLog(pilotProjectFill.getId(),pilotProjectFill.getProjectId(),pilotProjectFill.getStatus(),pilotProjectFill.getApprovalComments());
//        }
//
//
//        // 4.项目经验推广总结情况集合
//        List<PilotExperiencePush> pilotExperiencePushList = pilotProjectFill.getPilotExperiencePushList();
//        if (null != pilotExperiencePushList && pilotExperiencePushList.size() > 0) {
//            pilotExperiencePushList.stream().forEach(p -> {
//                p.setFillId(pilotProjectFill.getId());
//
//            });
//            saveOrUpdateList(pilotExperiencePushList);
//        }
//    }




    @Override
    @Transactional
    public boolean updateAuditStatus(PilotProjectFill pilotProjectFill) {
        boolean result = pilotProjectFillManager.updateById(pilotProjectFill);
        setApprovalLog(pilotProjectFill.getId(),pilotProjectFill.getProjectId(),pilotProjectFill.getStatus(),pilotProjectFill.getApprovalComments());
        return result;
    }

    /**
     * 设置审批日志实体类录入
     *
     * @param id
     * @param status
     */
    @Transactional
    public void setApprovalLog(String id,String projectId, Integer status,String approvalComments) {
        // 审批日志
        MunicipalMajorProjectManagement project = municipalMajorProjectManagementManager.getById(projectId);
        String title = project.getProjectName();
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(id);
        logVo.setModeType(1);
        logVo.setBizType("6-3");
        logVo.setApprovalComments(approvalComments);
        logVo.setModuleTableName("BIZ_PILOT_PROJECT_FILL");

        //审核状态0：草稿，1：已录入待更新，2：审核驳回，3：审核通过改革办待审核 ， 4：改革办审核确认驳回 ， 5：改革办审核确认完成
        if(status==0){
            logVo.setItemTitle("【"+title+"】录入！");
            logVo.setOperateInfo("需求交办推进信息录入！");
            logVo.setApprovalResults(0);
        }else if(status==1){
            logVo.setItemTitle("【"+title+"】推进记录提交审核！");
            logVo.setOperateInfo("提交审核");
            logVo.setApprovalResults(0);
        }else if(status==2){
            logVo.setItemTitle("【"+title+"】推进记录审核驳回！");
            logVo.setOperateInfo("审核驳回");
            logVo.setApprovalResults(1);
        }else if(status==3){
            logVo.setItemTitle("【"+title+"】推进记录审核通过！");
            logVo.setOperateInfo("审核通过");
            logVo.setApprovalResults(0);
        }else if(status==4){
            logVo.setItemTitle("【"+title+"】推进记录改革办驳回！");
            logVo.setOperateInfo("改革办驳回");
            logVo.setApprovalResults(1);
        }else if(status==5){
            logVo.setItemTitle("【"+title+"】推进记录改革办通过！");
            logVo.setOperateInfo("改革办通过");
            logVo.setApprovalResults(0);
        }

        logVo.setStatus(status.toString());
        logVo.setModeType(0);
        logVo.setPriority(0);
        logVo.setCreateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        logVo.setOperateDate(LocalDateTime.now());
        // 保存审批日志
        achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
    }


    @Override
    public List<PilotExperiencePush> queryListByFillId(String id) {
        QueryWrapper<PilotExperiencePush> queryWrapper = new QueryWrapper();
        queryWrapper.eq("FILL_ID_", id).eq("IS_DELE_", 0);
        List<PilotExperiencePush> list = this.list(queryWrapper);
        if(null != list && list.size() > 0){
            list.stream().forEach(p->{
                p.setDefaultFileList(fileManager.queryFileByBizId(p.getId()));
            });
        }
        return list;
    }

    @Override
    public boolean save(PilotExperiencePush entity) {
        boolean save = super.save(entity);
        List<String> ids = new ArrayList<>(1);
        ids.add(entity.getId());
        fileManager.updateFileBizIdByIds(ids, entity.getId());
        return save;
    }

    @Override
    public boolean saveBatch(Collection<PilotExperiencePush> list) {
        boolean b = this.saveOrUpdateBatch(list);
        if(null != list && list.size() > 0){
            list.stream().forEach(p->{
                List<DefaultFile> defaultFileList = p.getDefaultFileList();
                if(null != defaultFileList && defaultFileList.size() > 0){
                    List<String> fileList = defaultFileList.stream().map(f -> f.getId()).collect(Collectors.toList());
                    // 修改附件bizId
                    fileManager.updateFileBizIdByIds(fileList, p.getId());
                }
            });
        }
        return b;
    }

    @Override
    public boolean saveOrUpdate(PilotExperiencePush entity) {
        boolean b = super.saveOrUpdate(entity);
        List<String> ids = new ArrayList<>(1);
        ids.add(entity.getId());
        fileManager.updateFileBizIdByIds(ids, entity.getId());
        return b;
    }

    @Override
    public PageList<PilotExperiencePush> query(QueryFilter<PilotExperiencePush> queryFilter) {
        PageList<PilotExperiencePush> query = super.query(queryFilter);
        List<PilotExperiencePush> list = query.getRows();
        if(null != list && list.size() > 0){
            list.stream().forEach(p->{
                p.setDefaultFileList(fileManager.queryFileByBizId(p.getId()));
            });
        }
        return query;
    }

    @Override
    public List<PilotExperiencePush> list(Wrapper<PilotExperiencePush> queryWrapper) {
        List<PilotExperiencePush> list = super.list(queryWrapper);
        if(null != list && list.size() > 0){
            list.stream().forEach(p->{
                p.setDefaultFileList(fileManager.queryFileByBizId(p.getId()));
            });
        }
        return list;
    }

}
