package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.*;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 工作动态
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-04-07
 */
@Data
@TableName("BIZ_WORK_NEWS")
@ApiModel(value="BizWorkNews对象", description="工作动态")
public class BizWorkNews extends AutoFillFullModel<BizWorkNews> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "所属分类（字典：1：领导关注，2：工作部署）")
    @TableField("NEWS_TYPE_")
    private String newsType;

    @ApiModelProperty(value = "关联重大项目id")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "操作类型（字典：1：重大项目，2：区县）")
    @TableField("OPERATE_TYPE_")
    private Integer operateType;


    @ApiModelProperty(value = "标题")
    @TableField("TITLE_")
    private String title;

    @ApiModelProperty(value = "是否外部链接（0：否 ，1：是）")
    @TableField("IS_URL_")
    private Integer isUrl;

    @ApiModelProperty(value = "审核状态(0.草稿 ,1.提交待审核,2.区县审核员审核驳回,3.改革办待审核,4.改革办审核驳回,5.改革办审核通过)")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "内容URL")
    @TableField("URL_")
    private String url;

    @ApiModelProperty(value = "内容")
    @TableField("CONTENT_")
    private String content;

    @ApiModelProperty(value = "优秀程度（1：不上屏，2：上分屏 ，3：上主屏）")
    @TableField("EXCELLENT_")
    private String excellent;

    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    @ApiModelProperty(value = "有效日期（为空就一直有效）")
    @TableField("END_TIME_")
    private Date endTime;

    @ApiModelProperty(value = "是否置顶（0：否 默认，1：置顶）")
    @TableField("IS_TOP_")
    private Integer isTop;

    @ApiModelProperty(value = "拟稿人")
    @TableField("DRAFTER_")
    private String drafter;

    @ApiModelProperty(value = "页面嵌套高度")
    @TableField("PAGE_HEIGHT_")
    private String pageHeight;

    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableLogic
    @TableField("IS_DELE_")
    private String isDele="0";

    @ApiModelProperty(value = "报道日期")
    @TableField("REPORT_DATE_")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date reportDate;

    @ApiModelProperty(value = "附件id")
    @TableField(exist = false)
    private List<String> ids;

    @ApiModelProperty(value = "审批意见")
    @TableField(exist = false)
    private String approvalComments;

    @ApiModelProperty(value = "操作步骤0：通过 1：驳回 2：撤回")
    @TableField(exist = false)
    private Integer approvalResults;

    @ApiModelProperty(value = "本次更新时间")
    @TableField(exist = false)
    private LocalDate thisTime;
}
