package com.artfess.reform.fill.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@TableName("BIZ_REFORM_INVOLVED_DISTRICTS")
@ApiModel(value = "改革试点区县涉及表")
public class BizReformInvolvedDistricts extends BaseModel<BizReformInvolvedDistricts> {
    @TableId("ID_")
    @ApiModelProperty(value = "主键_ID")
    private String id;

    @TableField("PILOT_ID_")
    @ApiModelProperty(value = "项目ID")
    private String pilotId;

    @TableField("UNIT_ID_")
    @ApiModelProperty(value = "涉及区县单位ID（（关联组织机构表ID））")
    private String unitId;

    @TableField("UNIT_NAME_")
    @ApiModelProperty(value = "涉及区县单位NAME（关联组织机构表NAME）")
    private String unitName;

    @TableField("UNIT_CODE_")
    @ApiModelProperty(value = "单位CODE（关联组织机构表编码）")
    private String unitCode;

    @TableField("UNIT_GRADE_")
    @ApiModelProperty(value = "单位GRADE（关联组织机构表级别）")
    private String unitGrade;

    @TableField("tenant_id_")
    @ApiModelProperty(value = "租户ID")
    private String tenantId="-1";

}
