package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.*;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.io.Serializable;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 会议议定事项表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-09
 */
@TableName("BIZ_MEETING_MATTERS_AGREED")
@ApiModel(value="BizMeetingMattersAgreed对象", description="会议议定事项表")
@Data
public class BizMeetingMattersAgreed extends AutoFillFullModel<BizMeetingMattersAgreed> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "会议名称")
    @TableField("MEETING_NAME_")
    private String meetingName;

    @ApiModelProperty(value = "会议时间")
    @TableField("MEETING_TIME_")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate meetingTime;

    @ApiModelProperty(value = "交办事项")
    @TableField("MEETING_TASK_")
    private String meetingTask;

    @ApiModelProperty(value = "责任单位id关联组织机构表id")
    @TableField("UNIT_ID_")
    private String unitId;

    @ApiModelProperty(value = "责任单位name关联组织机构表名称")
    @TableField("UNIT_NAME_")
    private String unitName;

    @ApiModelProperty(value = "责任单位code关联组织机构表编码")
    @TableField("UNIT_CODE_")
    private String unitCode;

    @ApiModelProperty(value = "责任单位grade关联组织机构表级别")
    @TableField("UNIT_GRADE_")
    private String unitGrade;

    @ApiModelProperty(value = "反馈时限")
    @TableField("FEEDBACK_TIME_LIMIT_")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate feedbackTimeLimit;

    @ApiModelProperty(value = "办理详情文字+附件")
    @TableField("PROPULSIVE_DETAILED_")
    private String propulsiveDetailed;

    @ApiModelProperty(value = "主责单位状态最后更新时间")
    @TableField("PROPULSIVE_UPDATE_DATE_")
    private LocalDateTime propulsiveUpdateDate;

    @ApiModelProperty(value = "审核状态0：草稿，1：已录入待更新，2：审核驳回，3：审核通过改革办待审核 ， 4：改革办审核确认驳回 ， 5：改革办审核确认完成")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableLogic
    @TableField("IS_DELE_")
    private String isDele="0";

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "上传附件")
    @TableField(exist = false)
    private List<String> ids;


    @ApiModelProperty(value = "附件")
    @TableField(exist = false)
    private List<DefaultFile> files;
}
