package com.artfess.reform.fill.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.fill.dao.BizReformSatisfactionDistrictsDao;
import com.artfess.reform.fill.dao.BizReformSatisfactionManagementDao;
import com.artfess.reform.fill.manager.BizReformSatisfactionDistrictsManager;
import com.artfess.reform.fill.model.BizReformSatisfactionDistricts;
import com.artfess.reform.fill.model.BizReformSatisfactionManagement;
import com.artfess.uc.model.Org;
import com.artfess.uc.dao.OrgDao;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.temporal.IsoFields;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

/**
 * 满意度区县结果表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-08
 */
@Service
public class BizReformSatisfactionDistrictsManagerImpl extends BaseManagerImpl<BizReformSatisfactionDistrictsDao, BizReformSatisfactionDistricts> implements BizReformSatisfactionDistrictsManager {

    @Resource
    private BizReformSatisfactionManagementDao reformSatisfactionManagementDao;
    @Resource
    private OrgDao orgDao;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean importExcel(List<BizReformSatisfactionDistricts> list, String satisfactionId) {
        BizReformSatisfactionManagement management = this.reformSatisfactionManagementDao.selectById(satisfactionId);
        Assert.notNull(management, "改革区县满意度管理主表数据不存在");
        QueryWrapper<BizReformSatisfactionDistricts> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("SATISFACTION_ID_", satisfactionId);
        baseMapper.delete(queryWrapper);

        List<BizReformSatisfactionDistricts> No1List = this.baseMapper.getAfterQuarterFirst(management.getScoringYear(), management.getScoringQuarter() - 1);

        List<Org> orgList = orgDao.groupOrg();
        Map<String, Org> orgMap = orgList.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        list.forEach(detail -> {
            detail.setSatisfactionId(satisfactionId);
            if(orgMap.containsKey(detail.getUnitCode())) {
                Org org = orgMap.get(detail.getUnitCode());
                detail.setUnitName(org.getName());
                detail.setUnitId(org.getId());
                detail.setUnitGrade(org.getGrade());
            }
            if((null == No1List||No1List.size()==0) && detail.getAllSn() == 1) {
                detail.setHoldNum(0);
            }
            if((null != No1List&&No1List.size()>0) && detail.getAllSn() == 1) {
                for(BizReformSatisfactionDistricts no1 :No1List){
                    if(detail.getAllSn() == 1 && detail.getUnitCode().equals(no1.getUnitCode())){
                        detail.setHoldNum(no1.getHoldNum() + 1);
                        break;
                    }
                    if(detail.getAllSn() == 1 && !detail.getUnitCode().equals(no1.getUnitCode())){
                        detail.setHoldNum(0);
                    }
                }

            }
        });
        boolean b = this.saveBatch(list);
        return b;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean batchUpdate(BizReformSatisfactionManagement t) {
        Assert.hasText(t.getId(), "请选择要修改改革区县满意度管理主表id");
        List<BizReformSatisfactionDistricts> list = t.getBizReformSatisfactionDistricts();
        list.forEach(detail -> {
            detail.setSatisfactionId(t.getId());
        });
        boolean b = this.saveOrUpdateBatch(list);
        return b;
    }

    @Override
    public List<BizReformSatisfactionDistricts> queryBySatisfactionId(String satisfactionId) {
        Assert.hasText(satisfactionId, "改革区县满意度管理主表id不能为空！");
        QueryWrapper<BizReformSatisfactionDistricts> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("SATISFACTION_ID_", satisfactionId);
        List<BizReformSatisfactionDistricts> list = this.baseMapper.selectList(queryWrapper);
        return list;
    }

    @Override
    public List<BizReformSatisfactionDistricts> qureyFieldByUnitCode(String unitCode, Integer scoringYear, Integer scoringQuarter) {
        Assert.hasText(unitCode, "区县编码不能为空！");
        if (scoringYear == null || scoringYear == 0) {
            scoringYear = LocalDate.now().getYear();
        }
        if (scoringQuarter == null || scoringQuarter == 0) {
            scoringQuarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        List<BizReformSatisfactionDistricts> list = this.baseMapper.qureyFieldByUnitCode(unitCode,scoringYear,scoringQuarter);

        boolean existsQuarter = IntStream.rangeClosed(1, 4)
                .allMatch(quarter -> list.stream().anyMatch(vo -> vo.getScoringQuarter() == quarter));
        // 如果不存在完整的十二个月份，则添加新的对象
        if (!existsQuarter) {
            IntStream.rangeClosed(1, 4)
                    .filter(quarter -> list.stream().noneMatch(vo -> vo.getScoringQuarter() == quarter))
                    .mapToObj(quarter -> new BizReformSatisfactionDistricts(quarter, unitCode)) // 创建新的VO对象
                    .forEach(list::add); // 将新的VO对象添加到List中
        }
        return list;
    }
}
